/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;

@GeneratedBy(value=StringPrimitiveNodes.class)
public final class StringPrimitiveNodesFactory {
    public static List<NodeFactory<? extends RubiniusPrimitiveNode>> getFactories() {
        return Arrays.asList(CharacterAsciiPrimitiveNodeFactory.getInstance(), StringAwkSplitPrimitiveNodeFactory.getInstance(), StringByteSubstringPrimitiveNodeFactory.getInstance(), StringCheckNullSafePrimitiveNodeFactory.getInstance(), StringChrAtPrimitiveNodeFactory.getInstance(), StringCompareSubstringPrimitiveNodeFactory.getInstance(), StringEqualPrimitiveNodeFactory.getInstance(), StringFindCharacterPrimitiveNodeFactory.getInstance(), StringFromCodepointPrimitiveNodeFactory.getInstance(), StringToFPrimitiveNodeFactory.getInstance(), StringIndexPrimitiveNodeFactory.getInstance(), CharacterByteIndexNodeFactory.getInstance(), StringByteCharacterIndexPrimitiveNodeFactory.getInstance(), StringCharacterIndexPrimitiveNodeFactory.getInstance(), StringByteIndexPrimitiveNodeFactory.getInstance(), StringPreviousByteIndexPrimitiveNodeFactory.getInstance(), StringCopyFromPrimitiveNodeFactory.getInstance(), StringResizeCapacityPrimitiveNodeFactory.getInstance(), StringRindexPrimitiveNodeFactory.getInstance(), StringPatternPrimitiveNodeFactory.getInstance(), StringToInumPrimitiveNodeFactory.getInstance(), StringByteAppendPrimitiveNodeFactory.getInstance(), StringSubstringPrimitiveNodeFactory.getInstance(), StringFromByteArrayPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class)
    public static final class StringFromByteArrayPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringFromByteArrayPrimitiveNode> {
        private static StringFromByteArrayPrimitiveNodeFactory stringFromByteArrayPrimitiveNodeFactoryInstance;

        private StringFromByteArrayPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringFromByteArrayPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringFromByteArrayPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringFromByteArrayPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringFromByteArrayPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringFromByteArrayPrimitiveNode> getInstance() {
            if (stringFromByteArrayPrimitiveNodeFactoryInstance == null) {
                stringFromByteArrayPrimitiveNodeFactoryInstance = new StringFromByteArrayPrimitiveNodeFactory();
            }
            return stringFromByteArrayPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringFromByteArrayPrimitivePolymorphicNode
        extends StringFromByteArrayPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringFromByteArrayPrimitivePolymorphicNode(StringFromByteArrayPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFromByteArrayPrimitiveRubiniusByteArrayIntNode
        extends StringFromByteArrayPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromByteArrayPrimitiveRubiniusByteArrayIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubiniusByteArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringFromByteArrayPrimitiveRubiniusByteArrayIntNode(StringFromByteArrayPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubiniusByteArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubiniusByteArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubiniusByteArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringFromByteArray(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubiniusByteArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubiniusByteArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubiniusByteArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringFromByteArray(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringFromByteArrayPrimitiveNode create0(StringPrimitiveNodes.StringFromByteArrayPrimitiveNode current) {
                return new StringFromByteArrayPrimitiveRubiniusByteArrayIntNode((StringFromByteArrayPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringFromByteArrayPrimitiveUninitializedNode
        extends StringFromByteArrayPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromByteArrayPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringFromByteArrayPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringFromByteArrayPrimitiveUninitializedNode(StringFromByteArrayPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringFromByteArrayPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringFromByteArrayPrimitiveBaseNode rootNode = (StringFromByteArrayPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringFromByteArrayPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringFromByteArrayPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringFromByteArrayPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromByteArrayPrimitiveNode.class)
        private static abstract class StringFromByteArrayPrimitiveBaseNode
        extends StringPrimitiveNodes.StringFromByteArrayPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringFromByteArrayPrimitiveBaseNode next0;

            StringFromByteArrayPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringFromByteArrayPrimitiveBaseNode(StringFromByteArrayPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringFromByteArrayPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringFromByteArrayPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringFromByteArrayPrimitiveUninitializedNode(this);
                    ((StringFromByteArrayPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringFromByteArrayPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringFromByteArrayPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringFromByteArrayPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringFromByteArrayPrimitiveUninitializedNode(this), (Node)new StringFromByteArrayPrimitivePolymorphicNode(this), (DSLNode)((StringFromByteArrayPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringFromByteArrayPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubiniusByteArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (StringFromByteArrayPrimitiveBaseNode)StringFromByteArrayPrimitiveRubiniusByteArrayIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringFromByteArrayPrimitiveBaseNode otherCast = (StringFromByteArrayPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringFromByteArrayPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
    public static final class StringSubstringPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringSubstringPrimitiveNode> {
        private static StringSubstringPrimitiveNodeFactory stringSubstringPrimitiveNodeFactoryInstance;

        private StringSubstringPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringSubstringPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringSubstringPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringSubstringPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringSubstringPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringSubstringPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringSubstringPrimitiveNode> getInstance() {
            if (stringSubstringPrimitiveNodeFactoryInstance == null) {
                stringSubstringPrimitiveNodeFactoryInstance = new StringSubstringPrimitiveNodeFactory();
            }
            return stringSubstringPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringSubstringPrimitivePolymorphicNode
        extends StringSubstringPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringSubstringPrimitivePolymorphicNode(StringSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, RubyString arguments0ValueEvaluated, int arguments1ValueEvaluated, int arguments2ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                Integer arguments1Value = arguments1ValueEvaluated;
                Integer arguments2Value = arguments2ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringSubstringPrimitiveRubyStringInt1Node
        extends StringSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringSubstringPrimitiveRubyStringInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringSubstringPrimitiveRubyStringInt1Node(StringSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringSubstring(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            public Object execute(VirtualFrame frameValue, RubyString arguments0ValueEvaluated, int arguments1ValueEvaluated, int arguments2ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                int arguments1Value = arguments1ValueEvaluated;
                int arguments2Value = arguments2ValueEvaluated;
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringSubstring(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return super.stringSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringSubstringPrimitiveNode create0(StringPrimitiveNodes.StringSubstringPrimitiveNode current) {
                return new StringSubstringPrimitiveRubyStringInt1Node((StringSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringSubstringPrimitiveRubyStringInt0Node
        extends StringSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringSubstringPrimitiveRubyStringInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringSubstringPrimitiveRubyStringInt0Node(StringSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringSubstringSingleByteOptimizable(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            public Object execute(VirtualFrame frameValue, RubyString arguments0ValueEvaluated, int arguments1ValueEvaluated, int arguments2ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                int arguments1Value = arguments1ValueEvaluated;
                int arguments2Value = arguments2ValueEvaluated;
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringSubstringSingleByteOptimizable(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return super.stringSubstringSingleByteOptimizable(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringSubstringPrimitiveNode create0(StringPrimitiveNodes.StringSubstringPrimitiveNode current) {
                return new StringSubstringPrimitiveRubyStringInt0Node((StringSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringSubstringPrimitiveUninitializedNode
        extends StringSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringSubstringPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringSubstringPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringSubstringPrimitiveUninitializedNode(StringSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, RubyString arguments0ValueEvaluated, int arguments1ValueEvaluated, int arguments2ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyString arguments0Value = arguments0ValueEvaluated;
                Integer arguments1Value = arguments1ValueEvaluated;
                Integer arguments2Value = arguments2ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringSubstringPrimitiveBaseNode rootNode = (StringSubstringPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringSubstringPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringSubstringPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringSubstringPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringSubstringPrimitiveNode.class)
        private static abstract class StringSubstringPrimitiveBaseNode
        extends StringPrimitiveNodes.StringSubstringPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringSubstringPrimitiveBaseNode next0;

            StringSubstringPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringSubstringPrimitiveBaseNode(StringSubstringPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringSubstringPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringSubstringPrimitiveUninitializedNode(this);
                    ((StringSubstringPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringSubstringPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringSubstringPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringSubstringPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringSubstringPrimitiveUninitializedNode(this), (Node)new StringSubstringPrimitivePolymorphicNode(this), (DSLNode)((StringSubstringPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringSubstringPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (StringSubstringPrimitiveBaseNode)StringSubstringPrimitiveRubyStringInt0Node.create0(this);
                    }
                    return (StringSubstringPrimitiveBaseNode)StringSubstringPrimitiveRubyStringInt1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringSubstringPrimitiveBaseNode otherCast = (StringSubstringPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringSubstringPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringByteAppendPrimitiveNode.class)
    public static final class StringByteAppendPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringByteAppendPrimitiveNode> {
        private static StringByteAppendPrimitiveNodeFactory stringByteAppendPrimitiveNodeFactoryInstance;

        private StringByteAppendPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringByteAppendPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringByteAppendPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringByteAppendPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringByteAppendPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringByteAppendPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringByteAppendPrimitiveNode> getInstance() {
            if (stringByteAppendPrimitiveNodeFactoryInstance == null) {
                stringByteAppendPrimitiveNodeFactoryInstance = new StringByteAppendPrimitiveNodeFactory();
            }
            return stringByteAppendPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteAppendPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringByteAppendPrimitivePolymorphicNode
        extends StringByteAppendPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringByteAppendPrimitivePolymorphicNode(StringByteAppendPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteAppendPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteAppendPrimitiveRubyStringNode
        extends StringByteAppendPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteAppendPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            StringByteAppendPrimitiveRubyStringNode(StringByteAppendPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.stringByteAppend(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.stringByteAppend(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringByteAppendPrimitiveNode create0(StringPrimitiveNodes.StringByteAppendPrimitiveNode current) {
                return new StringByteAppendPrimitiveRubyStringNode((StringByteAppendPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteAppendPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringByteAppendPrimitiveUninitializedNode
        extends StringByteAppendPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteAppendPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringByteAppendPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringByteAppendPrimitiveUninitializedNode(StringByteAppendPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringByteAppendPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringByteAppendPrimitiveBaseNode rootNode = (StringByteAppendPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringByteAppendPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringByteAppendPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringByteAppendPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteAppendPrimitiveNode.class)
        private static abstract class StringByteAppendPrimitiveBaseNode
        extends StringPrimitiveNodes.StringByteAppendPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringByteAppendPrimitiveBaseNode next0;

            StringByteAppendPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringByteAppendPrimitiveBaseNode(StringByteAppendPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringByteAppendPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringByteAppendPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringByteAppendPrimitiveUninitializedNode(this);
                    ((StringByteAppendPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringByteAppendPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringByteAppendPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringByteAppendPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringByteAppendPrimitiveUninitializedNode(this), (Node)new StringByteAppendPrimitivePolymorphicNode(this), (DSLNode)((StringByteAppendPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringByteAppendPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (StringByteAppendPrimitiveBaseNode)StringByteAppendPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringByteAppendPrimitiveBaseNode otherCast = (StringByteAppendPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringByteAppendPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringToInumPrimitiveNode.class)
    public static final class StringToInumPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringToInumPrimitiveNode> {
        private static StringToInumPrimitiveNodeFactory stringToInumPrimitiveNodeFactoryInstance;

        private StringToInumPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringToInumPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringToInumPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringToInumPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringToInumPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringToInumPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringToInumPrimitiveNode> getInstance() {
            if (stringToInumPrimitiveNodeFactoryInstance == null) {
                stringToInumPrimitiveNodeFactoryInstance = new StringToInumPrimitiveNodeFactory();
            }
            return stringToInumPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToInumPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringToInumPrimitivePolymorphicNode
        extends StringToInumPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringToInumPrimitivePolymorphicNode(StringToInumPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToInumPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringToInumPrimitiveRubyStringBooleanNode
        extends StringToInumPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringToInumPrimitiveRubyStringBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Boolean.TYPE}, 0, 0);

            StringToInumPrimitiveRubyStringBooleanNode(StringToInumPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.stringToInum(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.stringToInum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringToInumPrimitiveNode create0(StringPrimitiveNodes.StringToInumPrimitiveNode current) {
                return new StringToInumPrimitiveRubyStringBooleanNode((StringToInumPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToInumPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringToInumPrimitiveUninitializedNode
        extends StringToInumPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringToInumPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringToInumPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringToInumPrimitiveUninitializedNode(StringToInumPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringToInumPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringToInumPrimitiveBaseNode rootNode = (StringToInumPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringToInumPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringToInumPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringToInumPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToInumPrimitiveNode.class)
        private static abstract class StringToInumPrimitiveBaseNode
        extends StringPrimitiveNodes.StringToInumPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringToInumPrimitiveBaseNode next0;

            StringToInumPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringToInumPrimitiveBaseNode(StringToInumPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringToInumPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringToInumPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringToInumPrimitiveUninitializedNode(this);
                    ((StringToInumPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringToInumPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringToInumPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringToInumPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringToInumPrimitiveUninitializedNode(this), (Node)new StringToInumPrimitivePolymorphicNode(this), (DSLNode)((StringToInumPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringToInumPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    return (StringToInumPrimitiveBaseNode)StringToInumPrimitiveRubyStringBooleanNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringToInumPrimitiveBaseNode otherCast = (StringToInumPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringToInumPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
    public static final class StringPatternPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringPatternPrimitiveNode> {
        private static StringPatternPrimitiveNodeFactory stringPatternPrimitiveNodeFactoryInstance;

        private StringPatternPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringPatternPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringPatternPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringPatternPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringPatternPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringPatternPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringPatternPrimitiveNode> getInstance() {
            if (stringPatternPrimitiveNodeFactoryInstance == null) {
                stringPatternPrimitiveNodeFactoryInstance = new StringPatternPrimitiveNodeFactory();
            }
            return stringPatternPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringPatternPrimitivePolymorphicNode
        extends StringPatternPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringPatternPrimitivePolymorphicNode(StringPatternPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringPatternPrimitiveRubyClassRubyStringNode
        extends StringPatternPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPatternPrimitiveRubyClassRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, Integer.TYPE, RubyString.class}, 0, 0);

            StringPatternPrimitiveRubyClassRubyStringNode(StringPatternPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                int arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.stringPattern(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.stringPattern(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringPatternPrimitiveNode create0(StringPrimitiveNodes.StringPatternPrimitiveNode current) {
                return new StringPatternPrimitiveRubyClassRubyStringNode((StringPatternPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringPatternPrimitiveRubyClassInt1Node
        extends StringPatternPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPatternPrimitiveRubyClassInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringPatternPrimitiveRubyClassInt1Node(StringPatternPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!super.isZero(arguments1Value)) {
                    return super.stringPattern(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isZero] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!super.isZero(arguments1ValueCast)) {
                        return super.stringPattern(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringPatternPrimitiveNode create0(StringPrimitiveNodes.StringPatternPrimitiveNode current) {
                return new StringPatternPrimitiveRubyClassInt1Node((StringPatternPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringPatternPrimitiveRubyClassInt0Node
        extends StringPatternPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPatternPrimitiveRubyClassInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringPatternPrimitiveRubyClassInt0Node(StringPatternPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (super.isZero(arguments1Value)) {
                    return super.stringPatternZero(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isZero] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (super.isZero(arguments1ValueCast)) {
                        return super.stringPatternZero(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringPatternPrimitiveNode create0(StringPrimitiveNodes.StringPatternPrimitiveNode current) {
                return new StringPatternPrimitiveRubyClassInt0Node((StringPatternPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringPatternPrimitiveUninitializedNode
        extends StringPatternPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPatternPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringPatternPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringPatternPrimitiveUninitializedNode(StringPatternPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringPatternPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringPatternPrimitiveBaseNode rootNode = (StringPatternPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringPatternPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringPatternPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringPatternPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPatternPrimitiveNode.class)
        private static abstract class StringPatternPrimitiveBaseNode
        extends StringPrimitiveNodes.StringPatternPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringPatternPrimitiveBaseNode next0;

            StringPatternPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringPatternPrimitiveBaseNode(StringPatternPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringPatternPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringPatternPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringPatternPrimitiveUninitializedNode(this);
                    ((StringPatternPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringPatternPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringPatternPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringPatternPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringPatternPrimitiveUninitializedNode(this), (Node)new StringPatternPrimitivePolymorphicNode(this), (DSLNode)((StringPatternPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringPatternPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        if (super.isZero(arguments1ValueCast)) {
                            return (StringPatternPrimitiveBaseNode)StringPatternPrimitiveRubyClassInt0Node.create0(this);
                        }
                        return (StringPatternPrimitiveBaseNode)StringPatternPrimitiveRubyClassInt1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        return (StringPatternPrimitiveBaseNode)StringPatternPrimitiveRubyClassRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringPatternPrimitiveBaseNode otherCast = (StringPatternPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringPatternPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringRindexPrimitiveNode.class)
    public static final class StringRindexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringRindexPrimitiveNode> {
        private static StringRindexPrimitiveNodeFactory stringRindexPrimitiveNodeFactoryInstance;

        private StringRindexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringRindexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringRindexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringRindexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringRindexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringRindexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringRindexPrimitiveNode> getInstance() {
            if (stringRindexPrimitiveNodeFactoryInstance == null) {
                stringRindexPrimitiveNodeFactoryInstance = new StringRindexPrimitiveNodeFactory();
            }
            return stringRindexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringRindexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringRindexPrimitivePolymorphicNode
        extends StringRindexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringRindexPrimitivePolymorphicNode(StringRindexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringRindexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringRindexPrimitiveRubyStringIntNode
        extends StringRindexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringRindexPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            StringRindexPrimitiveRubyStringIntNode(StringRindexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringRindex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringRindex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringRindexPrimitiveNode create0(StringPrimitiveNodes.StringRindexPrimitiveNode current) {
                return new StringRindexPrimitiveRubyStringIntNode((StringRindexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringRindexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringRindexPrimitiveUninitializedNode
        extends StringRindexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringRindexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringRindexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringRindexPrimitiveUninitializedNode(StringRindexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringRindexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringRindexPrimitiveBaseNode rootNode = (StringRindexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringRindexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringRindexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringRindexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringRindexPrimitiveNode.class)
        private static abstract class StringRindexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringRindexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringRindexPrimitiveBaseNode next0;

            StringRindexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringRindexPrimitiveBaseNode(StringRindexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringRindexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringRindexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringRindexPrimitiveUninitializedNode(this);
                    ((StringRindexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringRindexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringRindexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringRindexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringRindexPrimitiveUninitializedNode(this), (Node)new StringRindexPrimitivePolymorphicNode(this), (DSLNode)((StringRindexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringRindexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (StringRindexPrimitiveBaseNode)StringRindexPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringRindexPrimitiveBaseNode otherCast = (StringRindexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringRindexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class)
    public static final class StringResizeCapacityPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringResizeCapacityPrimitiveNode> {
        private static StringResizeCapacityPrimitiveNodeFactory stringResizeCapacityPrimitiveNodeFactoryInstance;

        private StringResizeCapacityPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringResizeCapacityPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringResizeCapacityPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringResizeCapacityPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringResizeCapacityPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringResizeCapacityPrimitiveNode> getInstance() {
            if (stringResizeCapacityPrimitiveNodeFactoryInstance == null) {
                stringResizeCapacityPrimitiveNodeFactoryInstance = new StringResizeCapacityPrimitiveNodeFactory();
            }
            return stringResizeCapacityPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringResizeCapacityPrimitivePolymorphicNode
        extends StringResizeCapacityPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringResizeCapacityPrimitivePolymorphicNode(StringResizeCapacityPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringResizeCapacityPrimitiveRubyStringNode
        extends StringResizeCapacityPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringResizeCapacityPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringResizeCapacityPrimitiveRubyStringNode(StringResizeCapacityPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.stringResizeCapacity(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.stringResizeCapacity(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringResizeCapacityPrimitiveNode create0(StringPrimitiveNodes.StringResizeCapacityPrimitiveNode current) {
                return new StringResizeCapacityPrimitiveRubyStringNode((StringResizeCapacityPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringResizeCapacityPrimitiveUninitializedNode
        extends StringResizeCapacityPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringResizeCapacityPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringResizeCapacityPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringResizeCapacityPrimitiveUninitializedNode(StringResizeCapacityPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringResizeCapacityPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringResizeCapacityPrimitiveBaseNode rootNode = (StringResizeCapacityPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringResizeCapacityPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringResizeCapacityPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringResizeCapacityPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringResizeCapacityPrimitiveNode.class)
        private static abstract class StringResizeCapacityPrimitiveBaseNode
        extends StringPrimitiveNodes.StringResizeCapacityPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringResizeCapacityPrimitiveBaseNode next0;

            StringResizeCapacityPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringResizeCapacityPrimitiveBaseNode(StringResizeCapacityPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringResizeCapacityPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringResizeCapacityPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringResizeCapacityPrimitiveUninitializedNode(this);
                    ((StringResizeCapacityPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringResizeCapacityPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringResizeCapacityPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringResizeCapacityPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringResizeCapacityPrimitiveUninitializedNode(this), (Node)new StringResizeCapacityPrimitivePolymorphicNode(this), (DSLNode)((StringResizeCapacityPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringResizeCapacityPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (StringResizeCapacityPrimitiveBaseNode)StringResizeCapacityPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringResizeCapacityPrimitiveBaseNode otherCast = (StringResizeCapacityPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringResizeCapacityPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringCopyFromPrimitiveNode.class)
    public static final class StringCopyFromPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringCopyFromPrimitiveNode> {
        private static StringCopyFromPrimitiveNodeFactory stringCopyFromPrimitiveNodeFactoryInstance;

        private StringCopyFromPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringCopyFromPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringCopyFromPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringCopyFromPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringCopyFromPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringCopyFromPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringCopyFromPrimitiveNode> getInstance() {
            if (stringCopyFromPrimitiveNodeFactoryInstance == null) {
                stringCopyFromPrimitiveNodeFactoryInstance = new StringCopyFromPrimitiveNodeFactory();
            }
            return stringCopyFromPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCopyFromPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringCopyFromPrimitivePolymorphicNode
        extends StringCopyFromPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments4PolymorphicType;

            StringCopyFromPrimitivePolymorphicNode(StringCopyFromPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                Object arguments4Value = this.arguments[4].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
                this.arguments4PolymorphicType = types[4];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCopyFromPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringCopyFromPrimitiveRubyStringIntIntNode
        extends StringCopyFromPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCopyFromPrimitiveRubyStringIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringCopyFromPrimitiveRubyStringIntIntNode(StringCopyFromPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments4Value;
                int arguments3Value;
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof int");
                }
                try {
                    arguments3Value = this.arguments[3].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof int");
                }
                try {
                    arguments4Value = this.arguments[4].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof int");
                }
                return super.stringCopyFrom(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments4Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    int arguments3ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments3Value);
                    int arguments4ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments4Value);
                    return super.stringCopyFrom(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static StringPrimitiveNodes.StringCopyFromPrimitiveNode create0(StringPrimitiveNodes.StringCopyFromPrimitiveNode current) {
                return new StringCopyFromPrimitiveRubyStringIntIntNode((StringCopyFromPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCopyFromPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringCopyFromPrimitiveUninitializedNode
        extends StringCopyFromPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCopyFromPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringCopyFromPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringCopyFromPrimitiveUninitializedNode(StringCopyFromPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                Object arguments4Value = this.arguments[4].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                StringCopyFromPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringCopyFromPrimitiveBaseNode rootNode = (StringCopyFromPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3], rootNode.arguments[4]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringCopyFromPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static StringPrimitiveNodes.StringCopyFromPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringCopyFromPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCopyFromPrimitiveNode.class)
        private static abstract class StringCopyFromPrimitiveBaseNode
        extends StringPrimitiveNodes.StringCopyFromPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringCopyFromPrimitiveBaseNode next0;

            StringCopyFromPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringCopyFromPrimitiveBaseNode(StringCopyFromPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, Object var6);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value, String reason) {
                String message;
                StringCopyFromPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringCopyFromPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    newNode = new StringCopyFromPrimitiveUninitializedNode(this);
                    ((StringCopyFromPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringCopyFromPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringCopyFromPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value)))) == null) {
                    returnNode = (StringCopyFromPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringCopyFromPrimitiveUninitializedNode(this), (Node)new StringCopyFromPrimitivePolymorphicNode(this), (DSLNode)((StringCopyFromPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringCopyFromPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments4Value)) {
                    return (StringCopyFromPrimitiveBaseNode)StringCopyFromPrimitiveRubyStringIntIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                    this.arguments[4] = null;
                } else {
                    StringCopyFromPrimitiveBaseNode otherCast = (StringCopyFromPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                    this.arguments[4] = otherCast.arguments[4];
                }
                this.next0 = newNext == null ? null : (StringCopyFromPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments4Value").append(" = ").append(arguments4Value);
                    if (arguments4Value != null) {
                        builder.append(" (").append(arguments4Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class)
    public static final class StringPreviousByteIndexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode> {
        private static StringPreviousByteIndexPrimitiveNodeFactory stringPreviousByteIndexPrimitiveNodeFactoryInstance;

        private StringPreviousByteIndexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringPreviousByteIndexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringPreviousByteIndexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode> getInstance() {
            if (stringPreviousByteIndexPrimitiveNodeFactoryInstance == null) {
                stringPreviousByteIndexPrimitiveNodeFactoryInstance = new StringPreviousByteIndexPrimitiveNodeFactory();
            }
            return stringPreviousByteIndexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringPreviousByteIndexPrimitivePolymorphicNode
        extends StringPreviousByteIndexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringPreviousByteIndexPrimitivePolymorphicNode(StringPreviousByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringPreviousByteIndexPrimitiveRubyStringNode
        extends StringPreviousByteIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPreviousByteIndexPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringPreviousByteIndexPrimitiveRubyStringNode(StringPreviousByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.stringPreviousByteIndex(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.stringPreviousByteIndex(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode create0(StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode current) {
                return new StringPreviousByteIndexPrimitiveRubyStringNode((StringPreviousByteIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringPreviousByteIndexPrimitiveUninitializedNode
        extends StringPreviousByteIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringPreviousByteIndexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringPreviousByteIndexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringPreviousByteIndexPrimitiveUninitializedNode(StringPreviousByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringPreviousByteIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringPreviousByteIndexPrimitiveBaseNode rootNode = (StringPreviousByteIndexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringPreviousByteIndexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringPreviousByteIndexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode.class)
        private static abstract class StringPreviousByteIndexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringPreviousByteIndexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringPreviousByteIndexPrimitiveBaseNode next0;

            StringPreviousByteIndexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringPreviousByteIndexPrimitiveBaseNode(StringPreviousByteIndexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringPreviousByteIndexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringPreviousByteIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringPreviousByteIndexPrimitiveUninitializedNode(this);
                    ((StringPreviousByteIndexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringPreviousByteIndexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringPreviousByteIndexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringPreviousByteIndexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringPreviousByteIndexPrimitiveUninitializedNode(this), (Node)new StringPreviousByteIndexPrimitivePolymorphicNode(this), (DSLNode)((StringPreviousByteIndexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringPreviousByteIndexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (StringPreviousByteIndexPrimitiveBaseNode)StringPreviousByteIndexPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringPreviousByteIndexPrimitiveBaseNode otherCast = (StringPreviousByteIndexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringPreviousByteIndexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
    public static final class StringByteIndexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringByteIndexPrimitiveNode> {
        private static StringByteIndexPrimitiveNodeFactory stringByteIndexPrimitiveNodeFactoryInstance;

        private StringByteIndexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringByteIndexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringByteIndexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringByteIndexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringByteIndexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringByteIndexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringByteIndexPrimitiveNode> getInstance() {
            if (stringByteIndexPrimitiveNodeFactoryInstance == null) {
                stringByteIndexPrimitiveNodeFactoryInstance = new StringByteIndexPrimitiveNodeFactory();
            }
            return stringByteIndexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringByteIndexPrimitivePolymorphicNode
        extends StringByteIndexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringByteIndexPrimitivePolymorphicNode(StringByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteIndexPrimitiveRubyStringNode
        extends StringByteIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteIndexPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            StringByteIndexPrimitiveRubyStringNode(StringByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringByteIndex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringByteIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteIndexPrimitiveNode current) {
                return new StringByteIndexPrimitiveRubyStringNode((StringByteIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteIndexPrimitiveRubyStringIntNode
        extends StringByteIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteIndexPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteIndexPrimitiveRubyStringIntNode(StringByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringByteIndex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringByteIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteIndexPrimitiveNode current) {
                return new StringByteIndexPrimitiveRubyStringIntNode((StringByteIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringByteIndexPrimitiveUninitializedNode
        extends StringByteIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteIndexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringByteIndexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringByteIndexPrimitiveUninitializedNode(StringByteIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringByteIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringByteIndexPrimitiveBaseNode rootNode = (StringByteIndexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringByteIndexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteIndexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringByteIndexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteIndexPrimitiveNode.class)
        private static abstract class StringByteIndexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringByteIndexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringByteIndexPrimitiveBaseNode next0;

            StringByteIndexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringByteIndexPrimitiveBaseNode(StringByteIndexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringByteIndexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringByteIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringByteIndexPrimitiveUninitializedNode(this);
                    ((StringByteIndexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringByteIndexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringByteIndexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringByteIndexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringByteIndexPrimitiveUninitializedNode(this), (Node)new StringByteIndexPrimitivePolymorphicNode(this), (DSLNode)((StringByteIndexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringByteIndexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (StringByteIndexPrimitiveBaseNode)StringByteIndexPrimitiveRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (StringByteIndexPrimitiveBaseNode)StringByteIndexPrimitiveRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringByteIndexPrimitiveBaseNode otherCast = (StringByteIndexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringByteIndexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class)
    public static final class StringCharacterIndexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringCharacterIndexPrimitiveNode> {
        private static StringCharacterIndexPrimitiveNodeFactory stringCharacterIndexPrimitiveNodeFactoryInstance;

        private StringCharacterIndexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringCharacterIndexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringCharacterIndexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringCharacterIndexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringCharacterIndexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringCharacterIndexPrimitiveNode> getInstance() {
            if (stringCharacterIndexPrimitiveNodeFactoryInstance == null) {
                stringCharacterIndexPrimitiveNodeFactoryInstance = new StringCharacterIndexPrimitiveNodeFactory();
            }
            return stringCharacterIndexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringCharacterIndexPrimitivePolymorphicNode
        extends StringCharacterIndexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringCharacterIndexPrimitivePolymorphicNode(StringCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringCharacterIndexPrimitiveRubyStringIntNode
        extends StringCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCharacterIndexPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            StringCharacterIndexPrimitiveRubyStringIntNode(StringCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringCharacterIndex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringCharacterIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringCharacterIndexPrimitiveNode create0(StringPrimitiveNodes.StringCharacterIndexPrimitiveNode current) {
                return new StringCharacterIndexPrimitiveRubyStringIntNode((StringCharacterIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringCharacterIndexPrimitiveUninitializedNode
        extends StringCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCharacterIndexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringCharacterIndexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringCharacterIndexPrimitiveUninitializedNode(StringCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringCharacterIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringCharacterIndexPrimitiveBaseNode rootNode = (StringCharacterIndexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringCharacterIndexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringCharacterIndexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringCharacterIndexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCharacterIndexPrimitiveNode.class)
        private static abstract class StringCharacterIndexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringCharacterIndexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringCharacterIndexPrimitiveBaseNode next0;

            StringCharacterIndexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringCharacterIndexPrimitiveBaseNode(StringCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringCharacterIndexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringCharacterIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringCharacterIndexPrimitiveUninitializedNode(this);
                    ((StringCharacterIndexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringCharacterIndexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringCharacterIndexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringCharacterIndexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringCharacterIndexPrimitiveUninitializedNode(this), (Node)new StringCharacterIndexPrimitivePolymorphicNode(this), (DSLNode)((StringCharacterIndexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringCharacterIndexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (StringCharacterIndexPrimitiveBaseNode)StringCharacterIndexPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringCharacterIndexPrimitiveBaseNode otherCast = (StringCharacterIndexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringCharacterIndexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
    public static final class StringByteCharacterIndexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode> {
        private static StringByteCharacterIndexPrimitiveNodeFactory stringByteCharacterIndexPrimitiveNodeFactoryInstance;

        private StringByteCharacterIndexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringByteCharacterIndexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringByteCharacterIndexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode> getInstance() {
            if (stringByteCharacterIndexPrimitiveNodeFactoryInstance == null) {
                stringByteCharacterIndexPrimitiveNodeFactoryInstance = new StringByteCharacterIndexPrimitiveNodeFactory();
            }
            return stringByteCharacterIndexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringByteCharacterIndexPrimitivePolymorphicNode
        extends StringByteCharacterIndexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringByteCharacterIndexPrimitivePolymorphicNode(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteCharacterIndexPrimitiveRubyStringInt3Node
        extends StringByteCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteCharacterIndexPrimitiveRubyStringInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteCharacterIndexPrimitiveRubyStringInt3Node(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!(StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0Value) || StringGuards.isFixedWidthEncoding(arguments0Value) || StringGuards.isValidUtf8(arguments0Value))) {
                    return super.stringByteCharacterIndex(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizableOrAsciiCompatible, !isFixedWidthEncoding, !isValidUtf8] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!(StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0ValueCast) || StringGuards.isFixedWidthEncoding(arguments0ValueCast) || StringGuards.isValidUtf8(arguments0ValueCast))) {
                        return super.stringByteCharacterIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode current) {
                return new StringByteCharacterIndexPrimitiveRubyStringInt3Node((StringByteCharacterIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteCharacterIndexPrimitiveRubyStringInt2Node
        extends StringByteCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteCharacterIndexPrimitiveRubyStringInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteCharacterIndexPrimitiveRubyStringInt2Node(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0Value) && !StringGuards.isFixedWidthEncoding(arguments0Value) && StringGuards.isValidUtf8(arguments0Value)) {
                    return super.stringByteCharacterIndexValidUtf8(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizableOrAsciiCompatible, !isFixedWidthEncoding, isValidUtf8] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0ValueCast) && !StringGuards.isFixedWidthEncoding(arguments0ValueCast) && StringGuards.isValidUtf8(arguments0ValueCast)) {
                        return super.stringByteCharacterIndexValidUtf8(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode current) {
                return new StringByteCharacterIndexPrimitiveRubyStringInt2Node((StringByteCharacterIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteCharacterIndexPrimitiveRubyStringInt1Node
        extends StringByteCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteCharacterIndexPrimitiveRubyStringInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteCharacterIndexPrimitiveRubyStringInt1Node(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0Value) && StringGuards.isFixedWidthEncoding(arguments0Value) && !StringGuards.isValidUtf8(arguments0Value)) {
                    return super.stringByteCharacterIndexFixedWidth(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizableOrAsciiCompatible, isFixedWidthEncoding, !isValidUtf8] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0ValueCast) && StringGuards.isFixedWidthEncoding(arguments0ValueCast) && !StringGuards.isValidUtf8(arguments0ValueCast)) {
                        return super.stringByteCharacterIndexFixedWidth(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode current) {
                return new StringByteCharacterIndexPrimitiveRubyStringInt1Node((StringByteCharacterIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteCharacterIndexPrimitiveRubyStringInt0Node
        extends StringByteCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteCharacterIndexPrimitiveRubyStringInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteCharacterIndexPrimitiveRubyStringInt0Node(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0Value)) {
                    return super.stringByteCharacterIndexSingleByte(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isSingleByteOptimizableOrAsciiCompatible] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0ValueCast)) {
                        return super.stringByteCharacterIndexSingleByte(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create0(StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode current) {
                return new StringByteCharacterIndexPrimitiveRubyStringInt0Node((StringByteCharacterIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringByteCharacterIndexPrimitiveUninitializedNode
        extends StringByteCharacterIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteCharacterIndexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringByteCharacterIndexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringByteCharacterIndexPrimitiveUninitializedNode(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringByteCharacterIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringByteCharacterIndexPrimitiveBaseNode rootNode = (StringByteCharacterIndexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringByteCharacterIndexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringByteCharacterIndexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode.class)
        private static abstract class StringByteCharacterIndexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringByteCharacterIndexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringByteCharacterIndexPrimitiveBaseNode next0;

            StringByteCharacterIndexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringByteCharacterIndexPrimitiveBaseNode(StringByteCharacterIndexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringByteCharacterIndexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringByteCharacterIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringByteCharacterIndexPrimitiveUninitializedNode(this);
                    ((StringByteCharacterIndexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringByteCharacterIndexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringByteCharacterIndexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringByteCharacterIndexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringByteCharacterIndexPrimitiveUninitializedNode(this), (Node)new StringByteCharacterIndexPrimitivePolymorphicNode(this), (DSLNode)((StringByteCharacterIndexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringByteCharacterIndexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizableOrAsciiCompatible(arguments0ValueCast)) {
                        return (StringByteCharacterIndexPrimitiveBaseNode)StringByteCharacterIndexPrimitiveRubyStringInt0Node.create0(this);
                    }
                    if (StringGuards.isFixedWidthEncoding(arguments0ValueCast) && !StringGuards.isValidUtf8(arguments0ValueCast)) {
                        return (StringByteCharacterIndexPrimitiveBaseNode)StringByteCharacterIndexPrimitiveRubyStringInt1Node.create0(this);
                    }
                    if (!StringGuards.isFixedWidthEncoding(arguments0ValueCast) && StringGuards.isValidUtf8(arguments0ValueCast)) {
                        return (StringByteCharacterIndexPrimitiveBaseNode)StringByteCharacterIndexPrimitiveRubyStringInt2Node.create0(this);
                    }
                    if (!StringGuards.isFixedWidthEncoding(arguments0ValueCast) && !StringGuards.isValidUtf8(arguments0ValueCast)) {
                        return (StringByteCharacterIndexPrimitiveBaseNode)StringByteCharacterIndexPrimitiveRubyStringInt3Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringByteCharacterIndexPrimitiveBaseNode otherCast = (StringByteCharacterIndexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringByteCharacterIndexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
    public static final class CharacterByteIndexNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.CharacterByteIndexNode> {
        private static CharacterByteIndexNodeFactory characterByteIndexNodeFactoryInstance;

        private CharacterByteIndexNodeFactory() {
            super(StringPrimitiveNodes.CharacterByteIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.CharacterByteIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CharacterByteIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.CharacterByteIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CharacterByteIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.CharacterByteIndexNode> getInstance() {
            if (characterByteIndexNodeFactoryInstance == null) {
                characterByteIndexNodeFactoryInstance = new CharacterByteIndexNodeFactory();
            }
            return characterByteIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CharacterByteIndexPolymorphicNode
        extends CharacterByteIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            CharacterByteIndexPolymorphicNode(CharacterByteIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CharacterByteIndexRubyStringInt1Node
        extends CharacterByteIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CharacterByteIndexRubyStringInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            CharacterByteIndexRubyStringInt1Node(CharacterByteIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringCharacterByteIndexMultiByteEncoding(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (!StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return super.stringCharacterByteIndexMultiByteEncoding(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.CharacterByteIndexNode create0(StringPrimitiveNodes.CharacterByteIndexNode current) {
                return new CharacterByteIndexRubyStringInt1Node((CharacterByteIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CharacterByteIndexRubyStringInt0Node
        extends CharacterByteIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CharacterByteIndexRubyStringInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            CharacterByteIndexRubyStringInt0Node(CharacterByteIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.stringCharacterByteIndex(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return super.stringCharacterByteIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.CharacterByteIndexNode create0(StringPrimitiveNodes.CharacterByteIndexNode current) {
                return new CharacterByteIndexRubyStringInt0Node((CharacterByteIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CharacterByteIndexUninitializedNode
        extends CharacterByteIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CharacterByteIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CharacterByteIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CharacterByteIndexUninitializedNode(CharacterByteIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                CharacterByteIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CharacterByteIndexBaseNode rootNode = (CharacterByteIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CharacterByteIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.CharacterByteIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CharacterByteIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterByteIndexNode.class)
        private static abstract class CharacterByteIndexBaseNode
        extends StringPrimitiveNodes.CharacterByteIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CharacterByteIndexBaseNode next0;

            CharacterByteIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CharacterByteIndexBaseNode(CharacterByteIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                CharacterByteIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CharacterByteIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new CharacterByteIndexUninitializedNode(this);
                    ((CharacterByteIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CharacterByteIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CharacterByteIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (CharacterByteIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CharacterByteIndexUninitializedNode(this), (Node)new CharacterByteIndexPolymorphicNode(this), (DSLNode)((CharacterByteIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CharacterByteIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (CharacterByteIndexBaseNode)CharacterByteIndexRubyStringInt0Node.create0(this);
                    }
                    return (CharacterByteIndexBaseNode)CharacterByteIndexRubyStringInt1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    CharacterByteIndexBaseNode otherCast = (CharacterByteIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (CharacterByteIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringIndexPrimitiveNode.class)
    public static final class StringIndexPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringIndexPrimitiveNode> {
        private static StringIndexPrimitiveNodeFactory stringIndexPrimitiveNodeFactoryInstance;

        private StringIndexPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringIndexPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringIndexPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringIndexPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringIndexPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringIndexPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringIndexPrimitiveNode> getInstance() {
            if (stringIndexPrimitiveNodeFactoryInstance == null) {
                stringIndexPrimitiveNodeFactoryInstance = new StringIndexPrimitiveNodeFactory();
            }
            return stringIndexPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringIndexPrimitivePolymorphicNode
        extends StringIndexPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringIndexPrimitivePolymorphicNode(StringIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringIndexPrimitiveRubyStringIntNode
        extends StringIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringIndexPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            StringIndexPrimitiveRubyStringIntNode(StringIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringIndex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringIndexPrimitiveNode create0(StringPrimitiveNodes.StringIndexPrimitiveNode current) {
                return new StringIndexPrimitiveRubyStringIntNode((StringIndexPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringIndexPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringIndexPrimitiveUninitializedNode
        extends StringIndexPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringIndexPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringIndexPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringIndexPrimitiveUninitializedNode(StringIndexPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringIndexPrimitiveBaseNode rootNode = (StringIndexPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringIndexPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringIndexPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringIndexPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringIndexPrimitiveNode.class)
        private static abstract class StringIndexPrimitiveBaseNode
        extends StringPrimitiveNodes.StringIndexPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringIndexPrimitiveBaseNode next0;

            StringIndexPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringIndexPrimitiveBaseNode(StringIndexPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringIndexPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringIndexPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringIndexPrimitiveUninitializedNode(this);
                    ((StringIndexPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringIndexPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringIndexPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringIndexPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringIndexPrimitiveUninitializedNode(this), (Node)new StringIndexPrimitivePolymorphicNode(this), (DSLNode)((StringIndexPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringIndexPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (StringIndexPrimitiveBaseNode)StringIndexPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringIndexPrimitiveBaseNode otherCast = (StringIndexPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringIndexPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringToFPrimitiveNode.class)
    public static final class StringToFPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringToFPrimitiveNode> {
        private static StringToFPrimitiveNodeFactory stringToFPrimitiveNodeFactoryInstance;

        private StringToFPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringToFPrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringToFPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringToFPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringToFPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringToFPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringToFPrimitiveNode> getInstance() {
            if (stringToFPrimitiveNodeFactoryInstance == null) {
                stringToFPrimitiveNodeFactoryInstance = new StringToFPrimitiveNodeFactory();
            }
            return stringToFPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToFPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringToFPrimitivePolymorphicNode
        extends StringToFPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StringToFPrimitivePolymorphicNode(StringToFPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToFPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringToFPrimitiveRubyStringNode
        extends StringToFPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringToFPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            StringToFPrimitiveRubyStringNode(StringToFPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.stringToF(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.stringToF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.StringToFPrimitiveNode create0(StringPrimitiveNodes.StringToFPrimitiveNode current) {
                return new StringToFPrimitiveRubyStringNode((StringToFPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToFPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringToFPrimitiveUninitializedNode
        extends StringToFPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringToFPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringToFPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringToFPrimitiveUninitializedNode(StringToFPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StringToFPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringToFPrimitiveBaseNode rootNode = (StringToFPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringToFPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.StringToFPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringToFPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringToFPrimitiveNode.class)
        private static abstract class StringToFPrimitiveBaseNode
        extends StringPrimitiveNodes.StringToFPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringToFPrimitiveBaseNode next0;

            StringToFPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringToFPrimitiveBaseNode(StringToFPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StringToFPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringToFPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StringToFPrimitiveUninitializedNode(this);
                    ((StringToFPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringToFPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringToFPrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StringToFPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringToFPrimitiveUninitializedNode(this), (Node)new StringToFPrimitivePolymorphicNode(this), (DSLNode)((StringToFPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringToFPrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (StringToFPrimitiveBaseNode)StringToFPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StringToFPrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StringToFPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
    public static final class StringFromCodepointPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringFromCodepointPrimitiveNode> {
        private static StringFromCodepointPrimitiveNodeFactory stringFromCodepointPrimitiveNodeFactoryInstance;

        private StringFromCodepointPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringFromCodepointPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringFromCodepointPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringFromCodepointPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringFromCodepointPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringFromCodepointPrimitiveNode> getInstance() {
            if (stringFromCodepointPrimitiveNodeFactoryInstance == null) {
                stringFromCodepointPrimitiveNodeFactoryInstance = new StringFromCodepointPrimitiveNodeFactory();
            }
            return stringFromCodepointPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringFromCodepointPrimitivePolymorphicNode
        extends StringFromCodepointPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringFromCodepointPrimitivePolymorphicNode(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value);
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFromCodepointPrimitiveLongNode
        extends StringFromCodepointPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromCodepointPrimitiveLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyEncoding.class}, 0, 0);

            StringFromCodepointPrimitiveLongNode(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                return super.stringFromCodepointSimple(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    return super.stringFromCodepointSimple(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFromCodepointPrimitiveNode create0(StringPrimitiveNodes.StringFromCodepointPrimitiveNode current) {
                return new StringFromCodepointPrimitiveLongNode((StringFromCodepointPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFromCodepointPrimitiveInt1Node
        extends StringFromCodepointPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromCodepointPrimitiveInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyEncoding.class}, 0, 0);

            StringFromCodepointPrimitiveInt1Node(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                if (!super.isSimple(arguments0Value, arguments1Value)) {
                    return super.stringFromCodepoint(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isSimple] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyEncoding arguments1ValueCast;
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value) && !super.isSimple(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value))) {
                    return super.stringFromCodepoint(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFromCodepointPrimitiveNode create0(StringPrimitiveNodes.StringFromCodepointPrimitiveNode current) {
                return new StringFromCodepointPrimitiveInt1Node((StringFromCodepointPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFromCodepointPrimitiveInt0Node
        extends StringFromCodepointPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromCodepointPrimitiveInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyEncoding.class}, 0, 0);

            StringFromCodepointPrimitiveInt0Node(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                if (super.isSimple(arguments0Value, arguments1Value)) {
                    return super.stringFromCodepointSimple(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isSimple] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyEncoding arguments1ValueCast;
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value) && super.isSimple(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value))) {
                    return super.stringFromCodepointSimple(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFromCodepointPrimitiveNode create0(StringPrimitiveNodes.StringFromCodepointPrimitiveNode current) {
                return new StringFromCodepointPrimitiveInt0Node((StringFromCodepointPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringFromCodepointPrimitiveUninitializedNode
        extends StringFromCodepointPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFromCodepointPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringFromCodepointPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringFromCodepointPrimitiveUninitializedNode(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringFromCodepointPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringFromCodepointPrimitiveBaseNode rootNode = (StringFromCodepointPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringFromCodepointPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFromCodepointPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringFromCodepointPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFromCodepointPrimitiveNode.class)
        private static abstract class StringFromCodepointPrimitiveBaseNode
        extends StringPrimitiveNodes.StringFromCodepointPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringFromCodepointPrimitiveBaseNode next0;

            StringFromCodepointPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringFromCodepointPrimitiveBaseNode(StringFromCodepointPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringFromCodepointPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringFromCodepointPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringFromCodepointPrimitiveUninitializedNode(this);
                    ((StringFromCodepointPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringFromCodepointPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringFromCodepointPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringFromCodepointPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringFromCodepointPrimitiveUninitializedNode(this), (Node)new StringFromCodepointPrimitivePolymorphicNode(this), (DSLNode)((StringFromCodepointPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringFromCodepointPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                        if (super.isSimple(arguments0ValueCast, arguments1ValueCast)) {
                            return (StringFromCodepointPrimitiveBaseNode)StringFromCodepointPrimitiveInt0Node.create0(this);
                        }
                        return (StringFromCodepointPrimitiveBaseNode)StringFromCodepointPrimitiveInt1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (StringFromCodepointPrimitiveBaseNode)StringFromCodepointPrimitiveLongNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringFromCodepointPrimitiveBaseNode otherCast = (StringFromCodepointPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringFromCodepointPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
    public static final class StringFindCharacterPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringFindCharacterPrimitiveNode> {
        private static StringFindCharacterPrimitiveNodeFactory stringFindCharacterPrimitiveNodeFactoryInstance;

        private StringFindCharacterPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringFindCharacterPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringFindCharacterPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringFindCharacterPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringFindCharacterPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringFindCharacterPrimitiveNode> getInstance() {
            if (stringFindCharacterPrimitiveNodeFactoryInstance == null) {
                stringFindCharacterPrimitiveNodeFactoryInstance = new StringFindCharacterPrimitiveNodeFactory();
            }
            return stringFindCharacterPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringFindCharacterPrimitivePolymorphicNode
        extends StringFindCharacterPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringFindCharacterPrimitivePolymorphicNode(StringFindCharacterPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFindCharacterPrimitiveRubyString1Node
        extends StringFindCharacterPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFindCharacterPrimitiveRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringFindCharacterPrimitiveRubyString1Node(StringFindCharacterPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (!StringGuards.isSingleByte(arguments0Value)) {
                    return super.stringFindCharacter(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isSingleByte] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (!StringGuards.isSingleByte(arguments0ValueCast)) {
                        return super.stringFindCharacter(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFindCharacterPrimitiveNode create0(StringPrimitiveNodes.StringFindCharacterPrimitiveNode current) {
                return new StringFindCharacterPrimitiveRubyString1Node((StringFindCharacterPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringFindCharacterPrimitiveRubyString0Node
        extends StringFindCharacterPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFindCharacterPrimitiveRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringFindCharacterPrimitiveRubyString0Node(StringFindCharacterPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (StringGuards.isSingleByte(arguments0Value)) {
                    return super.stringFindCharacterSingleByte(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isSingleByte] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (StringGuards.isSingleByte(arguments0ValueCast)) {
                        return super.stringFindCharacterSingleByte(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFindCharacterPrimitiveNode create0(StringPrimitiveNodes.StringFindCharacterPrimitiveNode current) {
                return new StringFindCharacterPrimitiveRubyString0Node((StringFindCharacterPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringFindCharacterPrimitiveUninitializedNode
        extends StringFindCharacterPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringFindCharacterPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringFindCharacterPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringFindCharacterPrimitiveUninitializedNode(StringFindCharacterPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringFindCharacterPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringFindCharacterPrimitiveBaseNode rootNode = (StringFindCharacterPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringFindCharacterPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringFindCharacterPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringFindCharacterPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringFindCharacterPrimitiveNode.class)
        private static abstract class StringFindCharacterPrimitiveBaseNode
        extends StringPrimitiveNodes.StringFindCharacterPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringFindCharacterPrimitiveBaseNode next0;

            StringFindCharacterPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringFindCharacterPrimitiveBaseNode(StringFindCharacterPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringFindCharacterPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringFindCharacterPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringFindCharacterPrimitiveUninitializedNode(this);
                    ((StringFindCharacterPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringFindCharacterPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringFindCharacterPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringFindCharacterPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringFindCharacterPrimitiveUninitializedNode(this), (Node)new StringFindCharacterPrimitivePolymorphicNode(this), (DSLNode)((StringFindCharacterPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringFindCharacterPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByte(arguments0ValueCast)) {
                        return (StringFindCharacterPrimitiveBaseNode)StringFindCharacterPrimitiveRubyString0Node.create0(this);
                    }
                    return (StringFindCharacterPrimitiveBaseNode)StringFindCharacterPrimitiveRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringFindCharacterPrimitiveBaseNode otherCast = (StringFindCharacterPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringFindCharacterPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringEqualPrimitiveNode.class)
    public static final class StringEqualPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringEqualPrimitiveNode> {
        private static StringEqualPrimitiveNodeFactory stringEqualPrimitiveNodeFactoryInstance;

        private StringEqualPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringEqualPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringEqualPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringEqualPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringEqualPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringEqualPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringEqualPrimitiveNode> getInstance() {
            if (stringEqualPrimitiveNodeFactoryInstance == null) {
                stringEqualPrimitiveNodeFactoryInstance = new StringEqualPrimitiveNodeFactory();
            }
            return stringEqualPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringEqualPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringEqualPrimitivePolymorphicNode
        extends StringEqualPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringEqualPrimitivePolymorphicNode(StringEqualPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringEqualPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringEqualPrimitiveRubyStringNode
        extends StringEqualPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringEqualPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            StringEqualPrimitiveRubyStringNode(StringEqualPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.stringEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.stringEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringEqualPrimitiveNode create0(StringPrimitiveNodes.StringEqualPrimitiveNode current) {
                return new StringEqualPrimitiveRubyStringNode((StringEqualPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringEqualPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringEqualPrimitiveUninitializedNode
        extends StringEqualPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringEqualPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringEqualPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringEqualPrimitiveUninitializedNode(StringEqualPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringEqualPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringEqualPrimitiveBaseNode rootNode = (StringEqualPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringEqualPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringEqualPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringEqualPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringEqualPrimitiveNode.class)
        private static abstract class StringEqualPrimitiveBaseNode
        extends StringPrimitiveNodes.StringEqualPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringEqualPrimitiveBaseNode next0;

            StringEqualPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringEqualPrimitiveBaseNode(StringEqualPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringEqualPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringEqualPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringEqualPrimitiveUninitializedNode(this);
                    ((StringEqualPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringEqualPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringEqualPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringEqualPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringEqualPrimitiveUninitializedNode(this), (Node)new StringEqualPrimitivePolymorphicNode(this), (DSLNode)((StringEqualPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringEqualPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (StringEqualPrimitiveBaseNode)StringEqualPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringEqualPrimitiveBaseNode otherCast = (StringEqualPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringEqualPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class)
    public static final class StringCompareSubstringPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringCompareSubstringPrimitiveNode> {
        private static StringCompareSubstringPrimitiveNodeFactory stringCompareSubstringPrimitiveNodeFactoryInstance;

        private StringCompareSubstringPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringCompareSubstringPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringCompareSubstringPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringCompareSubstringPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringCompareSubstringPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringCompareSubstringPrimitiveNode> getInstance() {
            if (stringCompareSubstringPrimitiveNodeFactoryInstance == null) {
                stringCompareSubstringPrimitiveNodeFactoryInstance = new StringCompareSubstringPrimitiveNodeFactory();
            }
            return stringCompareSubstringPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringCompareSubstringPrimitivePolymorphicNode
        extends StringCompareSubstringPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            StringCompareSubstringPrimitivePolymorphicNode(StringCompareSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringCompareSubstringPrimitiveRubyStringIntNode
        extends StringCompareSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCompareSubstringPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringCompareSubstringPrimitiveRubyStringIntNode(StringCompareSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments3Value;
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int");
                }
                try {
                    arguments3Value = this.arguments[3].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof int");
                }
                return super.stringCompareSubstring(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    int arguments3ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments3Value);
                    return super.stringCompareSubstring(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringPrimitiveNodes.StringCompareSubstringPrimitiveNode create0(StringPrimitiveNodes.StringCompareSubstringPrimitiveNode current) {
                return new StringCompareSubstringPrimitiveRubyStringIntNode((StringCompareSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringCompareSubstringPrimitiveUninitializedNode
        extends StringCompareSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCompareSubstringPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringCompareSubstringPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringCompareSubstringPrimitiveUninitializedNode(StringCompareSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                StringCompareSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringCompareSubstringPrimitiveBaseNode rootNode = (StringCompareSubstringPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringCompareSubstringPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringPrimitiveNodes.StringCompareSubstringPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringCompareSubstringPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCompareSubstringPrimitiveNode.class)
        private static abstract class StringCompareSubstringPrimitiveBaseNode
        extends StringPrimitiveNodes.StringCompareSubstringPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringCompareSubstringPrimitiveBaseNode next0;

            StringCompareSubstringPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringCompareSubstringPrimitiveBaseNode(StringCompareSubstringPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason) {
                String message;
                StringCompareSubstringPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringCompareSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new StringCompareSubstringPrimitiveUninitializedNode(this);
                    ((StringCompareSubstringPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringCompareSubstringPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringCompareSubstringPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (StringCompareSubstringPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringCompareSubstringPrimitiveUninitializedNode(this), (Node)new StringCompareSubstringPrimitivePolymorphicNode(this), (DSLNode)((StringCompareSubstringPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringCompareSubstringPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value)) {
                    return (StringCompareSubstringPrimitiveBaseNode)StringCompareSubstringPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    StringCompareSubstringPrimitiveBaseNode otherCast = (StringCompareSubstringPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (StringCompareSubstringPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringChrAtPrimitiveNode.class)
    public static final class StringChrAtPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringChrAtPrimitiveNode> {
        private static StringChrAtPrimitiveNodeFactory stringChrAtPrimitiveNodeFactoryInstance;

        private StringChrAtPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringChrAtPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringChrAtPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringChrAtPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringChrAtPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringChrAtPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringChrAtPrimitiveNode> getInstance() {
            if (stringChrAtPrimitiveNodeFactoryInstance == null) {
                stringChrAtPrimitiveNodeFactoryInstance = new StringChrAtPrimitiveNodeFactory();
            }
            return stringChrAtPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringChrAtPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringChrAtPrimitivePolymorphicNode
        extends StringChrAtPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringChrAtPrimitivePolymorphicNode(StringChrAtPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringChrAtPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringChrAtPrimitiveRubyStringNode
        extends StringChrAtPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringChrAtPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringChrAtPrimitiveRubyStringNode(StringChrAtPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.stringChrAt(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.stringChrAt(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringChrAtPrimitiveNode create0(StringPrimitiveNodes.StringChrAtPrimitiveNode current) {
                return new StringChrAtPrimitiveRubyStringNode((StringChrAtPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringChrAtPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringChrAtPrimitiveUninitializedNode
        extends StringChrAtPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringChrAtPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringChrAtPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringChrAtPrimitiveUninitializedNode(StringChrAtPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringChrAtPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringChrAtPrimitiveBaseNode rootNode = (StringChrAtPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringChrAtPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringChrAtPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringChrAtPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringChrAtPrimitiveNode.class)
        private static abstract class StringChrAtPrimitiveBaseNode
        extends StringPrimitiveNodes.StringChrAtPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringChrAtPrimitiveBaseNode next0;

            StringChrAtPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringChrAtPrimitiveBaseNode(StringChrAtPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringChrAtPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringChrAtPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringChrAtPrimitiveUninitializedNode(this);
                    ((StringChrAtPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringChrAtPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringChrAtPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringChrAtPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringChrAtPrimitiveUninitializedNode(this), (Node)new StringChrAtPrimitivePolymorphicNode(this), (DSLNode)((StringChrAtPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringChrAtPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (StringChrAtPrimitiveBaseNode)StringChrAtPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringChrAtPrimitiveBaseNode otherCast = (StringChrAtPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringChrAtPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class)
    public static final class StringCheckNullSafePrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringCheckNullSafePrimitiveNode> {
        private static StringCheckNullSafePrimitiveNodeFactory stringCheckNullSafePrimitiveNodeFactoryInstance;

        private StringCheckNullSafePrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringCheckNullSafePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringCheckNullSafePrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringCheckNullSafePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringCheckNullSafePrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringCheckNullSafePrimitiveNode> getInstance() {
            if (stringCheckNullSafePrimitiveNodeFactoryInstance == null) {
                stringCheckNullSafePrimitiveNodeFactoryInstance = new StringCheckNullSafePrimitiveNodeFactory();
            }
            return stringCheckNullSafePrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringCheckNullSafePrimitivePolymorphicNode
        extends StringCheckNullSafePrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StringCheckNullSafePrimitivePolymorphicNode(StringCheckNullSafePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringCheckNullSafePrimitiveRubyStringNode
        extends StringCheckNullSafePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCheckNullSafePrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            StringCheckNullSafePrimitiveRubyStringNode(StringCheckNullSafePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.stringCheckNullSafe(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.stringCheckNullSafe(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.StringCheckNullSafePrimitiveNode create0(StringPrimitiveNodes.StringCheckNullSafePrimitiveNode current) {
                return new StringCheckNullSafePrimitiveRubyStringNode((StringCheckNullSafePrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringCheckNullSafePrimitiveUninitializedNode
        extends StringCheckNullSafePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringCheckNullSafePrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringCheckNullSafePrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringCheckNullSafePrimitiveUninitializedNode(StringCheckNullSafePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StringCheckNullSafePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringCheckNullSafePrimitiveBaseNode rootNode = (StringCheckNullSafePrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringCheckNullSafePrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.StringCheckNullSafePrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringCheckNullSafePrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringCheckNullSafePrimitiveNode.class)
        private static abstract class StringCheckNullSafePrimitiveBaseNode
        extends StringPrimitiveNodes.StringCheckNullSafePrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringCheckNullSafePrimitiveBaseNode next0;

            StringCheckNullSafePrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringCheckNullSafePrimitiveBaseNode(StringCheckNullSafePrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StringCheckNullSafePrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringCheckNullSafePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StringCheckNullSafePrimitiveUninitializedNode(this);
                    ((StringCheckNullSafePrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringCheckNullSafePrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringCheckNullSafePrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StringCheckNullSafePrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringCheckNullSafePrimitiveUninitializedNode(this), (Node)new StringCheckNullSafePrimitivePolymorphicNode(this), (DSLNode)((StringCheckNullSafePrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringCheckNullSafePrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (StringCheckNullSafePrimitiveBaseNode)StringCheckNullSafePrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StringCheckNullSafePrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StringCheckNullSafePrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
    public static final class StringByteSubstringPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringByteSubstringPrimitiveNode> {
        private static StringByteSubstringPrimitiveNodeFactory stringByteSubstringPrimitiveNodeFactoryInstance;

        private StringByteSubstringPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringByteSubstringPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringByteSubstringPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringByteSubstringPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringByteSubstringPrimitiveNode> getInstance() {
            if (stringByteSubstringPrimitiveNodeFactoryInstance == null) {
                stringByteSubstringPrimitiveNodeFactoryInstance = new StringByteSubstringPrimitiveNodeFactory();
            }
            return stringByteSubstringPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringByteSubstringPrimitivePolymorphicNode
        extends StringByteSubstringPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StringByteSubstringPrimitivePolymorphicNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyRange.class ? this.arguments[1].executeRubyRange(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[2].executeLongFixnum(frameValue)) : (this.arguments2PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[2].executeFloat(frameValue)) : this.arguments[2].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringObjectObjectNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringObjectObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class, Object.class}, 0, 0);

            StringByteSubstringPrimitiveRubyStringObjectObjectNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!super.isRubyRange(arguments1Value)) {
                    return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isRubyRange] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyRange(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringObjectObjectNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringRubyRangeUndefinedPlaceholderNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringRubyRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.class, UndefinedPlaceholder.class}, 0, 0);

            StringByteSubstringPrimitiveRubyStringRubyRangeUndefinedPlaceholderNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringRubyRangeUndefinedPlaceholderNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringDoubleIntNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Double.TYPE, Integer.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringDoubleIntNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                double arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof double");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringDoubleIntNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringDoubleDoubleNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringDoubleDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Double.TYPE, Double.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringDoubleDoubleNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments2Value;
                double arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof double");
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof double");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringDoubleDoubleNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringLongLongNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringLongLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Long.TYPE, Long.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringLongLongNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments2Value;
                long arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof long");
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof long");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringLongLongNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringIntLongNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Long.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringIntLongNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof long");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringIntLongNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringLongIntNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Long.TYPE, Integer.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringLongIntNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                long arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof long");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringLongIntNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringDoubleUndefinedPlaceholderNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            StringByteSubstringPrimitiveRubyStringDoubleUndefinedPlaceholderNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                double arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof double");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringDoubleUndefinedPlaceholderNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringIntDoubleNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Double.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringIntDoubleNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof double");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringIntDoubleNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringIntIntNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            StringByteSubstringPrimitiveRubyStringIntIntNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringIntIntNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringByteSubstringPrimitiveRubyStringIntUndefinedPlaceholderNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveRubyStringIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            StringByteSubstringPrimitiveRubyStringIntUndefinedPlaceholderNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.stringByteSubstring(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.stringByteSubstring(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(StringPrimitiveNodes.StringByteSubstringPrimitiveNode current) {
                return new StringByteSubstringPrimitiveRubyStringIntUndefinedPlaceholderNode((StringByteSubstringPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringByteSubstringPrimitiveUninitializedNode
        extends StringByteSubstringPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringByteSubstringPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringByteSubstringPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringByteSubstringPrimitiveUninitializedNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StringByteSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringByteSubstringPrimitiveBaseNode rootNode = (StringByteSubstringPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringByteSubstringPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringPrimitiveNodes.StringByteSubstringPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringByteSubstringPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringByteSubstringPrimitiveNode.class)
        private static abstract class StringByteSubstringPrimitiveBaseNode
        extends StringPrimitiveNodes.StringByteSubstringPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringByteSubstringPrimitiveBaseNode next0;

            StringByteSubstringPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringByteSubstringPrimitiveBaseNode(StringByteSubstringPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StringByteSubstringPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringByteSubstringPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StringByteSubstringPrimitiveUninitializedNode(this);
                    ((StringByteSubstringPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringByteSubstringPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringByteSubstringPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StringByteSubstringPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringByteSubstringPrimitiveUninitializedNode(this), (Node)new StringByteSubstringPrimitivePolymorphicNode(this), (DSLNode)((StringByteSubstringPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringByteSubstringPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringIntUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringIntIntNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringIntDoubleNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringDoubleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringIntLongNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringLongLongNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringDoubleDoubleNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                            return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringDoubleIntNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringRubyRangeUndefinedPlaceholderNode.create0(this);
                    }
                    if (!super.isRubyRange(arguments1Value)) {
                        return (StringByteSubstringPrimitiveBaseNode)StringByteSubstringPrimitiveRubyStringObjectObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StringByteSubstringPrimitiveBaseNode otherCast = (StringByteSubstringPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StringByteSubstringPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class)
    public static final class StringAwkSplitPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.StringAwkSplitPrimitiveNode> {
        private static StringAwkSplitPrimitiveNodeFactory stringAwkSplitPrimitiveNodeFactoryInstance;

        private StringAwkSplitPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.StringAwkSplitPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringAwkSplitPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.StringAwkSplitPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringAwkSplitPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.StringAwkSplitPrimitiveNode> getInstance() {
            if (stringAwkSplitPrimitiveNodeFactoryInstance == null) {
                stringAwkSplitPrimitiveNodeFactoryInstance = new StringAwkSplitPrimitiveNodeFactory();
            }
            return stringAwkSplitPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringAwkSplitPrimitivePolymorphicNode
        extends StringAwkSplitPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StringAwkSplitPrimitivePolymorphicNode(StringAwkSplitPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringAwkSplitPrimitiveRubyStringNode
        extends StringAwkSplitPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringAwkSplitPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            StringAwkSplitPrimitiveRubyStringNode(StringAwkSplitPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.stringAwkSplit(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.stringAwkSplit(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringAwkSplitPrimitiveNode create0(StringPrimitiveNodes.StringAwkSplitPrimitiveNode current) {
                return new StringAwkSplitPrimitiveRubyStringNode((StringAwkSplitPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringAwkSplitPrimitiveUninitializedNode
        extends StringAwkSplitPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringAwkSplitPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringAwkSplitPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringAwkSplitPrimitiveUninitializedNode(StringAwkSplitPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StringAwkSplitPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringAwkSplitPrimitiveBaseNode rootNode = (StringAwkSplitPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringAwkSplitPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringPrimitiveNodes.StringAwkSplitPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringAwkSplitPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.StringAwkSplitPrimitiveNode.class)
        private static abstract class StringAwkSplitPrimitiveBaseNode
        extends StringPrimitiveNodes.StringAwkSplitPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringAwkSplitPrimitiveBaseNode next0;

            StringAwkSplitPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringAwkSplitPrimitiveBaseNode(StringAwkSplitPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                StringAwkSplitPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringAwkSplitPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StringAwkSplitPrimitiveUninitializedNode(this);
                    ((StringAwkSplitPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringAwkSplitPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringAwkSplitPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StringAwkSplitPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringAwkSplitPrimitiveUninitializedNode(this), (Node)new StringAwkSplitPrimitivePolymorphicNode(this), (DSLNode)((StringAwkSplitPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringAwkSplitPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (StringAwkSplitPrimitiveBaseNode)StringAwkSplitPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StringAwkSplitPrimitiveBaseNode otherCast = (StringAwkSplitPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StringAwkSplitPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class)
    public static final class CharacterAsciiPrimitiveNodeFactory
    extends NodeFactoryBase<StringPrimitiveNodes.CharacterAsciiPrimitiveNode> {
        private static CharacterAsciiPrimitiveNodeFactory characterAsciiPrimitiveNodeFactoryInstance;

        private CharacterAsciiPrimitiveNodeFactory() {
            super(StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringPrimitiveNodes.CharacterAsciiPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CharacterAsciiPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringPrimitiveNodes.CharacterAsciiPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CharacterAsciiPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringPrimitiveNodes.CharacterAsciiPrimitiveNode> getInstance() {
            if (characterAsciiPrimitiveNodeFactoryInstance == null) {
                characterAsciiPrimitiveNodeFactoryInstance = new CharacterAsciiPrimitiveNodeFactory();
            }
            return characterAsciiPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CharacterAsciiPrimitivePolymorphicNode
        extends CharacterAsciiPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CharacterAsciiPrimitivePolymorphicNode(CharacterAsciiPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CharacterAsciiPrimitiveRubyStringNode
        extends CharacterAsciiPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CharacterAsciiPrimitiveRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            CharacterAsciiPrimitiveRubyStringNode(CharacterAsciiPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.isCharacterAscii(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.isCharacterAscii(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.CharacterAsciiPrimitiveNode create0(StringPrimitiveNodes.CharacterAsciiPrimitiveNode current) {
                return new CharacterAsciiPrimitiveRubyStringNode((CharacterAsciiPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CharacterAsciiPrimitiveUninitializedNode
        extends CharacterAsciiPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CharacterAsciiPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CharacterAsciiPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CharacterAsciiPrimitiveUninitializedNode(CharacterAsciiPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CharacterAsciiPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CharacterAsciiPrimitiveBaseNode rootNode = (CharacterAsciiPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CharacterAsciiPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringPrimitiveNodes.CharacterAsciiPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CharacterAsciiPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringPrimitiveNodes.CharacterAsciiPrimitiveNode.class)
        private static abstract class CharacterAsciiPrimitiveBaseNode
        extends StringPrimitiveNodes.CharacterAsciiPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CharacterAsciiPrimitiveBaseNode next0;

            CharacterAsciiPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CharacterAsciiPrimitiveBaseNode(CharacterAsciiPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CharacterAsciiPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CharacterAsciiPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CharacterAsciiPrimitiveUninitializedNode(this);
                    ((CharacterAsciiPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CharacterAsciiPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CharacterAsciiPrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CharacterAsciiPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CharacterAsciiPrimitiveUninitializedNode(this), (Node)new CharacterAsciiPrimitivePolymorphicNode(this), (DSLNode)((CharacterAsciiPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CharacterAsciiPrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (CharacterAsciiPrimitiveBaseNode)CharacterAsciiPrimitiveRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CharacterAsciiPrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CharacterAsciiPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

