/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class NativeFunctionPrimitiveNodes {
    public static final int TYPE_CHAR = 0;
    public static final int TYPE_UCHAR = 1;
    public static final int TYPE_BOOL = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_USHORT = 4;
    public static final int TYPE_INT = 5;
    public static final int TYPE_UINT = 6;
    public static final int TYPE_LONG = 7;
    public static final int TYPE_ULONG = 8;
    public static final int TYPE_LL = 9;
    public static final int TYPE_ULL = 10;
    public static final int TYPE_FLOAT = 11;
    public static final int TYPE_DOUBLE = 12;
    public static final int TYPE_PTR = 13;
    public static final int TYPE_VOID = 14;
    public static final int TYPE_STRING = 15;
    public static final int TYPE_STRPTR = 16;
    public static final int TYPE_CHARARR = 17;
    public static final int TYPE_ENUM = 18;
    public static final int TYPE_VARARGS = 19;

    @RubiniusPrimitive(name="nativefunction_type_size", needsSelf=false)
    public static abstract class NativeFunctionTypeSizePrimitiveNode
    extends RubiniusPrimitiveNode {
        public NativeFunctionTypeSizePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NativeFunctionTypeSizePrimitiveNode(NativeFunctionTypeSizePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long typeSize(int type) {
            switch (type) {
                case 0: 
                case 1: {
                    return 1L;
                }
                case 3: 
                case 4: {
                    return 2L;
                }
                case 5: 
                case 6: {
                    return 4L;
                }
                case 7: 
                case 8: {
                    return 8L;
                }
                case 11: {
                    return 4L;
                }
                case 12: {
                    return 8L;
                }
                case 13: 
                case 16: {
                    return 8L;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

