/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class ExceptionPrimitiveNodes {
    private static final int ENOENT = Errno.ENOENT.intValue();

    @RubiniusPrimitive(name="exception_errno_error", needsSelf=false)
    public static abstract class ExceptionErrnoErrorPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ExceptionErrnoErrorPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExceptionErrnoErrorPrimitiveNode(ExceptionErrnoErrorPrimitiveNode prev) {
            super(prev);
        }

        @Specialization(guards={"isENOENT(arguments[1])"})
        public RubyException enoent(RubyString message, int errno) {
            return this.getContext().getCoreLibrary().fileNotFoundError(message.toString(), this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isENOENT(arguments[1])"})
        public RubyException unsupported(RubyString message, int errno) {
            Errno errnoObject = Errno.valueOf((long)errno);
            if (errnoObject == null) {
                throw new UnsupportedOperationException("errno: " + errno + " " + message);
            }
            throw new UnsupportedOperationException("errno: " + errnoObject.name());
        }

        protected boolean isENOENT(int errno) {
            return errno == ENOENT;
        }
    }
}

