/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Ptr;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

public abstract class EncodingConverterPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_converter_primitive_errinfo")
    public static abstract class EncodingConverterErrinfoNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterErrinfoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingConverterErrinfoNode(EncodingConverterErrinfoNode prev) {
            super(prev);
        }

        @Specialization
        public Object encodingConverterLastError(RubyEncodingConverter encodingConverter) {
            EncodingConverterErrinfoNode.notDesignedForCompilation();
            EConv ec = encodingConverter.getEConv();
            Object[] ret = new Object[]{this.getContext().getSymbol(ec.lastError.getResult().symbolicName()), this.nil(), this.nil(), this.nil(), this.nil()};
            if (ec.lastError.getSource() != null) {
                ret[1] = this.getContext().makeString(new ByteList(ec.lastError.getSource()));
            }
            if (ec.lastError.getDestination() != null) {
                ret[2] = this.getContext().makeString(new ByteList(ec.lastError.getDestination()));
            }
            if (ec.lastError.getErrorBytes() != null) {
                ret[3] = this.getContext().makeString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength()));
                ret[4] = this.getContext().makeString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP() + ec.lastError.getErrorBytesLength(), ec.lastError.getReadAgainLength()));
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ret, ret.length);
        }
    }

    @RubiniusPrimitive(name="encoding_converter_last_error")
    public static abstract class EncodingConverterLastErrorNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public EncodingConverterLastErrorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public EncodingConverterLastErrorNode(EncodingConverterLastErrorNode prev) {
            super(prev);
            this.newLookupTableNode = prev.newLookupTableNode;
            this.lookupTableWriteNode = prev.lookupTableWriteNode;
        }

        @Specialization
        public Object encodingConverterLastError(VirtualFrame frame, RubyEncodingConverter encodingConverter) {
            EncodingConverterLastErrorNode.notDesignedForCompilation();
            EConv ec = encodingConverter.getEConv();
            EConv.LastError lastError = ec.lastError;
            if (lastError.getResult() != EConvResult.InvalidByteSequence && lastError.getResult() != EConvResult.IncompleteInput && lastError.getResult() != EConvResult.UndefinedConversion) {
                return this.nil();
            }
            Object ret = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getContext().getSymbol("result"), this.eConvResultToSymbol(lastError.getResult()));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getContext().getSymbol("source_encoding_name"), this.getContext().makeString(new ByteList(lastError.getSource())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getContext().getSymbol("destination_encoding_name"), this.getContext().makeString(new ByteList(lastError.getDestination())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getContext().getSymbol("error_bytes"), this.getContext().makeString(new ByteList(lastError.getErrorBytes())));
            if (lastError.getReadAgainLength() != 0) {
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getContext().getSymbol("read_again_bytes"), lastError.getReadAgainLength());
            }
            return ret;
        }

        private RubySymbol eConvResultToSymbol(EConvResult result) {
            switch (result) {
                case InvalidByteSequence: {
                    return this.getContext().getSymbol("invalid_byte_sequence");
                }
                case UndefinedConversion: {
                    return this.getContext().getSymbol("undefined_conversion");
                }
                case DestinationBufferFull: {
                    return this.getContext().getSymbol("destination_buffer_full");
                }
                case SourceBufferEmpty: {
                    return this.getContext().getSymbol("source_buffer_empty");
                }
                case Finished: {
                    return this.getContext().getSymbol("finished");
                }
                case AfterOutput: {
                    return this.getContext().getSymbol("after_output");
                }
                case IncompleteInput: {
                    return this.getContext().getSymbol("incomplete_input");
                }
            }
            throw new UnsupportedOperationException(String.format("Unknown EConv result: %s", result));
        }
    }

    @RubiniusPrimitive(name="encoding_converter_putback")
    public static abstract class EncodingConverterPutbackNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterPutbackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingConverterPutbackNode(EncodingConverterPutbackNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString encodingConverterPutback(RubyEncodingConverter encodingConverter, int maxBytes) {
            EConv ec = encodingConverter.getEConv();
            int putbackable = ec.putbackable();
            return this.putback(encodingConverter, putbackable < maxBytes ? putbackable : maxBytes);
        }

        @Specialization
        public RubyString encodingConverterPutback(RubyEncodingConverter encodingConverter, UndefinedPlaceholder maxBytes) {
            EConv ec = encodingConverter.getEConv();
            return this.putback(encodingConverter, ec.putbackable());
        }

        private RubyString putback(RubyEncodingConverter encodingConverter, int n) {
            EConv ec = encodingConverter.getEConv();
            ByteList bytes = new ByteList(n);
            ec.putback(bytes.getUnsafeBytes(), bytes.getBegin(), n);
            bytes.setRealSize(n);
            if (ec.sourceEncoding != null) {
                bytes.setEncoding(ec.sourceEncoding);
            }
            return this.getContext().makeString(bytes);
        }
    }

    @RubiniusPrimitive(name="encoding_converter_primitive_convert")
    public static abstract class PrimitiveConvertNode
    extends RubiniusPrimitiveNode {
        public PrimitiveConvertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrimitiveConvertNode(PrimitiveConvertNode prev) {
            super(prev);
        }

        @Specialization
        public Object encodingConverterPrimitiveConvert(RubyEncodingConverter encodingConverter, RubyString source, RubyString target, int offset, int size, RubyHash options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Specialization
        public Object encodingConverterPrimitiveConvert(RubyEncodingConverter encodingConverter, RubyString source, RubyString target, int offset, int size, int options) {
            EConvResult res;
            boolean growOutputBuffer;
            source.modify();
            source.clearCodeRange();
            target.modify();
            target.clearCodeRange();
            ByteList inBytes = source.getByteList();
            ByteList outBytes = target.getByteList();
            Ptr inPtr = new Ptr();
            Ptr outPtr = new Ptr();
            EConv ec = encodingConverter.getEConv();
            boolean changeOffset = offset == 0;
            boolean bl = growOutputBuffer = size == -1;
            if (size == -1 && (size = 16) < source.getByteList().getRealSize()) {
                size = source.getByteList().getRealSize();
            }
            while (true) {
                if (changeOffset) {
                    offset = outBytes.getRealSize();
                }
                if (outBytes.getRealSize() < offset) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("output offset too big", this));
                }
                long outputByteEnd = offset + size;
                if (outputByteEnd > Integer.MAX_VALUE) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("output offset + bytesize too big", this));
                }
                outBytes.ensure((int)outputByteEnd);
                inPtr.p = inBytes.getBegin();
                outPtr.p = outBytes.getBegin() + offset;
                int os = outPtr.p + size;
                res = ec.convert(inBytes.getUnsafeBytes(), inPtr, inBytes.getRealSize() + inPtr.p, outBytes.getUnsafeBytes(), outPtr, os, options);
                outBytes.setRealSize(outPtr.p - outBytes.begin());
                source.getByteList().setRealSize(inBytes.getRealSize() - (inPtr.p - inBytes.getBegin()));
                source.getByteList().setBegin(inPtr.p);
                if (!growOutputBuffer || res != EConvResult.DestinationBufferFull) break;
                if (0x3FFFFFFF < size) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("too long conversion result", this));
                }
                size *= 2;
            }
            if (ec.destinationEncoding != null) {
                outBytes.setEncoding(ec.destinationEncoding);
            }
            return this.getContext().getSymbol(res.symbolicName());
        }
    }

    @RubiniusPrimitive(name="encoding_converter_allocate")
    public static abstract class EncodingConverterAllocateNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterAllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingConverterAllocateNode(EncodingConverterAllocateNode prev) {
            super(prev);
        }

        @Specialization
        public Object encodingConverterAllocate(RubyClass encodingConverterClass, UndefinedPlaceholder undefined1, UndefinedPlaceholder undefined2) {
            return new RubyEncodingConverter(encodingConverterClass, null);
        }
    }
}

