/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=TaintNode.class)
public final class TaintNodeFactory
extends NodeFactoryBase<TaintNode> {
    private static TaintNodeFactory instance;

    private TaintNodeFactory() {
        super(TaintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public TaintNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return TaintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static TaintNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return TaintUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<TaintNode> getInstance() {
        if (instance == null) {
            instance = new TaintNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class TaintPolymorphicNode
    extends TaintBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        TaintPolymorphicNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubySymbol.class ? this.child.executeRubySymbol(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(ex.getResult());
            }
            return this.next0.executeChained0(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated)) : (this.childPolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated) : (this.childPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated) : childValueEvaluated)))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(ex.getResult());
            }
            return this.next0.executeChained0(childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(Object childValue) {
            return this.next0.executeChained0(childValue);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintRubyBasicObjectNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        TaintRubyBasicObjectNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubySymbol(childValue)) {
                return super.taint(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [!isRubySymbol] failed");
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            RubyBasicObject childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubySymbol(childValue)) {
                return super.taint(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [!isRubySymbol] failed");
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!super.isRubySymbol(childValue)) {
                    return super.taint(childValueCast);
                }
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintRubyBasicObjectNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintRubySymbolNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

        TaintRubySymbolNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol childValue;
            try {
                childValue = this.child.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.taint(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            RubySymbol childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.taint(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                RubySymbol childValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(childValue);
                return super.taint(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintRubySymbolNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintDoubleNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        TaintDoubleNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof double");
            }
            return super.taint(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            double childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof double");
            }
            return super.taint(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.taint(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintDoubleNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintLongNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        TaintLongNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof long");
            }
            return super.taint(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            long childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof long");
            }
            return super.taint(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.taint(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintLongNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintIntNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        TaintIntNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof int");
            }
            return super.taint(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            int childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof int");
            }
            return super.taint(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.taint(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintIntNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class TaintBooleanNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        TaintBooleanNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.taint(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            boolean childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.taint(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.taint(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static TaintNode create0(TaintNode current) {
            return new TaintBooleanNode((TaintBaseNode)current);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class TaintUninitializedNode
    extends TaintBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(TaintUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        TaintUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        TaintUninitializedNode(TaintBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(childValue);
        }

        @Override
        public Object executeTaint(Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(childValue);
        }

        protected Object executeUninitialized0(Object childValue) {
            TaintBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                TaintBaseNode rootNode = (TaintBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((TaintBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(childValue);
        }

        static TaintNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new TaintUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=TaintNode.class)
    private static abstract class TaintBaseNode
    extends TaintNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected TaintBaseNode next0;

        TaintBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        TaintBaseNode(TaintBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(Object var1);

        protected final Object rewrite0(Object childValue, String reason) {
            String message;
            TaintBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            TaintBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new TaintUninitializedNode(this);
                ((TaintUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (TaintBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = TaintBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (TaintBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new TaintUninitializedNode(this), (Node)new TaintPolymorphicNode(this), (DSLNode)((TaintBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final TaintBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (TaintBaseNode)TaintBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (TaintBaseNode)TaintIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (TaintBaseNode)TaintLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (TaintBaseNode)TaintDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                return (TaintBaseNode)TaintRubySymbolNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubySymbol(childValue)) {
                return (TaintBaseNode)TaintRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((TaintBaseNode)other).child;
            this.next0 = newNext == null ? null : (TaintBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

