/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=FreezeNode.class)
public final class FreezeNodeFactory
extends NodeFactoryBase<FreezeNode> {
    private static FreezeNodeFactory instance;

    private FreezeNodeFactory() {
        super(FreezeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public FreezeNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return FreezeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static FreezeNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return FreezeUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<FreezeNode> getInstance() {
        if (instance == null) {
            instance = new FreezeNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class FreezePolymorphicNode
    extends FreezeBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        FreezePolymorphicNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubyBignum.class ? this.child.executeBignum(frameValue) : (this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubySymbol.class ? this.child.executeRubySymbol(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(ex.getResult());
            }
            return this.next0.executeChained0(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated)) : (this.childPolymorphicType == RubyBignum.class ? RubyTypesGen.RUBYTYPES.expectRubyBignum(childValueEvaluated) : (this.childPolymorphicType == RubyNilClass.class ? RubyTypesGen.RUBYTYPES.expectRubyNilClass(childValueEvaluated) : (this.childPolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated) : (this.childPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated) : childValueEvaluated)))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(ex.getResult());
            }
            return this.next0.executeChained0(childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(Object childValue) {
            return this.next0.executeChained0(childValue);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeRubyBasicObjectNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        FreezeRubyBasicObjectNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!(super.isRubyNilClass(childValue) || super.isRubyBignum(childValue) || super.isRubySymbol(childValue))) {
                return super.freeze(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [!isRubyNilClass, !isRubyBignum, !isRubySymbol] failed");
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            RubyBasicObject childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!(super.isRubyNilClass(childValue) || super.isRubyBignum(childValue) || super.isRubySymbol(childValue))) {
                return super.freeze(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [!isRubyNilClass, !isRubyBignum, !isRubySymbol] failed");
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!(super.isRubyNilClass(childValue) || super.isRubyBignum(childValue) || super.isRubySymbol(childValue))) {
                    return super.freeze(childValueCast);
                }
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeRubyBasicObjectNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeRubySymbolNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

        FreezeRubySymbolNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol childValue;
            try {
                childValue = this.child.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            RubySymbol childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                RubySymbol childValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeRubySymbolNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeRubyBignumNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

        FreezeRubyBignumNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBignum childValue;
            try {
                childValue = this.child.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBignum");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            RubyBignum childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBignum(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyBignum");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                RubyBignum childValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeRubyBignumNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeRubyNilClassNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        FreezeRubyNilClassNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            RubyNilClass childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyNilClass(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeRubyNilClassNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeDoubleNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        FreezeDoubleNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof double");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            double childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof double");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeDoubleNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeLongNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        FreezeLongNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof long");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            long childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof long");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeLongNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeIntNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        FreezeIntNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof int");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            int childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof int");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeIntNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class FreezeBooleanNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        FreezeBooleanNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.freeze(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            boolean childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.freeze(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.freeze(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static FreezeNode create0(FreezeNode current) {
            return new FreezeBooleanNode((FreezeBaseNode)current);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class FreezeUninitializedNode
    extends FreezeBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(FreezeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        FreezeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        FreezeUninitializedNode(FreezeBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(childValue);
        }

        @Override
        public Object executeFreeze(Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(childValue);
        }

        protected Object executeUninitialized0(Object childValue) {
            FreezeBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                FreezeBaseNode rootNode = (FreezeBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((FreezeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(childValue);
        }

        static FreezeNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new FreezeUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    private static abstract class FreezeBaseNode
    extends FreezeNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected FreezeBaseNode next0;

        FreezeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        FreezeBaseNode(FreezeBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(Object var1);

        protected final Object rewrite0(Object childValue, String reason) {
            String message;
            FreezeBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            FreezeBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new FreezeUninitializedNode(this);
                ((FreezeUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (FreezeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = FreezeBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (FreezeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FreezeUninitializedNode(this), (Node)new FreezePolymorphicNode(this), (DSLNode)((FreezeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final FreezeBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (FreezeBaseNode)FreezeBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (FreezeBaseNode)FreezeIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (FreezeBaseNode)FreezeLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (FreezeBaseNode)FreezeDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (FreezeBaseNode)FreezeRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                return (FreezeBaseNode)FreezeRubyBignumNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                return (FreezeBaseNode)FreezeRubySymbolNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubyNilClass(childValue) && !super.isRubyBignum(childValue) && !super.isRubySymbol(childValue)) {
                return (FreezeBaseNode)FreezeRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((FreezeBaseNode)other).child;
            this.next0 = newNext == null ? null : (FreezeBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

