/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ValueProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;

public class ReadPreArgumentNode
extends RubyNode {
    private final int index;
    private final BranchProfile outOfRangeProfile = BranchProfile.create();
    private final MissingArgumentBehaviour missingArgumentBehaviour;
    private final ValueProfile argumentValueProfile = ValueProfile.createPrimitiveProfile();

    public ReadPreArgumentNode(RubyContext context, SourceSection sourceSection, int index, MissingArgumentBehaviour missingArgumentBehaviour) {
        super(context, sourceSection);
        this.index = index;
        this.missingArgumentBehaviour = missingArgumentBehaviour;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.index >= RubyArguments.getUserArgumentsCount(frame.getArguments())) {
            this.outOfRangeProfile.enter();
            switch (this.missingArgumentBehaviour) {
                case RUNTIME_ERROR: {
                    break;
                }
                case UNDEFINED: {
                    return UndefinedPlaceholder.INSTANCE;
                }
                case NIL: {
                    return this.nil();
                }
            }
        }
        return this.argumentValueProfile.profile(RubyArguments.getUserArgument(frame.getArguments(), this.index));
    }
}

