/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class BlockDefinitionNode
extends RubyNode {
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTargetForBlocks;
    private final CallTarget callTargetForProcs;
    private final CallTarget callTargetForMethods;
    private final boolean requiresDeclarationFrame;
    private final TranslatorEnvironment.BlockID blockID;

    public BlockDefinitionNode(RubyContext context, SourceSection sourceSection, SharedMethodInfo sharedMethodInfo, boolean requiresDeclarationFrame, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods, TranslatorEnvironment.BlockID blockID) {
        super(context, sourceSection);
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForBlocks = callTargetForBlocks;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForMethods = callTargetForMethods;
        this.requiresDeclarationFrame = requiresDeclarationFrame;
        this.blockID = blockID;
    }

    public TranslatorEnvironment.BlockID getBlockID() {
        return this.blockID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        MaterializedFrame declarationFrame = this.requiresDeclarationFrame ? frame.materialize() : null;
        return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.sharedMethodInfo, this.callTargetForBlocks, this.callTargetForProcs, this.callTargetForMethods, declarationFrame, RubyArguments.getMethod(frame.getArguments()), RubyArguments.getSelf(frame.getArguments()), RubyArguments.getBlock(frame.getArguments()));
    }
}

