/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.methods.AliasNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyModule;

@GeneratedBy(value=AliasNode.class)
public final class AliasNodeFactory
extends NodeFactoryBase<AliasNode> {
    private static AliasNodeFactory instance;

    private AliasNodeFactory() {
        super(AliasNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, String.class, String.class, RubyNode.class}});
    }

    public AliasNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof String) || arguments[3] != null && !(arguments[3] instanceof String) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return AliasNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (String)arguments[2], (String)arguments[3], (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static AliasNode create(RubyContext context, SourceSection sourceSection, String newName, String oldName, RubyNode module) {
        return AliasUninitializedNode.create0(context, sourceSection, newName, oldName, module);
    }

    public static NodeFactory<AliasNode> getInstance() {
        if (instance == null) {
            instance = new AliasNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class AliasPolymorphicNode
    extends AliasBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> modulePolymorphicType;

        AliasPolymorphicNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object moduleValue;
            try {
                moduleValue = this.modulePolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.module.executeBoolean(frameValue)) : (this.modulePolymorphicType == Integer.TYPE ? Integer.valueOf(this.module.executeIntegerFixnum(frameValue)) : (this.modulePolymorphicType == Long.TYPE ? Long.valueOf(this.module.executeLongFixnum(frameValue)) : (this.modulePolymorphicType == Double.TYPE ? Double.valueOf(this.module.executeFloat(frameValue)) : (this.modulePolymorphicType == RubyBignum.class ? this.module.executeBignum(frameValue) : (this.modulePolymorphicType == RubyModule.class ? this.module.executeRubyModule(frameValue) : (this.modulePolymorphicType == RubyBasicObject.class ? this.module.executeRubyBasicObject(frameValue) : this.module.execute(frameValue)))))));
            }
            catch (UnexpectedResultException ex) {
                this.modulePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.modulePolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            return this.next0.executeChained0(frameValue, moduleValue);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasRubyBasicObjectNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        AliasRubyBasicObjectNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject moduleValue;
            try {
                moduleValue = this.module.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof RubyBasicObject");
            }
            if (!super.isRubyModule(moduleValue) && !super.isRubyBignum(moduleValue)) {
                return super.alias(moduleValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, moduleValue, "One of guards [!isRubyModule, !isRubyBignum] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(moduleValue)) {
                RubyBasicObject moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(moduleValue);
                if (!super.isRubyModule(moduleValue) && !super.isRubyBignum(moduleValue)) {
                    return super.alias(moduleValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasRubyBasicObjectNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasRubyModuleNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

        AliasRubyModuleNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyModule moduleValue;
            try {
                moduleValue = this.module.executeRubyModule(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof RubyModule");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue)) {
                RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasRubyModuleNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasRubyBignumNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

        AliasRubyBignumNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBignum moduleValue;
            try {
                moduleValue = this.module.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof RubyBignum");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(moduleValue)) {
                RubyBignum moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasRubyBignumNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasDoubleNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        AliasDoubleNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double moduleValue;
            try {
                moduleValue = this.module.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof double");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(moduleValue)) {
                double moduleValueCast = RubyTypesGen.RUBYTYPES.asDouble(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasDoubleNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasLongNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        AliasLongNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long moduleValue;
            try {
                moduleValue = this.module.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof long");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(moduleValue)) {
                long moduleValueCast = RubyTypesGen.RUBYTYPES.asLong(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasLongNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasIntNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        AliasIntNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int moduleValue;
            try {
                moduleValue = this.module.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof int");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(moduleValue)) {
                int moduleValueCast = RubyTypesGen.RUBYTYPES.asInteger(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasIntNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class AliasBooleanNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        AliasBooleanNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean moduleValue;
            try {
                moduleValue = this.module.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected moduleValue instanceof boolean");
            }
            return super.alias(moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(moduleValue)) {
                boolean moduleValueCast = RubyTypesGen.RUBYTYPES.asBoolean(moduleValue);
                return super.alias(moduleValueCast);
            }
            return this.next0.executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(AliasNode current) {
            return new AliasBooleanNode((AliasBaseNode)current);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class AliasUninitializedNode
    extends AliasBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(AliasUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        AliasUninitializedNode(RubyContext context, SourceSection sourceSection, String newName, String oldName, RubyNode module) {
            super(context, sourceSection, newName, oldName, module);
        }

        AliasUninitializedNode(AliasBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object moduleValue = this.module.execute(frameValue);
            return this.executeUninitialized0(frameValue, moduleValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object moduleValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, moduleValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object moduleValue) {
            AliasBaseNode newNode = this.specialize0(moduleValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                AliasBaseNode rootNode = (AliasBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module}, new Object[]{moduleValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((AliasBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue);
        }

        static AliasNode create0(RubyContext context, SourceSection sourceSection, String newName, String oldName, RubyNode module) {
            return new AliasUninitializedNode(context, sourceSection, newName, oldName, module);
        }
    }

    @GeneratedBy(value=AliasNode.class)
    private static abstract class AliasBaseNode
    extends AliasNode
    implements DSLNode {
        @Node.Child
        protected RubyNode module;
        @Node.Child
        protected AliasBaseNode next0;

        AliasBaseNode(RubyContext context, SourceSection sourceSection, String newName, String oldName, RubyNode module) {
            super(context, sourceSection, newName, oldName);
            this.module = module;
        }

        AliasBaseNode(AliasBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object moduleValue, String reason) {
            String message;
            AliasBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            AliasBaseNode newNode = this.specialize0(moduleValue);
            if (newNode == null) {
                newNode = new AliasUninitializedNode(this);
                ((AliasUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (AliasBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AliasBaseNode.createInfo0(reason, moduleValue)))) == null) {
                returnNode = (AliasBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AliasUninitializedNode(this), (Node)new AliasPolymorphicNode(this), (DSLNode)((AliasBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, moduleValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final AliasBaseNode specialize0(Object moduleValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(moduleValue)) {
                return (AliasBaseNode)AliasBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(moduleValue)) {
                return (AliasBaseNode)AliasIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(moduleValue)) {
                return (AliasBaseNode)AliasLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(moduleValue)) {
                return (AliasBaseNode)AliasDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(moduleValue)) {
                return (AliasBaseNode)AliasRubyBignumNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue)) {
                return (AliasBaseNode)AliasRubyModuleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(moduleValue) && !super.isRubyModule(moduleValue) && !super.isRubyBignum(moduleValue)) {
                return (AliasBaseNode)AliasRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.module = other == null ? null : ((AliasBaseNode)other).module;
            this.next0 = newNext == null ? null : (AliasBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object moduleValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("moduleValue").append(" = ").append(moduleValue);
                if (moduleValue != null) {
                    builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

