/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyRange;

@NodeChildren(value={@NodeChild(value="begin"), @NodeChild(value="end")})
public abstract class RangeLiteralNode
extends RubyNode {
    private final boolean excludeEnd;
    private final BranchProfile beginIntegerProfile = BranchProfile.create();
    private final BranchProfile beginLongProfile = BranchProfile.create();
    private final BranchProfile endIntegerProfile = BranchProfile.create();
    private final BranchProfile endLongProfile = BranchProfile.create();
    private final BranchProfile objectProfile = BranchProfile.create();
    @Node.Child
    private CallDispatchHeadNode cmpNode;

    public RangeLiteralNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd) {
        super(context, sourceSection);
        this.excludeEnd = excludeEnd;
    }

    public RangeLiteralNode(RangeLiteralNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.excludeEnd);
    }

    @Specialization
    public RubyRange.IntegerFixnumRange doRange(int begin, int end) {
        return new RubyRange.IntegerFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(int begin, long end) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(long begin, int end) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(long begin, long end) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }

    @Specialization
    public Object doRange(VirtualFrame frame, Object begin, Object end) {
        Object cmpResult;
        if (begin instanceof Integer) {
            this.beginIntegerProfile.enter();
            if (end instanceof Integer) {
                this.endIntegerProfile.enter();
                return this.doRange((int)((Integer)begin), (int)((Integer)end));
            }
            if (end instanceof Long) {
                this.endLongProfile.enter();
                return this.doRange((int)((Integer)begin), (long)((Long)end));
            }
        } else if (begin instanceof Long) {
            this.beginLongProfile.enter();
            if (end instanceof Integer) {
                this.endIntegerProfile.enter();
                return this.doRange((long)((Long)begin), (int)((Integer)end));
            }
            if (end instanceof Long) {
                this.endLongProfile.enter();
                return this.doRange((long)((Long)begin), (long)((Long)end));
            }
        }
        this.objectProfile.enter();
        if (this.cmpNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.cmpNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            cmpResult = this.cmpNode.call(frame, begin, "<=>", null, end);
        }
        catch (RaiseException e) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        if (cmpResult == this.nil()) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        return new RubyRange.ObjectRange(this.getContext().getCoreLibrary().getRangeClass(), begin, end, this.excludeEnd);
    }
}

