/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.HashSearchResult;

public class FindEntryNode
extends RubyNode {
    @Node.Child
    CallDispatchHeadNode hashNode;
    @Node.Child
    CallDispatchHeadNode eqlNode;
    @Node.Child
    BasicObjectNodes.ReferenceEqualNode equalNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();

    public FindEntryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context, true);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
    }

    public HashSearchResult search(VirtualFrame frame, RubyHash hash, Object key) {
        int hashed;
        Object hashValue = this.hashNode.call(frame, key, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            hashed = (Integer)hashValue;
        } else if (hashValue instanceof Long) {
            hashed = (int)((Long)hashValue).longValue();
        } else {
            throw new UnsupportedOperationException();
        }
        Entry[] entries = (Entry[])hash.getStore();
        int index = HashOperations.getIndex(hashed, entries.length);
        Entry previousEntry = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (this.byIdentityProfile.profile(hash.isCompareByIdentity()) ? this.equalNode.executeReferenceEqual(frame, key, entry.getKey()) : this.eqlNode.callBoolean(frame, key, "eql?", null, entry.getKey())) {
                return new HashSearchResult(index, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashSearchResult(index, previousEntry, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

