/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyMatchData;

public class ReadMatchReferenceNode
extends RubyNode {
    public static final int PRE = -1;
    public static final int POST = -2;
    public static final int GLOBAL = -3;
    public static final int HIGHEST = -4;
    private final int index;

    public ReadMatchReferenceNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ReadMatchReferenceNode.notDesignedForCompilation();
        Object match = this.getContext().getThreadManager().getCurrentThread().getThreadLocals().getInstanceVariable("$~");
        if (match == null || match == this.nil()) {
            return this.nil();
        }
        RubyMatchData matchData = (RubyMatchData)match;
        if (this.index > 0) {
            Object[] values = matchData.getValues();
            if (this.index >= values.length) {
                return this.nil();
            }
            return values[this.index];
        }
        if (this.index == -1) {
            return matchData.getPre();
        }
        if (this.index == -2) {
            return matchData.getPost();
        }
        if (this.index == -3) {
            return matchData.getGlobal();
        }
        if (this.index == -4) {
            Object[] values = matchData.getValues();
            for (int n = values.length - 1; n >= 0; --n) {
                if (values[n] == this.nil()) continue;
                return values[n];
            }
            return this.nil();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        ReadMatchReferenceNode.notDesignedForCompilation();
        if (this.execute(frame) != this.nil()) {
            return this.getContext().makeString("global-variable");
        }
        return this.nil();
    }
}

