/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

public abstract class CachedDispatchNode
extends DispatchNode {
    private final Object cachedName;
    private final RubySymbol cachedNameAsSymbol;
    private final boolean indirect;
    @Node.Child
    protected DispatchNode next;
    private final BranchProfile moreThanReferenceCompare = BranchProfile.create();

    public CachedDispatchNode(RubyContext context, Object cachedName, DispatchNode next, boolean indirect, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        assert (cachedName instanceof String || cachedName instanceof RubySymbol || cachedName instanceof RubyString);
        this.cachedName = cachedName;
        if (cachedName instanceof RubySymbol) {
            this.cachedNameAsSymbol = (RubySymbol)cachedName;
        } else if (cachedName instanceof RubyString) {
            this.cachedNameAsSymbol = context.getSymbol(((RubyString)cachedName).getBytes());
        } else if (cachedName instanceof String) {
            this.cachedNameAsSymbol = context.getSymbol((String)cachedName);
        } else {
            throw new UnsupportedOperationException();
        }
        this.indirect = indirect;
        this.next = next;
    }

    public CachedDispatchNode(CachedDispatchNode prev) {
        super(prev);
        this.cachedName = prev.cachedName;
        this.cachedNameAsSymbol = prev.cachedNameAsSymbol;
        this.next = prev.next;
        this.indirect = prev.indirect;
    }

    @Override
    protected DispatchNode getNext() {
        return this.next;
    }

    protected final boolean guardName(Object methodName) {
        if (this.cachedName == methodName) {
            return true;
        }
        this.moreThanReferenceCompare.enter();
        if (this.cachedName instanceof String) {
            return this.cachedName.equals(methodName);
        }
        if (this.cachedName instanceof RubySymbol) {
            return this.cachedName == methodName;
        }
        if (this.cachedName instanceof RubyString) {
            return methodName instanceof RubyString && ((RubyString)this.cachedName).getBytes().equal(((RubyString)methodName).getBytes());
        }
        throw new UnsupportedOperationException();
    }

    protected RubySymbol getCachedNameAsSymbol() {
        return this.cachedNameAsSymbol;
    }

    public boolean isIndirect() {
        return this.indirect;
    }
}

