/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.TrufflePrimitiveNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=TrufflePrimitiveNodes.class)
public final class TrufflePrimitiveNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BindingOfCallerNodeFactory.getInstance(), SourceOfCallerNodeFactory.getInstance(), GCCountNodeFactory.getInstance(), GCTimeNodeFactory.getInstance(), AssertConstantNodeFactory.getInstance(), AssertNotCompiledNodeFactory.getInstance(), DumpCallStackNodeFactory.getInstance(), FlushStdoutNodeFactory.getInstance(), FullTreeNodeFactory.getInstance(), JavaClassOfNodeFactory.getInstance(), DumpStringNodeFactory.getInstance(), SourceAttributionTreeNodeFactory.getInstance(), StorageClassNodeFactory.getInstance(), PanicNodeFactory.getInstance(), ParseTreeNodeFactory.getInstance(), TreeNodeFactory.getInstance(), GraalNodeFactory.getInstance(), SubstrateNodeFactory.getInstance(), GraalVersionNodeFactory.getInstance(), SimpleShellNodeFactory.getInstance(), DebugPrintNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
    public static final class DebugPrintNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DebugPrintNode> {
        private static DebugPrintNodeFactory debugPrintNodeFactoryInstance;

        private DebugPrintNodeFactory() {
            super(TrufflePrimitiveNodes.DebugPrintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.DebugPrintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DebugPrintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.DebugPrintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DebugPrintUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.DebugPrintNode> getInstance() {
            if (debugPrintNodeFactoryInstance == null) {
                debugPrintNodeFactoryInstance = new DebugPrintNodeFactory();
            }
            return debugPrintNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DebugPrintPolymorphicNode
        extends DebugPrintBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DebugPrintPolymorphicNode(DebugPrintBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DebugPrintRubyStringNode
        extends DebugPrintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DebugPrintRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DebugPrintRubyStringNode(DebugPrintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.debugPrint(arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.debugPrint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.DebugPrintNode create0(TrufflePrimitiveNodes.DebugPrintNode current) {
                return new DebugPrintRubyStringNode((DebugPrintBaseNode)current);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DebugPrintUninitializedNode
        extends DebugPrintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DebugPrintUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DebugPrintUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DebugPrintUninitializedNode(DebugPrintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DebugPrintBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DebugPrintBaseNode rootNode = (DebugPrintBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DebugPrintBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.DebugPrintNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DebugPrintUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
        private static abstract class DebugPrintBaseNode
        extends TrufflePrimitiveNodes.DebugPrintNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DebugPrintBaseNode next0;

            DebugPrintBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DebugPrintBaseNode(DebugPrintBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DebugPrintBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DebugPrintBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DebugPrintUninitializedNode(this);
                    ((DebugPrintUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DebugPrintBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DebugPrintBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DebugPrintBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DebugPrintUninitializedNode(this), (Node)new DebugPrintPolymorphicNode(this), (DSLNode)((DebugPrintBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DebugPrintBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DebugPrintBaseNode)DebugPrintRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DebugPrintBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DebugPrintBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SimpleShellNode.class)
    public static final class SimpleShellNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SimpleShellNode> {
        private static SimpleShellNodeFactory simpleShellNodeFactoryInstance;

        private SimpleShellNodeFactory() {
            super(TrufflePrimitiveNodes.SimpleShellNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.SimpleShellNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleShellNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.SimpleShellNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SimpleShellDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.SimpleShellNode> getInstance() {
            if (simpleShellNodeFactoryInstance == null) {
                simpleShellNodeFactoryInstance = new SimpleShellNodeFactory();
            }
            return simpleShellNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SimpleShellNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleShellDefaultNode
        extends SimpleShellBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleShellDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            SimpleShellDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.simpleShell();
            }

            static TrufflePrimitiveNodes.SimpleShellNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SimpleShellDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SimpleShellNode.class)
        private static abstract class SimpleShellBaseNode
        extends TrufflePrimitiveNodes.SimpleShellNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SimpleShellBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GraalVersionNode.class)
    public static final class GraalVersionNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GraalVersionNode> {
        private static GraalVersionNodeFactory graalVersionNodeFactoryInstance;

        private GraalVersionNodeFactory() {
            super(TrufflePrimitiveNodes.GraalVersionNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.GraalVersionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GraalVersionNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.GraalVersionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GraalVersionDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.GraalVersionNode> getInstance() {
            if (graalVersionNodeFactoryInstance == null) {
                graalVersionNodeFactoryInstance = new GraalVersionNodeFactory();
            }
            return graalVersionNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalVersionNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GraalVersionDefaultNode
        extends GraalVersionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GraalVersionDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GraalVersionDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.graalVersion();
            }

            static TrufflePrimitiveNodes.GraalVersionNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GraalVersionDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalVersionNode.class)
        private static abstract class GraalVersionBaseNode
        extends TrufflePrimitiveNodes.GraalVersionNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GraalVersionBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SubstrateNode.class)
    public static final class SubstrateNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SubstrateNode> {
        private static SubstrateNodeFactory substrateNodeFactoryInstance;

        private SubstrateNodeFactory() {
            super(TrufflePrimitiveNodes.SubstrateNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.SubstrateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubstrateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.SubstrateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SubstrateDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.SubstrateNode> getInstance() {
            if (substrateNodeFactoryInstance == null) {
                substrateNodeFactoryInstance = new SubstrateNodeFactory();
            }
            return substrateNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SubstrateNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubstrateDefaultNode
        extends SubstrateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubstrateDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            SubstrateDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.substrate();
            }

            static TrufflePrimitiveNodes.SubstrateNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SubstrateDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SubstrateNode.class)
        private static abstract class SubstrateBaseNode
        extends TrufflePrimitiveNodes.SubstrateNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SubstrateBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GraalNode.class)
    public static final class GraalNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GraalNode> {
        private static GraalNodeFactory graalNodeFactoryInstance;

        private GraalNodeFactory() {
            super(TrufflePrimitiveNodes.GraalNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.GraalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GraalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.GraalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GraalDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.GraalNode> getInstance() {
            if (graalNodeFactoryInstance == null) {
                graalNodeFactoryInstance = new GraalNodeFactory();
            }
            return graalNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GraalDefaultNode
        extends GraalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GraalDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GraalDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.graal();
            }

            static TrufflePrimitiveNodes.GraalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GraalDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalNode.class)
        private static abstract class GraalBaseNode
        extends TrufflePrimitiveNodes.GraalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GraalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.TreeNode.class)
    public static final class TreeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.TreeNode> {
        private static TreeNodeFactory treeNodeFactoryInstance;

        private TreeNodeFactory() {
            super(TrufflePrimitiveNodes.TreeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.TreeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TreeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.TreeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return TreeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.TreeNode> getInstance() {
            if (treeNodeFactoryInstance == null) {
                treeNodeFactoryInstance = new TreeNodeFactory();
            }
            return treeNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.TreeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TreeDefaultNode
        extends TreeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TreeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            TreeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.tree();
            }

            static TrufflePrimitiveNodes.TreeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new TreeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.TreeNode.class)
        private static abstract class TreeBaseNode
        extends TrufflePrimitiveNodes.TreeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            TreeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.ParseTreeNode.class)
    public static final class ParseTreeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.ParseTreeNode> {
        private static ParseTreeNodeFactory parseTreeNodeFactoryInstance;

        private ParseTreeNodeFactory() {
            super(TrufflePrimitiveNodes.ParseTreeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.ParseTreeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ParseTreeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.ParseTreeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ParseTreeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.ParseTreeNode> getInstance() {
            if (parseTreeNodeFactoryInstance == null) {
                parseTreeNodeFactoryInstance = new ParseTreeNodeFactory();
            }
            return parseTreeNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.ParseTreeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ParseTreeDefaultNode
        extends ParseTreeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ParseTreeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            ParseTreeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return super.parseTree(frameValue);
            }

            static TrufflePrimitiveNodes.ParseTreeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ParseTreeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.ParseTreeNode.class)
        private static abstract class ParseTreeBaseNode
        extends TrufflePrimitiveNodes.ParseTreeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            ParseTreeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.PanicNode.class)
    public static final class PanicNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.PanicNode> {
        private static PanicNodeFactory panicNodeFactoryInstance;

        private PanicNodeFactory() {
            super(TrufflePrimitiveNodes.PanicNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.PanicNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PanicNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.PanicNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PanicDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.PanicNode> getInstance() {
            if (panicNodeFactoryInstance == null) {
                panicNodeFactoryInstance = new PanicNodeFactory();
            }
            return panicNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.PanicNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PanicDefaultNode
        extends PanicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PanicDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            PanicDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.doPanic();
            }

            static TrufflePrimitiveNodes.PanicNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PanicDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.PanicNode.class)
        private static abstract class PanicBaseNode
        extends TrufflePrimitiveNodes.PanicNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            PanicBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
    public static final class StorageClassNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.StorageClassNode> {
        private static StorageClassNodeFactory storageClassNodeFactoryInstance;

        private StorageClassNodeFactory() {
            super(TrufflePrimitiveNodes.StorageClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.StorageClassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StorageClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.StorageClassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StorageClassUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.StorageClassNode> getInstance() {
            if (storageClassNodeFactoryInstance == null) {
                storageClassNodeFactoryInstance = new StorageClassNodeFactory();
            }
            return storageClassNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StorageClassPolymorphicNode
        extends StorageClassBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StorageClassPolymorphicNode(StorageClassBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyArray.class ? this.arguments[0].executeArray(frameValue) : (this.arguments0PolymorphicType == RubyHash.class ? this.arguments[0].executeRubyHash(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StorageClassRubyHashNode
        extends StorageClassBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StorageClassRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            StorageClassRubyHashNode(StorageClassBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                return super.storageClass(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.storageClass(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.StorageClassNode create0(TrufflePrimitiveNodes.StorageClassNode current) {
                return new StorageClassRubyHashNode((StorageClassBaseNode)current);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StorageClassRubyArrayNode
        extends StorageClassBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StorageClassRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            StorageClassRubyArrayNode(StorageClassBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.storageClass(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.storageClass(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.StorageClassNode create0(TrufflePrimitiveNodes.StorageClassNode current) {
                return new StorageClassRubyArrayNode((StorageClassBaseNode)current);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StorageClassUninitializedNode
        extends StorageClassBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StorageClassUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StorageClassUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StorageClassUninitializedNode(StorageClassBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StorageClassBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StorageClassBaseNode rootNode = (StorageClassBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StorageClassBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.StorageClassNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StorageClassUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.StorageClassNode.class)
        private static abstract class StorageClassBaseNode
        extends TrufflePrimitiveNodes.StorageClassNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StorageClassBaseNode next0;

            StorageClassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StorageClassBaseNode(StorageClassBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StorageClassBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StorageClassBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StorageClassUninitializedNode(this);
                    ((StorageClassUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StorageClassBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StorageClassBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StorageClassBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StorageClassUninitializedNode(this), (Node)new StorageClassPolymorphicNode(this), (DSLNode)((StorageClassBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StorageClassBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (StorageClassBaseNode)StorageClassRubyArrayNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (StorageClassBaseNode)StorageClassRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StorageClassBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StorageClassBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SourceAttributionTreeNode.class)
    public static final class SourceAttributionTreeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SourceAttributionTreeNode> {
        private static SourceAttributionTreeNodeFactory sourceAttributionTreeNodeFactoryInstance;

        private SourceAttributionTreeNodeFactory() {
            super(TrufflePrimitiveNodes.SourceAttributionTreeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.SourceAttributionTreeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SourceAttributionTreeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.SourceAttributionTreeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SourceAttributionTreeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.SourceAttributionTreeNode> getInstance() {
            if (sourceAttributionTreeNodeFactoryInstance == null) {
                sourceAttributionTreeNodeFactoryInstance = new SourceAttributionTreeNodeFactory();
            }
            return sourceAttributionTreeNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SourceAttributionTreeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SourceAttributionTreeDefaultNode
        extends SourceAttributionTreeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceAttributionTreeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            SourceAttributionTreeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.sourceAttributionTree();
            }

            static TrufflePrimitiveNodes.SourceAttributionTreeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SourceAttributionTreeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SourceAttributionTreeNode.class)
        private static abstract class SourceAttributionTreeBaseNode
        extends TrufflePrimitiveNodes.SourceAttributionTreeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SourceAttributionTreeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
    public static final class DumpStringNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DumpStringNode> {
        private static DumpStringNodeFactory dumpStringNodeFactoryInstance;

        private DumpStringNodeFactory() {
            super(TrufflePrimitiveNodes.DumpStringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.DumpStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpStringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.DumpStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DumpStringUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.DumpStringNode> getInstance() {
            if (dumpStringNodeFactoryInstance == null) {
                dumpStringNodeFactoryInstance = new DumpStringNodeFactory();
            }
            return dumpStringNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DumpStringPolymorphicNode
        extends DumpStringBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DumpStringPolymorphicNode(DumpStringBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DumpStringRubyStringNode
        extends DumpStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpStringRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DumpStringRubyStringNode(DumpStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.dumpString(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.dumpString(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.DumpStringNode create0(TrufflePrimitiveNodes.DumpStringNode current) {
                return new DumpStringRubyStringNode((DumpStringBaseNode)current);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DumpStringUninitializedNode
        extends DumpStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpStringUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DumpStringUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DumpStringUninitializedNode(DumpStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DumpStringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DumpStringBaseNode rootNode = (DumpStringBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DumpStringBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static TrufflePrimitiveNodes.DumpStringNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DumpStringUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
        private static abstract class DumpStringBaseNode
        extends TrufflePrimitiveNodes.DumpStringNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DumpStringBaseNode next0;

            DumpStringBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DumpStringBaseNode(DumpStringBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DumpStringBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DumpStringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DumpStringUninitializedNode(this);
                    ((DumpStringUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DumpStringBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DumpStringBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DumpStringBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DumpStringUninitializedNode(this), (Node)new DumpStringPolymorphicNode(this), (DSLNode)((DumpStringBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DumpStringBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DumpStringBaseNode)DumpStringRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DumpStringBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DumpStringBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.JavaClassOfNode.class)
    public static final class JavaClassOfNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.JavaClassOfNode> {
        private static JavaClassOfNodeFactory javaClassOfNodeFactoryInstance;

        private JavaClassOfNodeFactory() {
            super(TrufflePrimitiveNodes.JavaClassOfNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.JavaClassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JavaClassOfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.JavaClassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return JavaClassOfObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.JavaClassOfNode> getInstance() {
            if (javaClassOfNodeFactoryInstance == null) {
                javaClassOfNodeFactoryInstance = new JavaClassOfNodeFactory();
            }
            return javaClassOfNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.JavaClassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JavaClassOfObjectNode
        extends JavaClassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JavaClassOfObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            JavaClassOfObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.javaClassOf(arguments0Value);
            }

            static TrufflePrimitiveNodes.JavaClassOfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new JavaClassOfObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.JavaClassOfNode.class)
        private static abstract class JavaClassOfBaseNode
        extends TrufflePrimitiveNodes.JavaClassOfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            JavaClassOfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((JavaClassOfBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.FullTreeNode.class)
    public static final class FullTreeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.FullTreeNode> {
        private static FullTreeNodeFactory fullTreeNodeFactoryInstance;

        private FullTreeNodeFactory() {
            super(TrufflePrimitiveNodes.FullTreeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.FullTreeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FullTreeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.FullTreeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FullTreeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.FullTreeNode> getInstance() {
            if (fullTreeNodeFactoryInstance == null) {
                fullTreeNodeFactoryInstance = new FullTreeNodeFactory();
            }
            return fullTreeNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FullTreeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FullTreeDefaultNode
        extends FullTreeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FullTreeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            FullTreeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.fullTree();
            }

            static TrufflePrimitiveNodes.FullTreeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FullTreeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FullTreeNode.class)
        private static abstract class FullTreeBaseNode
        extends TrufflePrimitiveNodes.FullTreeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            FullTreeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.FlushStdoutNode.class)
    public static final class FlushStdoutNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.FlushStdoutNode> {
        private static FlushStdoutNodeFactory flushStdoutNodeFactoryInstance;

        private FlushStdoutNodeFactory() {
            super(TrufflePrimitiveNodes.FlushStdoutNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.FlushStdoutNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FlushStdoutNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.FlushStdoutNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FlushStdoutDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.FlushStdoutNode> getInstance() {
            if (flushStdoutNodeFactoryInstance == null) {
                flushStdoutNodeFactoryInstance = new FlushStdoutNodeFactory();
            }
            return flushStdoutNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FlushStdoutNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FlushStdoutDefaultNode
        extends FlushStdoutBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FlushStdoutDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            FlushStdoutDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.flush();
            }

            static TrufflePrimitiveNodes.FlushStdoutNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FlushStdoutDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FlushStdoutNode.class)
        private static abstract class FlushStdoutBaseNode
        extends TrufflePrimitiveNodes.FlushStdoutNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            FlushStdoutBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DumpCallStackNode.class)
    public static final class DumpCallStackNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DumpCallStackNode> {
        private static DumpCallStackNodeFactory dumpCallStackNodeFactoryInstance;

        private DumpCallStackNodeFactory() {
            super(TrufflePrimitiveNodes.DumpCallStackNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.DumpCallStackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpCallStackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.DumpCallStackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DumpCallStackDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.DumpCallStackNode> getInstance() {
            if (dumpCallStackNodeFactoryInstance == null) {
                dumpCallStackNodeFactoryInstance = new DumpCallStackNodeFactory();
            }
            return dumpCallStackNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpCallStackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DumpCallStackDefaultNode
        extends DumpCallStackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpCallStackDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            DumpCallStackDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.dumpCallStack();
            }

            static TrufflePrimitiveNodes.DumpCallStackNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DumpCallStackDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpCallStackNode.class)
        private static abstract class DumpCallStackBaseNode
        extends TrufflePrimitiveNodes.DumpCallStackNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            DumpCallStackBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AssertNotCompiledNode.class)
    public static final class AssertNotCompiledNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AssertNotCompiledNode> {
        private static AssertNotCompiledNodeFactory assertNotCompiledNodeFactoryInstance;

        private AssertNotCompiledNodeFactory() {
            super(TrufflePrimitiveNodes.AssertNotCompiledNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.AssertNotCompiledNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AssertNotCompiledNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.AssertNotCompiledNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AssertNotCompiledDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.AssertNotCompiledNode> getInstance() {
            if (assertNotCompiledNodeFactoryInstance == null) {
                assertNotCompiledNodeFactoryInstance = new AssertNotCompiledNodeFactory();
            }
            return assertNotCompiledNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertNotCompiledNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AssertNotCompiledDefaultNode
        extends AssertNotCompiledBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AssertNotCompiledDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            AssertNotCompiledDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.assertNotCompiled();
            }

            static TrufflePrimitiveNodes.AssertNotCompiledNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AssertNotCompiledDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertNotCompiledNode.class)
        private static abstract class AssertNotCompiledBaseNode
        extends TrufflePrimitiveNodes.AssertNotCompiledNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            AssertNotCompiledBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AssertConstantNode.class)
    public static final class AssertConstantNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AssertConstantNode> {
        private static AssertConstantNodeFactory assertConstantNodeFactoryInstance;

        private AssertConstantNodeFactory() {
            super(TrufflePrimitiveNodes.AssertConstantNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.AssertConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AssertConstantNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.AssertConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AssertConstantObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.AssertConstantNode> getInstance() {
            if (assertConstantNodeFactoryInstance == null) {
                assertConstantNodeFactoryInstance = new AssertConstantNodeFactory();
            }
            return assertConstantNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertConstantNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AssertConstantObjectNode
        extends AssertConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AssertConstantObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            AssertConstantObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.assertConstant(arguments0Value);
            }

            static TrufflePrimitiveNodes.AssertConstantNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AssertConstantObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertConstantNode.class)
        private static abstract class AssertConstantBaseNode
        extends TrufflePrimitiveNodes.AssertConstantNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            AssertConstantBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AssertConstantBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GCTimeNode.class)
    public static final class GCTimeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GCTimeNode> {
        private static GCTimeNodeFactory gCTimeNodeFactoryInstance;

        private GCTimeNodeFactory() {
            super(TrufflePrimitiveNodes.GCTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.GCTimeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GCTimeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.GCTimeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GCTimeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.GCTimeNode> getInstance() {
            if (gCTimeNodeFactoryInstance == null) {
                gCTimeNodeFactoryInstance = new GCTimeNodeFactory();
            }
            return gCTimeNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCTimeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GCTimeDefaultNode
        extends GCTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GCTimeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GCTimeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.gcTime();
            }

            static TrufflePrimitiveNodes.GCTimeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GCTimeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCTimeNode.class)
        private static abstract class GCTimeBaseNode
        extends TrufflePrimitiveNodes.GCTimeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GCTimeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GCCountNode.class)
    public static final class GCCountNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GCCountNode> {
        private static GCCountNodeFactory gCCountNodeFactoryInstance;

        private GCCountNodeFactory() {
            super(TrufflePrimitiveNodes.GCCountNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.GCCountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GCCountNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.GCCountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GCCountDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.GCCountNode> getInstance() {
            if (gCCountNodeFactoryInstance == null) {
                gCCountNodeFactoryInstance = new GCCountNodeFactory();
            }
            return gCCountNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCCountNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GCCountDefaultNode
        extends GCCountBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GCCountDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GCCountDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.gcCount();
            }

            static TrufflePrimitiveNodes.GCCountNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GCCountDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCCountNode.class)
        private static abstract class GCCountBaseNode
        extends TrufflePrimitiveNodes.GCCountNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GCCountBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SourceOfCallerNode.class)
    public static final class SourceOfCallerNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SourceOfCallerNode> {
        private static SourceOfCallerNodeFactory sourceOfCallerNodeFactoryInstance;

        private SourceOfCallerNodeFactory() {
            super(TrufflePrimitiveNodes.SourceOfCallerNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.SourceOfCallerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SourceOfCallerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.SourceOfCallerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SourceOfCallerDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.SourceOfCallerNode> getInstance() {
            if (sourceOfCallerNodeFactoryInstance == null) {
                sourceOfCallerNodeFactoryInstance = new SourceOfCallerNodeFactory();
            }
            return sourceOfCallerNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SourceOfCallerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SourceOfCallerDefaultNode
        extends SourceOfCallerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceOfCallerDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            SourceOfCallerDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.sourceOfCaller();
            }

            static TrufflePrimitiveNodes.SourceOfCallerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SourceOfCallerDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SourceOfCallerNode.class)
        private static abstract class SourceOfCallerBaseNode
        extends TrufflePrimitiveNodes.SourceOfCallerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SourceOfCallerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.BindingOfCallerNode.class)
    public static final class BindingOfCallerNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.BindingOfCallerNode> {
        private static BindingOfCallerNodeFactory bindingOfCallerNodeFactoryInstance;

        private BindingOfCallerNodeFactory() {
            super(TrufflePrimitiveNodes.BindingOfCallerNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrufflePrimitiveNodes.BindingOfCallerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindingOfCallerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrufflePrimitiveNodes.BindingOfCallerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BindingOfCallerDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrufflePrimitiveNodes.BindingOfCallerNode> getInstance() {
            if (bindingOfCallerNodeFactoryInstance == null) {
                bindingOfCallerNodeFactoryInstance = new BindingOfCallerNodeFactory();
            }
            return bindingOfCallerNodeFactoryInstance;
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.BindingOfCallerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BindingOfCallerDefaultNode
        extends BindingOfCallerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BindingOfCallerDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            BindingOfCallerDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBinding value;
                try {
                    value = this.executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBinding executeRubyBinding(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.bindingOfCaller();
            }

            static TrufflePrimitiveNodes.BindingOfCallerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BindingOfCallerDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.BindingOfCallerNode.class)
        private static abstract class BindingOfCallerBaseNode
        extends TrufflePrimitiveNodes.BindingOfCallerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            BindingOfCallerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }
}

