/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTimeZone;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyTime;

@CoreClass(name="Time")
public abstract class TimeNodes {

    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="offset")})
    public static abstract class InternalSetOffsetNode
    extends RubyNode {
        public InternalSetOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InternalSetOffsetNode(InternalSetOffsetNode prev) {
            super(prev);
        }

        @Specialization
        public Object internalSetOffset(RubyTime time, Object offset) {
            time.setOffset(offset);
            return offset;
        }
    }

    @NodeChild(value="self")
    public static abstract class InternalOffsetNode
    extends RubyNode {
        public InternalOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InternalOffsetNode(InternalOffsetNode prev) {
            super(prev);
        }

        @Specialization
        public Object internalOffset(RubyTime time) {
            return time.getOffset();
        }
    }

    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="isGMT")})
    public static abstract class InternalSetGMTNode
    extends RubyNode {
        public InternalSetGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InternalSetGMTNode(InternalSetGMTNode prev) {
            super(prev);
        }

        @Specialization
        public boolean internalSetGMT(RubyTime time, boolean isGMT) {
            if (isGMT) {
                time.setDateTime(time.getDateTime().withZone(DateTimeZone.UTC));
            }
            return isGMT;
        }
    }

    @NodeChild(value="self")
    public static abstract class InternalGMTNode
    extends RubyNode {
        public InternalGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InternalGMTNode(InternalGMTNode prev) {
            super(prev);
        }

        @Specialization
        public boolean internalGMT(RubyTime time) {
            return time.getOffset() == this.nil() && (time.getDateTime().getZone().equals((Object)DateTimeZone.UTC) || time.getDateTime().getZone().getOffset(time.getDateTime().getMillis()) == 0);
        }
    }
}

