/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ThreadPassNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

@CoreClass(name="Thread")
public abstract class ThreadNodes {

    @CoreMethod(names={"wakeup", "run"})
    public static abstract class WakeupNode
    extends CoreMethodNode {
        public WakeupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public WakeupNode(WakeupNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread wakeup(RubyThread thread) {
            WakeupNode.notDesignedForCompilation();
            if (thread.getStatus() == RubyThread.Status.DEAD) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("killed thread", this));
            }
            thread.wakeup();
            return thread;
        }
    }

    @CoreMethod(names={"value"})
    public static abstract class ValueNode
    extends CoreMethodNode {
        public ValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValueNode(ValueNode prev) {
            super(prev);
        }

        @Specialization
        public Object value(RubyThread self) {
            ValueNode.notDesignedForCompilation();
            self.join();
            return self.getValue();
        }
    }

    @CoreMethod(names={"stop?"})
    public static abstract class StopNode
    extends CoreMethodNode {
        public StopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StopNode(StopNode prev) {
            super(prev);
        }

        @Specialization
        public boolean stop(RubyThread self) {
            StopNode.notDesignedForCompilation();
            return self.getStatus() == RubyThread.Status.DEAD || self.getStatus() == RubyThread.Status.SLEEP;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodNode {
        public StatusNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatusNode(StatusNode prev) {
            super(prev);
        }

        @Specialization
        public Object status(RubyThread self) {
            StatusNode.notDesignedForCompilation();
            if (self.getStatus() == RubyThread.Status.DEAD) {
                if (self.getException() != null) {
                    return this.nil();
                }
                return false;
            }
            return new RubyString(this.getContext().getCoreLibrary().getStringClass(), self.getStatus().bytes);
        }
    }

    @CoreMethod(names={"raise"}, required=1, optional=1)
    public static abstract class RaiseNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initialize;

        public RaiseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        public RaiseNode(RaiseNode prev) {
            super(prev);
            this.initialize = prev.initialize;
        }

        @Specialization
        public RubyNilClass raise(VirtualFrame frame, RubyThread thread, RubyString message, UndefinedPlaceholder undefined) {
            return this.raise(frame, thread, this.getContext().getCoreLibrary().getRuntimeErrorClass(), message);
        }

        @Specialization
        public RubyNilClass raise(VirtualFrame frame, RubyThread thread, RubyClass exceptionClass, UndefinedPlaceholder message) {
            return this.raise(frame, thread, exceptionClass, this.getContext().makeString(""));
        }

        @Specialization
        public RubyNilClass raise(VirtualFrame frame, RubyThread thread, RubyClass exceptionClass, RubyString message) {
            RubyBasicObject exception = exceptionClass.allocate(this);
            this.initialize.call(frame, exception, "initialize", null, message);
            if (!(exception instanceof RubyException)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("exception class/object expected", this));
            }
            final RaiseException exceptionWrapper = new RaiseException((RubyException)exception);
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(thread.getCurrentFiberJavaThread(), this, new SafepointAction(){

                @Override
                public void run(RubyThread currentThread, Node currentNode) {
                    throw exceptionWrapper;
                }
            });
            return this.nil();
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true)
    public static abstract class PassNode
    extends CoreMethodNode {
        @Node.Child
        ThreadPassNode threadPassNode;

        public PassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.threadPassNode = new ThreadPassNode(context, sourceSection);
        }

        public PassNode(PassNode prev) {
            super(prev);
            this.threadPassNode = prev.threadPassNode;
        }

        @Specialization
        public RubyNilClass pass(VirtualFrame frame) {
            this.threadPassNode.executeVoid(frame);
            return this.nil();
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodNode {
        public MainNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MainNode(MainNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread main() {
            return this.getContext().getThreadManager().getRootThread();
        }
    }

    @CoreMethod(names={"join"}, optional=1)
    public static abstract class JoinNode
    extends CoreMethodNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JoinNode(JoinNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread join(RubyThread thread, UndefinedPlaceholder timeout) {
            JoinNode.notDesignedForCompilation();
            thread.join();
            return thread;
        }

        @Specialization
        public RubyThread join(RubyThread thread, RubyNilClass timeout) {
            return this.join(thread, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public Object join(RubyThread thread, int timeout) {
            JoinNode.notDesignedForCompilation();
            return this.joinMillis(thread, timeout * 1000);
        }

        @Specialization
        public Object join(RubyThread thread, double timeout) {
            JoinNode.notDesignedForCompilation();
            return this.joinMillis(thread, (int)(timeout * 1000.0));
        }

        private Object joinMillis(RubyThread self, int timeoutInMillis) {
            if (self.join(timeoutInMillis)) {
                return self;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyThread thread, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            thread.initialize(this.getContext(), this, block);
            return this.nil();
        }
    }

    @CoreMethod(names={"kill", "exit", "terminate"})
    public static abstract class KillNode
    extends CoreMethodNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KillNode(KillNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread kill(RubyThread rubyThread) {
            Thread toKill = rubyThread.getRootFiberJavaThread();
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(toKill, this, new SafepointAction(){

                @Override
                public void run(RubyThread currentThread, Node currentNode) {
                    currentThread.shutdown();
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodNode {
        public CurrentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CurrentNode(CurrentNode prev) {
            super(prev);
        }

        @Specialization
        public RubyThread current() {
            return this.getContext().getThreadManager().getCurrentThread();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodNode {
        public AliveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AliveNode(AliveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean alive(RubyThread thread) {
            return thread.getStatus() != RubyThread.Status.ABORTING && thread.getStatus() != RubyThread.Status.DEAD;
        }
    }
}

