/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=SymbolNodes.class)
public final class SymbolNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AllSymbolsNodeFactory.getInstance(), CapitalizeNodeFactory.getInstance(), CaseCompareNodeFactory.getInstance(), DowncaseNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), HashNodeFactory.getInstance(), InternNodeFactory.getInstance(), ToProcNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ToSNodeFactory.getInstance(), InspectNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SwapcaseNodeFactory.getInstance(), UpcaseNodeFactory.getInstance());
    }

    @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(SymbolNodes.UpcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpcaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpcasePolymorphicNode
        extends UpcaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UpcasePolymorphicNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpcaseRubySymbolNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            UpcaseRubySymbolNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.upcase(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.upcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.UpcaseNode create0(SymbolNodes.UpcaseNode current) {
                return new UpcaseRubySymbolNode((UpcaseBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpcaseUninitializedNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpcaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpcaseUninitializedNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpcaseBaseNode rootNode = (UpcaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UpcaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.UpcaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpcaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.UpcaseNode.class)
        private static abstract class UpcaseBaseNode
        extends SymbolNodes.UpcaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpcaseBaseNode next0;

            UpcaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpcaseBaseNode(UpcaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UpcaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UpcaseUninitializedNode(this);
                    ((UpcaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UpcaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UpcaseBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UpcaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UpcaseUninitializedNode(this), (Node)new UpcasePolymorphicNode(this), (DSLNode)((UpcaseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpcaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (UpcaseBaseNode)UpcaseRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UpcaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UpcaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
    public static final class SwapcaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.SwapcaseNode> {
        private static SwapcaseNodeFactory swapcaseNodeFactoryInstance;

        private SwapcaseNodeFactory() {
            super(SymbolNodes.SwapcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.SwapcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SwapcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.SwapcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SwapcaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.SwapcaseNode> getInstance() {
            if (swapcaseNodeFactoryInstance == null) {
                swapcaseNodeFactoryInstance = new SwapcaseNodeFactory();
            }
            return swapcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SwapcasePolymorphicNode
        extends SwapcaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SwapcasePolymorphicNode(SwapcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SwapcaseRubySymbolNode
        extends SwapcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SwapcaseRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            SwapcaseRubySymbolNode(SwapcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.swapcase(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.swapcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.SwapcaseNode create0(SymbolNodes.SwapcaseNode current) {
                return new SwapcaseRubySymbolNode((SwapcaseBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SwapcaseUninitializedNode
        extends SwapcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SwapcaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SwapcaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SwapcaseUninitializedNode(SwapcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SwapcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SwapcaseBaseNode rootNode = (SwapcaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SwapcaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.SwapcaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SwapcaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.SwapcaseNode.class)
        private static abstract class SwapcaseBaseNode
        extends SymbolNodes.SwapcaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SwapcaseBaseNode next0;

            SwapcaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SwapcaseBaseNode(SwapcaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SwapcaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SwapcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SwapcaseUninitializedNode(this);
                    ((SwapcaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SwapcaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SwapcaseBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SwapcaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SwapcaseUninitializedNode(this), (Node)new SwapcasePolymorphicNode(this), (DSLNode)((SwapcaseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SwapcaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (SwapcaseBaseNode)SwapcaseRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SwapcaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SwapcaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<SymbolNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(SymbolNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubySymbolNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            SizeRubySymbolNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.size(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.size(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.SizeNode create0(SymbolNodes.SizeNode current) {
                return new SizeRubySymbolNode((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends SymbolNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (SizeBaseNode)SizeRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<SymbolNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(SymbolNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubySymbolNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            InspectRubySymbolNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.inspect(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.inspect(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.InspectNode create0(SymbolNodes.InspectNode current) {
                return new InspectRubySymbolNode((InspectBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends SymbolNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InspectBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (InspectBaseNode)InspectRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(SymbolNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubySymbolNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            ToSRubySymbolNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToSNode create0(SymbolNodes.ToSNode current) {
                return new ToSRubySymbolNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends SymbolNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (ToSBaseNode)ToSRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(SymbolNodes.ToSymNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToSymNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSymNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.ToSymNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSymUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSymPolymorphicNode
        extends ToSymBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSymPolymorphicNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSymRubySymbolNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            ToSymRubySymbolNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.toSym(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.toSym(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToSymNode create0(SymbolNodes.ToSymNode current) {
                return new ToSymRubySymbolNode((ToSymBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSymUninitializedNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSymUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSymUninitializedNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSymBaseNode rootNode = (ToSymBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSymBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToSymNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSymUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToSymNode.class)
        private static abstract class ToSymBaseNode
        extends SymbolNodes.ToSymNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSymBaseNode next0;

            ToSymBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSymBaseNode(ToSymBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSymBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSymUninitializedNode(this);
                    ((ToSymUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSymBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSymBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSymBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSymUninitializedNode(this), (Node)new ToSymPolymorphicNode(this), (DSLNode)((ToSymBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSymBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (ToSymBaseNode)ToSymRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSymBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSymBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.ToProcNode.class)
    public static final class ToProcNodeFactory
    extends NodeFactoryBase<SymbolNodes.ToProcNode> {
        private static ToProcNodeFactory toProcNodeFactoryInstance;

        private ToProcNodeFactory() {
            super(SymbolNodes.ToProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.ToProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.ToProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToProcUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.ToProcNode> getInstance() {
            if (toProcNodeFactoryInstance == null) {
                toProcNodeFactoryInstance = new ToProcNodeFactory();
            }
            return toProcNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToProcPolymorphicNode
        extends ToProcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToProcPolymorphicNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToProcRubySymbolNode
        extends ToProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToProcRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            ToProcRubySymbolNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.toProc(arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.toProc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToProcNode create0(SymbolNodes.ToProcNode current) {
                return new ToProcRubySymbolNode((ToProcBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToProcUninitializedNode
        extends ToProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToProcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToProcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToProcUninitializedNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyProc executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToProcBaseNode rootNode = (ToProcBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToProcBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.ToProcNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToProcUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.ToProcNode.class)
        private static abstract class ToProcBaseNode
        extends SymbolNodes.ToProcNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToProcBaseNode next0;

            ToProcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToProcBaseNode(ToProcBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyProc executeChained0(VirtualFrame var1, Object var2);

            protected final RubyProc rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToProcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToProcUninitializedNode(this);
                    ((ToProcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToProcBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToProcBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToProcBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToProcUninitializedNode(this), (Node)new ToProcPolymorphicNode(this), (DSLNode)((ToProcBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToProcBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (ToProcBaseNode)ToProcRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToProcBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToProcBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.InternNode.class)
    public static final class InternNodeFactory
    extends NodeFactoryBase<SymbolNodes.InternNode> {
        private static InternNodeFactory internNodeFactoryInstance;

        private InternNodeFactory() {
            super(SymbolNodes.InternNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.InternNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InternNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.InternNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InternUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.InternNode> getInstance() {
            if (internNodeFactoryInstance == null) {
                internNodeFactoryInstance = new InternNodeFactory();
            }
            return internNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.InternNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InternPolymorphicNode
        extends InternBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InternPolymorphicNode(InternBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.InternNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InternRubySymbolNode
        extends InternBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            InternRubySymbolNode(InternBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.intern(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.intern(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.InternNode create0(SymbolNodes.InternNode current) {
                return new InternRubySymbolNode((InternBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.InternNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InternUninitializedNode
        extends InternBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InternUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InternUninitializedNode(InternBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InternBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InternBaseNode rootNode = (InternBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InternBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.InternNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InternUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.InternNode.class)
        private static abstract class InternBaseNode
        extends SymbolNodes.InternNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InternBaseNode next0;

            InternBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InternBaseNode(InternBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                InternBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InternBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InternUninitializedNode(this);
                    ((InternUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InternBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InternBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (InternBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InternUninitializedNode(this), (Node)new InternPolymorphicNode(this), (DSLNode)((InternBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InternBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (InternBaseNode)InternRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InternBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InternBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<SymbolNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(SymbolNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HashPolymorphicNode
        extends HashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            HashPolymorphicNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashRubySymbolNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            HashRubySymbolNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.HashNode create0(SymbolNodes.HashNode current) {
                return new HashRubySymbolNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HashUninitializedNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HashUninitializedNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    HashBaseNode rootNode = (HashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((HashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.HashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.HashNode.class)
        private static abstract class HashBaseNode
        extends SymbolNodes.HashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HashBaseNode next0;

            HashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HashBaseNode(HashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                HashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new HashUninitializedNode(this);
                    ((HashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (HashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = HashBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (HashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new HashUninitializedNode(this), (Node)new HashPolymorphicNode(this), (DSLNode)((HashBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (HashBaseNode)HashRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((HashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (HashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<SymbolNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(SymbolNodes.EncodingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.EncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EncodingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EncodingPolymorphicNode
        extends EncodingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EncodingPolymorphicNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EncodingRubySymbolNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            EncodingRubySymbolNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.encoding(arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.encoding(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.EncodingNode create0(SymbolNodes.EncodingNode current) {
                return new EncodingRubySymbolNode((EncodingBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EncodingUninitializedNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EncodingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EncodingUninitializedNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyEncoding executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EncodingBaseNode rootNode = (EncodingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EncodingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.EncodingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EncodingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.EncodingNode.class)
        private static abstract class EncodingBaseNode
        extends SymbolNodes.EncodingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EncodingBaseNode next0;

            EncodingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EncodingBaseNode(EncodingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyEncoding executeChained0(VirtualFrame var1, Object var2);

            protected final RubyEncoding rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EncodingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EncodingUninitializedNode(this);
                    ((EncodingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EncodingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EncodingBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EncodingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EncodingUninitializedNode(this), (Node)new EncodingPolymorphicNode(this), (DSLNode)((EncodingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EncodingBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (EncodingBaseNode)EncodingRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EncodingBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EncodingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<SymbolNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(SymbolNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubySymbolNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            EmptyRubySymbolNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.empty(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.empty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.EmptyNode create0(SymbolNodes.EmptyNode current) {
                return new EmptyRubySymbolNode((EmptyBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends SymbolNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EmptyBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (EmptyBaseNode)EmptyRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
    public static final class DowncaseNodeFactory
    extends NodeFactoryBase<SymbolNodes.DowncaseNode> {
        private static DowncaseNodeFactory downcaseNodeFactoryInstance;

        private DowncaseNodeFactory() {
            super(SymbolNodes.DowncaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.DowncaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.DowncaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DowncaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.DowncaseNode> getInstance() {
            if (downcaseNodeFactoryInstance == null) {
                downcaseNodeFactoryInstance = new DowncaseNodeFactory();
            }
            return downcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DowncasePolymorphicNode
        extends DowncaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DowncasePolymorphicNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DowncaseRubySymbolNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            DowncaseRubySymbolNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.downcase(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.downcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.DowncaseNode create0(SymbolNodes.DowncaseNode current) {
                return new DowncaseRubySymbolNode((DowncaseBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DowncaseUninitializedNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DowncaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DowncaseUninitializedNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DowncaseBaseNode rootNode = (DowncaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DowncaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.DowncaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DowncaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.DowncaseNode.class)
        private static abstract class DowncaseBaseNode
        extends SymbolNodes.DowncaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DowncaseBaseNode next0;

            DowncaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DowncaseBaseNode(DowncaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DowncaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DowncaseUninitializedNode(this);
                    ((DowncaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DowncaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DowncaseBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DowncaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DowncaseUninitializedNode(this), (Node)new DowncasePolymorphicNode(this), (DSLNode)((DowncaseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DowncaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (DowncaseBaseNode)DowncaseRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DowncaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DowncaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
    public static final class CaseCompareNodeFactory
    extends NodeFactoryBase<SymbolNodes.CaseCompareNode> {
        private static CaseCompareNodeFactory caseCompareNodeFactoryInstance;

        private CaseCompareNodeFactory() {
            super(SymbolNodes.CaseCompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CaseCompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CaseCompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.CaseCompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CaseCompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.CaseCompareNode> getInstance() {
            if (caseCompareNodeFactoryInstance == null) {
                caseCompareNodeFactoryInstance = new CaseCompareNodeFactory();
            }
            return caseCompareNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CaseComparePolymorphicNode
        extends CaseCompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CaseComparePolymorphicNode(CaseCompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CaseCompareRubyNilClassObjectNode
        extends CaseCompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCompareRubyNilClassObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, Object.class}, 0, 0);

            CaseCompareRubyNilClassObjectNode(CaseCompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubySymbol"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubySymbol(arguments1Value)) {
                    return super.caseCompare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubySymbol] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && !super.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.caseCompare(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CaseCompareNode create0(SymbolNodes.CaseCompareNode current) {
                return new CaseCompareRubyNilClassObjectNode((CaseCompareBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CaseCompareIntRubySymbolNode
        extends CaseCompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCompareIntRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, RubySymbol.class}, 0, 0);

            CaseCompareIntRubySymbolNode(CaseCompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubySymbol"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol"));
                }
                return super.caseCompare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.caseCompare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CaseCompareNode create0(SymbolNodes.CaseCompareNode current) {
                return new CaseCompareIntRubySymbolNode((CaseCompareBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CaseCompareUninitializedNode
        extends CaseCompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CaseCompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CaseCompareUninitializedNode(CaseCompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CaseCompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CaseCompareBaseNode rootNode = (CaseCompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CaseCompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CaseCompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CaseCompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.CaseCompareNode.class)
        private static abstract class CaseCompareBaseNode
        extends SymbolNodes.CaseCompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CaseCompareBaseNode next0;

            CaseCompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CaseCompareBaseNode(CaseCompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CaseCompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CaseCompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CaseCompareUninitializedNode(this);
                    ((CaseCompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CaseCompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CaseCompareBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CaseCompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CaseCompareUninitializedNode(this), (Node)new CaseComparePolymorphicNode(this), (DSLNode)((CaseCompareBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CaseCompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (CaseCompareBaseNode)CaseCompareIntRubySymbolNode.create0(this);
                    }
                    if (!super.isRubySymbol(arguments1Value)) {
                        return (CaseCompareBaseNode)CaseCompareRubyNilClassObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CaseCompareBaseNode otherCast = (CaseCompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CaseCompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
    public static final class CapitalizeNodeFactory
    extends NodeFactoryBase<SymbolNodes.CapitalizeNode> {
        private static CapitalizeNodeFactory capitalizeNodeFactoryInstance;

        private CapitalizeNodeFactory() {
            super(SymbolNodes.CapitalizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CapitalizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.CapitalizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapitalizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.CapitalizeNode> getInstance() {
            if (capitalizeNodeFactoryInstance == null) {
                capitalizeNodeFactoryInstance = new CapitalizeNodeFactory();
            }
            return capitalizeNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapitalizePolymorphicNode
        extends CapitalizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapitalizePolymorphicNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapitalizeRubySymbolNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

            CapitalizeRubySymbolNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubySymbol");
                }
                return super.capitalize(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.capitalize(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.CapitalizeNode create0(SymbolNodes.CapitalizeNode current) {
                return new CapitalizeRubySymbolNode((CapitalizeBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapitalizeUninitializedNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapitalizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapitalizeUninitializedNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapitalizeBaseNode rootNode = (CapitalizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapitalizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static SymbolNodes.CapitalizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapitalizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.CapitalizeNode.class)
        private static abstract class CapitalizeBaseNode
        extends SymbolNodes.CapitalizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapitalizeBaseNode next0;

            CapitalizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapitalizeBaseNode(CapitalizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CapitalizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapitalizeUninitializedNode(this);
                    ((CapitalizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapitalizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CapitalizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CapitalizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapitalizeUninitializedNode(this), (Node)new CapitalizePolymorphicNode(this), (DSLNode)((CapitalizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapitalizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    return (CapitalizeBaseNode)CapitalizeRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapitalizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapitalizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.AllSymbolsNode.class)
    public static final class AllSymbolsNodeFactory
    extends NodeFactoryBase<SymbolNodes.AllSymbolsNode> {
        private static AllSymbolsNodeFactory allSymbolsNodeFactoryInstance;

        private AllSymbolsNodeFactory() {
            super(SymbolNodes.AllSymbolsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.AllSymbolsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllSymbolsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.AllSymbolsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AllSymbolsDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.AllSymbolsNode> getInstance() {
            if (allSymbolsNodeFactoryInstance == null) {
                allSymbolsNodeFactoryInstance = new AllSymbolsNodeFactory();
            }
            return allSymbolsNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.AllSymbolsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AllSymbolsDefaultNode
        extends AllSymbolsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AllSymbolsDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            AllSymbolsDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.allSymbols();
            }

            static SymbolNodes.AllSymbolsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AllSymbolsDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.AllSymbolsNode.class)
        private static abstract class AllSymbolsBaseNode
        extends SymbolNodes.AllSymbolsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            AllSymbolsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<SymbolNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(SymbolNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyNilClassObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyNilClassObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, Object.class}, 0, 0);

            CompareRubyNilClassObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubySymbol"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubySymbol(arguments1Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubySymbol] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && !super.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.compare(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CompareNode create0(SymbolNodes.CompareNode current) {
                return new CompareRubyNilClassObjectNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntRubySymbolNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, RubySymbol.class}, 0, 0);

            CompareIntRubySymbolNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubySymbol"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CompareNode create0(SymbolNodes.CompareNode current) {
                return new CompareIntRubySymbolNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends SymbolNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CompareBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (CompareBaseNode)CompareIntRubySymbolNode.create0(this);
                    }
                    if (!super.isRubySymbol(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyNilClassObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=SymbolNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<SymbolNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(SymbolNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public SymbolNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static SymbolNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<SymbolNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubySymbolObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubySymbolObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, Object.class}, 0, 0);

            EqualRubySymbolObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubySymbol");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubySymbol(arguments1Value)) {
                    return super.equal(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubySymbol] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && !super.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    return super.equal(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.EqualNode create0(SymbolNodes.EqualNode current) {
                return new EqualRubySymbolObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubySymbolNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, RubySymbol.class}, 0, 0);

            EqualRubySymbolNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubySymbol");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.EqualNode create0(SymbolNodes.EqualNode current) {
                return new EqualRubySymbolNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static SymbolNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=SymbolNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends SymbolNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (EqualBaseNode)EqualRubySymbolNode.create0(this);
                    }
                    if (!super.isRubySymbol(arguments1Value)) {
                        return (EqualBaseNode)EqualRubySymbolObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

