/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;

@GeneratedBy(value=StringNodes.class)
public final class StringNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), FormatNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), MatchOperatorNodeFactory.getInstance(), ASCIIOnlyNodeFactory.getInstance(), BNodeFactory.getInstance(), BytesNodeFactory.getInstance(), ByteSizeNodeFactory.getInstance(), CaseCmpNodeFactory.getInstance(), ChopBangNodeFactory.getInstance(), CountNodeFactory.getInstance(), CryptNodeFactory.getInstance(), DataNodeFactory.getInstance(), DeleteBangNodeFactory.getInstance(), DowncaseNodeFactory.getInstance(), DowncaseBangNodeFactory.getInstance(), EachByteNodeFactory.getInstance(), EachCharNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), ForceEncodingNodeFactory.getInstance(), GetByteNodeFactory.getInstance(), HashNodeFactory.getInstance(), InspectNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InsertNodeFactory.getInstance(), LstripBangNodeFactory.getInstance(), MatchNodeFactory.getInstance(), ModifyBangNodeFactory.getInstance(), SetNumBytesNodeFactory.getInstance(), OrdNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), RstripBangNodeFactory.getInstance(), SwapcaseBangNodeFactory.getInstance(), DumpNodeFactory.getInstance(), ScanNodeFactory.getInstance(), SetByteNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SqueezeBangNodeFactory.getInstance(), SuccNodeFactory.getInstance(), SuccBangNodeFactory.getInstance(), SumNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ReverseBangNodeFactory.getInstance(), TrBangNodeFactory.getInstance(), TrSBangNodeFactory.getInstance(), UnpackNodeFactory.getInstance(), UpcaseNodeFactory.getInstance(), UpcaseBangNodeFactory.getInstance(), ValidEncodingQueryNodeFactory.getInstance(), CapitalizeBangNodeFactory.getInstance(), CapitalizeNodeFactory.getInstance(), ClearNodeFactory.getInstance());
    }

    @GeneratedBy(value=StringNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<StringNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(StringNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClearUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClearPolymorphicNode
        extends ClearBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClearPolymorphicNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyStringNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ClearRubyStringNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.clear(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.clear(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ClearNode create0(StringNodes.ClearNode current) {
                return new ClearRubyStringNode((ClearBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClearUninitializedNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClearUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClearUninitializedNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClearBaseNode rootNode = (ClearBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClearBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ClearNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClearUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        private static abstract class ClearBaseNode
        extends StringNodes.ClearNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClearBaseNode next0;

            ClearBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClearBaseNode(ClearBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ClearBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClearUninitializedNode(this);
                    ((ClearUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClearBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClearBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ClearBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClearUninitializedNode(this), (Node)new ClearPolymorphicNode(this), (DSLNode)((ClearBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClearBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ClearBaseNode)ClearRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClearBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClearBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeNode.class)
    public static final class CapitalizeNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeNode> {
        private static CapitalizeNodeFactory capitalizeNodeFactoryInstance;

        private CapitalizeNodeFactory() {
            super(StringNodes.CapitalizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CapitalizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapitalizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CapitalizeNode> getInstance() {
            if (capitalizeNodeFactoryInstance == null) {
                capitalizeNodeFactoryInstance = new CapitalizeNodeFactory();
            }
            return capitalizeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapitalizePolymorphicNode
        extends CapitalizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapitalizePolymorphicNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapitalizeRubyStringNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            CapitalizeRubyStringNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.capitalize(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.capitalize(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeNode create0(StringNodes.CapitalizeNode current) {
                return new CapitalizeRubyStringNode((CapitalizeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapitalizeUninitializedNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapitalizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapitalizeUninitializedNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapitalizeBaseNode rootNode = (CapitalizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapitalizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapitalizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        private static abstract class CapitalizeBaseNode
        extends StringNodes.CapitalizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapitalizeBaseNode next0;

            CapitalizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapitalizeBaseNode(CapitalizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CapitalizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapitalizeUninitializedNode(this);
                    ((CapitalizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapitalizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CapitalizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CapitalizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapitalizeUninitializedNode(this), (Node)new CapitalizePolymorphicNode(this), (DSLNode)((CapitalizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapitalizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (CapitalizeBaseNode)CapitalizeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapitalizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapitalizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
    public static final class CapitalizeBangNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeBangNode> {
        private static CapitalizeBangNodeFactory capitalizeBangNodeFactoryInstance;

        private CapitalizeBangNodeFactory() {
            super(StringNodes.CapitalizeBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CapitalizeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapitalizeBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CapitalizeBangNode> getInstance() {
            if (capitalizeBangNodeFactoryInstance == null) {
                capitalizeBangNodeFactoryInstance = new CapitalizeBangNodeFactory();
            }
            return capitalizeBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapitalizeBangPolymorphicNode
        extends CapitalizeBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapitalizeBangPolymorphicNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapitalizeBangRubyStringNode
        extends CapitalizeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            CapitalizeBangRubyStringNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.capitalizeBang(arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.capitalizeBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeBangNode create0(StringNodes.CapitalizeBangNode current) {
                return new CapitalizeBangRubyStringNode((CapitalizeBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapitalizeBangUninitializedNode
        extends CapitalizeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapitalizeBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapitalizeBangUninitializedNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapitalizeBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapitalizeBangBaseNode rootNode = (CapitalizeBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapitalizeBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapitalizeBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        private static abstract class CapitalizeBangBaseNode
        extends StringNodes.CapitalizeBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapitalizeBangBaseNode next0;

            CapitalizeBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapitalizeBangBaseNode(CapitalizeBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CapitalizeBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapitalizeBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapitalizeBangUninitializedNode(this);
                    ((CapitalizeBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapitalizeBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CapitalizeBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CapitalizeBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapitalizeBangUninitializedNode(this), (Node)new CapitalizeBangPolymorphicNode(this), (DSLNode)((CapitalizeBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapitalizeBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (CapitalizeBangBaseNode)CapitalizeBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapitalizeBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapitalizeBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
    public static final class ValidEncodingQueryNodeFactory
    extends NodeFactoryBase<StringNodes.ValidEncodingQueryNode> {
        private static ValidEncodingQueryNodeFactory validEncodingQueryNodeFactoryInstance;

        private ValidEncodingQueryNodeFactory() {
            super(StringNodes.ValidEncodingQueryNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ValidEncodingQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValidEncodingQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ValidEncodingQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ValidEncodingQueryUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ValidEncodingQueryNode> getInstance() {
            if (validEncodingQueryNodeFactoryInstance == null) {
                validEncodingQueryNodeFactoryInstance = new ValidEncodingQueryNodeFactory();
            }
            return validEncodingQueryNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ValidEncodingQueryPolymorphicNode
        extends ValidEncodingQueryBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ValidEncodingQueryPolymorphicNode(ValidEncodingQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValidEncodingQueryRubyStringNode
        extends ValidEncodingQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValidEncodingQueryRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ValidEncodingQueryRubyStringNode(ValidEncodingQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.validEncodingQuery(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.validEncodingQuery(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ValidEncodingQueryNode create0(StringNodes.ValidEncodingQueryNode current) {
                return new ValidEncodingQueryRubyStringNode((ValidEncodingQueryBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ValidEncodingQueryUninitializedNode
        extends ValidEncodingQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValidEncodingQueryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ValidEncodingQueryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ValidEncodingQueryUninitializedNode(ValidEncodingQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ValidEncodingQueryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ValidEncodingQueryBaseNode rootNode = (ValidEncodingQueryBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ValidEncodingQueryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ValidEncodingQueryNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ValidEncodingQueryUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        private static abstract class ValidEncodingQueryBaseNode
        extends StringNodes.ValidEncodingQueryNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ValidEncodingQueryBaseNode next0;

            ValidEncodingQueryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ValidEncodingQueryBaseNode(ValidEncodingQueryBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ValidEncodingQueryBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ValidEncodingQueryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ValidEncodingQueryUninitializedNode(this);
                    ((ValidEncodingQueryUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ValidEncodingQueryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ValidEncodingQueryBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ValidEncodingQueryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ValidEncodingQueryUninitializedNode(this), (Node)new ValidEncodingQueryPolymorphicNode(this), (DSLNode)((ValidEncodingQueryBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ValidEncodingQueryBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ValidEncodingQueryBaseNode)ValidEncodingQueryRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ValidEncodingQueryBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ValidEncodingQueryBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
    public static final class UpcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseBangNode> {
        private static UpcaseBangNodeFactory upcaseBangNodeFactoryInstance;

        private UpcaseBangNodeFactory() {
            super(StringNodes.UpcaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UpcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpcaseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UpcaseBangNode> getInstance() {
            if (upcaseBangNodeFactoryInstance == null) {
                upcaseBangNodeFactoryInstance = new UpcaseBangNodeFactory();
            }
            return upcaseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpcaseBangPolymorphicNode
        extends UpcaseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UpcaseBangPolymorphicNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpcaseBangRubyStringNode
        extends UpcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            UpcaseBangRubyStringNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.upcaseBang(arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.upcaseBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseBangNode create0(StringNodes.UpcaseBangNode current) {
                return new UpcaseBangRubyStringNode((UpcaseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpcaseBangUninitializedNode
        extends UpcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpcaseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpcaseBangUninitializedNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UpcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpcaseBangBaseNode rootNode = (UpcaseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UpcaseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpcaseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        private static abstract class UpcaseBangBaseNode
        extends StringNodes.UpcaseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpcaseBangBaseNode next0;

            UpcaseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpcaseBangBaseNode(UpcaseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UpcaseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UpcaseBangUninitializedNode(this);
                    ((UpcaseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UpcaseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UpcaseBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UpcaseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UpcaseBangUninitializedNode(this), (Node)new UpcaseBangPolymorphicNode(this), (DSLNode)((UpcaseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpcaseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (UpcaseBangBaseNode)UpcaseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UpcaseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UpcaseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(StringNodes.UpcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpcaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpcasePolymorphicNode
        extends UpcaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UpcasePolymorphicNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpcaseRubyStringNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            UpcaseRubyStringNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.upcase(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.upcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseNode create0(StringNodes.UpcaseNode current) {
                return new UpcaseRubyStringNode((UpcaseBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpcaseUninitializedNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpcaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpcaseUninitializedNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpcaseBaseNode rootNode = (UpcaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UpcaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpcaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        private static abstract class UpcaseBaseNode
        extends StringNodes.UpcaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpcaseBaseNode next0;

            UpcaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpcaseBaseNode(UpcaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UpcaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UpcaseUninitializedNode(this);
                    ((UpcaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UpcaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UpcaseBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UpcaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UpcaseUninitializedNode(this), (Node)new UpcasePolymorphicNode(this), (DSLNode)((UpcaseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpcaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (UpcaseBaseNode)UpcaseRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UpcaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UpcaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UnpackNode.class)
    public static final class UnpackNodeFactory
    extends NodeFactoryBase<StringNodes.UnpackNode> {
        private static UnpackNodeFactory unpackNodeFactoryInstance;

        private UnpackNodeFactory() {
            super(StringNodes.UnpackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UnpackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnpackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UnpackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnpackUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UnpackNode> getInstance() {
            if (unpackNodeFactoryInstance == null) {
                unpackNodeFactoryInstance = new UnpackNodeFactory();
            }
            return unpackNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnpackPolymorphicNode
        extends UnpackBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UnpackPolymorphicNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnpackRubyStringNode
        extends UnpackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnpackRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            UnpackRubyStringNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.unpack(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.unpack(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.UnpackNode create0(StringNodes.UnpackNode current) {
                return new UnpackRubyStringNode((UnpackBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnpackUninitializedNode
        extends UnpackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnpackUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnpackUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnpackUninitializedNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UnpackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnpackBaseNode rootNode = (UnpackBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnpackBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.UnpackNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnpackUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        private static abstract class UnpackBaseNode
        extends StringNodes.UnpackNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnpackBaseNode next0;

            UnpackBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnpackBaseNode(UnpackBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                UnpackBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnpackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UnpackUninitializedNode(this);
                    ((UnpackUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnpackBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UnpackBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (UnpackBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnpackUninitializedNode(this), (Node)new UnpackPolymorphicNode(this), (DSLNode)((UnpackBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnpackBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (UnpackBaseNode)UnpackRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UnpackBaseNode otherCast = (UnpackBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UnpackBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrSBangNode.class)
    public static final class TrSBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrSBangNode> {
        private static TrSBangNodeFactory trSBangNodeFactoryInstance;

        private TrSBangNodeFactory() {
            super(StringNodes.TrSBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.TrSBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return TrSBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.TrSBangNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return TrSBangUninitializedNode.create0(context, sourceSection, self, fromStr, toStrNode);
        }

        public static NodeFactory<StringNodes.TrSBangNode> getInstance() {
            if (trSBangNodeFactoryInstance == null) {
                trSBangNodeFactoryInstance = new TrSBangNodeFactory();
            }
            return trSBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TrSBangPolymorphicNode
        extends TrSBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> fromStrPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> toStrNodePolymorphicType;

            TrSBangPolymorphicNode(TrSBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                Object fromStrValue = this.fromStr.execute(frameValue);
                Object toStrNodeValue = this.toStrNode.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.fromStrPolymorphicType = types[1];
                this.toStrNodePolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TrSBangRubyStringNode
        extends TrSBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TrSBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyString.class}, 0, 0);

            TrSBangRubyStringNode(TrSBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString toStrNodeValue;
                RubyString fromStrValue;
                RubyString selfValue;
                try {
                    selfValue = this.self.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromStrValue2 = this.fromStr.execute(frameValue);
                    Object toStrNodeValue2 = this.toStrNode.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromStrValue2, toStrNodeValue2, "Expected selfValue instanceof RubyString");
                }
                try {
                    fromStrValue = this.fromStr.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object toStrNodeValue3 = this.toStrNode.execute(frameValue);
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), toStrNodeValue3, "Expected fromStrValue instanceof RubyString");
                }
                try {
                    toStrNodeValue = this.toStrNode.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, fromStrValue, ex.getResult(), "Expected toStrNodeValue instanceof RubyString");
                }
                return super.trSBang(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(selfValue) && RubyTypesGen.RUBYTYPES.isRubyString(fromStrValue) && RubyTypesGen.RUBYTYPES.isRubyString(toStrNodeValue)) {
                    RubyString selfValueCast = RubyTypesGen.RUBYTYPES.asRubyString(selfValue);
                    RubyString fromStrValueCast = RubyTypesGen.RUBYTYPES.asRubyString(fromStrValue);
                    RubyString toStrNodeValueCast = RubyTypesGen.RUBYTYPES.asRubyString(toStrNodeValue);
                    return super.trSBang(frameValue, selfValueCast, fromStrValueCast, toStrNodeValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            static StringNodes.TrSBangNode create0(StringNodes.TrSBangNode current) {
                return new TrSBangRubyStringNode((TrSBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TrSBangUninitializedNode
        extends TrSBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TrSBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TrSBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection, self, fromStr, toStrNode);
            }

            TrSBangUninitializedNode(TrSBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object fromStrValue = this.fromStr.execute(frameValue);
                Object toStrNodeValue = this.toStrNode.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                TrSBangBaseNode newNode = this.specialize0(selfValue, fromStrValue, toStrNodeValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    TrSBangBaseNode rootNode = (TrSBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.fromStr, rootNode.toStrNode}, new Object[]{selfValue, fromStrValue, toStrNodeValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((TrSBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            static StringNodes.TrSBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                return new TrSBangUninitializedNode(context, sourceSection, self, fromStr, toStrNode);
            }
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        private static abstract class TrSBangBaseNode
        extends StringNodes.TrSBangNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode fromStr;
            @Node.Child
            protected RubyNode toStrNode;
            @Node.Child
            protected TrSBangBaseNode next0;

            TrSBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection);
                this.self = self;
                this.fromStr = super.coerceFromStrToString(fromStr);
                this.toStrNode = super.coerceToStrToString(toStrNode);
            }

            TrSBangBaseNode(TrSBangBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue, String reason) {
                String message;
                TrSBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TrSBangBaseNode newNode = this.specialize0(selfValue, fromStrValue, toStrNodeValue);
                if (newNode == null) {
                    newNode = new TrSBangUninitializedNode(this);
                    ((TrSBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (TrSBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = TrSBangBaseNode.createInfo0(reason, selfValue, fromStrValue, toStrNodeValue)))) == null) {
                    returnNode = (TrSBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new TrSBangUninitializedNode(this), (Node)new TrSBangPolymorphicNode(this), (DSLNode)((TrSBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TrSBangBaseNode specialize0(Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(selfValue) && RubyTypesGen.RUBYTYPES.isRubyString(fromStrValue) && RubyTypesGen.RUBYTYPES.isRubyString(toStrNodeValue)) {
                    return (TrSBangBaseNode)TrSBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.fromStr = null;
                    this.toStrNode = null;
                } else {
                    TrSBangBaseNode otherCast = (TrSBangBaseNode)other;
                    this.self = otherCast.self;
                    this.fromStr = otherCast.fromStr;
                    this.toStrNode = otherCast.toStrNode;
                }
                this.next0 = newNext == null ? null : (TrSBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("fromStrValue").append(" = ").append(fromStrValue);
                    if (fromStrValue != null) {
                        builder.append(" (").append(fromStrValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("toStrNodeValue").append(" = ").append(toStrNodeValue);
                    if (toStrNodeValue != null) {
                        builder.append(" (").append(toStrNodeValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrBangNode.class)
    public static final class TrBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrBangNode> {
        private static TrBangNodeFactory trBangNodeFactoryInstance;

        private TrBangNodeFactory() {
            super(StringNodes.TrBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.TrBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return TrBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.TrBangNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return TrBangUninitializedNode.create0(context, sourceSection, self, fromStr, toStrNode);
        }

        public static NodeFactory<StringNodes.TrBangNode> getInstance() {
            if (trBangNodeFactoryInstance == null) {
                trBangNodeFactoryInstance = new TrBangNodeFactory();
            }
            return trBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TrBangPolymorphicNode
        extends TrBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> fromStrPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> toStrNodePolymorphicType;

            TrBangPolymorphicNode(TrBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                Object fromStrValue = this.fromStr.execute(frameValue);
                Object toStrNodeValue = this.toStrNode.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.fromStrPolymorphicType = types[1];
                this.toStrNodePolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TrBangRubyStringNode
        extends TrBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TrBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyString.class}, 0, 0);

            TrBangRubyStringNode(TrBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString toStrNodeValue;
                RubyString fromStrValue;
                RubyString selfValue;
                try {
                    selfValue = this.self.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromStrValue2 = this.fromStr.execute(frameValue);
                    Object toStrNodeValue2 = this.toStrNode.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromStrValue2, toStrNodeValue2, "Expected selfValue instanceof RubyString");
                }
                try {
                    fromStrValue = this.fromStr.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object toStrNodeValue3 = this.toStrNode.execute(frameValue);
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), toStrNodeValue3, "Expected fromStrValue instanceof RubyString");
                }
                try {
                    toStrNodeValue = this.toStrNode.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, fromStrValue, ex.getResult(), "Expected toStrNodeValue instanceof RubyString");
                }
                return super.trBang(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(selfValue) && RubyTypesGen.RUBYTYPES.isRubyString(fromStrValue) && RubyTypesGen.RUBYTYPES.isRubyString(toStrNodeValue)) {
                    RubyString selfValueCast = RubyTypesGen.RUBYTYPES.asRubyString(selfValue);
                    RubyString fromStrValueCast = RubyTypesGen.RUBYTYPES.asRubyString(fromStrValue);
                    RubyString toStrNodeValueCast = RubyTypesGen.RUBYTYPES.asRubyString(toStrNodeValue);
                    return super.trBang(frameValue, selfValueCast, fromStrValueCast, toStrNodeValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            static StringNodes.TrBangNode create0(StringNodes.TrBangNode current) {
                return new TrBangRubyStringNode((TrBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TrBangUninitializedNode
        extends TrBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TrBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TrBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection, self, fromStr, toStrNode);
            }

            TrBangUninitializedNode(TrBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object fromStrValue = this.fromStr.execute(frameValue);
                Object toStrNodeValue = this.toStrNode.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                TrBangBaseNode newNode = this.specialize0(selfValue, fromStrValue, toStrNodeValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    TrBangBaseNode rootNode = (TrBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.fromStr, rootNode.toStrNode}, new Object[]{selfValue, fromStrValue, toStrNodeValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((TrBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            static StringNodes.TrBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                return new TrBangUninitializedNode(context, sourceSection, self, fromStr, toStrNode);
            }
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        private static abstract class TrBangBaseNode
        extends StringNodes.TrBangNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode fromStr;
            @Node.Child
            protected RubyNode toStrNode;
            @Node.Child
            protected TrBangBaseNode next0;

            TrBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection);
                this.self = self;
                this.fromStr = super.coerceFromStrToString(fromStr);
                this.toStrNode = super.coerceToStrToString(toStrNode);
            }

            TrBangBaseNode(TrBangBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue, String reason) {
                String message;
                TrBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TrBangBaseNode newNode = this.specialize0(selfValue, fromStrValue, toStrNodeValue);
                if (newNode == null) {
                    newNode = new TrBangUninitializedNode(this);
                    ((TrBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (TrBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = TrBangBaseNode.createInfo0(reason, selfValue, fromStrValue, toStrNodeValue)))) == null) {
                    returnNode = (TrBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new TrBangUninitializedNode(this), (Node)new TrBangPolymorphicNode(this), (DSLNode)((TrBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, fromStrValue, toStrNodeValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TrBangBaseNode specialize0(Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(selfValue) && RubyTypesGen.RUBYTYPES.isRubyString(fromStrValue) && RubyTypesGen.RUBYTYPES.isRubyString(toStrNodeValue)) {
                    return (TrBangBaseNode)TrBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.fromStr = null;
                    this.toStrNode = null;
                } else {
                    TrBangBaseNode otherCast = (TrBangBaseNode)other;
                    this.self = otherCast.self;
                    this.fromStr = otherCast.fromStr;
                    this.toStrNode = otherCast.toStrNode;
                }
                this.next0 = newNext == null ? null : (TrBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("fromStrValue").append(" = ").append(fromStrValue);
                    if (fromStrValue != null) {
                        builder.append(" (").append(fromStrValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("toStrNodeValue").append(" = ").append(toStrNodeValue);
                    if (toStrNodeValue != null) {
                        builder.append(" (").append(toStrNodeValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReverseBangNode.class)
    public static final class ReverseBangNodeFactory
    extends NodeFactoryBase<StringNodes.ReverseBangNode> {
        private static ReverseBangNodeFactory reverseBangNodeFactoryInstance;

        private ReverseBangNodeFactory() {
            super(StringNodes.ReverseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ReverseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReverseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ReverseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReverseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ReverseBangNode> getInstance() {
            if (reverseBangNodeFactoryInstance == null) {
                reverseBangNodeFactoryInstance = new ReverseBangNodeFactory();
            }
            return reverseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReverseBangPolymorphicNode
        extends ReverseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReverseBangPolymorphicNode(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReverseBangRubyString2Node
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangRubyString2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReverseBangRubyString2Node(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!ReverseBangBaseNode.reverseIsEqualToSelf(arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.reverse(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!reverseIsEqualToSelf, !isSingleByteOptimizable] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !ReverseBangBaseNode.reverseIsEqualToSelf(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value)) && !StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                    return super.reverse(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(StringNodes.ReverseBangNode current) {
                return new ReverseBangRubyString2Node((ReverseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReverseBangRubyString1Node
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReverseBangRubyString1Node(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!ReverseBangBaseNode.reverseIsEqualToSelf(arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.reverseSingleByteOptimizable(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!reverseIsEqualToSelf, isSingleByteOptimizable] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !ReverseBangBaseNode.reverseIsEqualToSelf(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value)) && StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                    return super.reverseSingleByteOptimizable(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(StringNodes.ReverseBangNode current) {
                return new ReverseBangRubyString1Node((ReverseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReverseBangRubyString0Node
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReverseBangRubyString0Node(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (ReverseBangBaseNode.reverseIsEqualToSelf(arguments0Value)) {
                    return super.reverseNoOp(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [reverseIsEqualToSelf] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && ReverseBangBaseNode.reverseIsEqualToSelf(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.reverseNoOp(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(StringNodes.ReverseBangNode current) {
                return new ReverseBangRubyString0Node((ReverseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReverseBangUninitializedNode
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReverseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReverseBangUninitializedNode(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReverseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReverseBangBaseNode rootNode = (ReverseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReverseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReverseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        private static abstract class ReverseBangBaseNode
        extends StringNodes.ReverseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReverseBangBaseNode next0;

            ReverseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReverseBangBaseNode(ReverseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ReverseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReverseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReverseBangUninitializedNode(this);
                    ((ReverseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReverseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ReverseBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ReverseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReverseBangUninitializedNode(this), (Node)new ReverseBangPolymorphicNode(this), (DSLNode)((ReverseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReverseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0ValueCast)) {
                        return (ReverseBangBaseNode)ReverseBangRubyString0Node.create0(this);
                    }
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (ReverseBangBaseNode)ReverseBangRubyString1Node.create0(this);
                    }
                    return (ReverseBangBaseNode)ReverseBangRubyString2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReverseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReverseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<StringNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(StringNodes.ToSymNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSymNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSymNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToSymNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSymUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSymPolymorphicNode
        extends ToSymBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSymPolymorphicNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSymRubyStringNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToSymRubyStringNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toSym(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toSym(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSymNode create0(StringNodes.ToSymNode current) {
                return new ToSymRubyStringNode((ToSymBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSymUninitializedNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSymUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSymUninitializedNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSymBaseNode rootNode = (ToSymBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSymBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSymNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSymUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        private static abstract class ToSymBaseNode
        extends StringNodes.ToSymNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSymBaseNode next0;

            ToSymBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSymBaseNode(ToSymBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSymBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSymUninitializedNode(this);
                    ((ToSymUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSymBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSymBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSymBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSymUninitializedNode(this), (Node)new ToSymPolymorphicNode(this), (DSLNode)((ToSymBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSymBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToSymBaseNode)ToSymRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSymBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSymBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<StringNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(StringNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSObjectNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToSObjectNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (super.isStringSubclass(arguments0Value)) {
                    return super.toSOnSubclass(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isStringSubclass] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && super.isStringSubclass(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.toSOnSubclass(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSNode create0(StringNodes.ToSNode current) {
                return new ToSObjectNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyStringNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToSRubyStringNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString"));
                }
                if (!super.isStringSubclass(arguments0Value)) {
                    return super.toS(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, "One of guards [!isStringSubclass] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isStringSubclass(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSNode create0(StringNodes.ToSNode current) {
                return new ToSRubyStringNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends StringNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (!super.isStringSubclass(arguments0ValueCast)) {
                        return (ToSBaseNode)ToSRubyStringNode.create0(this);
                    }
                    return (ToSBaseNode)ToSObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<StringNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(StringNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToFUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToFPolymorphicNode
        extends ToFBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToFPolymorphicNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFRubyStringNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToFRubyStringNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToFNode create0(StringNodes.ToFNode current) {
                return new ToFRubyStringNode((ToFBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToFUninitializedNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToFUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToFUninitializedNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToFBaseNode rootNode = (ToFBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToFBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToFNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToFUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        private static abstract class ToFBaseNode
        extends StringNodes.ToFNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToFBaseNode next0;

            ToFBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToFBaseNode(ToFBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToFBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToFUninitializedNode(this);
                    ((ToFUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToFBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToFBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToFBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToFUninitializedNode(this), (Node)new ToFPolymorphicNode(this), (DSLNode)((ToFBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToFBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToFBaseNode)ToFRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToFBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToFBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SumNode.class)
    public static final class SumNodeFactory
    extends NodeFactoryBase<StringNodes.SumNode> {
        private static SumNodeFactory sumNodeFactoryInstance;

        private SumNodeFactory() {
            super(StringNodes.SumNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SumNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SumNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SumNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SumUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SumNode> getInstance() {
            if (sumNodeFactoryInstance == null) {
                sumNodeFactoryInstance = new SumNodeFactory();
            }
            return sumNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SumPolymorphicNode
        extends SumBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SumPolymorphicNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SumRubyStringObjectNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            SumRubyStringObjectNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isUndefinedPlaceholder(arguments1Value))) {
                    return super.sum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isInteger(arguments1Value) && !super.isLong(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.sum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SumNode create0(StringNodes.SumNode current) {
                return new SumRubyStringObjectNode((SumBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SumRubyStringUndefinedPlaceholderNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            SumRubyStringUndefinedPlaceholderNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.sum(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.sum(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SumNode create0(StringNodes.SumNode current) {
                return new SumRubyStringUndefinedPlaceholderNode((SumBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SumRubyStringLongNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumRubyStringLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Long.TYPE}, 0, 0);

            SumRubyStringLongNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.sum(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.sum(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SumNode create0(StringNodes.SumNode current) {
                return new SumRubyStringLongNode((SumBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SumRubyStringIntNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            SumRubyStringIntNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.sum(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.sum(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SumNode create0(StringNodes.SumNode current) {
                return new SumRubyStringIntNode((SumBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SumUninitializedNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SumUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SumUninitializedNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SumBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SumBaseNode rootNode = (SumBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SumBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SumNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SumUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        private static abstract class SumBaseNode
        extends StringNodes.SumNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SumBaseNode next0;

            SumBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SumBaseNode(SumBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SumBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SumBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SumUninitializedNode(this);
                    ((SumUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SumBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SumBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SumBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SumUninitializedNode(this), (Node)new SumPolymorphicNode(this), (DSLNode)((SumBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SumBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SumBaseNode)SumRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SumBaseNode)SumRubyStringLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (SumBaseNode)SumRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isUndefinedPlaceholder(arguments1Value))) {
                        return (SumBaseNode)SumRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SumBaseNode otherCast = (SumBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SumBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccBangNode.class)
    public static final class SuccBangNodeFactory
    extends NodeFactoryBase<StringNodes.SuccBangNode> {
        private static SuccBangNodeFactory succBangNodeFactoryInstance;

        private SuccBangNodeFactory() {
            super(StringNodes.SuccBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SuccBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SuccBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SuccBangNode> getInstance() {
            if (succBangNodeFactoryInstance == null) {
                succBangNodeFactoryInstance = new SuccBangNodeFactory();
            }
            return succBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SuccBangPolymorphicNode
        extends SuccBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SuccBangPolymorphicNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SuccBangRubyStringNode
        extends SuccBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SuccBangRubyStringNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.succBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.succBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccBangNode create0(StringNodes.SuccBangNode current) {
                return new SuccBangRubyStringNode((SuccBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SuccBangUninitializedNode
        extends SuccBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SuccBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SuccBangUninitializedNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SuccBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SuccBangBaseNode rootNode = (SuccBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SuccBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SuccBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        private static abstract class SuccBangBaseNode
        extends StringNodes.SuccBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SuccBangBaseNode next0;

            SuccBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SuccBangBaseNode(SuccBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SuccBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SuccBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SuccBangUninitializedNode(this);
                    ((SuccBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SuccBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SuccBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SuccBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SuccBangUninitializedNode(this), (Node)new SuccBangPolymorphicNode(this), (DSLNode)((SuccBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SuccBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SuccBangBaseNode)SuccBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SuccBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SuccBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccNode.class)
    public static final class SuccNodeFactory
    extends NodeFactoryBase<StringNodes.SuccNode> {
        private static SuccNodeFactory succNodeFactoryInstance;

        private SuccNodeFactory() {
            super(StringNodes.SuccNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SuccNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SuccUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SuccNode> getInstance() {
            if (succNodeFactoryInstance == null) {
                succNodeFactoryInstance = new SuccNodeFactory();
            }
            return succNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SuccPolymorphicNode
        extends SuccBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SuccPolymorphicNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SuccRubyStringNode
        extends SuccBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SuccRubyStringNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.succ(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.succ(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccNode create0(StringNodes.SuccNode current) {
                return new SuccRubyStringNode((SuccBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SuccUninitializedNode
        extends SuccBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SuccUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SuccUninitializedNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SuccBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SuccBaseNode rootNode = (SuccBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SuccBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SuccUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        private static abstract class SuccBaseNode
        extends StringNodes.SuccNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SuccBaseNode next0;

            SuccBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SuccBaseNode(SuccBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SuccBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SuccBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SuccUninitializedNode(this);
                    ((SuccUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SuccBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SuccBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SuccBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SuccUninitializedNode(this), (Node)new SuccPolymorphicNode(this), (DSLNode)((SuccBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SuccBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SuccBaseNode)SuccRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SuccBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SuccBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
    public static final class SqueezeBangNodeFactory
    extends NodeFactoryBase<StringNodes.SqueezeBangNode> {
        private static SqueezeBangNodeFactory squeezeBangNodeFactoryInstance;

        private SqueezeBangNodeFactory() {
            super(StringNodes.SqueezeBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SqueezeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SqueezeBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SqueezeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SqueezeBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SqueezeBangNode> getInstance() {
            if (squeezeBangNodeFactoryInstance == null) {
                squeezeBangNodeFactoryInstance = new SqueezeBangNodeFactory();
            }
            return squeezeBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SqueezeBangPolymorphicNode
        extends SqueezeBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SqueezeBangPolymorphicNode(SqueezeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqueezeBangRubyString1Node
        extends SqueezeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqueezeBangRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            SqueezeBangRubyString1Node(SqueezeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (!SqueezeBangBaseNode.zeroArgs(arguments0Value, arguments1Value)) {
                    return super.squeezeBang(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!zeroArgs] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && !SqueezeBangBaseNode.zeroArgs(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    return super.squeezeBang(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SqueezeBangNode create0(StringNodes.SqueezeBangNode current) {
                return new SqueezeBangRubyString1Node((SqueezeBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqueezeBangRubyString0Node
        extends SqueezeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqueezeBangRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            SqueezeBangRubyString0Node(SqueezeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (SqueezeBangBaseNode.zeroArgs(arguments0Value, arguments1Value)) {
                    return super.squeezeBangZeroArgs(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [zeroArgs] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && SqueezeBangBaseNode.zeroArgs(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    return super.squeezeBangZeroArgs(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SqueezeBangNode create0(StringNodes.SqueezeBangNode current) {
                return new SqueezeBangRubyString0Node((SqueezeBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SqueezeBangUninitializedNode
        extends SqueezeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqueezeBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SqueezeBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SqueezeBangUninitializedNode(SqueezeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SqueezeBangBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SqueezeBangBaseNode rootNode = (SqueezeBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SqueezeBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SqueezeBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SqueezeBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        private static abstract class SqueezeBangBaseNode
        extends StringNodes.SqueezeBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SqueezeBangBaseNode next0;

            SqueezeBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SqueezeBangBaseNode(SqueezeBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SqueezeBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SqueezeBangBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SqueezeBangUninitializedNode(this);
                    ((SqueezeBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SqueezeBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SqueezeBangBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SqueezeBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SqueezeBangUninitializedNode(this), (Node)new SqueezeBangPolymorphicNode(this), (DSLNode)((SqueezeBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SqueezeBangBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    Object[] arguments1ValueCast;
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringNodes.SqueezeBangNode.zeroArgs(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                        return (SqueezeBangBaseNode)SqueezeBangRubyString0Node.create0(this);
                    }
                    return (SqueezeBangBaseNode)SqueezeBangRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SqueezeBangBaseNode otherCast = (SqueezeBangBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SqueezeBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<StringNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(StringNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue, RubyString arguments0ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyString1Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SizeRubyString1Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.size(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue, RubyString arguments0ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.size(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.size(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SizeNode create0(StringNodes.SizeNode current) {
                return new SizeRubyString1Node((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyString0Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SizeRubyString0Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.sizeSingleByte(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue, RubyString arguments0ValueEvaluated) {
                RubyString arguments0Value = arguments0ValueEvaluated;
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.sizeSingleByte(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.sizeSingleByte(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SizeNode create0(StringNodes.SizeNode current) {
                return new SizeRubyString0Node((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue, RubyString arguments0ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyString arguments0Value = arguments0ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends StringNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (SizeBaseNode)SizeRubyString0Node.create0(this);
                    }
                    return (SizeBaseNode)SizeRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetByteNode.class)
    public static final class SetByteNodeFactory
    extends NodeFactoryBase<StringNodes.SetByteNode> {
        private static SetByteNodeFactory setByteNodeFactoryInstance;

        private SetByteNodeFactory() {
            super(StringNodes.SetByteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.SetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return SetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
            return SetByteUninitializedNode.create0(context, sourceSection, string, index, value);
        }

        public static NodeFactory<StringNodes.SetByteNode> getInstance() {
            if (setByteNodeFactoryInstance == null) {
                setByteNodeFactoryInstance = new SetByteNodeFactory();
            }
            return setByteNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetBytePolymorphicNode
        extends SetByteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> valuePolymorphicType;

            SetBytePolymorphicNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object stringValue = this.string.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, indexValue, valueValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.indexPolymorphicType = types[1];
                this.valuePolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                return this.next0.executeChained0(frameValue, stringValue, indexValue, valueValue);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetByteRubyStringIntNode
        extends SetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetByteRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            SetByteRubyStringIntNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int valueValue;
                int indexValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    Object valueValue2 = this.value.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object valueValue3 = this.value.execute(frameValue);
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int");
                }
                try {
                    valueValue = this.value.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
                }
                return super.setByte(stringValue, indexValue, valueValue);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                    return super.setByte(stringValueCast, indexValueCast, valueValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, indexValue, valueValue);
            }

            static StringNodes.SetByteNode create0(StringNodes.SetByteNode current) {
                return new SetByteRubyStringIntNode((SetByteBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetByteUninitializedNode
        extends SetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetByteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetByteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
                super(context, sourceSection, string, index, value);
            }

            SetByteUninitializedNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, indexValue, valueValue);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, indexValue, valueValue);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                SetByteBaseNode newNode = this.specialize0(stringValue, indexValue, valueValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetByteBaseNode rootNode = (SetByteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.index, rootNode.value}, new Object[]{stringValue, indexValue, valueValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetByteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, indexValue, valueValue);
            }

            static StringNodes.SetByteNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
                return new SetByteUninitializedNode(context, sourceSection, string, index, value);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        private static abstract class SetByteBaseNode
        extends StringNodes.SetByteNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode index;
            @Node.Child
            protected RubyNode value;
            @Node.Child
            protected SetByteBaseNode next0;

            SetByteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
                super(context, sourceSection);
                this.string = string;
                this.index = super.coerceIndexToInt(index);
                this.value = super.coerceValueToInt(value);
            }

            SetByteBaseNode(SetByteBaseNode copy) {
                super(copy);
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue, String reason) {
                String message;
                SetByteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetByteBaseNode newNode = this.specialize0(stringValue, indexValue, valueValue);
                if (newNode == null) {
                    newNode = new SetByteUninitializedNode(this);
                    ((SetByteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetByteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetByteBaseNode.createInfo0(reason, stringValue, indexValue, valueValue)))) == null) {
                    returnNode = (SetByteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetByteUninitializedNode(this), (Node)new SetBytePolymorphicNode(this), (DSLNode)((SetByteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, indexValue, valueValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetByteBaseNode specialize0(Object stringValue, Object indexValue, Object valueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                    return (SetByteBaseNode)SetByteRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.index = null;
                    this.value = null;
                } else {
                    SetByteBaseNode otherCast = (SetByteBaseNode)other;
                    this.string = otherCast.string;
                    this.index = otherCast.index;
                    this.value = otherCast.value;
                }
                this.next0 = newNext == null ? null : (SetByteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object indexValue, Object valueValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                    if (indexValue != null) {
                        builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("valueValue").append(" = ").append(valueValue);
                    if (valueValue != null) {
                        builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ScanNode.class)
    public static final class ScanNodeFactory
    extends NodeFactoryBase<StringNodes.ScanNode> {
        private static ScanNodeFactory scanNodeFactoryInstance;

        private ScanNodeFactory() {
            super(StringNodes.ScanNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ScanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ScanNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ScanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ScanUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ScanNode> getInstance() {
            if (scanNodeFactoryInstance == null) {
                scanNodeFactoryInstance = new ScanNodeFactory();
            }
            return scanNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ScanPolymorphicNode
        extends ScanBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ScanPolymorphicNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyStringRubyRegexpRubyProcNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyStringRubyRegexpRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, RubyProc.class}, 0, 0);

            ScanRubyStringRubyRegexpRubyProcNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                return super.scan(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.scan(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current) {
                return new ScanRubyStringRubyRegexpRubyProcNode((ScanBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyArrayRubyRegexpUndefinedPlaceholderNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyArrayRubyRegexpUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, UndefinedPlaceholder.class}, 0, 0);

            ScanRubyArrayRubyRegexpUndefinedPlaceholderNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                return super.scan(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.scan(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current) {
                return new ScanRubyArrayRubyRegexpUndefinedPlaceholderNode((ScanBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyStringRubyStringRubyProcNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyStringRubyStringRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyProc.class}, 0, 0);

            ScanRubyStringRubyStringRubyProcNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                return super.scan(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.scan(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current) {
                return new ScanRubyStringRubyStringRubyProcNode((ScanBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyArrayRubyStringUndefinedPlaceholderNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyArrayRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            ScanRubyArrayRubyStringUndefinedPlaceholderNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                return super.scan(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.scan(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current) {
                return new ScanRubyArrayRubyStringUndefinedPlaceholderNode((ScanBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ScanUninitializedNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ScanUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ScanUninitializedNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ScanBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ScanBaseNode rootNode = (ScanBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ScanBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ScanUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        private static abstract class ScanBaseNode
        extends StringNodes.ScanNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ScanBaseNode next0;

            ScanBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ScanBaseNode(ScanBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                ScanBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ScanBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ScanUninitializedNode(this);
                    ((ScanUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ScanBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ScanBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (ScanBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ScanUninitializedNode(this), (Node)new ScanPolymorphicNode(this), (DSLNode)((ScanBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ScanBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyArrayRubyStringUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyStringRubyStringRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyArrayRubyRegexpUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyStringRubyRegexpRubyProcNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ScanBaseNode otherCast = (ScanBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ScanBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DumpNode.class)
    public static final class DumpNodeFactory
    extends NodeFactoryBase<StringNodes.DumpNode> {
        private static DumpNodeFactory dumpNodeFactoryInstance;

        private DumpNodeFactory() {
            super(StringNodes.DumpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DumpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DumpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DumpUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DumpNode> getInstance() {
            if (dumpNodeFactoryInstance == null) {
                dumpNodeFactoryInstance = new DumpNodeFactory();
            }
            return dumpNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DumpPolymorphicNode
        extends DumpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DumpPolymorphicNode(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DumpRubyString1Node
        extends DumpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DumpRubyString1Node(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!StringGuards.isAsciiCompatible(arguments0Value)) {
                    return super.dump(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isAsciiCompatible] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !StringGuards.isAsciiCompatible(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.dump(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DumpNode create0(StringNodes.DumpNode current) {
                return new DumpRubyString1Node((DumpBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DumpRubyString0Node
        extends DumpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DumpRubyString0Node(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (StringGuards.isAsciiCompatible(arguments0Value)) {
                    return super.dumpAsciiCompatible(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isAsciiCompatible] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && StringGuards.isAsciiCompatible(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.dumpAsciiCompatible(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DumpNode create0(StringNodes.DumpNode current) {
                return new DumpRubyString0Node((DumpBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DumpUninitializedNode
        extends DumpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DumpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DumpUninitializedNode(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DumpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DumpBaseNode rootNode = (DumpBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DumpBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DumpNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DumpUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        private static abstract class DumpBaseNode
        extends StringNodes.DumpNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DumpBaseNode next0;

            DumpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DumpBaseNode(DumpBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DumpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DumpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DumpUninitializedNode(this);
                    ((DumpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DumpBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DumpBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DumpBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DumpUninitializedNode(this), (Node)new DumpPolymorphicNode(this), (DSLNode)((DumpBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DumpBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isAsciiCompatible(arguments0ValueCast)) {
                        return (DumpBaseNode)DumpRubyString0Node.create0(this);
                    }
                    return (DumpBaseNode)DumpRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DumpBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DumpBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
    public static final class SwapcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.SwapcaseBangNode> {
        private static SwapcaseBangNodeFactory swapcaseBangNodeFactoryInstance;

        private SwapcaseBangNodeFactory() {
            super(StringNodes.SwapcaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SwapcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SwapcaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SwapcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SwapcaseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SwapcaseBangNode> getInstance() {
            if (swapcaseBangNodeFactoryInstance == null) {
                swapcaseBangNodeFactoryInstance = new SwapcaseBangNodeFactory();
            }
            return swapcaseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SwapcaseBangPolymorphicNode
        extends SwapcaseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SwapcaseBangPolymorphicNode(SwapcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SwapcaseBangRubyStringNode
        extends SwapcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SwapcaseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SwapcaseBangRubyStringNode(SwapcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.swapcaseSingleByte(arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.swapcaseSingleByte(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SwapcaseBangNode create0(StringNodes.SwapcaseBangNode current) {
                return new SwapcaseBangRubyStringNode((SwapcaseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SwapcaseBangUninitializedNode
        extends SwapcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SwapcaseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SwapcaseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SwapcaseBangUninitializedNode(SwapcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SwapcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SwapcaseBangBaseNode rootNode = (SwapcaseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SwapcaseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SwapcaseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SwapcaseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        private static abstract class SwapcaseBangBaseNode
        extends StringNodes.SwapcaseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SwapcaseBangBaseNode next0;

            SwapcaseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SwapcaseBangBaseNode(SwapcaseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SwapcaseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SwapcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SwapcaseBangUninitializedNode(this);
                    ((SwapcaseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SwapcaseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SwapcaseBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SwapcaseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SwapcaseBangUninitializedNode(this), (Node)new SwapcaseBangPolymorphicNode(this), (DSLNode)((SwapcaseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SwapcaseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SwapcaseBangBaseNode)SwapcaseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SwapcaseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SwapcaseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.RstripBangNode.class)
    public static final class RstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.RstripBangNode> {
        private static RstripBangNodeFactory rstripBangNodeFactoryInstance;

        private RstripBangNodeFactory() {
            super(StringNodes.RstripBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.RstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RstripBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.RstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RstripBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.RstripBangNode> getInstance() {
            if (rstripBangNodeFactoryInstance == null) {
                rstripBangNodeFactoryInstance = new RstripBangNodeFactory();
            }
            return rstripBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RstripBangPolymorphicNode
        extends RstripBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RstripBangPolymorphicNode(RstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RstripBangRubyString1Node
        extends RstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RstripBangRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RstripBangRubyString1Node(RstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.rstripBang(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.rstripBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.RstripBangNode create0(StringNodes.RstripBangNode current) {
                return new RstripBangRubyString1Node((RstripBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RstripBangRubyString0Node
        extends RstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RstripBangRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RstripBangRubyString0Node(RstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.rstripBangSingleByte(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.rstripBangSingleByte(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.RstripBangNode create0(StringNodes.RstripBangNode current) {
                return new RstripBangRubyString0Node((RstripBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RstripBangUninitializedNode
        extends RstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RstripBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RstripBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RstripBangUninitializedNode(RstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RstripBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RstripBangBaseNode rootNode = (RstripBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RstripBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.RstripBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RstripBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        private static abstract class RstripBangBaseNode
        extends StringNodes.RstripBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RstripBangBaseNode next0;

            RstripBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RstripBangBaseNode(RstripBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RstripBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RstripBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RstripBangUninitializedNode(this);
                    ((RstripBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RstripBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RstripBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RstripBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RstripBangUninitializedNode(this), (Node)new RstripBangPolymorphicNode(this), (DSLNode)((RstripBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RstripBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (RstripBangBaseNode)RstripBangRubyString0Node.create0(this);
                    }
                    return (RstripBangBaseNode)RstripBangRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RstripBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RstripBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<StringNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(StringNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.ReplaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReplaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ReplaceNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return ReplaceUninitializedNode.create0(context, sourceSection, string, other);
        }

        public static NodeFactory<StringNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReplacePolymorphicNode
        extends ReplaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            ReplacePolymorphicNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyStringNode
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ReplaceRubyStringNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    otherValue = this.other.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyString");
                }
                return super.replace(stringValue, otherValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    RubyString otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue);
                    return super.replace(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ReplaceNode create0(StringNodes.ReplaceNode current) {
                return new ReplaceRubyStringNode((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReplaceUninitializedNode
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReplaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection, string, other);
            }

            ReplaceUninitializedNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                ReplaceBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReplaceBaseNode rootNode = (ReplaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.other}, new Object[]{stringValue, otherValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReplaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ReplaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                return new ReplaceUninitializedNode(context, sourceSection, string, other);
            }
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        private static abstract class ReplaceBaseNode
        extends StringNodes.ReplaceNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode other;
            @Node.Child
            protected ReplaceBaseNode next0;

            ReplaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string = string;
                this.other = super.coerceOtherToString(other);
            }

            ReplaceBaseNode(ReplaceBaseNode copy) {
                super(copy);
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object stringValue, Object otherValue, String reason) {
                String message;
                ReplaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReplaceBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    newNode = new ReplaceUninitializedNode(this);
                    ((ReplaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReplaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ReplaceBaseNode.createInfo0(reason, stringValue, otherValue)))) == null) {
                    returnNode = (ReplaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReplaceUninitializedNode(this), (Node)new ReplacePolymorphicNode(this), (DSLNode)((ReplaceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, otherValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReplaceBaseNode specialize0(Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    return (ReplaceBaseNode)ReplaceRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.other = null;
                } else {
                    ReplaceBaseNode otherCast = (ReplaceBaseNode)other;
                    this.string = otherCast.string;
                    this.other = otherCast.other;
                }
                this.next0 = newNext == null ? null : (ReplaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object otherValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                    if (otherValue != null) {
                        builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.OrdNode.class)
    public static final class OrdNodeFactory
    extends NodeFactoryBase<StringNodes.OrdNode> {
        private static OrdNodeFactory ordNodeFactoryInstance;

        private OrdNodeFactory() {
            super(StringNodes.OrdNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.OrdNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OrdNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.OrdNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OrdUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.OrdNode> getInstance() {
            if (ordNodeFactoryInstance == null) {
                ordNodeFactoryInstance = new OrdNodeFactory();
            }
            return ordNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OrdPolymorphicNode
        extends OrdBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            OrdPolymorphicNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OrdRubyStringNode
        extends OrdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrdRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            OrdRubyStringNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.ord(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.ord(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.OrdNode create0(StringNodes.OrdNode current) {
                return new OrdRubyStringNode((OrdBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OrdUninitializedNode
        extends OrdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrdUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OrdUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OrdUninitializedNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                OrdBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OrdBaseNode rootNode = (OrdBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((OrdBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.OrdNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OrdUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        private static abstract class OrdBaseNode
        extends StringNodes.OrdNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OrdBaseNode next0;

            OrdBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OrdBaseNode(OrdBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                OrdBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OrdBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new OrdUninitializedNode(this);
                    ((OrdUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (OrdBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = OrdBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (OrdBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new OrdUninitializedNode(this), (Node)new OrdPolymorphicNode(this), (DSLNode)((OrdBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OrdBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (OrdBaseNode)OrdRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OrdBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (OrdBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
    public static final class SetNumBytesNodeFactory
    extends NodeFactoryBase<StringNodes.SetNumBytesNode> {
        private static SetNumBytesNodeFactory setNumBytesNodeFactoryInstance;

        private SetNumBytesNodeFactory() {
            super(StringNodes.SetNumBytesNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SetNumBytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetNumBytesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SetNumBytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetNumBytesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SetNumBytesNode> getInstance() {
            if (setNumBytesNodeFactoryInstance == null) {
                setNumBytesNodeFactoryInstance = new SetNumBytesNodeFactory();
            }
            return setNumBytesNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetNumBytesPolymorphicNode
        extends SetNumBytesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SetNumBytesPolymorphicNode(SetNumBytesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetNumBytesRubyStringNode
        extends SetNumBytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetNumBytesRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            SetNumBytesRubyStringNode(SetNumBytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.setNumBytes(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.setNumBytes(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SetNumBytesNode create0(StringNodes.SetNumBytesNode current) {
                return new SetNumBytesRubyStringNode((SetNumBytesBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetNumBytesUninitializedNode
        extends SetNumBytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetNumBytesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetNumBytesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetNumBytesUninitializedNode(SetNumBytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SetNumBytesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetNumBytesBaseNode rootNode = (SetNumBytesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetNumBytesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SetNumBytesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetNumBytesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        private static abstract class SetNumBytesBaseNode
        extends StringNodes.SetNumBytesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetNumBytesBaseNode next0;

            SetNumBytesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetNumBytesBaseNode(SetNumBytesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SetNumBytesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetNumBytesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SetNumBytesUninitializedNode(this);
                    ((SetNumBytesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetNumBytesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetNumBytesBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SetNumBytesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetNumBytesUninitializedNode(this), (Node)new SetNumBytesPolymorphicNode(this), (DSLNode)((SetNumBytesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetNumBytesBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (SetNumBytesBaseNode)SetNumBytesRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SetNumBytesBaseNode otherCast = (SetNumBytesBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SetNumBytesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ModifyBangNode.class)
    public static final class ModifyBangNodeFactory
    extends NodeFactoryBase<StringNodes.ModifyBangNode> {
        private static ModifyBangNodeFactory modifyBangNodeFactoryInstance;

        private ModifyBangNodeFactory() {
            super(StringNodes.ModifyBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ModifyBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModifyBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ModifyBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModifyBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ModifyBangNode> getInstance() {
            if (modifyBangNodeFactoryInstance == null) {
                modifyBangNodeFactoryInstance = new ModifyBangNodeFactory();
            }
            return modifyBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModifyBangPolymorphicNode
        extends ModifyBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ModifyBangPolymorphicNode(ModifyBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModifyBangRubyStringNode
        extends ModifyBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModifyBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ModifyBangRubyStringNode(ModifyBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.modifyBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.modifyBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ModifyBangNode create0(StringNodes.ModifyBangNode current) {
                return new ModifyBangRubyStringNode((ModifyBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModifyBangUninitializedNode
        extends ModifyBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModifyBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModifyBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModifyBangUninitializedNode(ModifyBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ModifyBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModifyBangBaseNode rootNode = (ModifyBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ModifyBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ModifyBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModifyBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        private static abstract class ModifyBangBaseNode
        extends StringNodes.ModifyBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModifyBangBaseNode next0;

            ModifyBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModifyBangBaseNode(ModifyBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ModifyBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModifyBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ModifyBangUninitializedNode(this);
                    ((ModifyBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ModifyBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ModifyBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ModifyBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ModifyBangUninitializedNode(this), (Node)new ModifyBangPolymorphicNode(this), (DSLNode)((ModifyBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModifyBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ModifyBangBaseNode)ModifyBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ModifyBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ModifyBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MatchNode.class)
    public static final class MatchNodeFactory
    extends NodeFactoryBase<StringNodes.MatchNode> {
        private static MatchNodeFactory matchNodeFactoryInstance;

        private MatchNodeFactory() {
            super(StringNodes.MatchNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MatchUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MatchNode> getInstance() {
            if (matchNodeFactoryInstance == null) {
                matchNodeFactoryInstance = new MatchNodeFactory();
            }
            return matchNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MatchPolymorphicNode
        extends MatchBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MatchPolymorphicNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchRubyStringRubyRegexpNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchRubyStringRubyRegexpNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class}, 0, 0);

            MatchRubyStringRubyRegexpNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyRegexp");
                }
                return super.match(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.match(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(StringNodes.MatchNode current) {
                return new MatchRubyStringRubyRegexpNode((MatchBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchRubyStringNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            MatchRubyStringNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.match(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.match(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(StringNodes.MatchNode current) {
                return new MatchRubyStringNode((MatchBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MatchUninitializedNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MatchUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MatchUninitializedNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MatchBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MatchBaseNode rootNode = (MatchBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MatchBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MatchUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        private static abstract class MatchBaseNode
        extends StringNodes.MatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MatchBaseNode next0;

            MatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MatchBaseNode(MatchBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MatchBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MatchBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MatchUninitializedNode(this);
                    ((MatchUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MatchBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MatchBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MatchBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MatchUninitializedNode(this), (Node)new MatchPolymorphicNode(this), (DSLNode)((MatchBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MatchBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (MatchBaseNode)MatchRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        return (MatchBaseNode)MatchRubyStringRubyRegexpNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MatchBaseNode otherCast = (MatchBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MatchBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.LstripBangNode.class)
    public static final class LstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.LstripBangNode> {
        private static LstripBangNodeFactory lstripBangNodeFactoryInstance;

        private LstripBangNodeFactory() {
            super(StringNodes.LstripBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.LstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LstripBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.LstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LstripBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.LstripBangNode> getInstance() {
            if (lstripBangNodeFactoryInstance == null) {
                lstripBangNodeFactoryInstance = new LstripBangNodeFactory();
            }
            return lstripBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LstripBangPolymorphicNode
        extends LstripBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LstripBangPolymorphicNode(LstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LstripBangRubyString1Node
        extends LstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LstripBangRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            LstripBangRubyString1Node(LstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.lstripBang(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.lstripBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.LstripBangNode create0(StringNodes.LstripBangNode current) {
                return new LstripBangRubyString1Node((LstripBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LstripBangRubyString0Node
        extends LstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LstripBangRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            LstripBangRubyString0Node(LstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                    return super.lstripBangSingleByte(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyString arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value))) {
                    return super.lstripBangSingleByte(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.LstripBangNode create0(StringNodes.LstripBangNode current) {
                return new LstripBangRubyString0Node((LstripBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LstripBangUninitializedNode
        extends LstripBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LstripBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LstripBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LstripBangUninitializedNode(LstripBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LstripBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LstripBangBaseNode rootNode = (LstripBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LstripBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.LstripBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LstripBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        private static abstract class LstripBangBaseNode
        extends StringNodes.LstripBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LstripBangBaseNode next0;

            LstripBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LstripBangBaseNode(LstripBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                LstripBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LstripBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LstripBangUninitializedNode(this);
                    ((LstripBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LstripBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LstripBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (LstripBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LstripBangUninitializedNode(this), (Node)new LstripBangPolymorphicNode(this), (DSLNode)((LstripBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LstripBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isSingleByteOptimizable(arguments0ValueCast)) {
                        return (LstripBangBaseNode)LstripBangRubyString0Node.create0(this);
                    }
                    return (LstripBangBaseNode)LstripBangRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LstripBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LstripBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<StringNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(StringNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
            return InsertUninitializedNode.create0(context, sourceSection, string, index, otherString);
        }

        public static NodeFactory<StringNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InsertPolymorphicNode
        extends InsertBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherStringPolymorphicType;

            InsertPolymorphicNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object stringValue = this.string.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                Object otherStringValue = this.otherString.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, indexValue, otherStringValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.indexPolymorphicType = types[1];
                this.otherStringPolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                return this.next0.executeChained0(frameValue, stringValue, indexValue, otherStringValue);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyStringNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, RubyString.class}, 0, 0);

            InsertRubyStringNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString otherStringValue;
                int indexValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    Object otherStringValue2 = this.otherString.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, otherStringValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherStringValue3 = this.otherString.execute(frameValue);
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), otherStringValue3, "Expected indexValue instanceof int");
                }
                try {
                    otherStringValue = this.otherString.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, indexValue, ex.getResult(), "Expected otherStringValue instanceof RubyString");
                }
                return super.insert(frameValue, stringValue, indexValue, otherStringValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherStringValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    RubyString otherStringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherStringValue);
                    return super.insert(frameValue, stringValueCast, indexValueCast, otherStringValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, indexValue, otherStringValue);
            }

            static StringNodes.InsertNode create0(StringNodes.InsertNode current) {
                return new InsertRubyStringNode((InsertBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InsertUninitializedNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InsertUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
                super(context, sourceSection, string, index, otherString);
            }

            InsertUninitializedNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                Object otherStringValue = this.otherString.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, indexValue, otherStringValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, indexValue, otherStringValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                InsertBaseNode newNode = this.specialize0(stringValue, indexValue, otherStringValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InsertBaseNode rootNode = (InsertBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.index, rootNode.otherString}, new Object[]{stringValue, indexValue, otherStringValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InsertBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, indexValue, otherStringValue);
            }

            static StringNodes.InsertNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
                return new InsertUninitializedNode(context, sourceSection, string, index, otherString);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        private static abstract class InsertBaseNode
        extends StringNodes.InsertNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode index;
            @Node.Child
            protected RubyNode otherString;
            @Node.Child
            protected InsertBaseNode next0;

            InsertBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
                super(context, sourceSection);
                this.string = string;
                this.index = super.coerceIndexToInt(index);
                this.otherString = super.coerceOtherToString(otherString);
            }

            InsertBaseNode(InsertBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue, String reason) {
                String message;
                InsertBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InsertBaseNode newNode = this.specialize0(stringValue, indexValue, otherStringValue);
                if (newNode == null) {
                    newNode = new InsertUninitializedNode(this);
                    ((InsertUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InsertBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InsertBaseNode.createInfo0(reason, stringValue, indexValue, otherStringValue)))) == null) {
                    returnNode = (InsertBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InsertUninitializedNode(this), (Node)new InsertPolymorphicNode(this), (DSLNode)((InsertBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, indexValue, otherStringValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InsertBaseNode specialize0(Object stringValue, Object indexValue, Object otherStringValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherStringValue)) {
                    return (InsertBaseNode)InsertRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.index = null;
                    this.otherString = null;
                } else {
                    InsertBaseNode otherCast = (InsertBaseNode)other;
                    this.string = otherCast.string;
                    this.index = otherCast.index;
                    this.otherString = otherCast.otherString;
                }
                this.next0 = newNext == null ? null : (InsertBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object indexValue, Object otherStringValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                    if (indexValue != null) {
                        builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherStringValue").append(" = ").append(otherStringValue);
                    if (otherStringValue != null) {
                        builder.append(" (").append(otherStringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(StringNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyStringNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            InitializeCopyRubyStringNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeCopyNode create0(StringNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyStringNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends StringNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(StringNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyStringObjectNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            InitializeRubyStringObjectNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.initialize(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyString(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(StringNodes.InitializeNode current) {
                return new InitializeRubyStringObjectNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyStringNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            InitializeRubyStringNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(StringNodes.InitializeNode current) {
                return new InitializeRubyStringNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyStringUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyStringUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(StringNodes.InitializeNode current) {
                return new InitializeRubyStringUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends StringNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyStringNode.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<StringNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(StringNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyStringNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            InspectRubyStringNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.inspect(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.inspect(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.InspectNode create0(StringNodes.InspectNode current) {
                return new InspectRubyStringNode((InspectBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends StringNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InspectBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (InspectBaseNode)InspectRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<StringNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(StringNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HashPolymorphicNode
        extends HashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            HashPolymorphicNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashRubyStringNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            HashRubyStringNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.HashNode create0(StringNodes.HashNode current) {
                return new HashRubyStringNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HashUninitializedNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HashUninitializedNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    HashBaseNode rootNode = (HashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((HashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.HashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        private static abstract class HashBaseNode
        extends StringNodes.HashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HashBaseNode next0;

            HashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HashBaseNode(HashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                HashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new HashUninitializedNode(this);
                    ((HashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (HashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = HashBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (HashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new HashUninitializedNode(this), (Node)new HashPolymorphicNode(this), (DSLNode)((HashBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (HashBaseNode)HashRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((HashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (HashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetByteNode.class)
    public static final class GetByteNodeFactory
    extends NodeFactoryBase<StringNodes.GetByteNode> {
        private static GetByteNodeFactory getByteNodeFactoryInstance;

        private GetByteNodeFactory() {
            super(StringNodes.GetByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.GetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetByteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.GetByteNode> getInstance() {
            if (getByteNodeFactoryInstance == null) {
                getByteNodeFactoryInstance = new GetByteNodeFactory();
            }
            return getByteNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetBytePolymorphicNode
        extends GetByteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetBytePolymorphicNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetByteRubyStringNode
        extends GetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetByteRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            GetByteRubyStringNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.getByte(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.getByte(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.GetByteNode create0(StringNodes.GetByteNode current) {
                return new GetByteRubyStringNode((GetByteBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetByteUninitializedNode
        extends GetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetByteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetByteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetByteUninitializedNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetByteBaseNode rootNode = (GetByteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetByteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.GetByteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetByteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        private static abstract class GetByteBaseNode
        extends StringNodes.GetByteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetByteBaseNode next0;

            GetByteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetByteBaseNode(GetByteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetByteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetByteUninitializedNode(this);
                    ((GetByteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetByteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetByteBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetByteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetByteUninitializedNode(this), (Node)new GetBytePolymorphicNode(this), (DSLNode)((GetByteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetByteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (GetByteBaseNode)GetByteRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetByteBaseNode otherCast = (GetByteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetByteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
    public static final class ForceEncodingNodeFactory
    extends NodeFactoryBase<StringNodes.ForceEncodingNode> {
        private static ForceEncodingNodeFactory forceEncodingNodeFactoryInstance;

        private ForceEncodingNodeFactory() {
            super(StringNodes.ForceEncodingNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ForceEncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForceEncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ForceEncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ForceEncodingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ForceEncodingNode> getInstance() {
            if (forceEncodingNodeFactoryInstance == null) {
                forceEncodingNodeFactoryInstance = new ForceEncodingNodeFactory();
            }
            return forceEncodingNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ForceEncodingPolymorphicNode
        extends ForceEncodingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ForceEncodingPolymorphicNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubyEncoding.class ? this.arguments[1].executeRubyEncoding(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForceEncodingRubyStringObjectNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            ForceEncodingRubyStringObjectNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value) && !super.isRubyEncoding(arguments1Value)) {
                    return super.forceEncoding(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString, !isRubyEncoding] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyString(arguments1Value) && !super.isRubyEncoding(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.forceEncoding(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(StringNodes.ForceEncodingNode current) {
                return new ForceEncodingRubyStringObjectNode((ForceEncodingBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForceEncodingRubyStringRubyEncodingNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingRubyStringRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyEncoding.class}, 0, 0);

            ForceEncodingRubyStringRubyEncodingNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                return super.forceEncoding(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    return super.forceEncoding(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(StringNodes.ForceEncodingNode current) {
                return new ForceEncodingRubyStringRubyEncodingNode((ForceEncodingBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForceEncodingRubyStringNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ForceEncodingRubyStringNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.forceEncoding(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.forceEncoding(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(StringNodes.ForceEncodingNode current) {
                return new ForceEncodingRubyStringNode((ForceEncodingBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ForceEncodingUninitializedNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ForceEncodingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ForceEncodingUninitializedNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ForceEncodingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ForceEncodingBaseNode rootNode = (ForceEncodingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ForceEncodingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ForceEncodingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        private static abstract class ForceEncodingBaseNode
        extends StringNodes.ForceEncodingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ForceEncodingBaseNode next0;

            ForceEncodingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ForceEncodingBaseNode(ForceEncodingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ForceEncodingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ForceEncodingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ForceEncodingUninitializedNode(this);
                    ((ForceEncodingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ForceEncodingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ForceEncodingBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ForceEncodingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ForceEncodingUninitializedNode(this), (Node)new ForceEncodingPolymorphicNode(this), (DSLNode)((ForceEncodingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ForceEncodingBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ForceEncodingBaseNode)ForceEncodingRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                        return (ForceEncodingBaseNode)ForceEncodingRubyStringRubyEncodingNode.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value) && !super.isRubyEncoding(arguments1Value)) {
                        return (ForceEncodingBaseNode)ForceEncodingRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ForceEncodingBaseNode otherCast = (ForceEncodingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ForceEncodingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<StringNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(StringNodes.EncodingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EncodingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EncodingPolymorphicNode
        extends EncodingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EncodingPolymorphicNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EncodingRubyStringNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            EncodingRubyStringNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.encoding(arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.encoding(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EncodingNode create0(StringNodes.EncodingNode current) {
                return new EncodingRubyStringNode((EncodingBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EncodingUninitializedNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EncodingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EncodingUninitializedNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value;
                try {
                    value = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyEncoding executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EncodingBaseNode rootNode = (EncodingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EncodingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EncodingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EncodingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        private static abstract class EncodingBaseNode
        extends StringNodes.EncodingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EncodingBaseNode next0;

            EncodingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EncodingBaseNode(EncodingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyEncoding executeChained0(VirtualFrame var1, Object var2);

            protected final RubyEncoding rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EncodingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EncodingUninitializedNode(this);
                    ((EncodingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EncodingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EncodingBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EncodingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EncodingUninitializedNode(this), (Node)new EncodingPolymorphicNode(this), (DSLNode)((EncodingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EncodingBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (EncodingBaseNode)EncodingRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EncodingBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EncodingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<StringNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(StringNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyStringNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            EmptyRubyStringNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.empty(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.empty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EmptyNode create0(StringNodes.EmptyNode current) {
                return new EmptyRubyStringNode((EmptyBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends StringNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EmptyBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (EmptyBaseNode)EmptyRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachCharNode.class)
    public static final class EachCharNodeFactory
    extends NodeFactoryBase<StringNodes.EachCharNode> {
        private static EachCharNodeFactory eachCharNodeFactoryInstance;

        private EachCharNodeFactory() {
            super(StringNodes.EachCharNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EachCharNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachCharNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EachCharNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachCharUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EachCharNode> getInstance() {
            if (eachCharNodeFactoryInstance == null) {
                eachCharNodeFactoryInstance = new EachCharNodeFactory();
            }
            return eachCharNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachCharPolymorphicNode
        extends EachCharBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachCharPolymorphicNode(EachCharBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachCharRubyString1Node
        extends EachCharBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachCharRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyProc.class}, 0, 0);

            EachCharRubyString1Node(EachCharBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (!StringGuards.isValidOr7BitEncoding(arguments0Value)) {
                    return super.eachCharMultiByteEncoding(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isValidOr7BitEncoding] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (!StringGuards.isValidOr7BitEncoding(arguments0ValueCast)) {
                        return super.eachCharMultiByteEncoding(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EachCharNode create0(StringNodes.EachCharNode current) {
                return new EachCharRubyString1Node((EachCharBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachCharRubyString0Node
        extends EachCharBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachCharRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyProc.class}, 0, 0);

            EachCharRubyString0Node(EachCharBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (StringGuards.isValidOr7BitEncoding(arguments0Value)) {
                    return super.eachChar(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isValidOr7BitEncoding] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (StringGuards.isValidOr7BitEncoding(arguments0ValueCast)) {
                        return super.eachChar(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EachCharNode create0(StringNodes.EachCharNode current) {
                return new EachCharRubyString0Node((EachCharBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachCharUninitializedNode
        extends EachCharBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachCharUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachCharUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachCharUninitializedNode(EachCharBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachCharBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachCharBaseNode rootNode = (EachCharBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachCharBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EachCharNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachCharUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        private static abstract class EachCharBaseNode
        extends StringNodes.EachCharNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachCharBaseNode next0;

            EachCharBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachCharBaseNode(EachCharBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachCharBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachCharBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachCharUninitializedNode(this);
                    ((EachCharUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachCharBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachCharBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachCharBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachCharUninitializedNode(this), (Node)new EachCharPolymorphicNode(this), (DSLNode)((EachCharBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachCharBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    if (StringGuards.isValidOr7BitEncoding(arguments0ValueCast)) {
                        return (EachCharBaseNode)EachCharRubyString0Node.create0(this);
                    }
                    return (EachCharBaseNode)EachCharRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachCharBaseNode otherCast = (EachCharBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachCharBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachByteNode.class)
    public static final class EachByteNodeFactory
    extends NodeFactoryBase<StringNodes.EachByteNode> {
        private static EachByteNodeFactory eachByteNodeFactoryInstance;

        private EachByteNodeFactory() {
            super(StringNodes.EachByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EachByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EachByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachByteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EachByteNode> getInstance() {
            if (eachByteNodeFactoryInstance == null) {
                eachByteNodeFactoryInstance = new EachByteNodeFactory();
            }
            return eachByteNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachBytePolymorphicNode
        extends EachByteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachBytePolymorphicNode(EachByteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachByteRubyStringNode
        extends EachByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachByteRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyProc.class}, 0, 0);

            EachByteRubyStringNode(EachByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.eachByte(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.eachByte(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EachByteNode create0(StringNodes.EachByteNode current) {
                return new EachByteRubyStringNode((EachByteBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachByteUninitializedNode
        extends EachByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachByteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachByteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachByteUninitializedNode(EachByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachByteBaseNode rootNode = (EachByteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachByteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EachByteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachByteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        private static abstract class EachByteBaseNode
        extends StringNodes.EachByteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachByteBaseNode next0;

            EachByteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachByteBaseNode(EachByteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachByteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachByteUninitializedNode(this);
                    ((EachByteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachByteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachByteBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachByteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachByteUninitializedNode(this), (Node)new EachBytePolymorphicNode(this), (DSLNode)((EachByteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachByteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (EachByteBaseNode)EachByteRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachByteBaseNode otherCast = (EachByteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachByteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
    public static final class DowncaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseBangNode> {
        private static DowncaseBangNodeFactory downcaseBangNodeFactoryInstance;

        private DowncaseBangNodeFactory() {
            super(StringNodes.DowncaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DowncaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DowncaseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DowncaseBangNode> getInstance() {
            if (downcaseBangNodeFactoryInstance == null) {
                downcaseBangNodeFactoryInstance = new DowncaseBangNodeFactory();
            }
            return downcaseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DowncaseBangPolymorphicNode
        extends DowncaseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DowncaseBangPolymorphicNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DowncaseBangRubyStringNode
        extends DowncaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DowncaseBangRubyStringNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.downcase(arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.downcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseBangNode create0(StringNodes.DowncaseBangNode current) {
                return new DowncaseBangRubyStringNode((DowncaseBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DowncaseBangUninitializedNode
        extends DowncaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DowncaseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DowncaseBangUninitializedNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DowncaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DowncaseBangBaseNode rootNode = (DowncaseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DowncaseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DowncaseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        private static abstract class DowncaseBangBaseNode
        extends StringNodes.DowncaseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DowncaseBangBaseNode next0;

            DowncaseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DowncaseBangBaseNode(DowncaseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DowncaseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DowncaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DowncaseBangUninitializedNode(this);
                    ((DowncaseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DowncaseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DowncaseBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DowncaseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DowncaseBangUninitializedNode(this), (Node)new DowncaseBangPolymorphicNode(this), (DSLNode)((DowncaseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DowncaseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DowncaseBangBaseNode)DowncaseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DowncaseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DowncaseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseNode.class)
    public static final class DowncaseNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseNode> {
        private static DowncaseNodeFactory downcaseNodeFactoryInstance;

        private DowncaseNodeFactory() {
            super(StringNodes.DowncaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DowncaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DowncaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DowncaseNode> getInstance() {
            if (downcaseNodeFactoryInstance == null) {
                downcaseNodeFactoryInstance = new DowncaseNodeFactory();
            }
            return downcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DowncasePolymorphicNode
        extends DowncaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DowncasePolymorphicNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DowncaseRubyStringNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DowncaseRubyStringNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.downcase(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.downcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseNode create0(StringNodes.DowncaseNode current) {
                return new DowncaseRubyStringNode((DowncaseBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DowncaseUninitializedNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DowncaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DowncaseUninitializedNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DowncaseBaseNode rootNode = (DowncaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DowncaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DowncaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        private static abstract class DowncaseBaseNode
        extends StringNodes.DowncaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DowncaseBaseNode next0;

            DowncaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DowncaseBaseNode(DowncaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DowncaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DowncaseUninitializedNode(this);
                    ((DowncaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DowncaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DowncaseBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DowncaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DowncaseUninitializedNode(this), (Node)new DowncasePolymorphicNode(this), (DSLNode)((DowncaseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DowncaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DowncaseBaseNode)DowncaseRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DowncaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DowncaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DeleteBangNode.class)
    public static final class DeleteBangNodeFactory
    extends NodeFactoryBase<StringNodes.DeleteBangNode> {
        private static DeleteBangNodeFactory deleteBangNodeFactoryInstance;

        private DeleteBangNodeFactory() {
            super(StringNodes.DeleteBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DeleteBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DeleteBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DeleteBangNode> getInstance() {
            if (deleteBangNodeFactoryInstance == null) {
                deleteBangNodeFactoryInstance = new DeleteBangNodeFactory();
            }
            return deleteBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeleteBangPolymorphicNode
        extends DeleteBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeleteBangPolymorphicNode(DeleteBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteBangRubyStringNode
        extends DeleteBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            DeleteBangRubyStringNode(DeleteBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.deleteBang(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.deleteBang(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.DeleteBangNode create0(StringNodes.DeleteBangNode current) {
                return new DeleteBangRubyStringNode((DeleteBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteBangUninitializedNode
        extends DeleteBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteBangUninitializedNode(DeleteBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteBangBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBangBaseNode rootNode = (DeleteBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.DeleteBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        private static abstract class DeleteBangBaseNode
        extends StringNodes.DeleteBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBangBaseNode next0;

            DeleteBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBangBaseNode(DeleteBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DeleteBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBangBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteBangUninitializedNode(this);
                    ((DeleteBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DeleteBangBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteBangUninitializedNode(this), (Node)new DeleteBangPolymorphicNode(this), (DSLNode)((DeleteBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBangBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (DeleteBangBaseNode)DeleteBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteBangBaseNode otherCast = (DeleteBangBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DataNode.class)
    public static final class DataNodeFactory
    extends NodeFactoryBase<StringNodes.DataNode> {
        private static DataNodeFactory dataNodeFactoryInstance;

        private DataNodeFactory() {
            super(StringNodes.DataNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DataNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DataNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DataNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DataUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DataNode> getInstance() {
            if (dataNodeFactoryInstance == null) {
                dataNodeFactoryInstance = new DataNodeFactory();
            }
            return dataNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DataNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DataPolymorphicNode
        extends DataBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DataPolymorphicNode(DataBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubiniusByteArray value;
                try {
                    value = this.executeRubiniusByteArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubiniusByteArray executeRubiniusByteArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubiniusByteArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DataNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DataRubyStringNode
        extends DataBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DataRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DataRubyStringNode(DataBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubiniusByteArray value;
                try {
                    value = this.executeRubiniusByteArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubiniusByteArray executeRubiniusByteArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.data(arguments0Value);
            }

            @Override
            protected RubiniusByteArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.data(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DataNode create0(StringNodes.DataNode current) {
                return new DataRubyStringNode((DataBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.DataNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DataUninitializedNode
        extends DataBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DataUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DataUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DataUninitializedNode(DataBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubiniusByteArray value;
                try {
                    value = this.executeRubiniusByteArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubiniusByteArray executeRubiniusByteArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubiniusByteArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubiniusByteArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DataBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DataBaseNode rootNode = (DataBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DataBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DataNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DataUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DataNode.class)
        private static abstract class DataBaseNode
        extends StringNodes.DataNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DataBaseNode next0;

            DataBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DataBaseNode(DataBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubiniusByteArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubiniusByteArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DataBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DataBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DataUninitializedNode(this);
                    ((DataUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DataBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DataBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DataBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DataUninitializedNode(this), (Node)new DataPolymorphicNode(this), (DSLNode)((DataBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DataBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DataBaseNode)DataRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DataBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DataBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CryptNode.class)
    public static final class CryptNodeFactory
    extends NodeFactoryBase<StringNodes.CryptNode> {
        private static CryptNodeFactory cryptNodeFactoryInstance;

        private CryptNodeFactory() {
            super(StringNodes.CryptNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.CryptNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return CryptNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CryptNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
            return CryptUninitializedNode.create0(context, sourceSection, string, salt);
        }

        public static NodeFactory<StringNodes.CryptNode> getInstance() {
            if (cryptNodeFactoryInstance == null) {
                cryptNodeFactoryInstance = new CryptNodeFactory();
            }
            return cryptNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CryptPolymorphicNode
        extends CryptBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> saltPolymorphicType;

            CryptPolymorphicNode(CryptBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object stringValue = this.string.execute(frameValue);
                Object saltValue = this.salt.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, saltValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.saltPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object saltValue) {
                return this.next0.executeChained0(frameValue, stringValue, saltValue);
            }
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CryptRubyStringNode
        extends CryptBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CryptRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CryptRubyStringNode(CryptBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString saltValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object saltValue2 = this.salt.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), saltValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    saltValue = this.salt.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected saltValue instanceof RubyString");
                }
                return super.crypt(stringValue, saltValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object saltValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(saltValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    RubyString saltValueCast = RubyTypesGen.RUBYTYPES.asRubyString(saltValue);
                    return super.crypt(stringValueCast, saltValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, saltValue);
            }

            static StringNodes.CryptNode create0(StringNodes.CryptNode current) {
                return new CryptRubyStringNode((CryptBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CryptUninitializedNode
        extends CryptBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CryptUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CryptUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
                super(context, sourceSection, string, salt);
            }

            CryptUninitializedNode(CryptBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object saltValue = this.salt.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, saltValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object saltValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, saltValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object saltValue) {
                CryptBaseNode newNode = this.specialize0(stringValue, saltValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CryptBaseNode rootNode = (CryptBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.salt}, new Object[]{stringValue, saltValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CryptBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, saltValue);
            }

            static StringNodes.CryptNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
                return new CryptUninitializedNode(context, sourceSection, string, salt);
            }
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        private static abstract class CryptBaseNode
        extends StringNodes.CryptNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode salt;
            @Node.Child
            protected CryptBaseNode next0;

            CryptBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
                super(context, sourceSection);
                this.string = string;
                this.salt = super.coerceSaltToString(salt);
            }

            CryptBaseNode(CryptBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object stringValue, Object saltValue, String reason) {
                String message;
                CryptBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CryptBaseNode newNode = this.specialize0(stringValue, saltValue);
                if (newNode == null) {
                    newNode = new CryptUninitializedNode(this);
                    ((CryptUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CryptBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CryptBaseNode.createInfo0(reason, stringValue, saltValue)))) == null) {
                    returnNode = (CryptBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CryptUninitializedNode(this), (Node)new CryptPolymorphicNode(this), (DSLNode)((CryptBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, saltValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CryptBaseNode specialize0(Object stringValue, Object saltValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(saltValue)) {
                    return (CryptBaseNode)CryptRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.salt = null;
                } else {
                    CryptBaseNode otherCast = (CryptBaseNode)other;
                    this.string = otherCast.string;
                    this.salt = otherCast.salt;
                }
                this.next0 = newNext == null ? null : (CryptBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object saltValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("saltValue").append(" = ").append(saltValue);
                    if (saltValue != null) {
                        builder.append(" (").append(saltValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CountNode.class)
    public static final class CountNodeFactory
    extends NodeFactoryBase<StringNodes.CountNode> {
        private static CountNodeFactory countNodeFactoryInstance;

        private CountNodeFactory() {
            super(StringNodes.CountNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CountNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CountUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CountNode> getInstance() {
            if (countNodeFactoryInstance == null) {
                countNodeFactoryInstance = new CountNodeFactory();
            }
            return countNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CountPolymorphicNode
        extends CountBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CountPolymorphicNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CountRubyStringNode
        extends CountBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CountRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            CountRubyStringNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.count(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.count(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CountNode create0(StringNodes.CountNode current) {
                return new CountRubyStringNode((CountBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CountUninitializedNode
        extends CountBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CountUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CountUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CountUninitializedNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CountBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CountBaseNode rootNode = (CountBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CountBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CountNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CountUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        private static abstract class CountBaseNode
        extends StringNodes.CountNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CountBaseNode next0;

            CountBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CountBaseNode(CountBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CountBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CountBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CountUninitializedNode(this);
                    ((CountUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CountBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CountBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CountBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CountUninitializedNode(this), (Node)new CountPolymorphicNode(this), (DSLNode)((CountBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CountBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (CountBaseNode)CountRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CountBaseNode otherCast = (CountBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CountBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ChopBangNode.class)
    public static final class ChopBangNodeFactory
    extends NodeFactoryBase<StringNodes.ChopBangNode> {
        private static ChopBangNodeFactory chopBangNodeFactoryInstance;

        private ChopBangNodeFactory() {
            super(StringNodes.ChopBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ChopBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChopBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ChopBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChopBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ChopBangNode> getInstance() {
            if (chopBangNodeFactoryInstance == null) {
                chopBangNodeFactoryInstance = new ChopBangNodeFactory();
            }
            return chopBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ChopBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChopBangPolymorphicNode
        extends ChopBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ChopBangPolymorphicNode(ChopBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ChopBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChopBangRubyStringNode
        extends ChopBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChopBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ChopBangRubyStringNode(ChopBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.chopBang(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.chopBang(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChopBangNode create0(StringNodes.ChopBangNode current) {
                return new ChopBangRubyStringNode((ChopBangBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ChopBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChopBangUninitializedNode
        extends ChopBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChopBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChopBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChopBangUninitializedNode(ChopBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ChopBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChopBangBaseNode rootNode = (ChopBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ChopBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChopBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChopBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ChopBangNode.class)
        private static abstract class ChopBangBaseNode
        extends StringNodes.ChopBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChopBangBaseNode next0;

            ChopBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChopBangBaseNode(ChopBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ChopBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChopBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ChopBangUninitializedNode(this);
                    ((ChopBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ChopBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ChopBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ChopBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ChopBangUninitializedNode(this), (Node)new ChopBangPolymorphicNode(this), (DSLNode)((ChopBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChopBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ChopBangBaseNode)ChopBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ChopBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ChopBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CaseCmpNode.class)
    public static final class CaseCmpNodeFactory
    extends NodeFactoryBase<StringNodes.CaseCmpNode> {
        private static CaseCmpNodeFactory caseCmpNodeFactoryInstance;

        private CaseCmpNodeFactory() {
            super(StringNodes.CaseCmpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.CaseCmpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return CaseCmpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CaseCmpNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return CaseCmpUninitializedNode.create0(context, sourceSection, string, other);
        }

        public static NodeFactory<StringNodes.CaseCmpNode> getInstance() {
            if (caseCmpNodeFactoryInstance == null) {
                caseCmpNodeFactoryInstance = new CaseCmpNodeFactory();
            }
            return caseCmpNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CaseCmpPolymorphicNode
        extends CaseCmpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            CaseCmpPolymorphicNode(CaseCmpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CaseCmpRubyString1Node
        extends CaseCmpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCmpRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CaseCmpRubyString1Node(CaseCmpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    otherValue = this.other.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyString");
                }
                if (!CaseCmpBaseNode.bothSingleByteOptimizable(stringValue, otherValue)) {
                    return super.caseCmp(stringValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, stringValue, otherValue, "One of guards [!bothSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                RubyString otherValueCast;
                RubyString stringValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue) && !CaseCmpBaseNode.bothSingleByteOptimizable(stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue))) {
                    return super.caseCmp(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.CaseCmpNode create0(StringNodes.CaseCmpNode current) {
                return new CaseCmpRubyString1Node((CaseCmpBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CaseCmpRubyString0Node
        extends CaseCmpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCmpRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CaseCmpRubyString0Node(CaseCmpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    otherValue = this.other.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyString");
                }
                if (CaseCmpBaseNode.bothSingleByteOptimizable(stringValue, otherValue)) {
                    return super.caseCmpSingleByte(stringValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, stringValue, otherValue, "One of guards [bothSingleByteOptimizable] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                RubyString otherValueCast;
                RubyString stringValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue) && CaseCmpBaseNode.bothSingleByteOptimizable(stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue))) {
                    return super.caseCmpSingleByte(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.CaseCmpNode create0(StringNodes.CaseCmpNode current) {
                return new CaseCmpRubyString0Node((CaseCmpBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CaseCmpUninitializedNode
        extends CaseCmpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CaseCmpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CaseCmpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection, string, other);
            }

            CaseCmpUninitializedNode(CaseCmpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                CaseCmpBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CaseCmpBaseNode rootNode = (CaseCmpBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.other}, new Object[]{stringValue, otherValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CaseCmpBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.CaseCmpNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                return new CaseCmpUninitializedNode(context, sourceSection, string, other);
            }
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        private static abstract class CaseCmpBaseNode
        extends StringNodes.CaseCmpNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode other;
            @Node.Child
            protected CaseCmpBaseNode next0;

            CaseCmpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string = string;
                this.other = super.coerceOtherToString(other);
            }

            CaseCmpBaseNode(CaseCmpBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object stringValue, Object otherValue, String reason) {
                String message;
                CaseCmpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CaseCmpBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    newNode = new CaseCmpUninitializedNode(this);
                    ((CaseCmpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CaseCmpBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CaseCmpBaseNode.createInfo0(reason, stringValue, otherValue)))) == null) {
                    returnNode = (CaseCmpBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CaseCmpUninitializedNode(this), (Node)new CaseCmpPolymorphicNode(this), (DSLNode)((CaseCmpBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, otherValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CaseCmpBaseNode specialize0(Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    RubyString otherValueCast;
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    if (StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValueCast, otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue))) {
                        return (CaseCmpBaseNode)CaseCmpRubyString0Node.create0(this);
                    }
                    return (CaseCmpBaseNode)CaseCmpRubyString1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.other = null;
                } else {
                    CaseCmpBaseNode otherCast = (CaseCmpBaseNode)other;
                    this.string = otherCast.string;
                    this.other = otherCast.other;
                }
                this.next0 = newNext == null ? null : (CaseCmpBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object otherValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                    if (otherValue != null) {
                        builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ByteSizeNode.class)
    public static final class ByteSizeNodeFactory
    extends NodeFactoryBase<StringNodes.ByteSizeNode> {
        private static ByteSizeNodeFactory byteSizeNodeFactoryInstance;

        private ByteSizeNodeFactory() {
            super(StringNodes.ByteSizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ByteSizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ByteSizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ByteSizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ByteSizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ByteSizeNode> getInstance() {
            if (byteSizeNodeFactoryInstance == null) {
                byteSizeNodeFactoryInstance = new ByteSizeNodeFactory();
            }
            return byteSizeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ByteSizePolymorphicNode
        extends ByteSizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ByteSizePolymorphicNode(ByteSizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ByteSizeRubyStringNode
        extends ByteSizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ByteSizeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ByteSizeRubyStringNode(ByteSizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.byteSize(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.byteSize(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ByteSizeNode create0(StringNodes.ByteSizeNode current) {
                return new ByteSizeRubyStringNode((ByteSizeBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ByteSizeUninitializedNode
        extends ByteSizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ByteSizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ByteSizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ByteSizeUninitializedNode(ByteSizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ByteSizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ByteSizeBaseNode rootNode = (ByteSizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ByteSizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ByteSizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ByteSizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        private static abstract class ByteSizeBaseNode
        extends StringNodes.ByteSizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ByteSizeBaseNode next0;

            ByteSizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ByteSizeBaseNode(ByteSizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ByteSizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ByteSizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ByteSizeUninitializedNode(this);
                    ((ByteSizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ByteSizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ByteSizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ByteSizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ByteSizeUninitializedNode(this), (Node)new ByteSizePolymorphicNode(this), (DSLNode)((ByteSizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ByteSizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ByteSizeBaseNode)ByteSizeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ByteSizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ByteSizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.BytesNode.class)
    public static final class BytesNodeFactory
    extends NodeFactoryBase<StringNodes.BytesNode> {
        private static BytesNodeFactory bytesNodeFactoryInstance;

        private BytesNodeFactory() {
            super(StringNodes.BytesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BytesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.BytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BytesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.BytesNode> getInstance() {
            if (bytesNodeFactoryInstance == null) {
                bytesNodeFactoryInstance = new BytesNodeFactory();
            }
            return bytesNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BytesPolymorphicNode
        extends BytesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BytesPolymorphicNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BytesRubyStringNode
        extends BytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BytesRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            BytesRubyStringNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.bytes(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.bytes(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BytesNode create0(StringNodes.BytesNode current) {
                return new BytesRubyStringNode((BytesBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BytesUninitializedNode
        extends BytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BytesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BytesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BytesUninitializedNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BytesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BytesBaseNode rootNode = (BytesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BytesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BytesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BytesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        private static abstract class BytesBaseNode
        extends StringNodes.BytesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BytesBaseNode next0;

            BytesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BytesBaseNode(BytesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                BytesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BytesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BytesUninitializedNode(this);
                    ((BytesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BytesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BytesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (BytesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BytesUninitializedNode(this), (Node)new BytesPolymorphicNode(this), (DSLNode)((BytesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BytesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (BytesBaseNode)BytesRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BytesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BytesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.BNode.class)
    public static final class BNodeFactory
    extends NodeFactoryBase<StringNodes.BNode> {
        private static BNodeFactory bNodeFactoryInstance;

        private BNodeFactory() {
            super(StringNodes.BNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.BNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.BNode> getInstance() {
            if (bNodeFactoryInstance == null) {
                bNodeFactoryInstance = new BNodeFactory();
            }
            return bNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BPolymorphicNode
        extends BBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BPolymorphicNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BRubyStringNode
        extends BBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            BRubyStringNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.b(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.b(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BNode create0(StringNodes.BNode current) {
                return new BRubyStringNode((BBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BUninitializedNode
        extends BBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BUninitializedNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BBaseNode rootNode = (BBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        private static abstract class BBaseNode
        extends StringNodes.BNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BBaseNode next0;

            BBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BBaseNode(BBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                BBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BUninitializedNode(this);
                    ((BUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (BBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BUninitializedNode(this), (Node)new BPolymorphicNode(this), (DSLNode)((BBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (BBaseNode)BRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
    public static final class ASCIIOnlyNodeFactory
    extends NodeFactoryBase<StringNodes.ASCIIOnlyNode> {
        private static ASCIIOnlyNodeFactory aSCIIOnlyNodeFactoryInstance;

        private ASCIIOnlyNodeFactory() {
            super(StringNodes.ASCIIOnlyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ASCIIOnlyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASCIIOnlyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ASCIIOnlyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ASCIIOnlyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ASCIIOnlyNode> getInstance() {
            if (aSCIIOnlyNodeFactoryInstance == null) {
                aSCIIOnlyNodeFactoryInstance = new ASCIIOnlyNodeFactory();
            }
            return aSCIIOnlyNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ASCIIOnlyPolymorphicNode
        extends ASCIIOnlyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ASCIIOnlyPolymorphicNode(ASCIIOnlyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASCIIOnlyRubyStringNode
        extends ASCIIOnlyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASCIIOnlyRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ASCIIOnlyRubyStringNode(ASCIIOnlyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.asciiOnly(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.asciiOnly(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ASCIIOnlyNode create0(StringNodes.ASCIIOnlyNode current) {
                return new ASCIIOnlyRubyStringNode((ASCIIOnlyBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ASCIIOnlyUninitializedNode
        extends ASCIIOnlyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASCIIOnlyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ASCIIOnlyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ASCIIOnlyUninitializedNode(ASCIIOnlyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ASCIIOnlyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ASCIIOnlyBaseNode rootNode = (ASCIIOnlyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ASCIIOnlyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ASCIIOnlyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ASCIIOnlyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        private static abstract class ASCIIOnlyBaseNode
        extends StringNodes.ASCIIOnlyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ASCIIOnlyBaseNode next0;

            ASCIIOnlyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ASCIIOnlyBaseNode(ASCIIOnlyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ASCIIOnlyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ASCIIOnlyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ASCIIOnlyUninitializedNode(this);
                    ((ASCIIOnlyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ASCIIOnlyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ASCIIOnlyBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ASCIIOnlyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ASCIIOnlyUninitializedNode(this), (Node)new ASCIIOnlyPolymorphicNode(this), (DSLNode)((ASCIIOnlyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ASCIIOnlyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ASCIIOnlyBaseNode)ASCIIOnlyRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ASCIIOnlyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ASCIIOnlyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
    public static final class MatchOperatorNodeFactory
    extends NodeFactoryBase<StringNodes.MatchOperatorNode> {
        private static MatchOperatorNodeFactory matchOperatorNodeFactoryInstance;

        private MatchOperatorNodeFactory() {
            super(StringNodes.MatchOperatorNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MatchOperatorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchOperatorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MatchOperatorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MatchOperatorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MatchOperatorNode> getInstance() {
            if (matchOperatorNodeFactoryInstance == null) {
                matchOperatorNodeFactoryInstance = new MatchOperatorNodeFactory();
            }
            return matchOperatorNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MatchOperatorPolymorphicNode
        extends MatchOperatorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MatchOperatorPolymorphicNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchOperatorRubyStringNode
        extends MatchOperatorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchOperatorRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class}, 0, 0);

            MatchOperatorRubyStringNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyRegexp");
                }
                return super.match(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.match(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchOperatorNode create0(StringNodes.MatchOperatorNode current) {
                return new MatchOperatorRubyStringNode((MatchOperatorBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MatchOperatorUninitializedNode
        extends MatchOperatorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchOperatorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MatchOperatorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MatchOperatorUninitializedNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MatchOperatorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MatchOperatorBaseNode rootNode = (MatchOperatorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MatchOperatorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchOperatorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MatchOperatorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        private static abstract class MatchOperatorBaseNode
        extends StringNodes.MatchOperatorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MatchOperatorBaseNode next0;

            MatchOperatorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MatchOperatorBaseNode(MatchOperatorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MatchOperatorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MatchOperatorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MatchOperatorUninitializedNode(this);
                    ((MatchOperatorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MatchOperatorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MatchOperatorBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MatchOperatorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MatchOperatorUninitializedNode(this), (Node)new MatchOperatorPolymorphicNode(this), (DSLNode)((MatchOperatorBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MatchOperatorBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    return (MatchOperatorBaseNode)MatchOperatorRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MatchOperatorBaseNode otherCast = (MatchOperatorBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MatchOperatorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<StringNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(StringNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetIndexPolymorphicNode
        extends GetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            GetIndexPolymorphicNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : (this.arguments1PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[1].executeLongFixnumRange(frameValue) : (this.arguments1PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[1].executeObjectRange(frameValue) : (this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue))))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringRubyStringUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringRubyStringUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringRubyStringUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringRubyRegexpObjectNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringRubyRegexpObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, Object.class}, 0, 0);

            GetIndexRubyStringRubyRegexpObjectNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyRegexp");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!super.isUndefinedPlaceholder(arguments2Value)) {
                    return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringRubyRegexpObjectNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringRubyRegexpUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringRubyRegexpUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringRubyRegexpUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringRubyRegexpUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringObjectObjectNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringObjectObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class, Object.class}, 0, 0);

            GetIndexRubyStringObjectObjectNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!(super.isRubyRange(arguments1Value) || super.isRubyRegexp(arguments1Value) || super.isRubyString(arguments1Value) || super.isUndefinedPlaceholder(arguments2Value))) {
                    return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isRubyRange, !isRubyRegexp, !isRubyString, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!(!RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) || super.isRubyRange(arguments1Value) || super.isRubyRegexp(arguments1Value) || super.isRubyString(arguments1Value) || super.isUndefinedPlaceholder(arguments2Value))) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringObjectObjectNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringIntObjectNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringIntObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Object.class}, 0, 0);

            GetIndexRubyStringIntObjectNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!super.isUndefinedPlaceholder(arguments2Value)) {
                    return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringIntObjectNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringIntIntNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            GetIndexRubyStringIntIntNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.slice(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.slice(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringIntIntNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringObjectRangeUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringObjectRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.ObjectRange.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringObjectRangeUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.ObjectRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof ObjectRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.sliceObjectRange(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange.ObjectRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.sliceObjectRange(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringObjectRangeUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringLongFixnumRangeUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringLongFixnumRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.LongFixnumRange.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringLongFixnumRangeUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.LongFixnumRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof LongFixnumRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.sliceLongRange(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange.LongFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.sliceLongRange(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringLongFixnumRangeUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringIntegerFixnumRangeUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringIntegerFixnumRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.IntegerFixnumRange.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringIntegerFixnumRangeUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.sliceIntegerRange(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.sliceIntegerRange(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringIntegerFixnumRangeUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringObjectUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringObjectUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                if (!(super.isRubyRange(arguments1Value) || super.isRubyRegexp(arguments1Value) || super.isRubyString(arguments1Value))) {
                    return super.getIndex(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isRubyRange, !isRubyRegexp, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isRubyRange(arguments1Value) && !super.isRubyRegexp(arguments1Value) && !super.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.getIndex(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringObjectUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringIntUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringIntUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.getIndex(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.getIndex(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current) {
                return new GetIndexRubyStringIntUndefinedPlaceholderNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetIndexUninitializedNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetIndexUninitializedNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetIndexBaseNode rootNode = (GetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        private static abstract class GetIndexBaseNode
        extends StringNodes.GetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetIndexBaseNode next0;

            GetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetIndexBaseNode(GetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                GetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new GetIndexUninitializedNode(this);
                    ((GetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (GetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetIndexUninitializedNode(this), (Node)new GetIndexPolymorphicNode(this), (DSLNode)((GetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringIntUndefinedPlaceholderNode.create0(this);
                        }
                        if (!(super.isRubyRange(arguments1Value) || super.isRubyRegexp(arguments1Value) || super.isRubyString(arguments1Value))) {
                            return (GetIndexBaseNode)GetIndexRubyStringObjectUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringIntegerFixnumRangeUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringLongFixnumRangeUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringObjectRangeUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringIntIntNode.create0(this);
                        }
                        if (!super.isUndefinedPlaceholder(arguments2Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringIntObjectNode.create0(this);
                        }
                    }
                    if (!(super.isRubyRange(arguments1Value) || super.isRubyRegexp(arguments1Value) || super.isRubyString(arguments1Value) || super.isUndefinedPlaceholder(arguments2Value))) {
                        return (GetIndexBaseNode)GetIndexRubyStringObjectObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringRubyRegexpUndefinedPlaceholderNode.create0(this);
                        }
                        if (!super.isUndefinedPlaceholder(arguments2Value)) {
                            return (GetIndexBaseNode)GetIndexRubyStringRubyRegexpObjectNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (GetIndexBaseNode)GetIndexRubyStringRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    GetIndexBaseNode otherCast = (GetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (GetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.FormatNode.class)
    public static final class FormatNodeFactory
    extends NodeFactoryBase<StringNodes.FormatNode> {
        private static FormatNodeFactory formatNodeFactoryInstance;

        private FormatNodeFactory() {
            super(StringNodes.FormatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.FormatNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FormatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.FormatNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FormatUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.FormatNode> getInstance() {
            if (formatNodeFactoryInstance == null) {
                formatNodeFactoryInstance = new FormatNodeFactory();
            }
            return formatNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FormatPolymorphicNode
        extends FormatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            FormatPolymorphicNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FormatRubyStringNode
        extends FormatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FormatRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            FormatRubyStringNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.format(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.format(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.FormatNode create0(StringNodes.FormatNode current) {
                return new FormatRubyStringNode((FormatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FormatUninitializedNode
        extends FormatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FormatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FormatUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FormatUninitializedNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                FormatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FormatBaseNode rootNode = (FormatBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FormatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.FormatNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FormatUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        private static abstract class FormatBaseNode
        extends StringNodes.FormatNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FormatBaseNode next0;

            FormatBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FormatBaseNode(FormatBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                FormatBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FormatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new FormatUninitializedNode(this);
                    ((FormatUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FormatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = FormatBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (FormatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FormatUninitializedNode(this), (Node)new FormatPolymorphicNode(this), (DSLNode)((FormatBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FormatBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (FormatBaseNode)FormatRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    FormatBaseNode otherCast = (FormatBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (FormatBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<StringNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(StringNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return ConcatUninitializedNode.create0(context, sourceSection, string, other);
        }

        public static NodeFactory<StringNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConcatPolymorphicNode
        extends ConcatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            ConcatPolymorphicNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object otherValue;
                Object stringValue = this.string.execute(frameValue);
                try {
                    otherValue = this.otherPolymorphicType == Integer.TYPE ? Integer.valueOf(this.other.executeIntegerFixnum(frameValue)) : (this.otherPolymorphicType == Long.TYPE ? Long.valueOf(this.other.executeLongFixnum(frameValue)) : (this.otherPolymorphicType == RubyBignum.class ? this.other.executeBignum(frameValue) : (this.otherPolymorphicType == RubyString.class ? this.other.executeRubyString(frameValue) : this.other.execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.otherPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, stringValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatObjectNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            ConcatObjectNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue, "Expected stringValue instanceof RubyString");
                }
                Object otherValue = this.other.execute(frameValue);
                if (!(super.isInteger(otherValue) || super.isLong(otherValue) || super.isRubyBignum(otherValue) || super.isRubyString(otherValue))) {
                    return super.concat(frameValue, stringValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, stringValue, otherValue, "One of guards [!isInteger, !isLong, !isRubyBignum, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (!(!RubyTypesGen.RUBYTYPES.isRubyString(stringValue) || super.isInteger(otherValue) || super.isLong(otherValue) || super.isRubyBignum(otherValue) || super.isRubyString(otherValue))) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    return super.concat(frameValue, stringValueCast, otherValue);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current) {
                return new ConcatObjectNode((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyStringNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ConcatRubyStringNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString"));
                }
                try {
                    otherValue = this.other.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyString"));
                }
                return super.concat(stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    RubyString otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue);
                    return super.concat(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current) {
                return new ConcatRubyStringNode((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyStringRubyBignumNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyStringRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBignum.class}, 0, 0);

            ConcatRubyStringRubyBignumNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString"));
                }
                try {
                    otherValue = this.other.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyBignum"));
                }
                return super.concat(stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyBignum(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    RubyBignum otherValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(otherValue);
                    return super.concat(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current) {
                return new ConcatRubyStringRubyBignumNode((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyStringLongNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyStringLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Long.TYPE}, 0, 0);

            ConcatRubyStringLongNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                long otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString"));
                }
                try {
                    otherValue = this.other.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof long"));
                }
                return super.concat(stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isLong(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    long otherValueCast = RubyTypesGen.RUBYTYPES.asLong(otherValue);
                    return super.concat(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current) {
                return new ConcatRubyStringLongNode((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyStringIntNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            ConcatRubyStringIntNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString"));
                }
                try {
                    otherValue = this.other.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof int"));
                }
                return super.concat(stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isInteger(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    int otherValueCast = RubyTypesGen.RUBYTYPES.asInteger(otherValue);
                    return super.concat(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current) {
                return new ConcatRubyStringIntNode((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConcatUninitializedNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConcatUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection, string, other);
            }

            ConcatUninitializedNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                ConcatBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConcatBaseNode rootNode = (ConcatBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.other}, new Object[]{stringValue, otherValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConcatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.ConcatNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                return new ConcatUninitializedNode(context, sourceSection, string, other);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        private static abstract class ConcatBaseNode
        extends StringNodes.ConcatNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode other;
            @Node.Child
            protected ConcatBaseNode next0;

            ConcatBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string = string;
                this.other = other;
            }

            ConcatBaseNode(ConcatBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object stringValue, Object otherValue, String reason) {
                String message;
                ConcatBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConcatBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    newNode = new ConcatUninitializedNode(this);
                    ((ConcatUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConcatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConcatBaseNode.createInfo0(reason, stringValue, otherValue)))) == null) {
                    returnNode = (ConcatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConcatUninitializedNode(this), (Node)new ConcatPolymorphicNode(this), (DSLNode)((ConcatBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, otherValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConcatBaseNode specialize0(Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(otherValue)) {
                        return (ConcatBaseNode)ConcatRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(otherValue)) {
                        return (ConcatBaseNode)ConcatRubyStringLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(otherValue)) {
                        return (ConcatBaseNode)ConcatRubyStringRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                        return (ConcatBaseNode)ConcatRubyStringNode.create0(this);
                    }
                    if (!(super.isInteger(otherValue) || super.isLong(otherValue) || super.isRubyBignum(otherValue) || super.isRubyString(otherValue))) {
                        return (ConcatBaseNode)ConcatObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.other = null;
                } else {
                    ConcatBaseNode otherCast = (ConcatBaseNode)other;
                    this.string = otherCast.string;
                    this.other = otherCast.other;
                }
                this.next0 = newNext == null ? null : (ConcatBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object otherValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                    if (otherValue != null) {
                        builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<StringNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(StringNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            CompareObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value)) {
                    return super.compare(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.compare(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CompareNode create0(StringNodes.CompareNode current) {
                return new CompareObjectNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntRubyStringNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CompareIntRubyStringNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CompareNode create0(StringNodes.CompareNode current) {
                return new CompareIntRubyStringNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends StringNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CompareBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (CompareBaseNode)CompareIntRubyStringNode.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value)) {
                        return (CompareBaseNode)CompareObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<StringNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(StringNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyStringObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            EqualRubyStringObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value)) {
                    return super.equal(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.equal(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(StringNodes.EqualNode current) {
                return new EqualRubyStringObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyStringNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            EqualRubyStringNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(StringNodes.EqualNode current) {
                return new EqualRubyStringNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends StringNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyStringNode.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<StringNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(StringNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MulUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MulPolymorphicNode
        extends MulBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MulPolymorphicNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyStringObjectNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            MulRubyStringObjectNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyBignum(arguments1Value) && !super.isInteger(arguments1Value)) {
                    return super.multiply(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum, !isInteger] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyBignum(arguments1Value) && !super.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.multiply(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(StringNodes.MulNode current) {
                return new MulRubyStringObjectNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyStringRubyBignumNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyStringRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBignum.class}, 0, 0);

            MulRubyStringRubyBignumNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.multiply(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.multiply(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(StringNodes.MulNode current) {
                return new MulRubyStringRubyBignumNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyStringIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            MulRubyStringIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.multiply(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.multiply(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(StringNodes.MulNode current) {
                return new MulRubyStringIntNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MulUninitializedNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MulUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MulUninitializedNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MulBaseNode rootNode = (MulBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MulBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MulUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        private static abstract class MulBaseNode
        extends StringNodes.MulNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MulBaseNode next0;

            MulBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MulBaseNode(MulBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MulBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MulUninitializedNode(this);
                    ((MulUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MulBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MulBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MulBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MulUninitializedNode(this), (Node)new MulPolymorphicNode(this), (DSLNode)((MulBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MulBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (MulBaseNode)MulRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulRubyStringRubyBignumNode.create0(this);
                    }
                    if (!super.isRubyBignum(arguments1Value) && !super.isInteger(arguments1Value)) {
                        return (MulBaseNode)MulRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MulBaseNode otherCast = (MulBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MulBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=StringNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<StringNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(StringNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return AddUninitializedNode.create0(context, sourceSection, string, other);
        }

        public static NodeFactory<StringNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AddPolymorphicNode
        extends AddBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> stringPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            AddPolymorphicNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.stringPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddRubyStringNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            AddRubyStringNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString otherValue;
                RubyString stringValue;
                try {
                    stringValue = this.string.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected stringValue instanceof RubyString");
                }
                try {
                    otherValue = this.other.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, stringValue, ex.getResult(), "Expected otherValue instanceof RubyString");
                }
                return super.add(stringValue, otherValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                    RubyString otherValueCast = RubyTypesGen.RUBYTYPES.asRubyString(otherValue);
                    return super.add(stringValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.AddNode create0(StringNodes.AddNode current) {
                return new AddRubyStringNode((AddBaseNode)current);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AddUninitializedNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AddUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection, string, other);
            }

            AddUninitializedNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object stringValue = this.string.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, stringValue, otherValue);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                AddBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AddBaseNode rootNode = (AddBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.string, rootNode.other}, new Object[]{stringValue, otherValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AddBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, stringValue, otherValue);
            }

            static StringNodes.AddNode create0(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                return new AddUninitializedNode(context, sourceSection, string, other);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        private static abstract class AddBaseNode
        extends StringNodes.AddNode
        implements DSLNode {
            @Node.Child
            protected RubyNode string;
            @Node.Child
            protected RubyNode other;
            @Node.Child
            protected AddBaseNode next0;

            AddBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string = string;
                this.other = super.coerceOtherToString(other);
            }

            AddBaseNode(AddBaseNode copy) {
                super(copy);
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object stringValue, Object otherValue, String reason) {
                String message;
                AddBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AddBaseNode newNode = this.specialize0(stringValue, otherValue);
                if (newNode == null) {
                    newNode = new AddUninitializedNode(this);
                    ((AddUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AddBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AddBaseNode.createInfo0(reason, stringValue, otherValue)))) == null) {
                    returnNode = (AddBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AddUninitializedNode(this), (Node)new AddPolymorphicNode(this), (DSLNode)((AddBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, stringValue, otherValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AddBaseNode specialize0(Object stringValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue) && RubyTypesGen.RUBYTYPES.isRubyString(otherValue)) {
                    return (AddBaseNode)AddRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.string = null;
                    this.other = null;
                } else {
                    AddBaseNode otherCast = (AddBaseNode)other;
                    this.string = otherCast.string;
                    this.other = otherCast.other;
                }
                this.next0 = newNext == null ? null : (AddBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object stringValue, Object otherValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("stringValue").append(" = ").append(stringValue);
                    if (stringValue != null) {
                        builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                    if (otherValue != null) {
                        builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

