/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class StringGuards {
    public static boolean isSingleByteOptimizable(RubyString string) {
        return StringSupport.isSingleByteOptimizable((CodeRangeable)string, (Encoding)string.getBytes().getEncoding());
    }

    public static boolean isAsciiCompatible(RubyString string) {
        return string.getByteList().getEncoding().isAsciiCompatible();
    }

    public static boolean isSingleByteOptimizableOrAsciiCompatible(RubyString string) {
        return StringGuards.isSingleByteOptimizable(string) || StringGuards.isAsciiCompatible(string);
    }

    public static boolean isSingleByte(RubyString string) {
        return string.getByteList().getEncoding().isSingleByte();
    }

    public static boolean isValidOr7BitEncoding(RubyString string) {
        return string.isCodeRangeValid() || CodeRangeSupport.isCodeRangeAsciiOnly((CodeRangeable)string);
    }

    public static boolean isFixedWidthEncoding(RubyString string) {
        return string.getByteList().getEncoding().isFixedWidth();
    }

    public static boolean isValidUtf8(RubyString string) {
        return string.isCodeRangeValid() && string.getByteList().getEncoding() instanceof UTF8Encoding;
    }
}

