/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString to_s(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), ((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)regexp.getSource(), (int)regexp.getRegex().getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceNode(SourceNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString source(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return this.getContext().makeString(regexp.getSource().dup());
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodNode {
        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SearchFromNode(SearchFromNode prev) {
            super(prev);
        }

        @Specialization
        public Object searchFrom(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string, int startPos) {
            return regexp.matchCommon(string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public QuoteNode(QuoteNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString quote(org.jruby.truffle.runtime.core.RubyString raw) {
            QuoteNode.notDesignedForCompilation();
            boolean isAsciiOnly = raw.getByteList().getEncoding().isAsciiCompatible() && raw.scanForCodeRange() == 16;
            return this.getContext().makeString(RubyRegexp.quote19((ByteList)raw.getBytes(), (boolean)isAsciiOnly));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString quote(RubySymbol raw) {
            QuoteNode.notDesignedForCompilation();
            return this.quote(raw.toRubyString());
        }
    }

    @CoreMethod(names={"options"})
    public static abstract class OptionsNode
    extends CoreMethodNode {
        private final ConditionProfile notYetInitializedProfile = ConditionProfile.createBinaryProfile();

        public OptionsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OptionsNode(OptionsNode prev) {
            super(prev);
        }

        @Specialization
        public int options(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            OptionsNode.notDesignedForCompilation();
            if (this.notYetInitializedProfile.profile(regexp.getRegex() == null)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
            }
            if (regexp.getOptions() != null) {
                return regexp.getOptions().toOptions();
            }
            return RegexpOptions.fromJoniOptions((int)regexp.getRegex().getOptions()).toOptions();
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodNode {
        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchStartNode(MatchStartNode prev) {
            super(prev);
        }

        @Specialization
        public Object matchStart(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string, int startPos) {
            Object matchResult = regexp.matchCommon(string, false, false, startPos);
            if (matchResult instanceof RubyMatchData && ((RubyMatchData)matchResult).getNumberOfRegions() > 0 && ((RubyMatchData)matchResult).getRegion().beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"match"}, required=1, taintFromSelf=true)
    public static abstract class MatchNode
    extends CoreMethodNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string) {
            return regexp.matchCommon(string, false, false);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, RubyNilClass nil) {
            return this.nil();
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString match(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), ((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)regexp.getSource(), (int)regexp.getRegex().getOptions()).inspect19()).getByteList());
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            int options = regexp.getRegex().getOptions() & 0xFFFFFFDF;
            return options ^ regexp.getSource().hashCode();
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapeNode(EscapeNode prev) {
            super(prev);
        }

        public abstract org.jruby.truffle.runtime.core.RubyString executeEscape(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyString var2);

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString escape(org.jruby.truffle.runtime.core.RubyString pattern) {
            EscapeNode.notDesignedForCompilation();
            return this.getContext().makeString(RubyRegexp.quote19((ByteList)new ByteList(pattern.getBytes()), (boolean)true).toString());
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodNode {
        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchOperatorNode(MatchOperatorNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string) {
            return regexp.matchCommon(string, true, true);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, RubyBasicObject other) {
            MatchOperatorNode.notDesignedForCompilation();
            if (other instanceof org.jruby.truffle.runtime.core.RubyString) {
                return this.match(regexp, (org.jruby.truffle.runtime.core.RubyString)other);
            }
            return this.nil();
        }
    }

    public static abstract class EscapingYieldingNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private EscapeNode escapeNode;

        public EscapingYieldingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapingYieldingNode(EscapingYieldingNode prev) {
            super(prev);
        }

        protected org.jruby.truffle.runtime.core.RubyString escape(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            if (this.escapeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.escapeNode = (EscapeNode)this.insert(RegexpNodesFactory.EscapeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.escapeNode.executeEscape(frame, string);
        }
    }

    public static abstract class EscapingNode
    extends CoreMethodNode {
        @Node.Child
        private EscapeNode escapeNode;

        public EscapingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapingNode(EscapingNode prev) {
            super(prev);
        }

        protected org.jruby.truffle.runtime.core.RubyString escape(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            if (this.escapeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.escapeNode = (EscapeNode)this.insert(RegexpNodesFactory.EscapeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.escapeNode.executeEscape(frame, string);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(org.jruby.truffle.runtime.core.RubyRegexp a, org.jruby.truffle.runtime.core.RubyRegexp b) {
            if (a == b) {
                return true;
            }
            if (a.getRegex().getOptions() != b.getRegex().getOptions()) {
                return false;
            }
            if (a.getSource().getEncoding() != b.getSource().getEncoding()) {
                return false;
            }
            return a.getSource().equal(b.getSource());
        }

        @Specialization(guards={"!isRubyRegexp(arguments[1])"})
        public boolean equal(org.jruby.truffle.runtime.core.RubyRegexp a, Object b) {
            return false;
        }
    }
}

