/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ProcessNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=ProcessNodes.class)
public final class ProcessNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ClockGetTimeNodeFactory.getInstance(), KillNodeFactory.getInstance(), PidNodeFactory.getInstance());
    }

    @GeneratedBy(value=ProcessNodes.PidNode.class)
    public static final class PidNodeFactory
    extends NodeFactoryBase<ProcessNodes.PidNode> {
        private static PidNodeFactory pidNodeFactoryInstance;

        private PidNodeFactory() {
            super(ProcessNodes.PidNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ProcessNodes.PidNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PidNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ProcessNodes.PidNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PidDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ProcessNodes.PidNode> getInstance() {
            if (pidNodeFactoryInstance == null) {
                pidNodeFactoryInstance = new PidNodeFactory();
            }
            return pidNodeFactoryInstance;
        }

        @GeneratedBy(value=ProcessNodes.PidNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PidDefaultNode
        extends PidBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PidDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            PidDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.pid();
            }

            static ProcessNodes.PidNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PidDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ProcessNodes.PidNode.class)
        private static abstract class PidBaseNode
        extends ProcessNodes.PidNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            PidBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ProcessNodes.KillNode.class)
    public static final class KillNodeFactory
    extends NodeFactoryBase<ProcessNodes.KillNode> {
        private static KillNodeFactory killNodeFactoryInstance;

        private KillNodeFactory() {
            super(ProcessNodes.KillNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ProcessNodes.KillNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KillNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ProcessNodes.KillNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KillUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ProcessNodes.KillNode> getInstance() {
            if (killNodeFactoryInstance == null) {
                killNodeFactoryInstance = new KillNodeFactory();
            }
            return killNodeFactoryInstance;
        }

        @GeneratedBy(value=ProcessNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class KillPolymorphicNode
        extends KillBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            KillPolymorphicNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ProcessNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KillRubySymbolNode
        extends KillBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KillRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class, Integer.TYPE}, 0, 0);

            KillRubySymbolNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubySymbol arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubySymbol");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.kill(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubySymbol arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.kill(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.KillNode create0(ProcessNodes.KillNode current) {
                return new KillRubySymbolNode((KillBaseNode)current);
            }
        }

        @GeneratedBy(value=ProcessNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class KillUninitializedNode
        extends KillBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KillUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            KillUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            KillUninitializedNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                KillBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    KillBaseNode rootNode = (KillBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((KillBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.KillNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KillUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ProcessNodes.KillNode.class)
        private static abstract class KillBaseNode
        extends ProcessNodes.KillNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected KillBaseNode next0;

            KillBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            KillBaseNode(KillBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                KillBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                KillBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new KillUninitializedNode(this);
                    ((KillUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (KillBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = KillBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (KillBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new KillUninitializedNode(this), (Node)new KillPolymorphicNode(this), (DSLNode)((KillBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final KillBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (KillBaseNode)KillRubySymbolNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    KillBaseNode otherCast = (KillBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (KillBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
    public static final class ClockGetTimeNodeFactory
    extends NodeFactoryBase<ProcessNodes.ClockGetTimeNode> {
        private static ClockGetTimeNodeFactory clockGetTimeNodeFactoryInstance;

        private ClockGetTimeNodeFactory() {
            super(ProcessNodes.ClockGetTimeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ProcessNodes.ClockGetTimeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClockGetTimeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ProcessNodes.ClockGetTimeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClockGetTimeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ProcessNodes.ClockGetTimeNode> getInstance() {
            if (clockGetTimeNodeFactoryInstance == null) {
                clockGetTimeNodeFactoryInstance = new ClockGetTimeNodeFactory();
            }
            return clockGetTimeNodeFactoryInstance;
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClockGetTimePolymorphicNode
        extends ClockGetTimeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ClockGetTimePolymorphicNode(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClockGetTimeIntRubySymbol1Node
        extends ClockGetTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClockGetTimeIntRubySymbol1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubySymbol.class}, 0, 0);

            ClockGetTimeIntRubySymbol1Node(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                if (ClockGetTimeBaseNode.isRealtime(arguments0Value)) {
                    return super.clock_gettime_realtime(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isRealtime] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    if (ClockGetTimeBaseNode.isRealtime(arguments0ValueCast)) {
                        return super.clock_gettime_realtime(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.ClockGetTimeNode create0(ProcessNodes.ClockGetTimeNode current) {
                return new ClockGetTimeIntRubySymbol1Node((ClockGetTimeBaseNode)current);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClockGetTimeIntRubySymbol0Node
        extends ClockGetTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClockGetTimeIntRubySymbol0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubySymbol.class}, 0, 0);

            ClockGetTimeIntRubySymbol0Node(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                if (ClockGetTimeBaseNode.isMonotonic(arguments0Value)) {
                    return super.clock_gettime_monotonic(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isMonotonic] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    if (ClockGetTimeBaseNode.isMonotonic(arguments0ValueCast)) {
                        return super.clock_gettime_monotonic(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.ClockGetTimeNode create0(ProcessNodes.ClockGetTimeNode current) {
                return new ClockGetTimeIntRubySymbol0Node((ClockGetTimeBaseNode)current);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClockGetTimeIntUndefinedPlaceholder1Node
        extends ClockGetTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClockGetTimeIntUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ClockGetTimeIntUndefinedPlaceholder1Node(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ClockGetTimeBaseNode.isRealtime(arguments0Value)) {
                    return super.clock_gettime_realtime(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isRealtime] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ClockGetTimeBaseNode.isRealtime(arguments0ValueCast)) {
                        return super.clock_gettime_realtime(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.ClockGetTimeNode create0(ProcessNodes.ClockGetTimeNode current) {
                return new ClockGetTimeIntUndefinedPlaceholder1Node((ClockGetTimeBaseNode)current);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClockGetTimeIntUndefinedPlaceholder0Node
        extends ClockGetTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClockGetTimeIntUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ClockGetTimeIntUndefinedPlaceholder0Node(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ClockGetTimeBaseNode.isMonotonic(arguments0Value)) {
                    return super.clock_gettime_monotonic(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isMonotonic] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ClockGetTimeBaseNode.isMonotonic(arguments0ValueCast)) {
                        return super.clock_gettime_monotonic(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.ClockGetTimeNode create0(ProcessNodes.ClockGetTimeNode current) {
                return new ClockGetTimeIntUndefinedPlaceholder0Node((ClockGetTimeBaseNode)current);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClockGetTimeUninitializedNode
        extends ClockGetTimeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClockGetTimeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClockGetTimeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClockGetTimeUninitializedNode(ClockGetTimeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ClockGetTimeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClockGetTimeBaseNode rootNode = (ClockGetTimeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClockGetTimeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ProcessNodes.ClockGetTimeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClockGetTimeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        private static abstract class ClockGetTimeBaseNode
        extends ProcessNodes.ClockGetTimeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClockGetTimeBaseNode next0;

            ClockGetTimeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClockGetTimeBaseNode(ClockGetTimeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ClockGetTimeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClockGetTimeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ClockGetTimeUninitializedNode(this);
                    ((ClockGetTimeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClockGetTimeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClockGetTimeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ClockGetTimeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClockGetTimeUninitializedNode(this), (Node)new ClockGetTimePolymorphicNode(this), (DSLNode)((ClockGetTimeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClockGetTimeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(arguments0ValueCast)) {
                            return (ClockGetTimeBaseNode)ClockGetTimeIntUndefinedPlaceholder0Node.create0(this);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(arguments0ValueCast)) {
                            return (ClockGetTimeBaseNode)ClockGetTimeIntUndefinedPlaceholder1Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(arguments0ValueCast)) {
                            return (ClockGetTimeBaseNode)ClockGetTimeIntRubySymbol0Node.create0(this);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(arguments0ValueCast)) {
                            return (ClockGetTimeBaseNode)ClockGetTimeIntRubySymbol1Node.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ClockGetTimeBaseNode otherCast = (ClockGetTimeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ClockGetTimeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

