/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@GeneratedBy(value=ModuleNodes.class)
public final class ModuleNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(ContainsInstanceNodeFactory.getInstance(), IsSubclassOfNodeFactory.getInstance(), IsSubclassOfOrEqualToNodeFactory.getInstance(), IsSuperclassOfNodeFactory.getInstance(), IsSuperclassOfOrEqualToNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AliasMethodNodeFactory.getInstance(), AncestorsNodeFactory.getInstance(), AppendFeaturesNodeFactory.getInstance(), AttrReaderNodeFactory.getInstance(), AttrWriterNodeFactory.getInstance(), AttrAccessorNodeFactory.getInstance(), AutoloadNodeFactory.getInstance(), AutoloadQueryNodeFactory.getInstance(), ClassEvalNodeFactory.getInstance(), ClassExecNodeFactory.getInstance(), ClassVariableDefinedNodeFactory.getInstance(), ClassVariableGetNodeFactory.getInstance(), ClassVariablesNodeFactory.getInstance(), ConstantsNodeFactory.getInstance(), ConstDefinedNodeFactory.getInstance(), ConstGetNodeFactory.getInstance(), ConstMissingNodeFactory.getInstance(), ConstSetNodeFactory.getInstance(), DefineMethodNodeFactory.getInstance(), ExtendObjectNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), IncludedNodeFactory.getInstance(), IncludedModulesNodeFactory.getInstance(), MethodDefinedNodeFactory.getInstance(), ModuleFunctionNodeFactory.getInstance(), NameNodeFactory.getInstance(), NestingNodeFactory.getInstance(), PublicNodeFactory.getInstance(), PublicClassMethodNodeFactory.getInstance(), PrivateNodeFactory.getInstance(), PrivateClassMethodNodeFactory.getInstance(), PrivateMethodDefinedNodeFactory.getInstance(), ProtectedInstanceMethodsNodeFactory.getInstance(), ProtectedMethodDefinedNodeFactory.getInstance(), PrivateInstanceMethodsNodeFactory.getInstance(), PublicInstanceMethodNodeFactory.getInstance(), PublicInstanceMethodsNodeFactory.getInstance(), PublicMethodDefinedNodeFactory.getInstance(), InstanceMethodsNodeFactory.getInstance(), InstanceMethodNodeFactory.getInstance(), PrivateConstantNodeFactory.getInstance(), PublicConstantNodeFactory.getInstance(), ProtectedNodeFactory.getInstance(), RemoveClassVariableNodeFactory.getInstance(), RemoveConstNodeFactory.getInstance(), RemoveMethodNodeFactory.getInstance(), ToSNodeFactory.getInstance(), UndefMethodNodeFactory.getInstance(), SetVisibilityNodeFactory.getInstance());
    }

    @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
    public static final class SetVisibilityNodeFactory
    extends NodeFactoryBase<ModuleNodes.SetVisibilityNode> {
        private static SetVisibilityNodeFactory setVisibilityNodeFactoryInstance;

        private SetVisibilityNodeFactory() {
            super(ModuleNodes.SetVisibilityNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, Visibility.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.SetVisibilityNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof Visibility) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return SetVisibilityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (Visibility)arguments[2], (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.SetVisibilityNode create(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
            return SetVisibilityUninitializedNode.create0(context, sourceSection, visibility, module, names);
        }

        public static NodeFactory<ModuleNodes.SetVisibilityNode> getInstance() {
            if (setVisibilityNodeFactoryInstance == null) {
                setVisibilityNodeFactoryInstance = new SetVisibilityNodeFactory();
            }
            return setVisibilityNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetVisibilityPolymorphicNode
        extends SetVisibilityBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namesPolymorphicType;

            SetVisibilityPolymorphicNode(SetVisibilityBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object namesValue = this.names.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, namesValue);
            }

            @Override
            public RubyModule executeSetVisibility(VirtualFrame frameValue, RubyModule moduleValueEvaluated, Object[] namesValueEvaluated) {
                RubyModule moduleValue = moduleValueEvaluated;
                Object[] namesValue = namesValueEvaluated;
                return this.next0.executeChained0(frameValue, moduleValue, namesValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namesPolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object moduleValue, Object namesValue) {
                return this.next0.executeChained0(frameValue, moduleValue, namesValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetVisibilityRubyModuleNode
        extends SetVisibilityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetVisibilityRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            SetVisibilityRubyModuleNode(SetVisibilityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] namesValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object namesValue2 = this.names.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), namesValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    namesValue = this.names.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected namesValue instanceof Object[]");
                }
                return super.setVisibility(frameValue, moduleValue, namesValue);
            }

            @Override
            public RubyModule executeSetVisibility(VirtualFrame frameValue, RubyModule moduleValueEvaluated, Object[] namesValueEvaluated) {
                RubyModule moduleValue = moduleValueEvaluated;
                Object[] namesValue = namesValueEvaluated;
                return super.setVisibility(frameValue, moduleValue, namesValue);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object moduleValue, Object namesValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isObjectArray(namesValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    Object[] namesValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(namesValue);
                    return super.setVisibility(frameValue, moduleValueCast, namesValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, namesValue);
            }

            static ModuleNodes.SetVisibilityNode create0(ModuleNodes.SetVisibilityNode current) {
                return new SetVisibilityRubyModuleNode((SetVisibilityBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetVisibilityUninitializedNode
        extends SetVisibilityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetVisibilityUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetVisibilityUninitializedNode(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
                super(context, sourceSection, visibility, module, names);
            }

            SetVisibilityUninitializedNode(SetVisibilityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object namesValue = this.names.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, namesValue);
            }

            @Override
            public RubyModule executeSetVisibility(VirtualFrame frameValue, RubyModule moduleValueEvaluated, Object[] namesValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule moduleValue = moduleValueEvaluated;
                Object[] namesValue = namesValueEvaluated;
                return this.executeUninitialized0(frameValue, moduleValue, namesValue);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object moduleValue, Object namesValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, namesValue);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object namesValue) {
                SetVisibilityBaseNode newNode = this.specialize0(moduleValue, namesValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetVisibilityBaseNode rootNode = (SetVisibilityBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.names}, new Object[]{moduleValue, namesValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetVisibilityBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, namesValue);
            }

            static ModuleNodes.SetVisibilityNode create0(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
                return new SetVisibilityUninitializedNode(context, sourceSection, visibility, module, names);
            }
        }

        @GeneratedBy(value=ModuleNodes.SetVisibilityNode.class)
        private static abstract class SetVisibilityBaseNode
        extends ModuleNodes.SetVisibilityNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode names;
            @Node.Child
            protected SetVisibilityBaseNode next0;

            SetVisibilityBaseNode(RubyContext context, SourceSection sourceSection, Visibility visibility, RubyNode module, RubyNode names) {
                super(context, sourceSection, visibility);
                this.module = module;
                this.names = names;
            }

            SetVisibilityBaseNode(SetVisibilityBaseNode copy) {
                super(copy);
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object moduleValue, Object namesValue, String reason) {
                String message;
                SetVisibilityBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetVisibilityBaseNode newNode = this.specialize0(moduleValue, namesValue);
                if (newNode == null) {
                    newNode = new SetVisibilityUninitializedNode(this);
                    ((SetVisibilityUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetVisibilityBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetVisibilityBaseNode.createInfo0(reason, moduleValue, namesValue)))) == null) {
                    returnNode = (SetVisibilityBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetVisibilityUninitializedNode(this), (Node)new SetVisibilityPolymorphicNode(this), (DSLNode)((SetVisibilityBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, namesValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetVisibilityBaseNode specialize0(Object moduleValue, Object namesValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isObjectArray(namesValue)) {
                    return (SetVisibilityBaseNode)SetVisibilityRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.names = null;
                } else {
                    SetVisibilityBaseNode otherCast = (SetVisibilityBaseNode)other;
                    this.module = otherCast.module;
                    this.names = otherCast.names;
                }
                this.next0 = newNext == null ? null : (SetVisibilityBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object namesValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("namesValue").append(" = ").append(namesValue);
                    if (namesValue != null) {
                        builder.append(" (").append(namesValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
    public static final class UndefMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.UndefMethodNode> {
        private static UndefMethodNodeFactory undefMethodNodeFactoryInstance;

        private UndefMethodNodeFactory() {
            super(ModuleNodes.UndefMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.UndefMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UndefMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.UndefMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UndefMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.UndefMethodNode> getInstance() {
            if (undefMethodNodeFactoryInstance == null) {
                undefMethodNodeFactoryInstance = new UndefMethodNodeFactory();
            }
            return undefMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UndefMethodPolymorphicNode
        extends UndefMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UndefMethodPolymorphicNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyModuleRubySymbolNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            UndefMethodRubyModuleRubySymbolNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current) {
                return new UndefMethodRubyModuleRubySymbolNode((UndefMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefMethodRubyModuleRubyStringNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            UndefMethodRubyModuleRubyStringNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.undefMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.undefMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(ModuleNodes.UndefMethodNode current) {
                return new UndefMethodRubyModuleRubyStringNode((UndefMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UndefMethodUninitializedNode
        extends UndefMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UndefMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UndefMethodUninitializedNode(UndefMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UndefMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UndefMethodBaseNode rootNode = (UndefMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UndefMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.UndefMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UndefMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.UndefMethodNode.class)
        private static abstract class UndefMethodBaseNode
        extends ModuleNodes.UndefMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UndefMethodBaseNode next0;

            UndefMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UndefMethodBaseNode(UndefMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                UndefMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UndefMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UndefMethodUninitializedNode(this);
                    ((UndefMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UndefMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UndefMethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (UndefMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UndefMethodUninitializedNode(this), (Node)new UndefMethodPolymorphicNode(this), (DSLNode)((UndefMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UndefMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (UndefMethodBaseNode)UndefMethodRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UndefMethodBaseNode otherCast = (UndefMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UndefMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<ModuleNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(ModuleNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyModuleNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            ToSRubyModuleNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ToSNode create0(ModuleNodes.ToSNode current) {
                return new ToSRubyModuleNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends ModuleNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (ToSBaseNode)ToSRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
    public static final class RemoveMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveMethodNode> {
        private static RemoveMethodNodeFactory removeMethodNodeFactoryInstance;

        private RemoveMethodNodeFactory() {
            super(ModuleNodes.RemoveMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.RemoveMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RemoveMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.RemoveMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RemoveMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.RemoveMethodNode> getInstance() {
            if (removeMethodNodeFactoryInstance == null) {
                removeMethodNodeFactoryInstance = new RemoveMethodNodeFactory();
            }
            return removeMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RemoveMethodPolymorphicNode
        extends RemoveMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RemoveMethodPolymorphicNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveMethodRubyModuleNode
        extends RemoveMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            RemoveMethodRubyModuleNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.removeMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.removeMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveMethodNode create0(ModuleNodes.RemoveMethodNode current) {
                return new RemoveMethodRubyModuleNode((RemoveMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RemoveMethodUninitializedNode
        extends RemoveMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RemoveMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RemoveMethodUninitializedNode(RemoveMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RemoveMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RemoveMethodBaseNode rootNode = (RemoveMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RemoveMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RemoveMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveMethodNode.class)
        private static abstract class RemoveMethodBaseNode
        extends ModuleNodes.RemoveMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RemoveMethodBaseNode next0;

            RemoveMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RemoveMethodBaseNode(RemoveMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                RemoveMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RemoveMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RemoveMethodUninitializedNode(this);
                    ((RemoveMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RemoveMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RemoveMethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RemoveMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RemoveMethodUninitializedNode(this), (Node)new RemoveMethodPolymorphicNode(this), (DSLNode)((RemoveMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RemoveMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (RemoveMethodBaseNode)RemoveMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RemoveMethodBaseNode otherCast = (RemoveMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RemoveMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
    public static final class RemoveConstNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveConstNode> {
        private static RemoveConstNodeFactory removeConstNodeFactoryInstance;

        private RemoveConstNodeFactory() {
            super(ModuleNodes.RemoveConstNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.RemoveConstNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return RemoveConstNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.RemoveConstNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return RemoveConstUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.RemoveConstNode> getInstance() {
            if (removeConstNodeFactoryInstance == null) {
                removeConstNodeFactoryInstance = new RemoveConstNodeFactory();
            }
            return removeConstNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RemoveConstPolymorphicNode
        extends RemoveConstBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            RemoveConstPolymorphicNode(RemoveConstBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveConstRubyModuleNode
        extends RemoveConstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveConstRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            RemoveConstRubyModuleNode(RemoveConstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.removeConstant(moduleValue, nameValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.removeConstant(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.RemoveConstNode create0(ModuleNodes.RemoveConstNode current) {
                return new RemoveConstRubyModuleNode((RemoveConstBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RemoveConstUninitializedNode
        extends RemoveConstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveConstUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RemoveConstUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            RemoveConstUninitializedNode(RemoveConstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                RemoveConstBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RemoveConstBaseNode rootNode = (RemoveConstBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RemoveConstBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.RemoveConstNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new RemoveConstUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveConstNode.class)
        private static abstract class RemoveConstBaseNode
        extends ModuleNodes.RemoveConstNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RemoveConstBaseNode next0;

            RemoveConstBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            RemoveConstBaseNode(RemoveConstBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                RemoveConstBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RemoveConstBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new RemoveConstUninitializedNode(this);
                    ((RemoveConstUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RemoveConstBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RemoveConstBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (RemoveConstBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RemoveConstUninitializedNode(this), (Node)new RemoveConstPolymorphicNode(this), (DSLNode)((RemoveConstBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RemoveConstBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (RemoveConstBaseNode)RemoveConstRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    RemoveConstBaseNode otherCast = (RemoveConstBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (RemoveConstBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
    public static final class RemoveClassVariableNodeFactory
    extends NodeFactoryBase<ModuleNodes.RemoveClassVariableNode> {
        private static RemoveClassVariableNodeFactory removeClassVariableNodeFactoryInstance;

        private RemoveClassVariableNodeFactory() {
            super(ModuleNodes.RemoveClassVariableNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.RemoveClassVariableNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RemoveClassVariableNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.RemoveClassVariableNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RemoveClassVariableUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.RemoveClassVariableNode> getInstance() {
            if (removeClassVariableNodeFactoryInstance == null) {
                removeClassVariableNodeFactoryInstance = new RemoveClassVariableNodeFactory();
            }
            return removeClassVariableNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RemoveClassVariablePolymorphicNode
        extends RemoveClassVariableBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RemoveClassVariablePolymorphicNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveClassVariableRubyModuleRubySymbolNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            RemoveClassVariableRubyModuleRubySymbolNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.removeClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.removeClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(ModuleNodes.RemoveClassVariableNode current) {
                return new RemoveClassVariableRubyModuleRubySymbolNode((RemoveClassVariableBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RemoveClassVariableRubyModuleRubyStringNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            RemoveClassVariableRubyModuleRubyStringNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.removeClassVariable(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.removeClassVariable(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(ModuleNodes.RemoveClassVariableNode current) {
                return new RemoveClassVariableRubyModuleRubyStringNode((RemoveClassVariableBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RemoveClassVariableUninitializedNode
        extends RemoveClassVariableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RemoveClassVariableUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RemoveClassVariableUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RemoveClassVariableUninitializedNode(RemoveClassVariableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RemoveClassVariableBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RemoveClassVariableBaseNode rootNode = (RemoveClassVariableBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RemoveClassVariableBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.RemoveClassVariableNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RemoveClassVariableUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.RemoveClassVariableNode.class)
        private static abstract class RemoveClassVariableBaseNode
        extends ModuleNodes.RemoveClassVariableNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RemoveClassVariableBaseNode next0;

            RemoveClassVariableBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RemoveClassVariableBaseNode(RemoveClassVariableBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                RemoveClassVariableBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RemoveClassVariableBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RemoveClassVariableUninitializedNode(this);
                    ((RemoveClassVariableUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RemoveClassVariableBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RemoveClassVariableBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RemoveClassVariableBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RemoveClassVariableUninitializedNode(this), (Node)new RemoveClassVariablePolymorphicNode(this), (DSLNode)((RemoveClassVariableBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RemoveClassVariableBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (RemoveClassVariableBaseNode)RemoveClassVariableRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (RemoveClassVariableBaseNode)RemoveClassVariableRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RemoveClassVariableBaseNode otherCast = (RemoveClassVariableBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RemoveClassVariableBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
    public static final class ProtectedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedNode> {
        private static ProtectedNodeFactory protectedNodeFactoryInstance;

        private ProtectedNodeFactory() {
            super(ModuleNodes.ProtectedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ProtectedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProtectedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ProtectedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ProtectedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ProtectedNode> getInstance() {
            if (protectedNodeFactoryInstance == null) {
                protectedNodeFactoryInstance = new ProtectedNodeFactory();
            }
            return protectedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProtectedPolymorphicNode
        extends ProtectedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ProtectedPolymorphicNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProtectedRubyModuleNode
        extends ProtectedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            ProtectedRubyModuleNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doProtected(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doProtected(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedNode create0(ModuleNodes.ProtectedNode current) {
                return new ProtectedRubyModuleNode((ProtectedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProtectedUninitializedNode
        extends ProtectedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProtectedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ProtectedUninitializedNode(ProtectedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ProtectedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProtectedBaseNode rootNode = (ProtectedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ProtectedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ProtectedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedNode.class)
        private static abstract class ProtectedBaseNode
        extends ModuleNodes.ProtectedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ProtectedBaseNode next0;

            ProtectedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ProtectedBaseNode(ProtectedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ProtectedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProtectedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ProtectedUninitializedNode(this);
                    ((ProtectedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ProtectedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ProtectedBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ProtectedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProtectedUninitializedNode(this), (Node)new ProtectedPolymorphicNode(this), (DSLNode)((ProtectedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProtectedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (ProtectedBaseNode)ProtectedRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ProtectedBaseNode otherCast = (ProtectedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ProtectedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
    public static final class PublicConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicConstantNode> {
        private static PublicConstantNodeFactory publicConstantNodeFactoryInstance;

        private PublicConstantNodeFactory() {
            super(ModuleNodes.PublicConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PublicConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicConstantNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicConstantUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicConstantNode> getInstance() {
            if (publicConstantNodeFactoryInstance == null) {
                publicConstantNodeFactoryInstance = new PublicConstantNodeFactory();
            }
            return publicConstantNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicConstantPolymorphicNode
        extends PublicConstantBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicConstantPolymorphicNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicConstantRubyModuleNode
        extends PublicConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicConstantRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicConstantRubyModuleNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.publicConstant(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.publicConstant(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicConstantNode create0(ModuleNodes.PublicConstantNode current) {
                return new PublicConstantRubyModuleNode((PublicConstantBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicConstantUninitializedNode
        extends PublicConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicConstantUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicConstantUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicConstantUninitializedNode(PublicConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicConstantBaseNode rootNode = (PublicConstantBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicConstantBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicConstantNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicConstantUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicConstantNode.class)
        private static abstract class PublicConstantBaseNode
        extends ModuleNodes.PublicConstantNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicConstantBaseNode next0;

            PublicConstantBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicConstantBaseNode(PublicConstantBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PublicConstantBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicConstantUninitializedNode(this);
                    ((PublicConstantUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicConstantBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicConstantBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PublicConstantBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicConstantUninitializedNode(this), (Node)new PublicConstantPolymorphicNode(this), (DSLNode)((PublicConstantBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicConstantBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicConstantBaseNode)PublicConstantRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicConstantBaseNode otherCast = (PublicConstantBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicConstantBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
    public static final class PrivateConstantNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateConstantNode> {
        private static PrivateConstantNodeFactory privateConstantNodeFactoryInstance;

        private PrivateConstantNodeFactory() {
            super(ModuleNodes.PrivateConstantNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PrivateConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateConstantNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateConstantUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateConstantNode> getInstance() {
            if (privateConstantNodeFactoryInstance == null) {
                privateConstantNodeFactoryInstance = new PrivateConstantNodeFactory();
            }
            return privateConstantNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateConstantPolymorphicNode
        extends PrivateConstantBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateConstantPolymorphicNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateConstantRubyModuleNode
        extends PrivateConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateConstantRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateConstantRubyModuleNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.privateConstant(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.privateConstant(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateConstantNode create0(ModuleNodes.PrivateConstantNode current) {
                return new PrivateConstantRubyModuleNode((PrivateConstantBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateConstantUninitializedNode
        extends PrivateConstantBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateConstantUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateConstantUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateConstantUninitializedNode(PrivateConstantBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateConstantBaseNode rootNode = (PrivateConstantBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateConstantBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateConstantNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateConstantUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateConstantNode.class)
        private static abstract class PrivateConstantBaseNode
        extends ModuleNodes.PrivateConstantNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateConstantBaseNode next0;

            PrivateConstantBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateConstantBaseNode(PrivateConstantBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PrivateConstantBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateConstantBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateConstantUninitializedNode(this);
                    ((PrivateConstantUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateConstantBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateConstantBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PrivateConstantBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateConstantUninitializedNode(this), (Node)new PrivateConstantPolymorphicNode(this), (DSLNode)((PrivateConstantBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateConstantBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateConstantBaseNode)PrivateConstantRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateConstantBaseNode otherCast = (PrivateConstantBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateConstantBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
    public static final class InstanceMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodNode> {
        private static InstanceMethodNodeFactory instanceMethodNodeFactoryInstance;

        private InstanceMethodNodeFactory() {
            super(ModuleNodes.InstanceMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.InstanceMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InstanceMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InstanceMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return InstanceMethodUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.InstanceMethodNode> getInstance() {
            if (instanceMethodNodeFactoryInstance == null) {
                instanceMethodNodeFactoryInstance = new InstanceMethodNodeFactory();
            }
            return instanceMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceMethodPolymorphicNode
        extends InstanceMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            InstanceMethodPolymorphicNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodRubyModuleNode
        extends InstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            InstanceMethodRubyModuleNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.instanceMethod(moduleValue, nameValue);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.instanceMethod(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.InstanceMethodNode create0(ModuleNodes.InstanceMethodNode current) {
                return new InstanceMethodRubyModuleNode((InstanceMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceMethodUninitializedNode
        extends InstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            InstanceMethodUninitializedNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected RubyUnboundMethod executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                InstanceMethodBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceMethodBaseNode rootNode = (InstanceMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.InstanceMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new InstanceMethodUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodNode.class)
        private static abstract class InstanceMethodBaseNode
        extends ModuleNodes.InstanceMethodNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected InstanceMethodBaseNode next0;

            InstanceMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            InstanceMethodBaseNode(InstanceMethodBaseNode copy) {
                super(copy);
            }

            protected abstract RubyUnboundMethod executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyUnboundMethod rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                InstanceMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceMethodBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new InstanceMethodUninitializedNode(this);
                    ((InstanceMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceMethodBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (InstanceMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceMethodUninitializedNode(this), (Node)new InstanceMethodPolymorphicNode(this), (DSLNode)((InstanceMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceMethodBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (InstanceMethodBaseNode)InstanceMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    InstanceMethodBaseNode otherCast = (InstanceMethodBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (InstanceMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
    public static final class InstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.InstanceMethodsNode> {
        private static InstanceMethodsNodeFactory instanceMethodsNodeFactoryInstance;

        private InstanceMethodsNodeFactory() {
            super(ModuleNodes.InstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.InstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InstanceMethodsNode> getInstance() {
            if (instanceMethodsNodeFactoryInstance == null) {
                instanceMethodsNodeFactoryInstance = new InstanceMethodsNodeFactory();
            }
            return instanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceMethodsPolymorphicNode
        extends InstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceMethodsPolymorphicNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodsRubyModuleBooleanNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            InstanceMethodsRubyModuleBooleanNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.instanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.instanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(ModuleNodes.InstanceMethodsNode current) {
                return new InstanceMethodsRubyModuleBooleanNode((InstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            InstanceMethodsRubyModuleUndefinedPlaceholderNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.instanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.instanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(ModuleNodes.InstanceMethodsNode current) {
                return new InstanceMethodsRubyModuleUndefinedPlaceholderNode((InstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceMethodsUninitializedNode
        extends InstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceMethodsUninitializedNode(InstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceMethodsBaseNode rootNode = (InstanceMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InstanceMethodsNode.class)
        private static abstract class InstanceMethodsBaseNode
        extends ModuleNodes.InstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceMethodsBaseNode next0;

            InstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceMethodsBaseNode(InstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceMethodsUninitializedNode(this);
                    ((InstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InstanceMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceMethodsUninitializedNode(this), (Node)new InstanceMethodsPolymorphicNode(this), (DSLNode)((InstanceMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InstanceMethodsBaseNode)InstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (InstanceMethodsBaseNode)InstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceMethodsBaseNode otherCast = (InstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
    public static final class PublicMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicMethodDefinedNode> {
        private static PublicMethodDefinedNodeFactory publicMethodDefinedNodeFactoryInstance;

        private PublicMethodDefinedNodeFactory() {
            super(ModuleNodes.PublicMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.PublicMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicMethodDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return PublicMethodDefinedUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.PublicMethodDefinedNode> getInstance() {
            if (publicMethodDefinedNodeFactoryInstance == null) {
                publicMethodDefinedNodeFactoryInstance = new PublicMethodDefinedNodeFactory();
            }
            return publicMethodDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicMethodDefinedPolymorphicNode
        extends PublicMethodDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            PublicMethodDefinedPolymorphicNode(PublicMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicMethodDefinedRubyModuleNode
        extends PublicMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicMethodDefinedRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            PublicMethodDefinedRubyModuleNode(PublicMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.isPublicMethodDefined(moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.isPublicMethodDefined(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PublicMethodDefinedNode create0(ModuleNodes.PublicMethodDefinedNode current) {
                return new PublicMethodDefinedRubyModuleNode((PublicMethodDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicMethodDefinedUninitializedNode
        extends PublicMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicMethodDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicMethodDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            PublicMethodDefinedUninitializedNode(PublicMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                PublicMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicMethodDefinedBaseNode rootNode = (PublicMethodDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicMethodDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PublicMethodDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new PublicMethodDefinedUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicMethodDefinedNode.class)
        private static abstract class PublicMethodDefinedBaseNode
        extends ModuleNodes.PublicMethodDefinedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected PublicMethodDefinedBaseNode next0;

            PublicMethodDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            PublicMethodDefinedBaseNode(PublicMethodDefinedBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                PublicMethodDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new PublicMethodDefinedUninitializedNode(this);
                    ((PublicMethodDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicMethodDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicMethodDefinedBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (PublicMethodDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicMethodDefinedUninitializedNode(this), (Node)new PublicMethodDefinedPolymorphicNode(this), (DSLNode)((PublicMethodDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicMethodDefinedBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (PublicMethodDefinedBaseNode)PublicMethodDefinedRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    PublicMethodDefinedBaseNode otherCast = (PublicMethodDefinedBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (PublicMethodDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
    public static final class PublicInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicInstanceMethodsNode> {
        private static PublicInstanceMethodsNodeFactory publicInstanceMethodsNodeFactoryInstance;

        private PublicInstanceMethodsNodeFactory() {
            super(ModuleNodes.PublicInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PublicInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicInstanceMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicInstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicInstanceMethodsNode> getInstance() {
            if (publicInstanceMethodsNodeFactoryInstance == null) {
                publicInstanceMethodsNodeFactoryInstance = new PublicInstanceMethodsNodeFactory();
            }
            return publicInstanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicInstanceMethodsPolymorphicNode
        extends PublicInstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicInstanceMethodsPolymorphicNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicInstanceMethodsRubyModuleBooleanNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            PublicInstanceMethodsRubyModuleBooleanNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.publicInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.publicInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(ModuleNodes.PublicInstanceMethodsNode current) {
                return new PublicInstanceMethodsRubyModuleBooleanNode((PublicInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.publicInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.publicInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(ModuleNodes.PublicInstanceMethodsNode current) {
                return new PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode((PublicInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicInstanceMethodsUninitializedNode
        extends PublicInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicInstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicInstanceMethodsUninitializedNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicInstanceMethodsBaseNode rootNode = (PublicInstanceMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicInstanceMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicInstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicInstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodsNode.class)
        private static abstract class PublicInstanceMethodsBaseNode
        extends ModuleNodes.PublicInstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicInstanceMethodsBaseNode next0;

            PublicInstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicInstanceMethodsBaseNode(PublicInstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PublicInstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicInstanceMethodsUninitializedNode(this);
                    ((PublicInstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicInstanceMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicInstanceMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PublicInstanceMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicInstanceMethodsUninitializedNode(this), (Node)new PublicInstanceMethodsPolymorphicNode(this), (DSLNode)((PublicInstanceMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicInstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PublicInstanceMethodsBaseNode)PublicInstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PublicInstanceMethodsBaseNode)PublicInstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicInstanceMethodsBaseNode otherCast = (PublicInstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicInstanceMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
    public static final class PublicInstanceMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicInstanceMethodNode> {
        private static PublicInstanceMethodNodeFactory publicInstanceMethodNodeFactoryInstance;

        private PublicInstanceMethodNodeFactory() {
            super(ModuleNodes.PublicInstanceMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.PublicInstanceMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicInstanceMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicInstanceMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return PublicInstanceMethodUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.PublicInstanceMethodNode> getInstance() {
            if (publicInstanceMethodNodeFactoryInstance == null) {
                publicInstanceMethodNodeFactoryInstance = new PublicInstanceMethodNodeFactory();
            }
            return publicInstanceMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicInstanceMethodPolymorphicNode
        extends PublicInstanceMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            PublicInstanceMethodPolymorphicNode(PublicInstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicInstanceMethodRubyModuleNode
        extends PublicInstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            PublicInstanceMethodRubyModuleNode(PublicInstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.publicInstanceMethod(moduleValue, nameValue);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.publicInstanceMethod(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PublicInstanceMethodNode create0(ModuleNodes.PublicInstanceMethodNode current) {
                return new PublicInstanceMethodRubyModuleNode((PublicInstanceMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicInstanceMethodUninitializedNode
        extends PublicInstanceMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicInstanceMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicInstanceMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            PublicInstanceMethodUninitializedNode(PublicInstanceMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected RubyUnboundMethod executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                PublicInstanceMethodBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicInstanceMethodBaseNode rootNode = (PublicInstanceMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicInstanceMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PublicInstanceMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new PublicInstanceMethodUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicInstanceMethodNode.class)
        private static abstract class PublicInstanceMethodBaseNode
        extends ModuleNodes.PublicInstanceMethodNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected PublicInstanceMethodBaseNode next0;

            PublicInstanceMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            PublicInstanceMethodBaseNode(PublicInstanceMethodBaseNode copy) {
                super(copy);
            }

            protected abstract RubyUnboundMethod executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyUnboundMethod rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                PublicInstanceMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicInstanceMethodBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new PublicInstanceMethodUninitializedNode(this);
                    ((PublicInstanceMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicInstanceMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicInstanceMethodBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (PublicInstanceMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicInstanceMethodUninitializedNode(this), (Node)new PublicInstanceMethodPolymorphicNode(this), (DSLNode)((PublicInstanceMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicInstanceMethodBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (PublicInstanceMethodBaseNode)PublicInstanceMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    PublicInstanceMethodBaseNode otherCast = (PublicInstanceMethodBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (PublicInstanceMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
    public static final class PrivateInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateInstanceMethodsNode> {
        private static PrivateInstanceMethodsNodeFactory privateInstanceMethodsNodeFactoryInstance;

        private PrivateInstanceMethodsNodeFactory() {
            super(ModuleNodes.PrivateInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PrivateInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateInstanceMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateInstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateInstanceMethodsNode> getInstance() {
            if (privateInstanceMethodsNodeFactoryInstance == null) {
                privateInstanceMethodsNodeFactoryInstance = new PrivateInstanceMethodsNodeFactory();
            }
            return privateInstanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateInstanceMethodsPolymorphicNode
        extends PrivateInstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateInstanceMethodsPolymorphicNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateInstanceMethodsRubyModuleBooleanNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            PrivateInstanceMethodsRubyModuleBooleanNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.privateInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.privateInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(ModuleNodes.PrivateInstanceMethodsNode current) {
                return new PrivateInstanceMethodsRubyModuleBooleanNode((PrivateInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.privateInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.privateInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(ModuleNodes.PrivateInstanceMethodsNode current) {
                return new PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode((PrivateInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateInstanceMethodsUninitializedNode
        extends PrivateInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateInstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateInstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateInstanceMethodsUninitializedNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateInstanceMethodsBaseNode rootNode = (PrivateInstanceMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateInstanceMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateInstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateInstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateInstanceMethodsNode.class)
        private static abstract class PrivateInstanceMethodsBaseNode
        extends ModuleNodes.PrivateInstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateInstanceMethodsBaseNode next0;

            PrivateInstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateInstanceMethodsBaseNode(PrivateInstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PrivateInstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateInstanceMethodsUninitializedNode(this);
                    ((PrivateInstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateInstanceMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateInstanceMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PrivateInstanceMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateInstanceMethodsUninitializedNode(this), (Node)new PrivateInstanceMethodsPolymorphicNode(this), (DSLNode)((PrivateInstanceMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateInstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PrivateInstanceMethodsBaseNode)PrivateInstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PrivateInstanceMethodsBaseNode)PrivateInstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateInstanceMethodsBaseNode otherCast = (PrivateInstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateInstanceMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
    public static final class ProtectedMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedMethodDefinedNode> {
        private static ProtectedMethodDefinedNodeFactory protectedMethodDefinedNodeFactoryInstance;

        private ProtectedMethodDefinedNodeFactory() {
            super(ModuleNodes.ProtectedMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.ProtectedMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ProtectedMethodDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ProtectedMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return ProtectedMethodDefinedUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.ProtectedMethodDefinedNode> getInstance() {
            if (protectedMethodDefinedNodeFactoryInstance == null) {
                protectedMethodDefinedNodeFactoryInstance = new ProtectedMethodDefinedNodeFactory();
            }
            return protectedMethodDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProtectedMethodDefinedPolymorphicNode
        extends ProtectedMethodDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            ProtectedMethodDefinedPolymorphicNode(ProtectedMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProtectedMethodDefinedRubyModuleNode
        extends ProtectedMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedMethodDefinedRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            ProtectedMethodDefinedRubyModuleNode(ProtectedMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.isProtectedMethodDefined(moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.isProtectedMethodDefined(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.ProtectedMethodDefinedNode create0(ModuleNodes.ProtectedMethodDefinedNode current) {
                return new ProtectedMethodDefinedRubyModuleNode((ProtectedMethodDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProtectedMethodDefinedUninitializedNode
        extends ProtectedMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedMethodDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProtectedMethodDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            ProtectedMethodDefinedUninitializedNode(ProtectedMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                ProtectedMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProtectedMethodDefinedBaseNode rootNode = (ProtectedMethodDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ProtectedMethodDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.ProtectedMethodDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new ProtectedMethodDefinedUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedMethodDefinedNode.class)
        private static abstract class ProtectedMethodDefinedBaseNode
        extends ModuleNodes.ProtectedMethodDefinedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected ProtectedMethodDefinedBaseNode next0;

            ProtectedMethodDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            ProtectedMethodDefinedBaseNode(ProtectedMethodDefinedBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                ProtectedMethodDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProtectedMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new ProtectedMethodDefinedUninitializedNode(this);
                    ((ProtectedMethodDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ProtectedMethodDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ProtectedMethodDefinedBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (ProtectedMethodDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProtectedMethodDefinedUninitializedNode(this), (Node)new ProtectedMethodDefinedPolymorphicNode(this), (DSLNode)((ProtectedMethodDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProtectedMethodDefinedBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (ProtectedMethodDefinedBaseNode)ProtectedMethodDefinedRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    ProtectedMethodDefinedBaseNode otherCast = (ProtectedMethodDefinedBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (ProtectedMethodDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
    public static final class ProtectedInstanceMethodsNodeFactory
    extends NodeFactoryBase<ModuleNodes.ProtectedInstanceMethodsNode> {
        private static ProtectedInstanceMethodsNodeFactory protectedInstanceMethodsNodeFactoryInstance;

        private ProtectedInstanceMethodsNodeFactory() {
            super(ModuleNodes.ProtectedInstanceMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ProtectedInstanceMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProtectedInstanceMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ProtectedInstanceMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ProtectedInstanceMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ProtectedInstanceMethodsNode> getInstance() {
            if (protectedInstanceMethodsNodeFactoryInstance == null) {
                protectedInstanceMethodsNodeFactoryInstance = new ProtectedInstanceMethodsNodeFactory();
            }
            return protectedInstanceMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProtectedInstanceMethodsPolymorphicNode
        extends ProtectedInstanceMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ProtectedInstanceMethodsPolymorphicNode(ProtectedInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProtectedInstanceMethodsRubyModuleBooleanNode
        extends ProtectedInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedInstanceMethodsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            ProtectedInstanceMethodsRubyModuleBooleanNode(ProtectedInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.protectedInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.protectedInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedInstanceMethodsNode create0(ModuleNodes.ProtectedInstanceMethodsNode current) {
                return new ProtectedInstanceMethodsRubyModuleBooleanNode((ProtectedInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProtectedInstanceMethodsRubyModuleUndefinedPlaceholderNode
        extends ProtectedInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedInstanceMethodsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            ProtectedInstanceMethodsRubyModuleUndefinedPlaceholderNode(ProtectedInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.protectedInstanceMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.protectedInstanceMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedInstanceMethodsNode create0(ModuleNodes.ProtectedInstanceMethodsNode current) {
                return new ProtectedInstanceMethodsRubyModuleUndefinedPlaceholderNode((ProtectedInstanceMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProtectedInstanceMethodsUninitializedNode
        extends ProtectedInstanceMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProtectedInstanceMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProtectedInstanceMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ProtectedInstanceMethodsUninitializedNode(ProtectedInstanceMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ProtectedInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProtectedInstanceMethodsBaseNode rootNode = (ProtectedInstanceMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ProtectedInstanceMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ProtectedInstanceMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ProtectedInstanceMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ProtectedInstanceMethodsNode.class)
        private static abstract class ProtectedInstanceMethodsBaseNode
        extends ModuleNodes.ProtectedInstanceMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ProtectedInstanceMethodsBaseNode next0;

            ProtectedInstanceMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ProtectedInstanceMethodsBaseNode(ProtectedInstanceMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ProtectedInstanceMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProtectedInstanceMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ProtectedInstanceMethodsUninitializedNode(this);
                    ((ProtectedInstanceMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ProtectedInstanceMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ProtectedInstanceMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ProtectedInstanceMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProtectedInstanceMethodsUninitializedNode(this), (Node)new ProtectedInstanceMethodsPolymorphicNode(this), (DSLNode)((ProtectedInstanceMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProtectedInstanceMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (ProtectedInstanceMethodsBaseNode)ProtectedInstanceMethodsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (ProtectedInstanceMethodsBaseNode)ProtectedInstanceMethodsRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ProtectedInstanceMethodsBaseNode otherCast = (ProtectedInstanceMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ProtectedInstanceMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
    public static final class PrivateMethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateMethodDefinedNode> {
        private static PrivateMethodDefinedNodeFactory privateMethodDefinedNodeFactoryInstance;

        private PrivateMethodDefinedNodeFactory() {
            super(ModuleNodes.PrivateMethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.PrivateMethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PrivateMethodDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateMethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return PrivateMethodDefinedUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.PrivateMethodDefinedNode> getInstance() {
            if (privateMethodDefinedNodeFactoryInstance == null) {
                privateMethodDefinedNodeFactoryInstance = new PrivateMethodDefinedNodeFactory();
            }
            return privateMethodDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateMethodDefinedPolymorphicNode
        extends PrivateMethodDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            PrivateMethodDefinedPolymorphicNode(PrivateMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateMethodDefinedRubyModuleNode
        extends PrivateMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateMethodDefinedRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            PrivateMethodDefinedRubyModuleNode(PrivateMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.isPrivateMethodDefined(moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.isPrivateMethodDefined(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PrivateMethodDefinedNode create0(ModuleNodes.PrivateMethodDefinedNode current) {
                return new PrivateMethodDefinedRubyModuleNode((PrivateMethodDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateMethodDefinedUninitializedNode
        extends PrivateMethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateMethodDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateMethodDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            PrivateMethodDefinedUninitializedNode(PrivateMethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                PrivateMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateMethodDefinedBaseNode rootNode = (PrivateMethodDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateMethodDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.PrivateMethodDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new PrivateMethodDefinedUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateMethodDefinedNode.class)
        private static abstract class PrivateMethodDefinedBaseNode
        extends ModuleNodes.PrivateMethodDefinedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected PrivateMethodDefinedBaseNode next0;

            PrivateMethodDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            PrivateMethodDefinedBaseNode(PrivateMethodDefinedBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                PrivateMethodDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateMethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new PrivateMethodDefinedUninitializedNode(this);
                    ((PrivateMethodDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateMethodDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateMethodDefinedBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (PrivateMethodDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateMethodDefinedUninitializedNode(this), (Node)new PrivateMethodDefinedPolymorphicNode(this), (DSLNode)((PrivateMethodDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateMethodDefinedBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (PrivateMethodDefinedBaseNode)PrivateMethodDefinedRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    PrivateMethodDefinedBaseNode otherCast = (PrivateMethodDefinedBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (PrivateMethodDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
    public static final class PrivateClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateClassMethodNode> {
        private static PrivateClassMethodNodeFactory privateClassMethodNodeFactoryInstance;

        private PrivateClassMethodNodeFactory() {
            super(ModuleNodes.PrivateClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PrivateClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateClassMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateClassMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateClassMethodNode> getInstance() {
            if (privateClassMethodNodeFactoryInstance == null) {
                privateClassMethodNodeFactoryInstance = new PrivateClassMethodNodeFactory();
            }
            return privateClassMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateClassMethodPolymorphicNode
        extends PrivateClassMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateClassMethodPolymorphicNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateClassMethodRubyModuleNode
        extends PrivateClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateClassMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateClassMethodRubyModuleNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.privateClassMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.privateClassMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateClassMethodNode create0(ModuleNodes.PrivateClassMethodNode current) {
                return new PrivateClassMethodRubyModuleNode((PrivateClassMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateClassMethodUninitializedNode
        extends PrivateClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateClassMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateClassMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateClassMethodUninitializedNode(PrivateClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateClassMethodBaseNode rootNode = (PrivateClassMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateClassMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateClassMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateClassMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateClassMethodNode.class)
        private static abstract class PrivateClassMethodBaseNode
        extends ModuleNodes.PrivateClassMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateClassMethodBaseNode next0;

            PrivateClassMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateClassMethodBaseNode(PrivateClassMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PrivateClassMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateClassMethodUninitializedNode(this);
                    ((PrivateClassMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateClassMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateClassMethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PrivateClassMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateClassMethodUninitializedNode(this), (Node)new PrivateClassMethodPolymorphicNode(this), (DSLNode)((PrivateClassMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateClassMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateClassMethodBaseNode)PrivateClassMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateClassMethodBaseNode otherCast = (PrivateClassMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateClassMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PrivateNode.class)
    public static final class PrivateNodeFactory
    extends NodeFactoryBase<ModuleNodes.PrivateNode> {
        private static PrivateNodeFactory privateNodeFactoryInstance;

        private PrivateNodeFactory() {
            super(ModuleNodes.PrivateNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PrivateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PrivateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PrivateNode> getInstance() {
            if (privateNodeFactoryInstance == null) {
                privateNodeFactoryInstance = new PrivateNodeFactory();
            }
            return privateNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivatePolymorphicNode
        extends PrivateBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivatePolymorphicNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateRubyModuleNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PrivateRubyModuleNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doPrivate(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return super.doPrivate(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doPrivate(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateNode create0(ModuleNodes.PrivateNode current) {
                return new PrivateRubyModuleNode((PrivateBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateUninitializedNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateUninitializedNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePrivate(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateBaseNode rootNode = (PrivateBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PrivateNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PrivateNode.class)
        private static abstract class PrivateBaseNode
        extends ModuleNodes.PrivateNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateBaseNode next0;

            PrivateBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateBaseNode(PrivateBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PrivateBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateUninitializedNode(this);
                    ((PrivateUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PrivateBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateUninitializedNode(this), (Node)new PrivatePolymorphicNode(this), (DSLNode)((PrivateBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PrivateBaseNode)PrivateRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateBaseNode otherCast = (PrivateBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
    public static final class PublicClassMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicClassMethodNode> {
        private static PublicClassMethodNodeFactory publicClassMethodNodeFactoryInstance;

        private PublicClassMethodNodeFactory() {
            super(ModuleNodes.PublicClassMethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PublicClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicClassMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicClassMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicClassMethodNode> getInstance() {
            if (publicClassMethodNodeFactoryInstance == null) {
                publicClassMethodNodeFactoryInstance = new PublicClassMethodNodeFactory();
            }
            return publicClassMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicClassMethodPolymorphicNode
        extends PublicClassMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicClassMethodPolymorphicNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicClassMethodRubyModuleNode
        extends PublicClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicClassMethodRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicClassMethodRubyModuleNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.publicClassMethod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.publicClassMethod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicClassMethodNode create0(ModuleNodes.PublicClassMethodNode current) {
                return new PublicClassMethodRubyModuleNode((PublicClassMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicClassMethodUninitializedNode
        extends PublicClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicClassMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicClassMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicClassMethodUninitializedNode(PublicClassMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicClassMethodBaseNode rootNode = (PublicClassMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicClassMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicClassMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicClassMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicClassMethodNode.class)
        private static abstract class PublicClassMethodBaseNode
        extends ModuleNodes.PublicClassMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicClassMethodBaseNode next0;

            PublicClassMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicClassMethodBaseNode(PublicClassMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PublicClassMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicClassMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicClassMethodUninitializedNode(this);
                    ((PublicClassMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicClassMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicClassMethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PublicClassMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicClassMethodUninitializedNode(this), (Node)new PublicClassMethodPolymorphicNode(this), (DSLNode)((PublicClassMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicClassMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicClassMethodBaseNode)PublicClassMethodRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicClassMethodBaseNode otherCast = (PublicClassMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicClassMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.PublicNode.class)
    public static final class PublicNodeFactory
    extends NodeFactoryBase<ModuleNodes.PublicNode> {
        private static PublicNodeFactory publicNodeFactoryInstance;

        private PublicNodeFactory() {
            super(ModuleNodes.PublicNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.PublicNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.PublicNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.PublicNode> getInstance() {
            if (publicNodeFactoryInstance == null) {
                publicNodeFactoryInstance = new PublicNodeFactory();
            }
            return publicNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicPolymorphicNode
        extends PublicBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicPolymorphicNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicRubyModuleNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            PublicRubyModuleNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.doPublic(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return super.doPublic(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.doPublic(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicNode create0(ModuleNodes.PublicNode current) {
                return new PublicRubyModuleNode((PublicBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicUninitializedNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicUninitializedNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executePublic(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicBaseNode rootNode = (PublicBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.PublicNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.PublicNode.class)
        private static abstract class PublicBaseNode
        extends ModuleNodes.PublicNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicBaseNode next0;

            PublicBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicBaseNode(PublicBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PublicBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicUninitializedNode(this);
                    ((PublicUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PublicBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicUninitializedNode(this), (Node)new PublicPolymorphicNode(this), (DSLNode)((PublicBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (PublicBaseNode)PublicRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicBaseNode otherCast = (PublicBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NestingNode.class)
    public static final class NestingNodeFactory
    extends NodeFactoryBase<ModuleNodes.NestingNode> {
        private static NestingNodeFactory nestingNodeFactoryInstance;

        private NestingNodeFactory() {
            super(ModuleNodes.NestingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.NestingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NestingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.NestingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NestingDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.NestingNode> getInstance() {
            if (nestingNodeFactoryInstance == null) {
                nestingNodeFactoryInstance = new NestingNodeFactory();
            }
            return nestingNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.NestingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NestingDefaultNode
        extends NestingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NestingDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            NestingDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.nesting(frameValue);
            }

            static ModuleNodes.NestingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NestingDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.NestingNode.class)
        private static abstract class NestingBaseNode
        extends ModuleNodes.NestingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NestingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<ModuleNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(ModuleNodes.NameNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NamePolymorphicNode
        extends NameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NamePolymorphicNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameRubyModuleNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            NameRubyModuleNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.name(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.name(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.NameNode create0(ModuleNodes.NameNode current) {
                return new NameRubyModuleNode((NameBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NameUninitializedNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NameUninitializedNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NameBaseNode rootNode = (NameBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NameBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.NameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.NameNode.class)
        private static abstract class NameBaseNode
        extends ModuleNodes.NameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NameBaseNode next0;

            NameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NameBaseNode(NameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                NameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NameUninitializedNode(this);
                    ((NameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NameBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NameBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (NameBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NameUninitializedNode(this), (Node)new NamePolymorphicNode(this), (DSLNode)((NameBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (NameBaseNode)NameRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NameBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
    public static final class ModuleFunctionNodeFactory
    extends NodeFactoryBase<ModuleNodes.ModuleFunctionNode> {
        private static ModuleFunctionNodeFactory moduleFunctionNodeFactoryInstance;

        private ModuleFunctionNodeFactory() {
            super(ModuleNodes.ModuleFunctionNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ModuleFunctionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModuleFunctionNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ModuleFunctionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModuleFunctionUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ModuleFunctionNode> getInstance() {
            if (moduleFunctionNodeFactoryInstance == null) {
                moduleFunctionNodeFactoryInstance = new ModuleFunctionNodeFactory();
            }
            return moduleFunctionNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModuleFunctionPolymorphicNode
        extends ModuleFunctionBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ModuleFunctionPolymorphicNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModuleFunctionRubyModuleNode
        extends ModuleFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModuleFunctionRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            ModuleFunctionRubyModuleNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.moduleFunction(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.moduleFunction(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ModuleFunctionNode create0(ModuleNodes.ModuleFunctionNode current) {
                return new ModuleFunctionRubyModuleNode((ModuleFunctionBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModuleFunctionUninitializedNode
        extends ModuleFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModuleFunctionUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModuleFunctionUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModuleFunctionUninitializedNode(ModuleFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ModuleFunctionBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModuleFunctionBaseNode rootNode = (ModuleFunctionBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ModuleFunctionBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ModuleFunctionNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModuleFunctionUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ModuleFunctionNode.class)
        private static abstract class ModuleFunctionBaseNode
        extends ModuleNodes.ModuleFunctionNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModuleFunctionBaseNode next0;

            ModuleFunctionBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModuleFunctionBaseNode(ModuleFunctionBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ModuleFunctionBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModuleFunctionBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ModuleFunctionUninitializedNode(this);
                    ((ModuleFunctionUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ModuleFunctionBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ModuleFunctionBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ModuleFunctionBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ModuleFunctionUninitializedNode(this), (Node)new ModuleFunctionPolymorphicNode(this), (DSLNode)((ModuleFunctionBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModuleFunctionBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (ModuleFunctionBaseNode)ModuleFunctionRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ModuleFunctionBaseNode otherCast = (ModuleFunctionBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ModuleFunctionBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
    public static final class MethodDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.MethodDefinedNode> {
        private static MethodDefinedNodeFactory methodDefinedNodeFactoryInstance;

        private MethodDefinedNodeFactory() {
            super(ModuleNodes.MethodDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.MethodDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return MethodDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.MethodDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return MethodDefinedUninitializedNode.create0(context, sourceSection, module, name, inherit);
        }

        public static NodeFactory<ModuleNodes.MethodDefinedNode> getInstance() {
            if (methodDefinedNodeFactoryInstance == null) {
                methodDefinedNodeFactoryInstance = new MethodDefinedNodeFactory();
            }
            return methodDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MethodDefinedPolymorphicNode
        extends MethodDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> inheritPolymorphicType;

            MethodDefinedPolymorphicNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object inheritValue;
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                try {
                    inheritValue = this.inheritPolymorphicType == UndefinedPlaceholder.class ? this.inherit.executeUndefinedPlaceholder(frameValue) : (this.inheritPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.inherit.executeBoolean(frameValue)) : this.inherit.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.inheritPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, nameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.inheritPolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodDefinedRubyModuleBooleanNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Boolean.TYPE}, 0, 0);

            MethodDefinedRubyModuleBooleanNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof boolean");
                }
                return super.isMethodDefined(moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                    return super.isMethodDefined(moduleValueCast, nameValueCast, inheritValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.MethodDefinedNode create0(ModuleNodes.MethodDefinedNode current) {
                return new MethodDefinedRubyModuleBooleanNode((MethodDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodDefinedRubyModuleUndefinedPlaceholderNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class}, 0, 0);

            MethodDefinedRubyModuleUndefinedPlaceholderNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof UndefinedPlaceholder");
                }
                return super.isMethodDefined(moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder inheritValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(inheritValue);
                    return super.isMethodDefined(moduleValueCast, nameValueCast, inheritValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.MethodDefinedNode create0(ModuleNodes.MethodDefinedNode current) {
                return new MethodDefinedRubyModuleUndefinedPlaceholderNode((MethodDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MethodDefinedUninitializedNode
        extends MethodDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MethodDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection, module, name, inherit);
            }

            MethodDefinedUninitializedNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object inheritValue = this.inherit.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                MethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MethodDefinedBaseNode rootNode = (MethodDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.inherit}, new Object[]{moduleValue, nameValue, inheritValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MethodDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.MethodDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                return new MethodDefinedUninitializedNode(context, sourceSection, module, name, inherit);
            }
        }

        @GeneratedBy(value=ModuleNodes.MethodDefinedNode.class)
        private static abstract class MethodDefinedBaseNode
        extends ModuleNodes.MethodDefinedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode inherit;
            @Node.Child
            protected MethodDefinedBaseNode next0;

            MethodDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
                this.inherit = inherit;
            }

            MethodDefinedBaseNode(MethodDefinedBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue, String reason) {
                String message;
                MethodDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MethodDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    newNode = new MethodDefinedUninitializedNode(this);
                    ((MethodDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MethodDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MethodDefinedBaseNode.createInfo0(reason, moduleValue, nameValue, inheritValue)))) == null) {
                    returnNode = (MethodDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MethodDefinedUninitializedNode(this), (Node)new MethodDefinedPolymorphicNode(this), (DSLNode)((MethodDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MethodDefinedBaseNode specialize0(Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                        return (MethodDefinedBaseNode)MethodDefinedRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                        return (MethodDefinedBaseNode)MethodDefinedRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.inherit = null;
                } else {
                    MethodDefinedBaseNode otherCast = (MethodDefinedBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.inherit = otherCast.inherit;
                }
                this.next0 = newNext == null ? null : (MethodDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object inheritValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("inheritValue").append(" = ").append(inheritValue);
                    if (inheritValue != null) {
                        builder.append(" (").append(inheritValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
    public static final class IncludedModulesNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludedModulesNode> {
        private static IncludedModulesNodeFactory includedModulesNodeFactoryInstance;

        private IncludedModulesNodeFactory() {
            super(ModuleNodes.IncludedModulesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IncludedModulesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludedModulesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IncludedModulesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludedModulesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IncludedModulesNode> getInstance() {
            if (includedModulesNodeFactoryInstance == null) {
                includedModulesNodeFactoryInstance = new IncludedModulesNodeFactory();
            }
            return includedModulesNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludedModulesPolymorphicNode
        extends IncludedModulesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IncludedModulesPolymorphicNode(IncludedModulesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludedModulesRubyModuleNode
        extends IncludedModulesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludedModulesRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            IncludedModulesRubyModuleNode(IncludedModulesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.includedModules(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.includedModules(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.IncludedModulesNode create0(ModuleNodes.IncludedModulesNode current) {
                return new IncludedModulesRubyModuleNode((IncludedModulesBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludedModulesUninitializedNode
        extends IncludedModulesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludedModulesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludedModulesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludedModulesUninitializedNode(IncludedModulesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IncludedModulesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludedModulesBaseNode rootNode = (IncludedModulesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IncludedModulesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.IncludedModulesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludedModulesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludedModulesNode.class)
        private static abstract class IncludedModulesBaseNode
        extends ModuleNodes.IncludedModulesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludedModulesBaseNode next0;

            IncludedModulesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludedModulesBaseNode(IncludedModulesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IncludedModulesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludedModulesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IncludedModulesUninitializedNode(this);
                    ((IncludedModulesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IncludedModulesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IncludedModulesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IncludedModulesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IncludedModulesUninitializedNode(this), (Node)new IncludedModulesPolymorphicNode(this), (DSLNode)((IncludedModulesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludedModulesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (IncludedModulesBaseNode)IncludedModulesRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IncludedModulesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IncludedModulesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IncludedNode.class)
    public static final class IncludedNodeFactory
    extends NodeFactoryBase<ModuleNodes.IncludedNode> {
        private static IncludedNodeFactory includedNodeFactoryInstance;

        private IncludedNodeFactory() {
            super(ModuleNodes.IncludedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IncludedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IncludedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludedObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IncludedNode> getInstance() {
            if (includedNodeFactoryInstance == null) {
                includedNodeFactoryInstance = new IncludedNodeFactory();
            }
            return includedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IncludedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludedObjectNode
        extends IncludedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludedObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            IncludedObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.included(arguments0Value);
            }

            static ModuleNodes.IncludedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludedObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IncludedNode.class)
        private static abstract class IncludedBaseNode
        extends ModuleNodes.IncludedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            IncludedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IncludedBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ModuleNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyClass.class ? this.arguments[0].executeRubyClass(frameValue) : (this.arguments0PolymorphicType == RubyModule.class ? this.arguments[0].executeRubyModule(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyClass.class ? this.arguments[1].executeRubyClass(frameValue) : (this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyClassNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, RubyClass.class}, 0, 0);

            InitializeCopyRubyClassNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyClass arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyClass");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    RubyClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeCopyNode create0(ModuleNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyClassNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyModuleNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            InitializeCopyRubyModuleNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                if (!super.isRubyClass(arguments0Value) && !super.isRubyClass(arguments1Value)) {
                    return super.initializeCopy(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyClass, !isRubyClass] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    if (!super.isRubyClass(arguments0Value) && !super.isRubyClass(arguments1Value)) {
                        return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeCopyNode create0(ModuleNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyModuleNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends ModuleNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value) && !super.isRubyClass(arguments0Value) && !super.isRubyClass(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyModuleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyClassNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ModuleNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ModuleNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                Object arguments1Value;
                RubyModule arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated) : (this.arguments1PolymorphicType == RubyProc.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyModuleRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyModuleRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyProc.class}, 0, 0);

            InitializeRubyModuleRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.initialize(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyProc arguments1Value = arguments1ValueEvaluated;
                return super.initialize(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(ModuleNodes.InitializeNode current) {
                return new InitializeRubyModuleRubyProcNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyModuleUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyModuleUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(ModuleNodes.InitializeNode current) {
                return new InitializeRubyModuleUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public RubyModule executeInitialize(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyProc arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyProc arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends ModuleNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyModuleRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
    public static final class ExtendObjectNodeFactory
    extends NodeFactoryBase<ModuleNodes.ExtendObjectNode> {
        private static ExtendObjectNodeFactory extendObjectNodeFactoryInstance;

        private ExtendObjectNodeFactory() {
            super(ModuleNodes.ExtendObjectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ExtendObjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExtendObjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ExtendObjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExtendObjectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ExtendObjectNode> getInstance() {
            if (extendObjectNodeFactoryInstance == null) {
                extendObjectNodeFactoryInstance = new ExtendObjectNodeFactory();
            }
            return extendObjectNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExtendObjectPolymorphicNode
        extends ExtendObjectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ExtendObjectPolymorphicNode(ExtendObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExtendObjectRubyModuleNode
        extends ExtendObjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExtendObjectRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            ExtendObjectRubyModuleNode(ExtendObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.extendObject(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.extendObject(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ExtendObjectNode create0(ModuleNodes.ExtendObjectNode current) {
                return new ExtendObjectRubyModuleNode((ExtendObjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExtendObjectUninitializedNode
        extends ExtendObjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExtendObjectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExtendObjectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExtendObjectUninitializedNode(ExtendObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ExtendObjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExtendObjectBaseNode rootNode = (ExtendObjectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExtendObjectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ExtendObjectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExtendObjectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ExtendObjectNode.class)
        private static abstract class ExtendObjectBaseNode
        extends ModuleNodes.ExtendObjectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExtendObjectBaseNode next0;

            ExtendObjectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExtendObjectBaseNode(ExtendObjectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ExtendObjectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExtendObjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ExtendObjectUninitializedNode(this);
                    ((ExtendObjectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExtendObjectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ExtendObjectBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ExtendObjectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExtendObjectUninitializedNode(this), (Node)new ExtendObjectPolymorphicNode(this), (DSLNode)((ExtendObjectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExtendObjectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    return (ExtendObjectBaseNode)ExtendObjectRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ExtendObjectBaseNode otherCast = (ExtendObjectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ExtendObjectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
    public static final class DefineMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.DefineMethodNode> {
        private static DefineMethodNodeFactory defineMethodNodeFactoryInstance;

        private DefineMethodNodeFactory() {
            super(ModuleNodes.DefineMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.DefineMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 6 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode) || arguments[5] != null && !(arguments[5] instanceof RubyNode))) {
                return DefineMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]), (RubyNode)((Object)arguments[5]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.DefineMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
            return DefineMethodUninitializedNode.create0(context, sourceSection, module, name, proc, block);
        }

        public static NodeFactory<ModuleNodes.DefineMethodNode> getInstance() {
            if (defineMethodNodeFactoryInstance == null) {
                defineMethodNodeFactoryInstance = new DefineMethodNodeFactory();
            }
            return defineMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefineMethodPolymorphicNode
        extends DefineMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> procPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> blockPolymorphicType;

            DefineMethodPolymorphicNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object blockValue;
                Object procValue;
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                try {
                    procValue = this.procPolymorphicType == UndefinedPlaceholder.class ? this.proc.executeUndefinedPlaceholder(frameValue) : (this.procPolymorphicType == RubyProc.class ? this.proc.executeRubyProc(frameValue) : (this.procPolymorphicType == RubyMethod.class ? this.proc.executeRubyMethod(frameValue) : (this.procPolymorphicType == RubyUnboundMethod.class ? this.proc.executeRubyUnboundMethod(frameValue) : this.proc.execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue2 = this.block.execute(frameValue);
                    this.procPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue2);
                }
                try {
                    blockValue = this.blockPolymorphicType == UndefinedPlaceholder.class ? this.block.executeUndefinedPlaceholder(frameValue) : (this.blockPolymorphicType == RubyProc.class ? this.block.executeRubyProc(frameValue) : this.block.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.blockPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.procPolymorphicType = types[2];
                this.blockPolymorphicType = types[3];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubyUnboundMethodUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubyUnboundMethodUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, RubyUnboundMethod.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubyUnboundMethodUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder blockValue;
                RubyUnboundMethod procValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object procValue2 = this.proc.execute(frameValue);
                    Object blockValue2 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, procValue2, blockValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object procValue3 = this.proc.execute(frameValue);
                    Object blockValue3 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), procValue3, blockValue3, "Expected nameValue instanceof String");
                }
                try {
                    procValue = this.proc.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue4 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue4, "Expected procValue instanceof RubyUnboundMethod");
                }
                try {
                    blockValue = this.block.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, procValue, ex.getResult(), "Expected blockValue instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(procValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    RubyUnboundMethod procValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(procValue);
                    UndefinedPlaceholder blockValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(blockValue);
                    return super.defineMethod(frameValue, moduleValueCast, nameValueCast, procValueCast, blockValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current) {
                return new DefineMethodRubyModuleRubyUnboundMethodUndefinedPlaceholderNode((DefineMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubyMethodUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubyMethodUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, RubyMethod.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubyMethodUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder blockValue;
                RubyMethod procValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object procValue2 = this.proc.execute(frameValue);
                    Object blockValue2 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, procValue2, blockValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object procValue3 = this.proc.execute(frameValue);
                    Object blockValue3 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), procValue3, blockValue3, "Expected nameValue instanceof String");
                }
                try {
                    procValue = this.proc.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue4 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue4, "Expected procValue instanceof RubyMethod");
                }
                try {
                    blockValue = this.block.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, procValue, ex.getResult(), "Expected blockValue instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isRubyMethod(procValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    RubyMethod procValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(procValue);
                    UndefinedPlaceholder blockValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(blockValue);
                    return super.defineMethod(moduleValueCast, nameValueCast, procValueCast, blockValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current) {
                return new DefineMethodRubyModuleRubyMethodUndefinedPlaceholderNode((DefineMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleRubyProcUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleRubyProcUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, RubyProc.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleRubyProcUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder blockValue;
                RubyProc procValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object procValue2 = this.proc.execute(frameValue);
                    Object blockValue2 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, procValue2, blockValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object procValue3 = this.proc.execute(frameValue);
                    Object blockValue3 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), procValue3, blockValue3, "Expected nameValue instanceof String");
                }
                try {
                    procValue = this.proc.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue4 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue4, "Expected procValue instanceof RubyProc");
                }
                try {
                    blockValue = this.block.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, procValue, ex.getResult(), "Expected blockValue instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isRubyProc(procValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    RubyProc procValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(procValue);
                    UndefinedPlaceholder blockValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(blockValue);
                    return super.defineMethod(moduleValueCast, nameValueCast, procValueCast, blockValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current) {
                return new DefineMethodRubyModuleRubyProcUndefinedPlaceholderNode((DefineMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleUndefinedPlaceholderRubyProcNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            DefineMethodRubyModuleUndefinedPlaceholderRubyProcNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc blockValue;
                UndefinedPlaceholder procValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object procValue2 = this.proc.execute(frameValue);
                    Object blockValue2 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, procValue2, blockValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object procValue3 = this.proc.execute(frameValue);
                    Object blockValue3 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), procValue3, blockValue3, "Expected nameValue instanceof String");
                }
                try {
                    procValue = this.proc.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue4 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue4, "Expected procValue instanceof UndefinedPlaceholder");
                }
                try {
                    blockValue = this.block.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, procValue, ex.getResult(), "Expected blockValue instanceof RubyProc");
                }
                return super.defineMethod(moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(procValue) && RubyTypesGen.RUBYTYPES.isRubyProc(blockValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder procValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(procValue);
                    RubyProc blockValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(blockValue);
                    return super.defineMethod(moduleValueCast, nameValueCast, procValueCast, blockValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current) {
                return new DefineMethodRubyModuleUndefinedPlaceholderRubyProcNode((DefineMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineMethodRubyModuleUndefinedPlaceholderUndefinedPlaceholderNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodRubyModuleUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            DefineMethodRubyModuleUndefinedPlaceholderUndefinedPlaceholderNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder blockValue;
                UndefinedPlaceholder procValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object procValue2 = this.proc.execute(frameValue);
                    Object blockValue2 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, procValue2, blockValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object procValue3 = this.proc.execute(frameValue);
                    Object blockValue3 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), procValue3, blockValue3, "Expected nameValue instanceof String");
                }
                try {
                    procValue = this.proc.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object blockValue4 = this.block.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), blockValue4, "Expected procValue instanceof UndefinedPlaceholder");
                }
                try {
                    blockValue = this.block.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, procValue, ex.getResult(), "Expected blockValue instanceof UndefinedPlaceholder");
                }
                return super.defineMethod(moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(procValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder procValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(procValue);
                    UndefinedPlaceholder blockValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(blockValue);
                    return super.defineMethod(moduleValueCast, nameValueCast, procValueCast, blockValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(ModuleNodes.DefineMethodNode current) {
                return new DefineMethodRubyModuleUndefinedPlaceholderUndefinedPlaceholderNode((DefineMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefineMethodUninitializedNode
        extends DefineMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefineMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
                super(context, sourceSection, module, name, proc, block);
            }

            DefineMethodUninitializedNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object procValue = this.proc.execute(frameValue);
                Object blockValue = this.block.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                DefineMethodBaseNode newNode = this.specialize0(moduleValue, nameValue, procValue, blockValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefineMethodBaseNode rootNode = (DefineMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.proc, rootNode.block}, new Object[]{moduleValue, nameValue, procValue, blockValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DefineMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            static ModuleNodes.DefineMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
                return new DefineMethodUninitializedNode(context, sourceSection, module, name, proc, block);
            }
        }

        @GeneratedBy(value=ModuleNodes.DefineMethodNode.class)
        private static abstract class DefineMethodBaseNode
        extends ModuleNodes.DefineMethodNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode proc;
            @Node.Child
            protected RubyNode block;
            @Node.Child
            protected DefineMethodBaseNode next0;

            DefineMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode proc, RubyNode block) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
                this.proc = proc;
                this.block = block;
            }

            DefineMethodBaseNode(DefineMethodBaseNode copy) {
                super(copy);
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object procValue, Object blockValue, String reason) {
                String message;
                DefineMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefineMethodBaseNode newNode = this.specialize0(moduleValue, nameValue, procValue, blockValue);
                if (newNode == null) {
                    newNode = new DefineMethodUninitializedNode(this);
                    ((DefineMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DefineMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DefineMethodBaseNode.createInfo0(reason, moduleValue, nameValue, procValue, blockValue)))) == null) {
                    returnNode = (DefineMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DefineMethodUninitializedNode(this), (Node)new DefineMethodPolymorphicNode(this), (DSLNode)((DefineMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, procValue, blockValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefineMethodBaseNode specialize0(Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(procValue)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(blockValue)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(blockValue)) {
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(procValue)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubyProcUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyMethod(procValue)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubyMethodUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(procValue)) {
                            return (DefineMethodBaseNode)DefineMethodRubyModuleRubyUnboundMethodUndefinedPlaceholderNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.proc = null;
                    this.block = null;
                } else {
                    DefineMethodBaseNode otherCast = (DefineMethodBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.proc = otherCast.proc;
                    this.block = otherCast.block;
                }
                this.next0 = newNext == null ? null : (DefineMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object procValue, Object blockValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("procValue").append(" = ").append(procValue);
                    if (procValue != null) {
                        builder.append(" (").append(procValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("blockValue").append(" = ").append(blockValue);
                    if (blockValue != null) {
                        builder.append(" (").append(blockValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
    public static final class ConstSetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstSetNode> {
        private static ConstSetNodeFactory constSetNodeFactoryInstance;

        private ConstSetNodeFactory() {
            super(ModuleNodes.ConstSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.ConstSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstSetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
            return ConstSetUninitializedNode.create0(context, sourceSection, module, name, value);
        }

        public static NodeFactory<ModuleNodes.ConstSetNode> getInstance() {
            if (constSetNodeFactoryInstance == null) {
                constSetNodeFactoryInstance = new ConstSetNodeFactory();
            }
            return constSetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstSetPolymorphicNode
        extends ConstSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> valuePolymorphicType;

            ConstSetPolymorphicNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, valueValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.valuePolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object valueValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, valueValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstSetRubyModuleObjectNode
        extends ConstSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstSetRubyModuleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Object.class}, 0, 0);

            ConstSetRubyModuleObjectNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object valueValue = this.value.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, valueValue, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object valueValue = this.value.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), valueValue, "Expected nameValue instanceof String");
                }
                Object valueValue = this.value.execute(frameValue);
                return super.setConstant(moduleValue, nameValue, valueValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object valueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.setConstant(moduleValueCast, nameValueCast, valueValue);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, valueValue);
            }

            static ModuleNodes.ConstSetNode create0(ModuleNodes.ConstSetNode current) {
                return new ConstSetRubyModuleObjectNode((ConstSetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstSetUninitializedNode
        extends ConstSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
                super(context, sourceSection, module, name, value);
            }

            ConstSetUninitializedNode(ConstSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, valueValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object valueValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, valueValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object valueValue) {
                ConstSetBaseNode newNode = this.specialize0(moduleValue, nameValue, valueValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstSetBaseNode rootNode = (ConstSetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.value}, new Object[]{moduleValue, nameValue, valueValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstSetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, valueValue);
            }

            static ModuleNodes.ConstSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
                return new ConstSetUninitializedNode(context, sourceSection, module, name, value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstSetNode.class)
        private static abstract class ConstSetBaseNode
        extends ModuleNodes.ConstSetNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode value;
            @Node.Child
            protected ConstSetBaseNode next0;

            ConstSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode value) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
                this.value = value;
            }

            ConstSetBaseNode(ConstSetBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object valueValue, String reason) {
                String message;
                ConstSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstSetBaseNode newNode = this.specialize0(moduleValue, nameValue, valueValue);
                if (newNode == null) {
                    newNode = new ConstSetUninitializedNode(this);
                    ((ConstSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstSetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstSetBaseNode.createInfo0(reason, moduleValue, nameValue, valueValue)))) == null) {
                    returnNode = (ConstSetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstSetUninitializedNode(this), (Node)new ConstSetPolymorphicNode(this), (DSLNode)((ConstSetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, valueValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstSetBaseNode specialize0(Object moduleValue, Object nameValue, Object valueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (ConstSetBaseNode)ConstSetRubyModuleObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.value = null;
                } else {
                    ConstSetBaseNode otherCast = (ConstSetBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.value = otherCast.value;
                }
                this.next0 = newNext == null ? null : (ConstSetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object valueValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("valueValue").append(" = ").append(valueValue);
                    if (valueValue != null) {
                        builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
    public static final class ConstMissingNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstMissingNode> {
        private static ConstMissingNodeFactory constMissingNodeFactoryInstance;

        private ConstMissingNodeFactory() {
            super(ModuleNodes.ConstMissingNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ConstMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstMissingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstMissingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstMissingNode> getInstance() {
            if (constMissingNodeFactoryInstance == null) {
                constMissingNodeFactoryInstance = new ConstMissingNodeFactory();
            }
            return constMissingNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstMissingPolymorphicNode
        extends ConstMissingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstMissingPolymorphicNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstMissingRubyModuleNode
        extends ConstMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstMissingRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ConstMissingRubyModuleNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.methodMissing(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.methodMissing(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstMissingNode create0(ModuleNodes.ConstMissingNode current) {
                return new ConstMissingRubyModuleNode((ConstMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstMissingUninitializedNode
        extends ConstMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstMissingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstMissingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstMissingUninitializedNode(ConstMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstMissingBaseNode rootNode = (ConstMissingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstMissingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstMissingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstMissingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstMissingNode.class)
        private static abstract class ConstMissingBaseNode
        extends ModuleNodes.ConstMissingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstMissingBaseNode next0;

            ConstMissingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstMissingBaseNode(ConstMissingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ConstMissingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstMissingUninitializedNode(this);
                    ((ConstMissingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstMissingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstMissingBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ConstMissingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstMissingUninitializedNode(this), (Node)new ConstMissingPolymorphicNode(this), (DSLNode)((ConstMissingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstMissingBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (ConstMissingBaseNode)ConstMissingRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstMissingBaseNode otherCast = (ConstMissingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstMissingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
    public static final class ConstGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstGetNode> {
        private static ConstGetNodeFactory constGetNodeFactoryInstance;

        private ConstGetNodeFactory() {
            super(ModuleNodes.ConstGetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.ConstGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstGetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return ConstGetUninitializedNode.create0(context, sourceSection, module, name, inherit);
        }

        public static NodeFactory<ModuleNodes.ConstGetNode> getInstance() {
            if (constGetNodeFactoryInstance == null) {
                constGetNodeFactoryInstance = new ConstGetNodeFactory();
            }
            return constGetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstGetPolymorphicNode
        extends ConstGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> inheritPolymorphicType;

            ConstGetPolymorphicNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object inheritValue;
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                try {
                    inheritValue = this.inheritPolymorphicType == UndefinedPlaceholder.class ? this.inherit.executeUndefinedPlaceholder(frameValue) : (this.inheritPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.inherit.executeBoolean(frameValue)) : this.inherit.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.inheritPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, nameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.inheritPolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleBoolean2Node
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleBoolean2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Boolean.TYPE}, 0, 0);

            ConstGetRubyModuleBoolean2Node(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof boolean");
                }
                if (super.isScoped(nameValue)) {
                    return super.getConstantScoped(frameValue, moduleValue, nameValue, inheritValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, moduleValue, nameValue, inheritValue, "One of guards [isScoped] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                    if (super.isScoped(nameValueCast)) {
                        return super.getConstantScoped(frameValue, moduleValueCast, nameValueCast, inheritValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current) {
                return new ConstGetRubyModuleBoolean2Node((ConstGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleBoolean1Node
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleBoolean1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Boolean.TYPE}, 0, 0);

            ConstGetRubyModuleBoolean1Node(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof boolean");
                }
                if (!super.isTrue(inheritValue) && !super.isScoped(nameValue)) {
                    return super.getConstantNoInherit(frameValue, moduleValue, nameValue, inheritValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, moduleValue, nameValue, inheritValue, "One of guards [!isTrue, !isScoped] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                    if (!super.isTrue(inheritValueCast) && !super.isScoped(nameValueCast)) {
                        return super.getConstantNoInherit(frameValue, moduleValueCast, nameValueCast, inheritValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current) {
                return new ConstGetRubyModuleBoolean1Node((ConstGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleBoolean0Node
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleBoolean0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Boolean.TYPE}, 0, 0);

            ConstGetRubyModuleBoolean0Node(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof boolean");
                }
                if (super.isTrue(inheritValue) && !super.isScoped(nameValue)) {
                    return super.getConstant(frameValue, moduleValue, nameValue, inheritValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, moduleValue, nameValue, inheritValue, "One of guards [isTrue, !isScoped] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                    if (super.isTrue(inheritValueCast) && !super.isScoped(nameValueCast)) {
                        return super.getConstant(frameValue, moduleValueCast, nameValueCast, inheritValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current) {
                return new ConstGetRubyModuleBoolean0Node((ConstGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleUndefinedPlaceholder1Node
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class}, 0, 0);

            ConstGetRubyModuleUndefinedPlaceholder1Node(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof UndefinedPlaceholder");
                }
                if (super.isScoped(nameValue)) {
                    return super.getConstantScoped(frameValue, moduleValue, nameValue, inheritValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, moduleValue, nameValue, inheritValue, "One of guards [isScoped] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder inheritValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(inheritValue);
                    if (super.isScoped(nameValueCast)) {
                        return super.getConstantScoped(frameValue, moduleValueCast, nameValueCast, inheritValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current) {
                return new ConstGetRubyModuleUndefinedPlaceholder1Node((ConstGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstGetRubyModuleUndefinedPlaceholder0Node
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetRubyModuleUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class}, 0, 0);

            ConstGetRubyModuleUndefinedPlaceholder0Node(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof UndefinedPlaceholder");
                }
                if (!super.isScoped(nameValue)) {
                    return super.getConstant(frameValue, moduleValue, nameValue, inheritValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, moduleValue, nameValue, inheritValue, "One of guards [!isScoped] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder inheritValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(inheritValue);
                    if (!super.isScoped(nameValueCast)) {
                        return super.getConstant(frameValue, moduleValueCast, nameValueCast, inheritValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(ModuleNodes.ConstGetNode current) {
                return new ConstGetRubyModuleUndefinedPlaceholder0Node((ConstGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstGetUninitializedNode
        extends ConstGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection, module, name, inherit);
            }

            ConstGetUninitializedNode(ConstGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object inheritValue = this.inherit.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                ConstGetBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstGetBaseNode rootNode = (ConstGetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.inherit}, new Object[]{moduleValue, nameValue, inheritValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstGetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                return new ConstGetUninitializedNode(context, sourceSection, module, name, inherit);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstGetNode.class)
        private static abstract class ConstGetBaseNode
        extends ModuleNodes.ConstGetNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode inherit;
            @Node.Child
            protected ConstGetBaseNode next0;

            ConstGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
                this.inherit = inherit;
            }

            ConstGetBaseNode(ConstGetBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue, String reason) {
                String message;
                ConstGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstGetBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    newNode = new ConstGetUninitializedNode(this);
                    ((ConstGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstGetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstGetBaseNode.createInfo0(reason, moduleValue, nameValue, inheritValue)))) == null) {
                    returnNode = (ConstGetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstGetUninitializedNode(this), (Node)new ConstGetPolymorphicNode(this), (DSLNode)((ConstGetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstGetBaseNode specialize0(Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                        if (!super.isScoped(nameValueCast)) {
                            return (ConstGetBaseNode)ConstGetRubyModuleUndefinedPlaceholder0Node.create0(this);
                        }
                        return (ConstGetBaseNode)ConstGetRubyModuleUndefinedPlaceholder1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                        boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                        if (super.isTrue(inheritValueCast) && !super.isScoped(nameValueCast)) {
                            return (ConstGetBaseNode)ConstGetRubyModuleBoolean0Node.create0(this);
                        }
                        if (!super.isTrue(inheritValueCast) && !super.isScoped(nameValueCast)) {
                            return (ConstGetBaseNode)ConstGetRubyModuleBoolean1Node.create0(this);
                        }
                        if (super.isScoped(nameValueCast)) {
                            return (ConstGetBaseNode)ConstGetRubyModuleBoolean2Node.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.inherit = null;
                } else {
                    ConstGetBaseNode otherCast = (ConstGetBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.inherit = otherCast.inherit;
                }
                this.next0 = newNext == null ? null : (ConstGetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object inheritValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("inheritValue").append(" = ").append(inheritValue);
                    if (inheritValue != null) {
                        builder.append(" (").append(inheritValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
    public static final class ConstDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstDefinedNode> {
        private static ConstDefinedNodeFactory constDefinedNodeFactoryInstance;

        private ConstDefinedNodeFactory() {
            super(ModuleNodes.ConstDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.ConstDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return ConstDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
            return ConstDefinedUninitializedNode.create0(context, sourceSection, module, name, inherit);
        }

        public static NodeFactory<ModuleNodes.ConstDefinedNode> getInstance() {
            if (constDefinedNodeFactoryInstance == null) {
                constDefinedNodeFactoryInstance = new ConstDefinedNodeFactory();
            }
            return constDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstDefinedPolymorphicNode
        extends ConstDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> inheritPolymorphicType;

            ConstDefinedPolymorphicNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object inheritValue;
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                try {
                    inheritValue = this.inheritPolymorphicType == UndefinedPlaceholder.class ? this.inherit.executeUndefinedPlaceholder(frameValue) : (this.inheritPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.inherit.executeBoolean(frameValue)) : this.inherit.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.inheritPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, nameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.inheritPolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstDefinedRubyModuleBooleanNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, Boolean.TYPE}, 0, 0);

            ConstDefinedRubyModuleBooleanNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof boolean");
                }
                return super.isConstDefined(moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    boolean inheritValueCast = RubyTypesGen.RUBYTYPES.asBoolean(inheritValue);
                    return super.isConstDefined(moduleValueCast, nameValueCast, inheritValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstDefinedNode create0(ModuleNodes.ConstDefinedNode current) {
                return new ConstDefinedRubyModuleBooleanNode((ConstDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstDefinedRubyModuleUndefinedPlaceholderNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class, UndefinedPlaceholder.class}, 0, 0);

            ConstDefinedRubyModuleUndefinedPlaceholderNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder inheritValue;
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object inheritValue2 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, inheritValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object inheritValue3 = this.inherit.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), inheritValue3, "Expected nameValue instanceof String");
                }
                try {
                    inheritValue = this.inherit.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected inheritValue instanceof UndefinedPlaceholder");
                }
                return super.isConstDefined(moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    UndefinedPlaceholder inheritValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(inheritValue);
                    return super.isConstDefined(moduleValueCast, nameValueCast, inheritValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstDefinedNode create0(ModuleNodes.ConstDefinedNode current) {
                return new ConstDefinedRubyModuleUndefinedPlaceholderNode((ConstDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstDefinedUninitializedNode
        extends ConstDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection, module, name, inherit);
            }

            ConstDefinedUninitializedNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object inheritValue = this.inherit.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, inheritValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue) {
                ConstDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstDefinedBaseNode rootNode = (ConstDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.inherit}, new Object[]{moduleValue, nameValue, inheritValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            static ModuleNodes.ConstDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                return new ConstDefinedUninitializedNode(context, sourceSection, module, name, inherit);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstDefinedNode.class)
        private static abstract class ConstDefinedBaseNode
        extends ModuleNodes.ConstDefinedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode inherit;
            @Node.Child
            protected ConstDefinedBaseNode next0;

            ConstDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode inherit) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
                this.inherit = inherit;
            }

            ConstDefinedBaseNode(ConstDefinedBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object inheritValue, String reason) {
                String message;
                ConstDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstDefinedBaseNode newNode = this.specialize0(moduleValue, nameValue, inheritValue);
                if (newNode == null) {
                    newNode = new ConstDefinedUninitializedNode(this);
                    ((ConstDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstDefinedBaseNode.createInfo0(reason, moduleValue, nameValue, inheritValue)))) == null) {
                    returnNode = (ConstDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstDefinedUninitializedNode(this), (Node)new ConstDefinedPolymorphicNode(this), (DSLNode)((ConstDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, inheritValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstDefinedBaseNode specialize0(Object moduleValue, Object nameValue, Object inheritValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(inheritValue)) {
                        return (ConstDefinedBaseNode)ConstDefinedRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(inheritValue)) {
                        return (ConstDefinedBaseNode)ConstDefinedRubyModuleBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.inherit = null;
                } else {
                    ConstDefinedBaseNode otherCast = (ConstDefinedBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.inherit = otherCast.inherit;
                }
                this.next0 = newNext == null ? null : (ConstDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object inheritValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("inheritValue").append(" = ").append(inheritValue);
                    if (inheritValue != null) {
                        builder.append(" (").append(inheritValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
    public static final class ConstantsNodeFactory
    extends NodeFactoryBase<ModuleNodes.ConstantsNode> {
        private static ConstantsNodeFactory constantsNodeFactoryInstance;

        private ConstantsNodeFactory() {
            super(ModuleNodes.ConstantsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ConstantsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstantsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ConstantsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstantsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ConstantsNode> getInstance() {
            if (constantsNodeFactoryInstance == null) {
                constantsNodeFactoryInstance = new ConstantsNodeFactory();
            }
            return constantsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstantsPolymorphicNode
        extends ConstantsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstantsPolymorphicNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstantsRubyModuleObjectNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsRubyModuleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object.class}, 0, 0);

            ConstantsRubyModuleObjectNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyModule");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.constants(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.constants(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(ModuleNodes.ConstantsNode current) {
                return new ConstantsRubyModuleObjectNode((ConstantsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstantsRubyModuleBooleanNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsRubyModuleBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Boolean.TYPE}, 0, 0);

            ConstantsRubyModuleBooleanNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.constants(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.constants(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(ModuleNodes.ConstantsNode current) {
                return new ConstantsRubyModuleBooleanNode((ConstantsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstantsRubyModuleUndefinedPlaceholderNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsRubyModuleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class}, 0, 0);

            ConstantsRubyModuleUndefinedPlaceholderNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.constants(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.constants(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(ModuleNodes.ConstantsNode current) {
                return new ConstantsRubyModuleUndefinedPlaceholderNode((ConstantsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstantsUninitializedNode
        extends ConstantsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstantsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstantsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstantsUninitializedNode(ConstantsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstantsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstantsBaseNode rootNode = (ConstantsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstantsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ConstantsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstantsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ConstantsNode.class)
        private static abstract class ConstantsBaseNode
        extends ModuleNodes.ConstantsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstantsBaseNode next0;

            ConstantsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstantsBaseNode(ConstantsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ConstantsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstantsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstantsUninitializedNode(this);
                    ((ConstantsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstantsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstantsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ConstantsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstantsUninitializedNode(this), (Node)new ConstantsPolymorphicNode(this), (DSLNode)((ConstantsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstantsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (ConstantsBaseNode)ConstantsRubyModuleUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (ConstantsBaseNode)ConstantsRubyModuleBooleanNode.create0(this);
                    }
                    if (!super.isUndefinedPlaceholder(arguments1Value)) {
                        return (ConstantsBaseNode)ConstantsRubyModuleObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstantsBaseNode otherCast = (ConstantsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstantsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
    public static final class ClassVariablesNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariablesNode> {
        private static ClassVariablesNodeFactory classVariablesNodeFactoryInstance;

        private ClassVariablesNodeFactory() {
            super(ModuleNodes.ClassVariablesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ClassVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassVariablesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassVariablesNode> getInstance() {
            if (classVariablesNodeFactoryInstance == null) {
                classVariablesNodeFactoryInstance = new ClassVariablesNodeFactory();
            }
            return classVariablesNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariablesPolymorphicNode
        extends ClassVariablesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClassVariablesPolymorphicNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariablesRubyModuleNode
        extends ClassVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariablesRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            ClassVariablesRubyModuleNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.getClassVariables(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.getClassVariables(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ClassVariablesNode create0(ModuleNodes.ClassVariablesNode current) {
                return new ClassVariablesRubyModuleNode((ClassVariablesBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariablesUninitializedNode
        extends ClassVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariablesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariablesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassVariablesUninitializedNode(ClassVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClassVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariablesBaseNode rootNode = (ClassVariablesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClassVariablesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.ClassVariablesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassVariablesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariablesNode.class)
        private static abstract class ClassVariablesBaseNode
        extends ModuleNodes.ClassVariablesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassVariablesBaseNode next0;

            ClassVariablesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassVariablesBaseNode(ClassVariablesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ClassVariablesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClassVariablesUninitializedNode(this);
                    ((ClassVariablesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClassVariablesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClassVariablesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ClassVariablesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassVariablesUninitializedNode(this), (Node)new ClassVariablesPolymorphicNode(this), (DSLNode)((ClassVariablesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariablesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (ClassVariablesBaseNode)ClassVariablesRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClassVariablesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClassVariablesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
    public static final class ClassVariableGetNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableGetNode> {
        private static ClassVariableGetNodeFactory classVariableGetNodeFactoryInstance;

        private ClassVariableGetNodeFactory() {
            super(ModuleNodes.ClassVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.ClassVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ClassVariableGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
            return ClassVariableGetUninitializedNode.create0(context, sourceSection, module, name);
        }

        public static NodeFactory<ModuleNodes.ClassVariableGetNode> getInstance() {
            if (classVariableGetNodeFactoryInstance == null) {
                classVariableGetNodeFactoryInstance = new ClassVariableGetNodeFactory();
            }
            return classVariableGetNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariableGetPolymorphicNode
        extends ClassVariableGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;

            ClassVariableGetPolymorphicNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableGetRubyModuleNode
        extends ClassVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableGetRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, String.class}, 0, 0);

            ClassVariableGetRubyModuleNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), "Expected nameValue instanceof String");
                }
                return super.getClassVariable(moduleValue, nameValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    String nameValueCast = RubyTypesGen.RUBYTYPES.asString(nameValue);
                    return super.getClassVariable(moduleValueCast, nameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.ClassVariableGetNode create0(ModuleNodes.ClassVariableGetNode current) {
                return new ClassVariableGetRubyModuleNode((ClassVariableGetBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariableGetUninitializedNode
        extends ClassVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariableGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection, module, name);
            }

            ClassVariableGetUninitializedNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
                ClassVariableGetBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariableGetBaseNode rootNode = (ClassVariableGetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name}, new Object[]{moduleValue, nameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClassVariableGetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue);
            }

            static ModuleNodes.ClassVariableGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                return new ClassVariableGetUninitializedNode(context, sourceSection, module, name);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableGetNode.class)
        private static abstract class ClassVariableGetBaseNode
        extends ModuleNodes.ClassVariableGetNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected ClassVariableGetBaseNode next0;

            ClassVariableGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name) {
                super(context, sourceSection);
                this.module = module;
                this.name = super.coerceToString(name);
            }

            ClassVariableGetBaseNode(ClassVariableGetBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, String reason) {
                String message;
                ClassVariableGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariableGetBaseNode newNode = this.specialize0(moduleValue, nameValue);
                if (newNode == null) {
                    newNode = new ClassVariableGetUninitializedNode(this);
                    ((ClassVariableGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClassVariableGetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClassVariableGetBaseNode.createInfo0(reason, moduleValue, nameValue)))) == null) {
                    returnNode = (ClassVariableGetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassVariableGetUninitializedNode(this), (Node)new ClassVariableGetPolymorphicNode(this), (DSLNode)((ClassVariableGetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariableGetBaseNode specialize0(Object moduleValue, Object nameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isString(nameValue)) {
                    return (ClassVariableGetBaseNode)ClassVariableGetRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                } else {
                    ClassVariableGetBaseNode otherCast = (ClassVariableGetBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                }
                this.next0 = newNext == null ? null : (ClassVariableGetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
    public static final class ClassVariableDefinedNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassVariableDefinedNode> {
        private static ClassVariableDefinedNodeFactory classVariableDefinedNodeFactoryInstance;

        private ClassVariableDefinedNodeFactory() {
            super(ModuleNodes.ClassVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ClassVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassVariableDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassVariableDefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassVariableDefinedNode> getInstance() {
            if (classVariableDefinedNodeFactoryInstance == null) {
                classVariableDefinedNodeFactoryInstance = new ClassVariableDefinedNodeFactory();
            }
            return classVariableDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassVariableDefinedPolymorphicNode
        extends ClassVariableDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ClassVariableDefinedPolymorphicNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableDefinedRubyModuleRubySymbolNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            ClassVariableDefinedRubyModuleRubySymbolNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.isClassVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.isClassVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(ModuleNodes.ClassVariableDefinedNode current) {
                return new ClassVariableDefinedRubyModuleRubySymbolNode((ClassVariableDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassVariableDefinedRubyModuleRubyStringNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            ClassVariableDefinedRubyModuleRubyStringNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.isClassVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.isClassVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(ModuleNodes.ClassVariableDefinedNode current) {
                return new ClassVariableDefinedRubyModuleRubyStringNode((ClassVariableDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassVariableDefinedUninitializedNode
        extends ClassVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassVariableDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassVariableDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassVariableDefinedUninitializedNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ClassVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassVariableDefinedBaseNode rootNode = (ClassVariableDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClassVariableDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ClassVariableDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassVariableDefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassVariableDefinedNode.class)
        private static abstract class ClassVariableDefinedBaseNode
        extends ModuleNodes.ClassVariableDefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassVariableDefinedBaseNode next0;

            ClassVariableDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassVariableDefinedBaseNode(ClassVariableDefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ClassVariableDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ClassVariableDefinedUninitializedNode(this);
                    ((ClassVariableDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClassVariableDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClassVariableDefinedBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ClassVariableDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassVariableDefinedUninitializedNode(this), (Node)new ClassVariableDefinedPolymorphicNode(this), (DSLNode)((ClassVariableDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassVariableDefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ClassVariableDefinedBaseNode)ClassVariableDefinedRubyModuleRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (ClassVariableDefinedBaseNode)ClassVariableDefinedRubyModuleRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ClassVariableDefinedBaseNode otherCast = (ClassVariableDefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ClassVariableDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
    public static final class ClassExecNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassExecNode> {
        private static ClassExecNodeFactory classExecNodeFactoryInstance;

        private ClassExecNodeFactory() {
            super(ModuleNodes.ClassExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ClassExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassExecNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassExecUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassExecNode> getInstance() {
            if (classExecNodeFactoryInstance == null) {
                classExecNodeFactoryInstance = new ClassExecNodeFactory();
            }
            return classExecNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassExecPolymorphicNode
        extends ClassExecBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ClassExecPolymorphicNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassExec(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassExecRubyModuleRubyProcNode
        extends ClassExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassExecRubyModuleRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class, RubyProc.class}, 0, 0);

            ClassExecRubyModuleRubyProcNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.classExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassExec(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return super.classExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.classExec(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ClassExecNode create0(ModuleNodes.ClassExecNode current) {
                return new ClassExecRubyModuleRubyProcNode((ClassExecBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassExecUninitializedNode
        extends ClassExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassExecUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassExecUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassExecUninitializedNode(ClassExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object executeClassExec(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, Object[] arguments1ValueEvaluated, RubyProc arguments2ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                Object[] arguments1Value = arguments1ValueEvaluated;
                RubyProc arguments2Value = arguments2ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ClassExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassExecBaseNode rootNode = (ClassExecBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClassExecBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.ClassExecNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassExecUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassExecNode.class)
        private static abstract class ClassExecBaseNode
        extends ModuleNodes.ClassExecNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassExecBaseNode next0;

            ClassExecBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassExecBaseNode(ClassExecBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                ClassExecBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ClassExecUninitializedNode(this);
                    ((ClassExecUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClassExecBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClassExecBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (ClassExecBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassExecUninitializedNode(this), (Node)new ClassExecPolymorphicNode(this), (DSLNode)((ClassExecBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassExecBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    return (ClassExecBaseNode)ClassExecRubyModuleRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ClassExecBaseNode otherCast = (ClassExecBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ClassExecBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
    public static final class ClassEvalNodeFactory
    extends NodeFactoryBase<ModuleNodes.ClassEvalNode> {
        private static ClassEvalNodeFactory classEvalNodeFactoryInstance;

        private ClassEvalNodeFactory() {
            super(ModuleNodes.ClassEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ClassEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClassEvalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ClassEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClassEvalUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ClassEvalNode> getInstance() {
            if (classEvalNodeFactoryInstance == null) {
                classEvalNodeFactoryInstance = new ClassEvalNodeFactory();
            }
            return classEvalNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClassEvalPolymorphicNode
        extends ClassEvalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments4PolymorphicType;

            ClassEvalPolymorphicNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments4Value;
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2, arguments4Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3, arguments4Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[3].executeIntegerFixnum(frameValue)) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value4);
                }
                try {
                    arguments4Value = this.arguments4PolymorphicType == UndefinedPlaceholder.class ? this.arguments[4].executeUndefinedPlaceholder(frameValue) : (this.arguments4PolymorphicType == RubyProc.class ? this.arguments[4].executeRubyProc(frameValue) : this.arguments[4].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments4PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
                this.arguments4PolymorphicType = types[4];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current) {
                return new ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof RubyProc");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    RubyProc arguments4ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current) {
                return new ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode((ClassEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                int arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof int");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    int arguments3ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current) {
                return new ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode((ClassEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current) {
                return new ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments4Value;
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    Object arguments4Value2 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, arguments4Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    Object arguments4Value3 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, arguments4Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    Object arguments4Value4 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, arguments4Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments4Value5 = this.arguments[4].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), arguments4Value5, "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments4Value = this.arguments[4].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, ex.getResult(), "Expected arguments4Value instanceof UndefinedPlaceholder");
                }
                return super.classEval(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    UndefinedPlaceholder arguments4ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments4Value);
                    return super.classEval(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast, arguments4ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(ModuleNodes.ClassEvalNode current) {
                return new ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((ClassEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClassEvalUninitializedNode
        extends ClassEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClassEvalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClassEvalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClassEvalUninitializedNode(ClassEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                Object arguments4Value = this.arguments[4].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                ClassEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClassEvalBaseNode rootNode = (ClassEvalBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3], rootNode.arguments[4]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClassEvalBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            static ModuleNodes.ClassEvalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClassEvalUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ClassEvalNode.class)
        private static abstract class ClassEvalBaseNode
        extends ModuleNodes.ClassEvalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClassEvalBaseNode next0;

            ClassEvalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClassEvalBaseNode(ClassEvalBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, Object var6);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value, String reason) {
                String message;
                ClassEvalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClassEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                if (newNode == null) {
                    newNode = new ClassEvalUninitializedNode(this);
                    ((ClassEvalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClassEvalBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClassEvalBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value)))) == null) {
                    returnNode = (ClassEvalBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassEvalUninitializedNode(this), (Node)new ClassEvalPolymorphicNode(this), (DSLNode)((ClassEvalBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClassEvalBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                                return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                                return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringRubyStringUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments3Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleRubyStringRubyStringIntUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments4Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments4Value)) {
                            return (ClassEvalBaseNode)ClassEvalRubyModuleUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                    this.arguments[4] = null;
                } else {
                    ClassEvalBaseNode otherCast = (ClassEvalBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                    this.arguments[4] = otherCast.arguments[4];
                }
                this.next0 = newNext == null ? null : (ClassEvalBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments4Value").append(" = ").append(arguments4Value);
                    if (arguments4Value != null) {
                        builder.append(" (").append(arguments4Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
    public static final class AutoloadQueryNodeFactory
    extends NodeFactoryBase<ModuleNodes.AutoloadQueryNode> {
        private static AutoloadQueryNodeFactory autoloadQueryNodeFactoryInstance;

        private AutoloadQueryNodeFactory() {
            super(ModuleNodes.AutoloadQueryNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AutoloadQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AutoloadQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AutoloadQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AutoloadQueryUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AutoloadQueryNode> getInstance() {
            if (autoloadQueryNodeFactoryInstance == null) {
                autoloadQueryNodeFactoryInstance = new AutoloadQueryNodeFactory();
            }
            return autoloadQueryNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AutoloadQueryPolymorphicNode
        extends AutoloadQueryBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AutoloadQueryPolymorphicNode(AutoloadQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AutoloadQueryRubyModuleRubyStringNode
        extends AutoloadQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadQueryRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class}, 0, 0);

            AutoloadQueryRubyModuleRubyStringNode(AutoloadQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.autoloadQuery(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.autoloadQuery(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AutoloadQueryNode create0(ModuleNodes.AutoloadQueryNode current) {
                return new AutoloadQueryRubyModuleRubyStringNode((AutoloadQueryBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AutoloadQueryRubyModuleRubySymbolNode
        extends AutoloadQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadQueryRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class}, 0, 0);

            AutoloadQueryRubyModuleRubySymbolNode(AutoloadQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.autoloadQuery(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.autoloadQuery(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AutoloadQueryNode create0(ModuleNodes.AutoloadQueryNode current) {
                return new AutoloadQueryRubyModuleRubySymbolNode((AutoloadQueryBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AutoloadQueryUninitializedNode
        extends AutoloadQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadQueryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AutoloadQueryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AutoloadQueryUninitializedNode(AutoloadQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AutoloadQueryBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AutoloadQueryBaseNode rootNode = (AutoloadQueryBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AutoloadQueryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AutoloadQueryNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AutoloadQueryUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadQueryNode.class)
        private static abstract class AutoloadQueryBaseNode
        extends ModuleNodes.AutoloadQueryNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AutoloadQueryBaseNode next0;

            AutoloadQueryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AutoloadQueryBaseNode(AutoloadQueryBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AutoloadQueryBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AutoloadQueryBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AutoloadQueryUninitializedNode(this);
                    ((AutoloadQueryUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AutoloadQueryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AutoloadQueryBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AutoloadQueryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AutoloadQueryUninitializedNode(this), (Node)new AutoloadQueryPolymorphicNode(this), (DSLNode)((AutoloadQueryBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AutoloadQueryBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (AutoloadQueryBaseNode)AutoloadQueryRubyModuleRubySymbolNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (AutoloadQueryBaseNode)AutoloadQueryRubyModuleRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AutoloadQueryBaseNode otherCast = (AutoloadQueryBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AutoloadQueryBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
    public static final class AutoloadNodeFactory
    extends NodeFactoryBase<ModuleNodes.AutoloadNode> {
        private static AutoloadNodeFactory autoloadNodeFactoryInstance;

        private AutoloadNodeFactory() {
            super(ModuleNodes.AutoloadNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public ModuleNodes.AutoloadNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return AutoloadNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AutoloadNode create(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
            return AutoloadUninitializedNode.create0(context, sourceSection, module, name, filename);
        }

        public static NodeFactory<ModuleNodes.AutoloadNode> getInstance() {
            if (autoloadNodeFactoryInstance == null) {
                autoloadNodeFactoryInstance = new AutoloadNodeFactory();
            }
            return autoloadNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AutoloadPolymorphicNode
        extends AutoloadBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> modulePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> namePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> filenamePolymorphicType;

            AutoloadPolymorphicNode(AutoloadBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object nameValue;
                Object moduleValue = this.module.execute(frameValue);
                try {
                    nameValue = this.namePolymorphicType == RubyString.class ? this.name.executeRubyString(frameValue) : (this.namePolymorphicType == RubySymbol.class ? this.name.executeRubySymbol(frameValue) : this.name.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue = this.filename.execute(frameValue);
                    this.namePolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, moduleValue, ex.getResult(), filenameValue);
                }
                Object filenameValue = this.filename.execute(frameValue);
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.modulePolymorphicType = types[0];
                this.namePolymorphicType = types[1];
                this.filenamePolymorphicType = types[2];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue) {
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AutoloadRubyModuleRubyStringNode
        extends AutoloadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadRubyModuleRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class}, 0, 0);

            AutoloadRubyModuleRubyStringNode(AutoloadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString filenameValue;
                RubyString nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, filenameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), filenameValue3, "Expected nameValue instanceof RubyString");
                }
                try {
                    filenameValue = this.filename.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected filenameValue instanceof RubyString");
                }
                return super.autoload(moduleValue, nameValue, filenameValue);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isRubyString(nameValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    RubyString nameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(nameValue);
                    RubyString filenameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(filenameValue);
                    return super.autoload(moduleValueCast, nameValueCast, filenameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }

            static ModuleNodes.AutoloadNode create0(ModuleNodes.AutoloadNode current) {
                return new AutoloadRubyModuleRubyStringNode((AutoloadBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AutoloadRubyModuleRubySymbolNode
        extends AutoloadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadRubyModuleRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, RubyString.class}, 0, 0);

            AutoloadRubyModuleRubySymbolNode(AutoloadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString filenameValue;
                RubySymbol nameValue;
                RubyModule moduleValue;
                try {
                    moduleValue = this.module.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue2 = this.name.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), nameValue2, filenameValue2, "Expected moduleValue instanceof RubyModule");
                }
                try {
                    nameValue = this.name.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    return this.rewrite0(frameValue, moduleValue, ex.getResult(), filenameValue3, "Expected nameValue instanceof RubySymbol");
                }
                try {
                    filenameValue = this.filename.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, moduleValue, nameValue, ex.getResult(), "Expected filenameValue instanceof RubyString");
                }
                return super.autoload(moduleValue, nameValue, filenameValue);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isRubySymbol(nameValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue)) {
                    RubyModule moduleValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(moduleValue);
                    RubySymbol nameValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(nameValue);
                    RubyString filenameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(filenameValue);
                    return super.autoload(moduleValueCast, nameValueCast, filenameValueCast);
                }
                return this.next0.executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }

            static ModuleNodes.AutoloadNode create0(ModuleNodes.AutoloadNode current) {
                return new AutoloadRubyModuleRubySymbolNode((AutoloadBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AutoloadUninitializedNode
        extends AutoloadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AutoloadUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AutoloadUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
                super(context, sourceSection, module, name, filename);
            }

            AutoloadUninitializedNode(AutoloadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object moduleValue = this.module.execute(frameValue);
                Object nameValue = this.name.execute(frameValue);
                Object filenameValue = this.filename.execute(frameValue);
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, filenameValue);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, moduleValue, nameValue, filenameValue);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue) {
                AutoloadBaseNode newNode = this.specialize0(moduleValue, nameValue, filenameValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AutoloadBaseNode rootNode = (AutoloadBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.module, rootNode.name, rootNode.filename}, new Object[]{moduleValue, nameValue, filenameValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AutoloadBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }

            static ModuleNodes.AutoloadNode create0(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
                return new AutoloadUninitializedNode(context, sourceSection, module, name, filename);
            }
        }

        @GeneratedBy(value=ModuleNodes.AutoloadNode.class)
        private static abstract class AutoloadBaseNode
        extends ModuleNodes.AutoloadNode
        implements DSLNode {
            @Node.Child
            protected RubyNode module;
            @Node.Child
            protected RubyNode name;
            @Node.Child
            protected RubyNode filename;
            @Node.Child
            protected AutoloadBaseNode next0;

            AutoloadBaseNode(RubyContext context, SourceSection sourceSection, RubyNode module, RubyNode name, RubyNode filename) {
                super(context, sourceSection);
                this.module = module;
                this.name = name;
                this.filename = super.coerceFilenameToString(filename);
            }

            AutoloadBaseNode(AutoloadBaseNode copy) {
                super(copy);
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object moduleValue, Object nameValue, Object filenameValue, String reason) {
                String message;
                AutoloadBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AutoloadBaseNode newNode = this.specialize0(moduleValue, nameValue, filenameValue);
                if (newNode == null) {
                    newNode = new AutoloadUninitializedNode(this);
                    ((AutoloadUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AutoloadBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AutoloadBaseNode.createInfo0(reason, moduleValue, nameValue, filenameValue)))) == null) {
                    returnNode = (AutoloadBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AutoloadUninitializedNode(this), (Node)new AutoloadPolymorphicNode(this), (DSLNode)((AutoloadBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, moduleValue, nameValue, filenameValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AutoloadBaseNode specialize0(Object moduleValue, Object nameValue, Object filenameValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(moduleValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(nameValue)) {
                        return (AutoloadBaseNode)AutoloadRubyModuleRubySymbolNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(nameValue)) {
                        return (AutoloadBaseNode)AutoloadRubyModuleRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.module = null;
                    this.name = null;
                    this.filename = null;
                } else {
                    AutoloadBaseNode otherCast = (AutoloadBaseNode)other;
                    this.module = otherCast.module;
                    this.name = otherCast.name;
                    this.filename = otherCast.filename;
                }
                this.next0 = newNext == null ? null : (AutoloadBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object moduleValue, Object nameValue, Object filenameValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("moduleValue").append(" = ").append(moduleValue);
                    if (moduleValue != null) {
                        builder.append(" (").append(moduleValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("nameValue").append(" = ").append(nameValue);
                    if (nameValue != null) {
                        builder.append(" (").append(nameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("filenameValue").append(" = ").append(filenameValue);
                    if (filenameValue != null) {
                        builder.append(" (").append(filenameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
    public static final class AttrAccessorNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrAccessorNode> {
        private static AttrAccessorNodeFactory attrAccessorNodeFactoryInstance;

        private AttrAccessorNodeFactory() {
            super(ModuleNodes.AttrAccessorNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AttrAccessorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrAccessorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrAccessorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrAccessorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrAccessorNode> getInstance() {
            if (attrAccessorNodeFactoryInstance == null) {
                attrAccessorNodeFactoryInstance = new AttrAccessorNodeFactory();
            }
            return attrAccessorNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrAccessorPolymorphicNode
        extends AttrAccessorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrAccessorPolymorphicNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrAccessorRubyModuleNode
        extends AttrAccessorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrAccessorRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrAccessorRubyModuleNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrAccessor(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrAccessor(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrAccessorNode create0(ModuleNodes.AttrAccessorNode current) {
                return new AttrAccessorRubyModuleNode((AttrAccessorBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrAccessorUninitializedNode
        extends AttrAccessorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrAccessorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrAccessorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrAccessorUninitializedNode(AttrAccessorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrAccessorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrAccessorBaseNode rootNode = (AttrAccessorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AttrAccessorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrAccessorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrAccessorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrAccessorNode.class)
        private static abstract class AttrAccessorBaseNode
        extends ModuleNodes.AttrAccessorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrAccessorBaseNode next0;

            AttrAccessorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrAccessorBaseNode(AttrAccessorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AttrAccessorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrAccessorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrAccessorUninitializedNode(this);
                    ((AttrAccessorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AttrAccessorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AttrAccessorBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AttrAccessorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AttrAccessorUninitializedNode(this), (Node)new AttrAccessorPolymorphicNode(this), (DSLNode)((AttrAccessorBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrAccessorBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrAccessorBaseNode)AttrAccessorRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrAccessorBaseNode otherCast = (AttrAccessorBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrAccessorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
    public static final class AttrWriterNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrWriterNode> {
        private static AttrWriterNodeFactory attrWriterNodeFactoryInstance;

        private AttrWriterNodeFactory() {
            super(ModuleNodes.AttrWriterNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AttrWriterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrWriterNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrWriterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrWriterUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrWriterNode> getInstance() {
            if (attrWriterNodeFactoryInstance == null) {
                attrWriterNodeFactoryInstance = new AttrWriterNodeFactory();
            }
            return attrWriterNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrWriterPolymorphicNode
        extends AttrWriterBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrWriterPolymorphicNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrWriterRubyModuleNode
        extends AttrWriterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrWriterRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrWriterRubyModuleNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrWriter(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrWriter(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrWriterNode create0(ModuleNodes.AttrWriterNode current) {
                return new AttrWriterRubyModuleNode((AttrWriterBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrWriterUninitializedNode
        extends AttrWriterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrWriterUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrWriterUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrWriterUninitializedNode(AttrWriterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrWriterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrWriterBaseNode rootNode = (AttrWriterBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AttrWriterBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrWriterNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrWriterUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrWriterNode.class)
        private static abstract class AttrWriterBaseNode
        extends ModuleNodes.AttrWriterNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrWriterBaseNode next0;

            AttrWriterBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrWriterBaseNode(AttrWriterBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AttrWriterBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrWriterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrWriterUninitializedNode(this);
                    ((AttrWriterUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AttrWriterBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AttrWriterBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AttrWriterBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AttrWriterUninitializedNode(this), (Node)new AttrWriterPolymorphicNode(this), (DSLNode)((AttrWriterBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrWriterBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrWriterBaseNode)AttrWriterRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrWriterBaseNode otherCast = (AttrWriterBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrWriterBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
    public static final class AttrReaderNodeFactory
    extends NodeFactoryBase<ModuleNodes.AttrReaderNode> {
        private static AttrReaderNodeFactory attrReaderNodeFactoryInstance;

        private AttrReaderNodeFactory() {
            super(ModuleNodes.AttrReaderNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AttrReaderNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttrReaderNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AttrReaderNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AttrReaderUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AttrReaderNode> getInstance() {
            if (attrReaderNodeFactoryInstance == null) {
                attrReaderNodeFactoryInstance = new AttrReaderNodeFactory();
            }
            return attrReaderNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AttrReaderPolymorphicNode
        extends AttrReaderBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AttrReaderPolymorphicNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AttrReaderRubyModuleNode
        extends AttrReaderBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrReaderRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object[].class}, 0, 0);

            AttrReaderRubyModuleNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.attrReader(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.attrReader(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrReaderNode create0(ModuleNodes.AttrReaderNode current) {
                return new AttrReaderRubyModuleNode((AttrReaderBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AttrReaderUninitializedNode
        extends AttrReaderBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AttrReaderUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AttrReaderUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AttrReaderUninitializedNode(AttrReaderBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AttrReaderBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AttrReaderBaseNode rootNode = (AttrReaderBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AttrReaderBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AttrReaderNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AttrReaderUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AttrReaderNode.class)
        private static abstract class AttrReaderBaseNode
        extends ModuleNodes.AttrReaderNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AttrReaderBaseNode next0;

            AttrReaderBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AttrReaderBaseNode(AttrReaderBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AttrReaderBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AttrReaderBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AttrReaderUninitializedNode(this);
                    ((AttrReaderUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AttrReaderBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AttrReaderBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AttrReaderBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AttrReaderUninitializedNode(this), (Node)new AttrReaderPolymorphicNode(this), (DSLNode)((AttrReaderBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AttrReaderBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (AttrReaderBaseNode)AttrReaderRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AttrReaderBaseNode otherCast = (AttrReaderBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AttrReaderBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
    public static final class AppendFeaturesNodeFactory
    extends NodeFactoryBase<ModuleNodes.AppendFeaturesNode> {
        private static AppendFeaturesNodeFactory appendFeaturesNodeFactoryInstance;

        private AppendFeaturesNodeFactory() {
            super(ModuleNodes.AppendFeaturesNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AppendFeaturesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AppendFeaturesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AppendFeaturesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AppendFeaturesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AppendFeaturesNode> getInstance() {
            if (appendFeaturesNodeFactoryInstance == null) {
                appendFeaturesNodeFactoryInstance = new AppendFeaturesNodeFactory();
            }
            return appendFeaturesNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AppendFeaturesPolymorphicNode
        extends AppendFeaturesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AppendFeaturesPolymorphicNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AppendFeaturesRubyModuleNode
        extends AppendFeaturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AppendFeaturesRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            AppendFeaturesRubyModuleNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.appendFeatures(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.appendFeatures(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AppendFeaturesNode create0(ModuleNodes.AppendFeaturesNode current) {
                return new AppendFeaturesRubyModuleNode((AppendFeaturesBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AppendFeaturesUninitializedNode
        extends AppendFeaturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AppendFeaturesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AppendFeaturesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AppendFeaturesUninitializedNode(AppendFeaturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AppendFeaturesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AppendFeaturesBaseNode rootNode = (AppendFeaturesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AppendFeaturesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.AppendFeaturesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AppendFeaturesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AppendFeaturesNode.class)
        private static abstract class AppendFeaturesBaseNode
        extends ModuleNodes.AppendFeaturesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AppendFeaturesBaseNode next0;

            AppendFeaturesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AppendFeaturesBaseNode(AppendFeaturesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AppendFeaturesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AppendFeaturesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AppendFeaturesUninitializedNode(this);
                    ((AppendFeaturesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AppendFeaturesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AppendFeaturesBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AppendFeaturesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AppendFeaturesUninitializedNode(this), (Node)new AppendFeaturesPolymorphicNode(this), (DSLNode)((AppendFeaturesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AppendFeaturesBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    return (AppendFeaturesBaseNode)AppendFeaturesRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AppendFeaturesBaseNode otherCast = (AppendFeaturesBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AppendFeaturesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
    public static final class AncestorsNodeFactory
    extends NodeFactoryBase<ModuleNodes.AncestorsNode> {
        private static AncestorsNodeFactory ancestorsNodeFactoryInstance;

        private AncestorsNodeFactory() {
            super(ModuleNodes.AncestorsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AncestorsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AncestorsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AncestorsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AncestorsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AncestorsNode> getInstance() {
            if (ancestorsNodeFactoryInstance == null) {
                ancestorsNodeFactoryInstance = new AncestorsNodeFactory();
            }
            return ancestorsNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AncestorsPolymorphicNode
        extends AncestorsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AncestorsPolymorphicNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AncestorsRubyModuleNode
        extends AncestorsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AncestorsRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class}, 0, 0);

            AncestorsRubyModuleNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyModule");
                }
                return super.ancestors(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.ancestors(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.AncestorsNode create0(ModuleNodes.AncestorsNode current) {
                return new AncestorsRubyModuleNode((AncestorsBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AncestorsUninitializedNode
        extends AncestorsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AncestorsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AncestorsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AncestorsUninitializedNode(AncestorsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AncestorsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AncestorsBaseNode rootNode = (AncestorsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AncestorsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ModuleNodes.AncestorsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AncestorsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AncestorsNode.class)
        private static abstract class AncestorsBaseNode
        extends ModuleNodes.AncestorsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AncestorsBaseNode next0;

            AncestorsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AncestorsBaseNode(AncestorsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                AncestorsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AncestorsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AncestorsUninitializedNode(this);
                    ((AncestorsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AncestorsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AncestorsBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (AncestorsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AncestorsUninitializedNode(this), (Node)new AncestorsPolymorphicNode(this), (DSLNode)((AncestorsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AncestorsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    return (AncestorsBaseNode)AncestorsRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AncestorsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AncestorsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
    public static final class AliasMethodNodeFactory
    extends NodeFactoryBase<ModuleNodes.AliasMethodNode> {
        private static AliasMethodNodeFactory aliasMethodNodeFactoryInstance;

        private AliasMethodNodeFactory() {
            super(ModuleNodes.AliasMethodNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.AliasMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AliasMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.AliasMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AliasMethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.AliasMethodNode> getInstance() {
            if (aliasMethodNodeFactoryInstance == null) {
                aliasMethodNodeFactoryInstance = new AliasMethodNodeFactory();
            }
            return aliasMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AliasMethodPolymorphicNode
        extends AliasMethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            AliasMethodPolymorphicNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : (this.arguments2PolymorphicType == RubySymbol.class ? this.arguments[2].executeRubySymbol(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AliasMethodRubyModuleRubyStringRubyStringNode
        extends AliasMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliasMethodRubyModuleRubyStringRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyString.class, RubyString.class}, 0, 0);

            AliasMethodRubyModuleRubyStringRubyStringNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.aliasMethod(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.aliasMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.AliasMethodNode create0(ModuleNodes.AliasMethodNode current) {
                return new AliasMethodRubyModuleRubyStringRubyStringNode((AliasMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AliasMethodRubyModuleRubySymbolRubySymbolNode
        extends AliasMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliasMethodRubyModuleRubySymbolRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubySymbol.class, RubySymbol.class}, 0, 0);

            AliasMethodRubyModuleRubySymbolRubySymbolNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments2Value;
                RubySymbol arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubySymbol");
                }
                return super.aliasMethod(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments2Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    RubySymbol arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments2Value);
                    return super.aliasMethod(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.AliasMethodNode create0(ModuleNodes.AliasMethodNode current) {
                return new AliasMethodRubyModuleRubySymbolRubySymbolNode((AliasMethodBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AliasMethodUninitializedNode
        extends AliasMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliasMethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AliasMethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AliasMethodUninitializedNode(AliasMethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                AliasMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AliasMethodBaseNode rootNode = (AliasMethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AliasMethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ModuleNodes.AliasMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AliasMethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.AliasMethodNode.class)
        private static abstract class AliasMethodBaseNode
        extends ModuleNodes.AliasMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AliasMethodBaseNode next0;

            AliasMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AliasMethodBaseNode(AliasMethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                AliasMethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AliasMethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new AliasMethodUninitializedNode(this);
                    ((AliasMethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AliasMethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AliasMethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (AliasMethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AliasMethodUninitializedNode(this), (Node)new AliasMethodPolymorphicNode(this), (DSLNode)((AliasMethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AliasMethodBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments2Value)) {
                        return (AliasMethodBaseNode)AliasMethodRubyModuleRubySymbolRubySymbolNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        return (AliasMethodBaseNode)AliasMethodRubyModuleRubyStringRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    AliasMethodBaseNode otherCast = (AliasMethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (AliasMethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<ModuleNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(ModuleNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyModuleRubyBasicObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            CompareRubyModuleRubyBasicObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.compare(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.compare(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(ModuleNodes.CompareNode current) {
                return new CompareRubyModuleRubyBasicObjectNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyModuleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            CompareRubyModuleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.compare(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.compare(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(ModuleNodes.CompareNode current) {
                return new CompareRubyModuleNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends ModuleNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CompareBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
    public static final class IsSuperclassOfOrEqualToNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSuperclassOfOrEqualToNode> {
        private static IsSuperclassOfOrEqualToNodeFactory isSuperclassOfOrEqualToNodeFactoryInstance;

        private IsSuperclassOfOrEqualToNodeFactory() {
            super(ModuleNodes.IsSuperclassOfOrEqualToNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IsSuperclassOfOrEqualToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSuperclassOfOrEqualToNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IsSuperclassOfOrEqualToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsSuperclassOfOrEqualToUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IsSuperclassOfOrEqualToNode> getInstance() {
            if (isSuperclassOfOrEqualToNodeFactoryInstance == null) {
                isSuperclassOfOrEqualToNodeFactoryInstance = new IsSuperclassOfOrEqualToNodeFactory();
            }
            return isSuperclassOfOrEqualToNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsSuperclassOfOrEqualToPolymorphicNode
        extends IsSuperclassOfOrEqualToBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsSuperclassOfOrEqualToPolymorphicNode(IsSuperclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyBasicObject.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSuperclassOfOrEqualToRubyModuleRubyBasicObjectNode
        extends IsSuperclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfOrEqualToRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            IsSuperclassOfOrEqualToRubyModuleRubyBasicObjectNode(IsSuperclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.isSuperclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSuperclassOfOrEqualTo(frameValue, arguments0Value, (RubyBasicObject)arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.isSuperclassOfOrEqualTo(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfOrEqualToNode create0(ModuleNodes.IsSuperclassOfOrEqualToNode current) {
                return new IsSuperclassOfOrEqualToRubyModuleRubyBasicObjectNode((IsSuperclassOfOrEqualToBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSuperclassOfOrEqualToRubyModuleNode
        extends IsSuperclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfOrEqualToRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IsSuperclassOfOrEqualToRubyModuleNode(IsSuperclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isSuperclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSuperclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isSuperclassOfOrEqualTo(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfOrEqualToNode create0(ModuleNodes.IsSuperclassOfOrEqualToNode current) {
                return new IsSuperclassOfOrEqualToRubyModuleNode((IsSuperclassOfOrEqualToBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsSuperclassOfOrEqualToUninitializedNode
        extends IsSuperclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfOrEqualToUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsSuperclassOfOrEqualToUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsSuperclassOfOrEqualToUninitializedNode(IsSuperclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsSuperclassOfOrEqualToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsSuperclassOfOrEqualToBaseNode rootNode = (IsSuperclassOfOrEqualToBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsSuperclassOfOrEqualToBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfOrEqualToNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsSuperclassOfOrEqualToUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfOrEqualToNode.class)
        private static abstract class IsSuperclassOfOrEqualToBaseNode
        extends ModuleNodes.IsSuperclassOfOrEqualToNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsSuperclassOfOrEqualToBaseNode next0;

            IsSuperclassOfOrEqualToBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsSuperclassOfOrEqualToBaseNode(IsSuperclassOfOrEqualToBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IsSuperclassOfOrEqualToBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsSuperclassOfOrEqualToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsSuperclassOfOrEqualToUninitializedNode(this);
                    ((IsSuperclassOfOrEqualToUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsSuperclassOfOrEqualToBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsSuperclassOfOrEqualToBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IsSuperclassOfOrEqualToBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsSuperclassOfOrEqualToUninitializedNode(this), (Node)new IsSuperclassOfOrEqualToPolymorphicNode(this), (DSLNode)((IsSuperclassOfOrEqualToBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsSuperclassOfOrEqualToBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (IsSuperclassOfOrEqualToBaseNode)IsSuperclassOfOrEqualToRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (IsSuperclassOfOrEqualToBaseNode)IsSuperclassOfOrEqualToRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsSuperclassOfOrEqualToBaseNode otherCast = (IsSuperclassOfOrEqualToBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsSuperclassOfOrEqualToBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
    public static final class IsSuperclassOfNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSuperclassOfNode> {
        private static IsSuperclassOfNodeFactory isSuperclassOfNodeFactoryInstance;

        private IsSuperclassOfNodeFactory() {
            super(ModuleNodes.IsSuperclassOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IsSuperclassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSuperclassOfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IsSuperclassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsSuperclassOfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IsSuperclassOfNode> getInstance() {
            if (isSuperclassOfNodeFactoryInstance == null) {
                isSuperclassOfNodeFactoryInstance = new IsSuperclassOfNodeFactory();
            }
            return isSuperclassOfNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsSuperclassOfPolymorphicNode
        extends IsSuperclassOfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsSuperclassOfPolymorphicNode(IsSuperclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyBasicObject.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSuperclassOfRubyModuleRubyBasicObjectNode
        extends IsSuperclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            IsSuperclassOfRubyModuleRubyBasicObjectNode(IsSuperclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.isSuperclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSuperclassOf(frameValue, arguments0Value, (RubyBasicObject)arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.isSuperclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfNode create0(ModuleNodes.IsSuperclassOfNode current) {
                return new IsSuperclassOfRubyModuleRubyBasicObjectNode((IsSuperclassOfBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSuperclassOfRubyModuleNode
        extends IsSuperclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IsSuperclassOfRubyModuleNode(IsSuperclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isSuperclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSuperclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isSuperclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfNode create0(ModuleNodes.IsSuperclassOfNode current) {
                return new IsSuperclassOfRubyModuleNode((IsSuperclassOfBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsSuperclassOfUninitializedNode
        extends IsSuperclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSuperclassOfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsSuperclassOfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsSuperclassOfUninitializedNode(IsSuperclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSuperclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsSuperclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsSuperclassOfBaseNode rootNode = (IsSuperclassOfBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsSuperclassOfBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSuperclassOfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsSuperclassOfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSuperclassOfNode.class)
        private static abstract class IsSuperclassOfBaseNode
        extends ModuleNodes.IsSuperclassOfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsSuperclassOfBaseNode next0;

            IsSuperclassOfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsSuperclassOfBaseNode(IsSuperclassOfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IsSuperclassOfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsSuperclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsSuperclassOfUninitializedNode(this);
                    ((IsSuperclassOfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsSuperclassOfBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsSuperclassOfBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IsSuperclassOfBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsSuperclassOfUninitializedNode(this), (Node)new IsSuperclassOfPolymorphicNode(this), (DSLNode)((IsSuperclassOfBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsSuperclassOfBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (IsSuperclassOfBaseNode)IsSuperclassOfRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (IsSuperclassOfBaseNode)IsSuperclassOfRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsSuperclassOfBaseNode otherCast = (IsSuperclassOfBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsSuperclassOfBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
    public static final class IsSubclassOfOrEqualToNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSubclassOfOrEqualToNode> {
        private static IsSubclassOfOrEqualToNodeFactory isSubclassOfOrEqualToNodeFactoryInstance;

        private IsSubclassOfOrEqualToNodeFactory() {
            super(ModuleNodes.IsSubclassOfOrEqualToNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IsSubclassOfOrEqualToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSubclassOfOrEqualToNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IsSubclassOfOrEqualToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsSubclassOfOrEqualToUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IsSubclassOfOrEqualToNode> getInstance() {
            if (isSubclassOfOrEqualToNodeFactoryInstance == null) {
                isSubclassOfOrEqualToNodeFactoryInstance = new IsSubclassOfOrEqualToNodeFactory();
            }
            return isSubclassOfOrEqualToNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsSubclassOfOrEqualToPolymorphicNode
        extends IsSubclassOfOrEqualToBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsSubclassOfOrEqualToPolymorphicNode(IsSubclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyBasicObject.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfOrEqualToRubyModuleRubyBasicObjectNode
        extends IsSubclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfOrEqualToRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            IsSubclassOfOrEqualToRubyModuleRubyBasicObjectNode(IsSubclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.isSubclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOfOrEqualTo(frameValue, arguments0Value, (RubyBasicObject)arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.isSubclassOfOrEqualTo(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfOrEqualToNode create0(ModuleNodes.IsSubclassOfOrEqualToNode current) {
                return new IsSubclassOfOrEqualToRubyModuleRubyBasicObjectNode((IsSubclassOfOrEqualToBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfOrEqualToRubyModuleNode
        extends IsSubclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfOrEqualToRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IsSubclassOfOrEqualToRubyModuleNode(IsSubclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isSubclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOfOrEqualTo(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isSubclassOfOrEqualTo(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfOrEqualToNode create0(ModuleNodes.IsSubclassOfOrEqualToNode current) {
                return new IsSubclassOfOrEqualToRubyModuleNode((IsSubclassOfOrEqualToBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsSubclassOfOrEqualToUninitializedNode
        extends IsSubclassOfOrEqualToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfOrEqualToUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsSubclassOfOrEqualToUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsSubclassOfOrEqualToUninitializedNode(IsSubclassOfOrEqualToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOfOrEqualTo(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsSubclassOfOrEqualToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsSubclassOfOrEqualToBaseNode rootNode = (IsSubclassOfOrEqualToBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsSubclassOfOrEqualToBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfOrEqualToNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsSubclassOfOrEqualToUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfOrEqualToNode.class)
        private static abstract class IsSubclassOfOrEqualToBaseNode
        extends ModuleNodes.IsSubclassOfOrEqualToNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsSubclassOfOrEqualToBaseNode next0;

            IsSubclassOfOrEqualToBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsSubclassOfOrEqualToBaseNode(IsSubclassOfOrEqualToBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IsSubclassOfOrEqualToBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsSubclassOfOrEqualToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsSubclassOfOrEqualToUninitializedNode(this);
                    ((IsSubclassOfOrEqualToUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsSubclassOfOrEqualToBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsSubclassOfOrEqualToBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IsSubclassOfOrEqualToBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsSubclassOfOrEqualToUninitializedNode(this), (Node)new IsSubclassOfOrEqualToPolymorphicNode(this), (DSLNode)((IsSubclassOfOrEqualToBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsSubclassOfOrEqualToBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (IsSubclassOfOrEqualToBaseNode)IsSubclassOfOrEqualToRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (IsSubclassOfOrEqualToBaseNode)IsSubclassOfOrEqualToRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsSubclassOfOrEqualToBaseNode otherCast = (IsSubclassOfOrEqualToBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsSubclassOfOrEqualToBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
    public static final class IsSubclassOfNodeFactory
    extends NodeFactoryBase<ModuleNodes.IsSubclassOfNode> {
        private static IsSubclassOfNodeFactory isSubclassOfNodeFactoryInstance;

        private IsSubclassOfNodeFactory() {
            super(ModuleNodes.IsSubclassOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.IsSubclassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsSubclassOfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.IsSubclassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsSubclassOfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.IsSubclassOfNode> getInstance() {
            if (isSubclassOfNodeFactoryInstance == null) {
                isSubclassOfNodeFactoryInstance = new IsSubclassOfNodeFactory();
            }
            return isSubclassOfNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsSubclassOfPolymorphicNode
        extends IsSubclassOfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsSubclassOfPolymorphicNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyBasicObject.class ? arguments1ValueEvaluated : arguments1ValueEvaluated);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfRubyModuleRubyBasicObjectNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            IsSubclassOfRubyModuleRubyBasicObjectNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOf(frameValue, arguments0Value, (RubyBasicObject)arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.isSubclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(ModuleNodes.IsSubclassOfNode current) {
                return new IsSubclassOfRubyModuleRubyBasicObjectNode((IsSubclassOfBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsSubclassOfRubyModuleNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyModule.class}, 0, 0);

            IsSubclassOfRubyModuleNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isSubclassOf(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isSubclassOf(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(ModuleNodes.IsSubclassOfNode current) {
                return new IsSubclassOfRubyModuleNode((IsSubclassOfBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsSubclassOfUninitializedNode
        extends IsSubclassOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsSubclassOfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsSubclassOfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsSubclassOfUninitializedNode(IsSubclassOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeIsSubclassOf(VirtualFrame frameValue, RubyModule arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyModule arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsSubclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsSubclassOfBaseNode rootNode = (IsSubclassOfBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsSubclassOfBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.IsSubclassOfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsSubclassOfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.IsSubclassOfNode.class)
        private static abstract class IsSubclassOfBaseNode
        extends ModuleNodes.IsSubclassOfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsSubclassOfBaseNode next0;

            IsSubclassOfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsSubclassOfBaseNode(IsSubclassOfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IsSubclassOfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsSubclassOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsSubclassOfUninitializedNode(this);
                    ((IsSubclassOfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsSubclassOfBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsSubclassOfBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IsSubclassOfBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsSubclassOfUninitializedNode(this), (Node)new IsSubclassOfPolymorphicNode(this), (DSLNode)((IsSubclassOfBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsSubclassOfBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                        return (IsSubclassOfBaseNode)IsSubclassOfRubyModuleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (IsSubclassOfBaseNode)IsSubclassOfRubyModuleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsSubclassOfBaseNode otherCast = (IsSubclassOfBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsSubclassOfBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
    public static final class ContainsInstanceNodeFactory
    extends NodeFactoryBase<ModuleNodes.ContainsInstanceNode> {
        private static ContainsInstanceNodeFactory containsInstanceNodeFactoryInstance;

        private ContainsInstanceNodeFactory() {
            super(ModuleNodes.ContainsInstanceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ModuleNodes.ContainsInstanceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ContainsInstanceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ModuleNodes.ContainsInstanceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ContainsInstanceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ModuleNodes.ContainsInstanceNode> getInstance() {
            if (containsInstanceNodeFactoryInstance == null) {
                containsInstanceNodeFactoryInstance = new ContainsInstanceNodeFactory();
            }
            return containsInstanceNodeFactoryInstance;
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ContainsInstancePolymorphicNode
        extends ContainsInstanceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ContainsInstancePolymorphicNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ContainsInstanceRubyModuleObjectNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceRubyModuleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, Object.class}, 0, 0);

            ContainsInstanceRubyModuleObjectNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyModule");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyBasicObject(arguments1Value)) {
                    return super.containsInstance(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBasicObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && !super.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    return super.containsInstance(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(ModuleNodes.ContainsInstanceNode current) {
                return new ContainsInstanceRubyModuleObjectNode((ContainsInstanceBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ContainsInstanceRubyModuleRubyBasicObjectNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceRubyModuleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyModule.class, RubyBasicObject.class}, 0, 0);

            ContainsInstanceRubyModuleRubyBasicObjectNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                RubyModule arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyModule");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.containsInstance(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyModule arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.containsInstance(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(ModuleNodes.ContainsInstanceNode current) {
                return new ContainsInstanceRubyModuleRubyBasicObjectNode((ContainsInstanceBaseNode)current);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ContainsInstanceUninitializedNode
        extends ContainsInstanceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ContainsInstanceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ContainsInstanceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ContainsInstanceUninitializedNode(ContainsInstanceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ContainsInstanceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ContainsInstanceBaseNode rootNode = (ContainsInstanceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ContainsInstanceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ModuleNodes.ContainsInstanceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ContainsInstanceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ModuleNodes.ContainsInstanceNode.class)
        private static abstract class ContainsInstanceBaseNode
        extends ModuleNodes.ContainsInstanceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ContainsInstanceBaseNode next0;

            ContainsInstanceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ContainsInstanceBaseNode(ContainsInstanceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ContainsInstanceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ContainsInstanceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ContainsInstanceUninitializedNode(this);
                    ((ContainsInstanceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ContainsInstanceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ContainsInstanceBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ContainsInstanceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ContainsInstanceUninitializedNode(this), (Node)new ContainsInstancePolymorphicNode(this), (DSLNode)((ContainsInstanceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ContainsInstanceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                        return (ContainsInstanceBaseNode)ContainsInstanceRubyModuleRubyBasicObjectNode.create0(this);
                    }
                    if (!super.isRubyBasicObject(arguments1Value)) {
                        return (ContainsInstanceBaseNode)ContainsInstanceRubyModuleObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ContainsInstanceBaseNode otherCast = (ContainsInstanceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ContainsInstanceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

