/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@GeneratedBy(value=MethodNodes.class)
public final class MethodNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), ArityNodeFactory.getInstance(), CallNodeFactory.getInstance(), NameNodeFactory.getInstance(), OwnerNodeFactory.getInstance(), ReceiverNodeFactory.getInstance(), SourceLocationNodeFactory.getInstance(), UnbindNodeFactory.getInstance(), ToProcNodeFactory.getInstance());
    }

    @GeneratedBy(value=MethodNodes.ToProcNode.class)
    public static final class ToProcNodeFactory
    extends NodeFactoryBase<MethodNodes.ToProcNode> {
        private static ToProcNodeFactory toProcNodeFactoryInstance;

        private ToProcNodeFactory() {
            super(MethodNodes.ToProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.ToProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.ToProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToProcUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.ToProcNode> getInstance() {
            if (toProcNodeFactoryInstance == null) {
                toProcNodeFactoryInstance = new ToProcNodeFactory();
            }
            return toProcNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToProcPolymorphicNode
        extends ToProcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToProcPolymorphicNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToProcRubyMethodNode
        extends ToProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToProcRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            ToProcRubyMethodNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.toProc(arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.toProc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ToProcNode create0(MethodNodes.ToProcNode current) {
                return new ToProcRubyMethodNode((ToProcBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.ToProcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToProcUninitializedNode
        extends ToProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToProcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToProcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToProcUninitializedNode(ToProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyProc executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToProcBaseNode rootNode = (ToProcBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToProcBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ToProcNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToProcUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.ToProcNode.class)
        private static abstract class ToProcBaseNode
        extends MethodNodes.ToProcNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToProcBaseNode next0;

            ToProcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToProcBaseNode(ToProcBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyProc executeChained0(VirtualFrame var1, Object var2);

            protected final RubyProc rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToProcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToProcUninitializedNode(this);
                    ((ToProcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToProcBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToProcBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToProcBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToProcUninitializedNode(this), (Node)new ToProcPolymorphicNode(this), (DSLNode)((ToProcBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToProcBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (ToProcBaseNode)ToProcRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToProcBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToProcBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.UnbindNode.class)
    public static final class UnbindNodeFactory
    extends NodeFactoryBase<MethodNodes.UnbindNode> {
        private static UnbindNodeFactory unbindNodeFactoryInstance;

        private UnbindNodeFactory() {
            super(MethodNodes.UnbindNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.UnbindNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnbindNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.UnbindNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnbindUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.UnbindNode> getInstance() {
            if (unbindNodeFactoryInstance == null) {
                unbindNodeFactoryInstance = new UnbindNodeFactory();
            }
            return unbindNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.UnbindNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnbindPolymorphicNode
        extends UnbindBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UnbindPolymorphicNode(UnbindBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.UnbindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnbindRubyMethodNode
        extends UnbindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnbindRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            UnbindRubyMethodNode(UnbindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.unbind(arguments0Value);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.unbind(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.UnbindNode create0(MethodNodes.UnbindNode current) {
                return new UnbindRubyMethodNode((UnbindBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.UnbindNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnbindUninitializedNode
        extends UnbindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnbindUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnbindUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnbindUninitializedNode(UnbindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod value;
                try {
                    value = this.executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyUnboundMethod executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyUnboundMethod executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UnbindBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnbindBaseNode rootNode = (UnbindBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnbindBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.UnbindNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnbindUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.UnbindNode.class)
        private static abstract class UnbindBaseNode
        extends MethodNodes.UnbindNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnbindBaseNode next0;

            UnbindBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnbindBaseNode(UnbindBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyUnboundMethod executeChained0(VirtualFrame var1, Object var2);

            protected final RubyUnboundMethod rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UnbindBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnbindBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UnbindUninitializedNode(this);
                    ((UnbindUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnbindBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UnbindBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UnbindBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnbindUninitializedNode(this), (Node)new UnbindPolymorphicNode(this), (DSLNode)((UnbindBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnbindBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (UnbindBaseNode)UnbindRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UnbindBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UnbindBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.SourceLocationNode.class)
    public static final class SourceLocationNodeFactory
    extends NodeFactoryBase<MethodNodes.SourceLocationNode> {
        private static SourceLocationNodeFactory sourceLocationNodeFactoryInstance;

        private SourceLocationNodeFactory() {
            super(MethodNodes.SourceLocationNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.SourceLocationNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SourceLocationNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.SourceLocationNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SourceLocationUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.SourceLocationNode> getInstance() {
            if (sourceLocationNodeFactoryInstance == null) {
                sourceLocationNodeFactoryInstance = new SourceLocationNodeFactory();
            }
            return sourceLocationNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SourceLocationPolymorphicNode
        extends SourceLocationBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SourceLocationPolymorphicNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SourceLocationRubyMethodNode
        extends SourceLocationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceLocationRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            SourceLocationRubyMethodNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.sourceLocation(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.sourceLocation(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.SourceLocationNode create0(MethodNodes.SourceLocationNode current) {
                return new SourceLocationRubyMethodNode((SourceLocationBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SourceLocationUninitializedNode
        extends SourceLocationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceLocationUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SourceLocationUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SourceLocationUninitializedNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SourceLocationBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SourceLocationBaseNode rootNode = (SourceLocationBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SourceLocationBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.SourceLocationNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SourceLocationUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.SourceLocationNode.class)
        private static abstract class SourceLocationBaseNode
        extends MethodNodes.SourceLocationNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SourceLocationBaseNode next0;

            SourceLocationBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SourceLocationBaseNode(SourceLocationBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SourceLocationBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SourceLocationBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SourceLocationUninitializedNode(this);
                    ((SourceLocationUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SourceLocationBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SourceLocationBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SourceLocationBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SourceLocationUninitializedNode(this), (Node)new SourceLocationPolymorphicNode(this), (DSLNode)((SourceLocationBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SourceLocationBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (SourceLocationBaseNode)SourceLocationRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SourceLocationBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SourceLocationBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.ReceiverNode.class)
    public static final class ReceiverNodeFactory
    extends NodeFactoryBase<MethodNodes.ReceiverNode> {
        private static ReceiverNodeFactory receiverNodeFactoryInstance;

        private ReceiverNodeFactory() {
            super(MethodNodes.ReceiverNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.ReceiverNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReceiverNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.ReceiverNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReceiverUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.ReceiverNode> getInstance() {
            if (receiverNodeFactoryInstance == null) {
                receiverNodeFactoryInstance = new ReceiverNodeFactory();
            }
            return receiverNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.ReceiverNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReceiverPolymorphicNode
        extends ReceiverBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReceiverPolymorphicNode(ReceiverBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.ReceiverNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReceiverRubyMethodNode
        extends ReceiverBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReceiverRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            ReceiverRubyMethodNode(ReceiverBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.receiver(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.receiver(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ReceiverNode create0(MethodNodes.ReceiverNode current) {
                return new ReceiverRubyMethodNode((ReceiverBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.ReceiverNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReceiverUninitializedNode
        extends ReceiverBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReceiverUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReceiverUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReceiverUninitializedNode(ReceiverBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReceiverBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReceiverBaseNode rootNode = (ReceiverBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReceiverBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ReceiverNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReceiverUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.ReceiverNode.class)
        private static abstract class ReceiverBaseNode
        extends MethodNodes.ReceiverNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReceiverBaseNode next0;

            ReceiverBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReceiverBaseNode(ReceiverBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ReceiverBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReceiverBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReceiverUninitializedNode(this);
                    ((ReceiverUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReceiverBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ReceiverBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ReceiverBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReceiverUninitializedNode(this), (Node)new ReceiverPolymorphicNode(this), (DSLNode)((ReceiverBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReceiverBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (ReceiverBaseNode)ReceiverRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReceiverBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReceiverBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.OwnerNode.class)
    public static final class OwnerNodeFactory
    extends NodeFactoryBase<MethodNodes.OwnerNode> {
        private static OwnerNodeFactory ownerNodeFactoryInstance;

        private OwnerNodeFactory() {
            super(MethodNodes.OwnerNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.OwnerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OwnerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.OwnerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OwnerUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.OwnerNode> getInstance() {
            if (ownerNodeFactoryInstance == null) {
                ownerNodeFactoryInstance = new OwnerNodeFactory();
            }
            return ownerNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OwnerPolymorphicNode
        extends OwnerBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            OwnerPolymorphicNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OwnerRubyMethodNode
        extends OwnerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OwnerRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            OwnerRubyMethodNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.owner(arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.owner(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.OwnerNode create0(MethodNodes.OwnerNode current) {
                return new OwnerRubyMethodNode((OwnerBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OwnerUninitializedNode
        extends OwnerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OwnerUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OwnerUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OwnerUninitializedNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                OwnerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OwnerBaseNode rootNode = (OwnerBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((OwnerBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.OwnerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OwnerUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.OwnerNode.class)
        private static abstract class OwnerBaseNode
        extends MethodNodes.OwnerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OwnerBaseNode next0;

            OwnerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OwnerBaseNode(OwnerBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                OwnerBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OwnerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new OwnerUninitializedNode(this);
                    ((OwnerUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (OwnerBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = OwnerBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (OwnerBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new OwnerUninitializedNode(this), (Node)new OwnerPolymorphicNode(this), (DSLNode)((OwnerBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OwnerBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (OwnerBaseNode)OwnerRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OwnerBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (OwnerBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<MethodNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(MethodNodes.NameNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NamePolymorphicNode
        extends NameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NamePolymorphicNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameRubyMethodNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            NameRubyMethodNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.name(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.name(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.NameNode create0(MethodNodes.NameNode current) {
                return new NameRubyMethodNode((NameBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NameUninitializedNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NameUninitializedNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NameBaseNode rootNode = (NameBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NameBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.NameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.NameNode.class)
        private static abstract class NameBaseNode
        extends MethodNodes.NameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NameBaseNode next0;

            NameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NameBaseNode(NameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                NameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NameUninitializedNode(this);
                    ((NameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NameBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NameBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (NameBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NameUninitializedNode(this), (Node)new NamePolymorphicNode(this), (DSLNode)((NameBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (NameBaseNode)NameRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NameBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.CallNode.class)
    public static final class CallNodeFactory
    extends NodeFactoryBase<MethodNodes.CallNode> {
        private static CallNodeFactory callNodeFactoryInstance;

        private CallNodeFactory() {
            super(MethodNodes.CallNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.CallNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CallNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.CallNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CallUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.CallNode> getInstance() {
            if (callNodeFactoryInstance == null) {
                callNodeFactoryInstance = new CallNodeFactory();
            }
            return callNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CallPolymorphicNode
        extends CallBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            CallPolymorphicNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CallRubyMethodRubyProcNode
        extends CallBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallRubyMethodRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class, Object[].class, RubyProc.class}, 0, 0);

            CallRubyMethodRubyProcNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyMethod");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.doCall(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.doCall(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static MethodNodes.CallNode create0(MethodNodes.CallNode current) {
                return new CallRubyMethodRubyProcNode((CallBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CallRubyMethodUndefinedPlaceholderNode
        extends CallBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallRubyMethodUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class, Object[].class, UndefinedPlaceholder.class}, 0, 0);

            CallRubyMethodUndefinedPlaceholderNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                Object[] arguments1Value;
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyMethod");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.call(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.call(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static MethodNodes.CallNode create0(MethodNodes.CallNode current) {
                return new CallRubyMethodUndefinedPlaceholderNode((CallBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CallUninitializedNode
        extends CallBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CallUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CallUninitializedNode(CallBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                CallBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CallBaseNode rootNode = (CallBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CallBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static MethodNodes.CallNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CallUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.CallNode.class)
        private static abstract class CallBaseNode
        extends MethodNodes.CallNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CallBaseNode next0;

            CallBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CallBaseNode(CallBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                CallBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CallBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new CallUninitializedNode(this);
                    ((CallUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CallBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CallBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (CallBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CallUninitializedNode(this), (Node)new CallPolymorphicNode(this), (DSLNode)((CallBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CallBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (CallBaseNode)CallRubyMethodUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        return (CallBaseNode)CallRubyMethodRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    CallBaseNode otherCast = (CallBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (CallBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.ArityNode.class)
    public static final class ArityNodeFactory
    extends NodeFactoryBase<MethodNodes.ArityNode> {
        private static ArityNodeFactory arityNodeFactoryInstance;

        private ArityNodeFactory() {
            super(MethodNodes.ArityNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.ArityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ArityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.ArityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ArityUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.ArityNode> getInstance() {
            if (arityNodeFactoryInstance == null) {
                arityNodeFactoryInstance = new ArityNodeFactory();
            }
            return arityNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ArityPolymorphicNode
        extends ArityBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ArityPolymorphicNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ArityRubyMethodNode
        extends ArityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ArityRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class}, 0, 0);

            ArityRubyMethodNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMethod");
                }
                return super.arity(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.arity(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ArityNode create0(MethodNodes.ArityNode current) {
                return new ArityRubyMethodNode((ArityBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ArityUninitializedNode
        extends ArityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ArityUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ArityUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ArityUninitializedNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ArityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ArityBaseNode rootNode = (ArityBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ArityBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MethodNodes.ArityNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ArityUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.ArityNode.class)
        private static abstract class ArityBaseNode
        extends MethodNodes.ArityNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ArityBaseNode next0;

            ArityBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ArityBaseNode(ArityBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ArityBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ArityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ArityUninitializedNode(this);
                    ((ArityUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ArityBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArityBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ArityBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArityUninitializedNode(this), (Node)new ArityPolymorphicNode(this), (DSLNode)((ArityBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ArityBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    return (ArityBaseNode)ArityRubyMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ArityBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ArityBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MethodNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<MethodNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(MethodNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MethodNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MethodNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MethodNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=MethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyMethod.class ? this.arguments[1].executeRubyMethod(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyMethodObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyMethodObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class, Object.class}, 0, 0);

            EqualRubyMethodObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyMethod");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyMethod(arguments1Value)) {
                    return super.equal(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyMethod] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && !super.isRubyMethod(arguments1Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    return super.equal(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MethodNodes.EqualNode create0(MethodNodes.EqualNode current) {
                return new EqualRubyMethodObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyMethodNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMethod.class, RubyMethod.class}, 0, 0);

            EqualRubyMethodNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMethod arguments1Value;
                RubyMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMethod");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyMethod");
                }
                return super.equal(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyMethod(arguments1Value)) {
                    RubyMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments0Value);
                    RubyMethod arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyMethod(arguments1Value);
                    return super.equal(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MethodNodes.EqualNode create0(MethodNodes.EqualNode current) {
                return new EqualRubyMethodNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=MethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MethodNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MethodNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends MethodNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyMethod(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyMethodNode.create0(this);
                    }
                    if (!super.isRubyMethod(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyMethodObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

