/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.HashGuards;
import org.jruby.truffle.nodes.core.HashNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=HashNodes.class)
public final class HashNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(ConstructNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), GetOrUndefinedNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompareByIdentityNodeFactory.getInstance(), IsCompareByIdentityNodeFactory.getInstance(), DefaultProcNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), EachNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), MapNodeFactory.getInstance(), MergeNodeFactory.getInstance(), SetDefaultNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), RehashNodeFactory.getInstance(), DefaultValueNodeFactory.getInstance(), SetDefaultValueNodeFactory.getInstance(), SetDefaultProcNodeFactory.getInstance());
    }

    @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
    public static final class SetDefaultProcNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultProcNode> {
        private static SetDefaultProcNodeFactory setDefaultProcNodeFactoryInstance;

        private SetDefaultProcNodeFactory() {
            super(HashNodes.SetDefaultProcNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public HashNodes.SetDefaultProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SetDefaultProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SetDefaultProcNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
            return SetDefaultProcUninitializedNode.create0(context, sourceSection, self, defaultProc);
        }

        public static NodeFactory<HashNodes.SetDefaultProcNode> getInstance() {
            if (setDefaultProcNodeFactoryInstance == null) {
                setDefaultProcNodeFactoryInstance = new SetDefaultProcNodeFactory();
            }
            return setDefaultProcNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetDefaultProcPolymorphicNode
        extends SetDefaultProcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> defaultProcPolymorphicType;

            SetDefaultProcPolymorphicNode(SetDefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object defaultProcValue;
                Object selfValue = this.self.execute(frameValue);
                try {
                    defaultProcValue = this.defaultProcPolymorphicType == RubyNilClass.class ? this.defaultProc.executeRubyNilClass(frameValue) : (this.defaultProcPolymorphicType == RubyProc.class ? this.defaultProc.executeRubyProc(frameValue) : this.defaultProc.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.defaultProcPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, selfValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, selfValue, defaultProcValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.defaultProcPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                return this.next0.executeChained0(frameValue, selfValue, defaultProcValue);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultProcRubyNilClassNode
        extends SetDefaultProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultProcRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyNilClass.class}, 0, 0);

            SetDefaultProcRubyNilClassNode(SetDefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass defaultProcValue;
                RubyHash selfValue;
                try {
                    selfValue = this.self.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object defaultProcValue2 = this.defaultProc.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), defaultProcValue2, "Expected selfValue instanceof RubyHash"));
                }
                try {
                    defaultProcValue = this.defaultProc.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected defaultProcValue instanceof RubyNilClass"));
                }
                return super.setDefaultProc(selfValue, defaultProcValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue) && RubyTypesGen.RUBYTYPES.isRubyNilClass(defaultProcValue)) {
                    RubyHash selfValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(selfValue);
                    RubyNilClass defaultProcValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(defaultProcValue);
                    return super.setDefaultProc(selfValueCast, defaultProcValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, defaultProcValue);
            }

            static HashNodes.SetDefaultProcNode create0(HashNodes.SetDefaultProcNode current) {
                return new SetDefaultProcRubyNilClassNode((SetDefaultProcBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultProcRubyProcNode
        extends SetDefaultProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultProcRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            SetDefaultProcRubyProcNode(SetDefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc defaultProcValue;
                RubyHash selfValue;
                try {
                    selfValue = this.self.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object defaultProcValue2 = this.defaultProc.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyProc(this.rewrite0(frameValue, ex.getResult(), defaultProcValue2, "Expected selfValue instanceof RubyHash"));
                }
                try {
                    defaultProcValue = this.defaultProc.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyProc(this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected defaultProcValue instanceof RubyProc"));
                }
                return super.setDefaultProc(selfValue, defaultProcValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue) && RubyTypesGen.RUBYTYPES.isRubyProc(defaultProcValue)) {
                    RubyHash selfValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(selfValue);
                    RubyProc defaultProcValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(defaultProcValue);
                    return super.setDefaultProc(selfValueCast, defaultProcValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, defaultProcValue);
            }

            static HashNodes.SetDefaultProcNode create0(HashNodes.SetDefaultProcNode current) {
                return new SetDefaultProcRubyProcNode((SetDefaultProcBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetDefaultProcUninitializedNode
        extends SetDefaultProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultProcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetDefaultProcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
                super(context, sourceSection, self, defaultProc);
            }

            SetDefaultProcUninitializedNode(SetDefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object defaultProcValue = this.defaultProc.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, defaultProcValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, defaultProcValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                SetDefaultProcBaseNode newNode = this.specialize0(selfValue, defaultProcValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetDefaultProcBaseNode rootNode = (SetDefaultProcBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.defaultProc}, new Object[]{selfValue, defaultProcValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetDefaultProcBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, defaultProcValue);
            }

            static HashNodes.SetDefaultProcNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
                return new SetDefaultProcUninitializedNode(context, sourceSection, self, defaultProc);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        private static abstract class SetDefaultProcBaseNode
        extends HashNodes.SetDefaultProcNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode defaultProc;
            @Node.Child
            protected SetDefaultProcBaseNode next0;

            SetDefaultProcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultProc) {
                super(context, sourceSection);
                this.self = self;
                this.defaultProc = defaultProc;
            }

            SetDefaultProcBaseNode(SetDefaultProcBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, Object defaultProcValue, String reason) {
                String message;
                SetDefaultProcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetDefaultProcBaseNode newNode = this.specialize0(selfValue, defaultProcValue);
                if (newNode == null) {
                    newNode = new SetDefaultProcUninitializedNode(this);
                    ((SetDefaultProcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetDefaultProcBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetDefaultProcBaseNode.createInfo0(reason, selfValue, defaultProcValue)))) == null) {
                    returnNode = (SetDefaultProcBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetDefaultProcUninitializedNode(this), (Node)new SetDefaultProcPolymorphicNode(this), (DSLNode)((SetDefaultProcBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, defaultProcValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetDefaultProcBaseNode specialize0(Object selfValue, Object defaultProcValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(defaultProcValue)) {
                        return (SetDefaultProcBaseNode)SetDefaultProcRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyNilClass(defaultProcValue)) {
                        return (SetDefaultProcBaseNode)SetDefaultProcRubyNilClassNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.defaultProc = null;
                } else {
                    SetDefaultProcBaseNode otherCast = (SetDefaultProcBaseNode)other;
                    this.self = otherCast.self;
                    this.defaultProc = otherCast.defaultProc;
                }
                this.next0 = newNext == null ? null : (SetDefaultProcBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object defaultProcValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("defaultProcValue").append(" = ").append(defaultProcValue);
                    if (defaultProcValue != null) {
                        builder.append(" (").append(defaultProcValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
    public static final class SetDefaultValueNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultValueNode> {
        private static SetDefaultValueNodeFactory setDefaultValueNodeFactoryInstance;

        private SetDefaultValueNodeFactory() {
            super(HashNodes.SetDefaultValueNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public HashNodes.SetDefaultValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SetDefaultValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SetDefaultValueNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
            return SetDefaultValueUninitializedNode.create0(context, sourceSection, self, defaultValue);
        }

        public static NodeFactory<HashNodes.SetDefaultValueNode> getInstance() {
            if (setDefaultValueNodeFactoryInstance == null) {
                setDefaultValueNodeFactoryInstance = new SetDefaultValueNodeFactory();
            }
            return setDefaultValueNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetDefaultValuePolymorphicNode
        extends SetDefaultValueBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> defaultValuePolymorphicType;

            SetDefaultValuePolymorphicNode(SetDefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                Object defaultValueValue = this.defaultValue.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, defaultValueValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.defaultValuePolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultValueValue) {
                return this.next0.executeChained0(frameValue, selfValue, defaultValueValue);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultValueRubyHashNode
        extends SetDefaultValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultValueRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            SetDefaultValueRubyHashNode(SetDefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash selfValue;
                try {
                    selfValue = this.self.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object defaultValueValue = this.defaultValue.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), defaultValueValue, "Expected selfValue instanceof RubyHash");
                }
                Object defaultValueValue = this.defaultValue.execute(frameValue);
                return super.setDefaultValue(selfValue, defaultValueValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultValueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue)) {
                    RubyHash selfValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(selfValue);
                    return super.setDefaultValue(selfValueCast, defaultValueValue);
                }
                return this.next0.executeChained0(frameValue, selfValue, defaultValueValue);
            }

            static HashNodes.SetDefaultValueNode create0(HashNodes.SetDefaultValueNode current) {
                return new SetDefaultValueRubyHashNode((SetDefaultValueBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetDefaultValueUninitializedNode
        extends SetDefaultValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultValueUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetDefaultValueUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
                super(context, sourceSection, self, defaultValue);
            }

            SetDefaultValueUninitializedNode(SetDefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object defaultValueValue = this.defaultValue.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, defaultValueValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object defaultValueValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, defaultValueValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object defaultValueValue) {
                SetDefaultValueBaseNode newNode = this.specialize0(selfValue, defaultValueValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetDefaultValueBaseNode rootNode = (SetDefaultValueBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.defaultValue}, new Object[]{selfValue, defaultValueValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetDefaultValueBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, defaultValueValue);
            }

            static HashNodes.SetDefaultValueNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
                return new SetDefaultValueUninitializedNode(context, sourceSection, self, defaultValue);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        private static abstract class SetDefaultValueBaseNode
        extends HashNodes.SetDefaultValueNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode defaultValue;
            @Node.Child
            protected SetDefaultValueBaseNode next0;

            SetDefaultValueBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode defaultValue) {
                super(context, sourceSection);
                this.self = self;
                this.defaultValue = defaultValue;
            }

            SetDefaultValueBaseNode(SetDefaultValueBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, Object defaultValueValue, String reason) {
                String message;
                SetDefaultValueBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetDefaultValueBaseNode newNode = this.specialize0(selfValue, defaultValueValue);
                if (newNode == null) {
                    newNode = new SetDefaultValueUninitializedNode(this);
                    ((SetDefaultValueUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetDefaultValueBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetDefaultValueBaseNode.createInfo0(reason, selfValue, defaultValueValue)))) == null) {
                    returnNode = (SetDefaultValueBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetDefaultValueUninitializedNode(this), (Node)new SetDefaultValuePolymorphicNode(this), (DSLNode)((SetDefaultValueBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, defaultValueValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetDefaultValueBaseNode specialize0(Object selfValue, Object defaultValueValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue)) {
                    return (SetDefaultValueBaseNode)SetDefaultValueRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.defaultValue = null;
                } else {
                    SetDefaultValueBaseNode otherCast = (SetDefaultValueBaseNode)other;
                    this.self = otherCast.self;
                    this.defaultValue = otherCast.defaultValue;
                }
                this.next0 = newNext == null ? null : (SetDefaultValueBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object defaultValueValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("defaultValueValue").append(" = ").append(defaultValueValue);
                    if (defaultValueValue != null) {
                        builder.append(" (").append(defaultValueValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultValueNode.class)
    public static final class DefaultValueNodeFactory
    extends NodeFactoryBase<HashNodes.DefaultValueNode> {
        private static DefaultValueNodeFactory defaultValueNodeFactoryInstance;

        private DefaultValueNodeFactory() {
            super(HashNodes.DefaultValueNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public HashNodes.DefaultValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return DefaultValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.DefaultValueNode create(RubyContext context, SourceSection sourceSection, RubyNode self) {
            return DefaultValueUninitializedNode.create0(context, sourceSection, self);
        }

        public static NodeFactory<HashNodes.DefaultValueNode> getInstance() {
            if (defaultValueNodeFactoryInstance == null) {
                defaultValueNodeFactoryInstance = new DefaultValueNodeFactory();
            }
            return defaultValueNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefaultValuePolymorphicNode
        extends DefaultValueBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;

            DefaultValuePolymorphicNode(DefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                return this.next0.executeChained0(frameValue, selfValue);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultValueRubyHashNode
        extends DefaultValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultValueRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            DefaultValueRubyHashNode(DefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash selfValue;
                try {
                    selfValue = this.self.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected selfValue instanceof RubyHash");
                }
                return super.defaultValue(selfValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue)) {
                    RubyHash selfValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(selfValue);
                    return super.defaultValue(selfValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue);
            }

            static HashNodes.DefaultValueNode create0(HashNodes.DefaultValueNode current) {
                return new DefaultValueRubyHashNode((DefaultValueBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefaultValueUninitializedNode
        extends DefaultValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultValueUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefaultValueUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection, self);
            }

            DefaultValueUninitializedNode(DefaultValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue) {
                DefaultValueBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefaultValueBaseNode rootNode = (DefaultValueBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self}, new Object[]{selfValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DefaultValueBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue);
            }

            static HashNodes.DefaultValueNode create0(RubyContext context, SourceSection sourceSection, RubyNode self) {
                return new DefaultValueUninitializedNode(context, sourceSection, self);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        private static abstract class DefaultValueBaseNode
        extends HashNodes.DefaultValueNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected DefaultValueBaseNode next0;

            DefaultValueBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection);
                this.self = self;
            }

            DefaultValueBaseNode(DefaultValueBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, String reason) {
                String message;
                DefaultValueBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefaultValueBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    newNode = new DefaultValueUninitializedNode(this);
                    ((DefaultValueUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DefaultValueBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DefaultValueBaseNode.createInfo0(reason, selfValue)))) == null) {
                    returnNode = (DefaultValueBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DefaultValueUninitializedNode(this), (Node)new DefaultValuePolymorphicNode(this), (DSLNode)((DefaultValueBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefaultValueBaseNode specialize0(Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(selfValue)) {
                    return (DefaultValueBaseNode)DefaultValueRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.self = other == null ? null : ((DefaultValueBaseNode)other).self;
                this.next0 = newNext == null ? null : (DefaultValueBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.RehashNode.class)
    public static final class RehashNodeFactory
    extends NodeFactoryBase<HashNodes.RehashNode> {
        private static RehashNodeFactory rehashNodeFactoryInstance;

        private RehashNodeFactory() {
            super(HashNodes.RehashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.RehashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RehashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.RehashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RehashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.RehashNode> getInstance() {
            if (rehashNodeFactoryInstance == null) {
                rehashNodeFactoryInstance = new RehashNodeFactory();
            }
            return rehashNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RehashPolymorphicNode
        extends RehashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RehashPolymorphicNode(RehashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RehashRubyHash2Node
        extends RehashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RehashRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            RehashRubyHash2Node(RehashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.rehashBuckets(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.rehashBuckets(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.RehashNode create0(HashNodes.RehashNode current) {
                return new RehashRubyHash2Node((RehashBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RehashRubyHash1Node
        extends RehashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RehashRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            RehashRubyHash1Node(RehashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.rehashPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.rehashPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.RehashNode create0(HashNodes.RehashNode current) {
                return new RehashRubyHash1Node((RehashBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RehashRubyHash0Node
        extends RehashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RehashRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            RehashRubyHash0Node(RehashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.rehashNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.rehashNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.RehashNode create0(HashNodes.RehashNode current) {
                return new RehashRubyHash0Node((RehashBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RehashUninitializedNode
        extends RehashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RehashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RehashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RehashUninitializedNode(RehashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RehashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RehashBaseNode rootNode = (RehashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RehashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.RehashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RehashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        private static abstract class RehashBaseNode
        extends HashNodes.RehashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RehashBaseNode next0;

            RehashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RehashBaseNode(RehashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RehashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RehashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RehashUninitializedNode(this);
                    ((RehashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RehashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RehashBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RehashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RehashUninitializedNode(this), (Node)new RehashPolymorphicNode(this), (DSLNode)((RehashBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RehashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (RehashBaseNode)RehashRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (RehashBaseNode)RehashRubyHash1Node.create0(this);
                    }
                    return (RehashBaseNode)RehashRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RehashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RehashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<HashNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(HashNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyHash1Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            SizeRubyHash1Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.sizePackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.sizePackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(HashNodes.SizeNode current) {
                return new SizeRubyHash1Node((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyHash0Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            SizeRubyHash0Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.sizeNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.sizeNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(HashNodes.SizeNode current) {
                return new SizeRubyHash0Node((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends HashNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (SizeBaseNode)SizeRubyHash0Node.create0(this);
                    }
                    return (SizeBaseNode)SizeRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<HashNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(HashNodes.ShiftNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ShiftPolymorphicNode
        extends ShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ShiftPolymorphicNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArray1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ShiftRubyArray1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash"));
                }
                if (!HashGuards.isEmpty(arguments0Value) && HashGuards.isBuckets(arguments0Value)) {
                    return super.shiftBuckets(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, "One of guards [!isEmpty, isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.shiftBuckets(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(HashNodes.ShiftNode current) {
                return new ShiftRubyArray1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArray0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ShiftRubyArray0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash"));
                }
                if (!(HashGuards.isEmpty(arguments0Value) || HashGuards.isNull(arguments0Value) || HashGuards.isBuckets(arguments0Value))) {
                    return super.shiftPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, "One of guards [!isEmpty, !isNull, !isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.shiftPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(HashNodes.ShiftNode current) {
                return new ShiftRubyArray0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ShiftObject1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isEmpty(arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value) && HashGuards.hasDefaultBlock(arguments0Value)) {
                    return super.shiftEmptyDefaultProc(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isEmpty, !hasDefaultValue, hasDefaultBlock] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.hasDefaultValue(arguments0ValueCast) && HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                    return super.shiftEmptyDefaultProc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(HashNodes.ShiftNode current) {
                return new ShiftObject1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ShiftObject0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isEmpty(arguments0Value) && HashGuards.hasDefaultValue(arguments0Value) && !HashGuards.hasDefaultBlock(arguments0Value)) {
                    return super.shiftEmpyDefaultValue(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isEmpty, hasDefaultValue, !hasDefaultBlock] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && HashGuards.hasDefaultValue(arguments0ValueCast) && !HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                    return super.shiftEmpyDefaultValue(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(HashNodes.ShiftNode current) {
                return new ShiftObject0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyNilClassNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ShiftRubyNilClassNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash"));
                }
                if (HashGuards.isEmpty(arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value) && !HashGuards.hasDefaultBlock(arguments0Value)) {
                    return super.shiftEmpty(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, "One of guards [isEmpty, !hasDefaultValue, !hasDefaultBlock] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.hasDefaultValue(arguments0ValueCast) && !HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                    return super.shiftEmpty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(HashNodes.ShiftNode current) {
                return new ShiftRubyNilClassNode((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ShiftUninitializedNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ShiftUninitializedNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ShiftBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ShiftBaseNode rootNode = (ShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        private static abstract class ShiftBaseNode
        extends HashNodes.ShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ShiftBaseNode next0;

            ShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ShiftBaseNode(ShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ShiftBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ShiftUninitializedNode(this);
                    ((ShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ShiftBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ShiftUninitializedNode(this), (Node)new ShiftPolymorphicNode(this), (DSLNode)((ShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ShiftBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isEmpty(arguments0ValueCast) && !HashGuards.hasDefaultValue(arguments0ValueCast) && !HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                        return (ShiftBaseNode)ShiftRubyNilClassNode.create0(this);
                    }
                    if (HashGuards.isEmpty(arguments0ValueCast) && HashGuards.hasDefaultValue(arguments0ValueCast) && !HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                        return (ShiftBaseNode)ShiftObject0Node.create0(this);
                    }
                    if (HashGuards.isEmpty(arguments0ValueCast) && !HashGuards.hasDefaultValue(arguments0ValueCast) && HashGuards.hasDefaultBlock(arguments0ValueCast)) {
                        return (ShiftBaseNode)ShiftObject1Node.create0(this);
                    }
                    if (!(HashGuards.isEmpty(arguments0ValueCast) || HashGuards.isNull(arguments0ValueCast) || HashGuards.isBuckets(arguments0ValueCast))) {
                        return (ShiftBaseNode)ShiftRubyArray0Node.create0(this);
                    }
                    if (!HashGuards.isEmpty(arguments0ValueCast) && HashGuards.isBuckets(arguments0ValueCast)) {
                        return (ShiftBaseNode)ShiftRubyArray1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ShiftBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultNode.class)
    public static final class SetDefaultNodeFactory
    extends NodeFactoryBase<HashNodes.SetDefaultNode> {
        private static SetDefaultNodeFactory setDefaultNodeFactoryInstance;

        private SetDefaultNodeFactory() {
            super(HashNodes.SetDefaultNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.SetDefaultNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetDefaultNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SetDefaultNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetDefaultUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.SetDefaultNode> getInstance() {
            if (setDefaultNodeFactoryInstance == null) {
                setDefaultNodeFactoryInstance = new SetDefaultNodeFactory();
            }
            return setDefaultNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetDefaultPolymorphicNode
        extends SetDefaultBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SetDefaultPolymorphicNode(SetDefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultRubyHashNode
        extends SetDefaultBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            SetDefaultRubyHashNode(SetDefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.setDefault(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.setDefault(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.SetDefaultNode create0(HashNodes.SetDefaultNode current) {
                return new SetDefaultRubyHashNode((SetDefaultBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetDefaultUninitializedNode
        extends SetDefaultBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetDefaultUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetDefaultUninitializedNode(SetDefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SetDefaultBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetDefaultBaseNode rootNode = (SetDefaultBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetDefaultBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.SetDefaultNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetDefaultUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        private static abstract class SetDefaultBaseNode
        extends HashNodes.SetDefaultNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetDefaultBaseNode next0;

            SetDefaultBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetDefaultBaseNode(SetDefaultBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SetDefaultBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetDefaultBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SetDefaultUninitializedNode(this);
                    ((SetDefaultUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetDefaultBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetDefaultBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SetDefaultBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetDefaultUninitializedNode(this), (Node)new SetDefaultPolymorphicNode(this), (DSLNode)((SetDefaultBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetDefaultBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (SetDefaultBaseNode)SetDefaultRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SetDefaultBaseNode otherCast = (SetDefaultBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SetDefaultBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.MergeNode.class)
    public static final class MergeNodeFactory
    extends NodeFactoryBase<HashNodes.MergeNode> {
        private static MergeNodeFactory mergeNodeFactoryInstance;

        private MergeNodeFactory() {
            super(HashNodes.MergeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.MergeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MergeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.MergeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MergeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.MergeNode> getInstance() {
            if (mergeNodeFactoryInstance == null) {
                mergeNodeFactoryInstance = new MergeNodeFactory();
            }
            return mergeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MergePolymorphicNode
        extends MergeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            MergePolymorphicNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyHash.class ? this.arguments[1].executeRubyHash(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeObjectNode
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            MergeObjectNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!super.isRubyHash(arguments1Value) && !HashGuards.isCompareByIdentity(arguments0Value)) {
                    return super.merge(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isRubyHash, !isCompareByIdentity] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyHash(arguments1Value) && !HashGuards.isCompareByIdentity(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.merge(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current) {
                return new MergeObjectNode((MergeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHashRubyHashRubyProcNode
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHashRubyHashRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class, RubyProc.class}, 0, 0);

            MergeRubyHashRubyHashRubyProcNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyHash"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                if (!HashGuards.isCompareByIdentity(arguments0Value)) {
                    return super.merge(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isCompareByIdentity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (!HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                        return super.merge(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current) {
                return new MergeRubyHashRubyHashRubyProcNode((MergeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHashRubyHashUndefinedPlaceholder2Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHashRubyHashUndefinedPlaceholder2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class, UndefinedPlaceholder.class}, 0, 0);

            MergeRubyHashRubyHashUndefinedPlaceholder2Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyHash"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                if (!HashGuards.isCompareByIdentity(arguments0Value)) {
                    return super.mergeBucketsBuckets(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isCompareByIdentity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    if (!HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                        return super.mergeBucketsBuckets(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current) {
                return new MergeRubyHashRubyHashUndefinedPlaceholder2Node((MergeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHashRubyHashUndefinedPlaceholder1Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHashRubyHashUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class, UndefinedPlaceholder.class}, 0, 0);

            MergeRubyHashRubyHashUndefinedPlaceholder1Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyHash"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                if (!(HashGuards.isNull(arguments0Value) || HashGuards.isBuckets(arguments0Value) || HashGuards.isNull(arguments1Value) || HashGuards.isBuckets(arguments1Value) || HashGuards.isCompareByIdentity(arguments0Value))) {
                    return super.mergePackedArrayPackedArray(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets, !isNull, !isBuckets, !isCompareByIdentity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    if (!(HashGuards.isNull(arguments0ValueCast) || HashGuards.isBuckets(arguments0ValueCast) || HashGuards.isNull(arguments1ValueCast) || HashGuards.isBuckets(arguments1ValueCast) || HashGuards.isCompareByIdentity(arguments0ValueCast))) {
                        return super.mergePackedArrayPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current) {
                return new MergeRubyHashRubyHashUndefinedPlaceholder1Node((MergeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHashRubyHashUndefinedPlaceholder0Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHashRubyHashUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class, UndefinedPlaceholder.class}, 0, 0);

            MergeRubyHashRubyHashUndefinedPlaceholder0Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyHash"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value) && HashGuards.isNull(arguments1Value) && !HashGuards.isCompareByIdentity(arguments0Value)) {
                    return super.mergePackedArrayNull(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets, isNull, !isCompareByIdentity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast) && HashGuards.isNull(arguments1ValueCast) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                        return super.mergePackedArrayNull(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current) {
                return new MergeRubyHashRubyHashUndefinedPlaceholder0Node((MergeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MergeUninitializedNode
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MergeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MergeUninitializedNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                MergeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MergeBaseNode rootNode = (MergeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MergeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.MergeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MergeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        private static abstract class MergeBaseNode
        extends HashNodes.MergeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MergeBaseNode next0;

            MergeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MergeBaseNode(MergeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                MergeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MergeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new MergeUninitializedNode(this);
                    ((MergeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MergeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MergeBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (MergeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MergeUninitializedNode(this), (Node)new MergePolymorphicNode(this), (DSLNode)((MergeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MergeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                        RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast) && HashGuards.isNull(arguments1ValueCast) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                                return (MergeBaseNode)MergeRubyHashRubyHashUndefinedPlaceholder0Node.create0(this);
                            }
                            if (!(HashGuards.isNull(arguments0ValueCast) || HashGuards.isBuckets(arguments0ValueCast) || HashGuards.isNull(arguments1ValueCast) || HashGuards.isBuckets(arguments1ValueCast) || HashGuards.isCompareByIdentity(arguments0ValueCast))) {
                                return (MergeBaseNode)MergeRubyHashRubyHashUndefinedPlaceholder1Node.create0(this);
                            }
                            if (!HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                                return (MergeBaseNode)MergeRubyHashRubyHashUndefinedPlaceholder2Node.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                            return (MergeBaseNode)MergeRubyHashRubyHashRubyProcNode.create0(this);
                        }
                    }
                    if (!super.isRubyHash(arguments1Value) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                        return (MergeBaseNode)MergeObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    MergeBaseNode otherCast = (MergeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (MergeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<HashNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(HashNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapPolymorphicNode
        extends MapBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapPolymorphicNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyHash2Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            MapRubyHash2Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.mapBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.mapBuckets(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(HashNodes.MapNode current) {
                return new MapRubyHash2Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyHash1Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            MapRubyHash1Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.mapPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.mapPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(HashNodes.MapNode current) {
                return new MapRubyHash1Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyHash0Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            MapRubyHash0Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.mapNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return super.mapNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(HashNodes.MapNode current) {
                return new MapRubyHash0Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapUninitializedNode
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapUninitializedNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapBaseNode rootNode = (MapBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        private static abstract class MapBaseNode
        extends HashNodes.MapNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapBaseNode next0;

            MapBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapBaseNode(MapBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MapBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapUninitializedNode(this);
                    ((MapUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MapBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapUninitializedNode(this), (Node)new MapPolymorphicNode(this), (DSLNode)((MapBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyHash1Node.create0(this);
                    }
                    return (MapBaseNode)MapRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapBaseNode otherCast = (MapBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(HashNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyHash.class ? this.arguments[1].executeRubyHash(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyObjectNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            InitializeCopyObjectNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyHash(arguments1Value)) {
                    return super.dupBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyHash] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.dupBuckets(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current) {
                return new InitializeCopyObjectNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash2Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash2Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash"));
                }
                if (HashGuards.isBuckets(arguments1Value)) {
                    return super.dupBuckets(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isBuckets(arguments1ValueCast)) {
                        return super.dupBuckets(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyHash2Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash1Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash1Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash"));
                }
                if (!HashGuards.isNull(arguments1Value) && !HashGuards.isBuckets(arguments1Value)) {
                    return super.dupPackedArray(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (!HashGuards.isNull(arguments1ValueCast) && !HashGuards.isBuckets(arguments1ValueCast)) {
                        return super.dupPackedArray(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyHash1Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash0Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash0Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash"));
                }
                if (HashGuards.isNull(arguments1Value)) {
                    return super.dupNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isNull(arguments1ValueCast)) {
                        return super.dupNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyHash0Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends HashNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                        RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                        if (HashGuards.isNull(arguments1ValueCast)) {
                            return (InitializeCopyBaseNode)InitializeCopyRubyHash0Node.create0(this);
                        }
                        if (!HashGuards.isBuckets(arguments1ValueCast)) {
                            return (InitializeCopyBaseNode)InitializeCopyRubyHash1Node.create0(this);
                        }
                        return (InitializeCopyBaseNode)InitializeCopyRubyHash2Node.create0(this);
                    }
                    if (!super.isRubyHash(arguments1Value)) {
                        return (InitializeCopyBaseNode)InitializeCopyObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(HashNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectObjectRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, RubyProc.class}, 0, 0);

            InitializeObjectObjectRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current) {
                return new InitializeObjectObjectRubyProcNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashObjectUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyHashObjectUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current) {
                return new InitializeRubyHashObjectUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashUndefinedPlaceholderRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeRubyHashUndefinedPlaceholderRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current) {
                return new InitializeRubyHashUndefinedPlaceholderRubyProcNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current) {
                return new InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends HashNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyHashUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (!super.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyHashObjectUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (InitializeBaseNode)InitializeObjectObjectRubyProcNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<HashNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(HashNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyHash1Node
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            EmptyRubyHash1Node(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.emptyPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(HashNodes.EmptyNode current) {
                return new EmptyRubyHash1Node((EmptyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyHash0Node
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            EmptyRubyHash0Node(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.emptyNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(HashNodes.EmptyNode current) {
                return new EmptyRubyHash0Node((EmptyBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends HashNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EmptyBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (EmptyBaseNode)EmptyRubyHash0Node.create0(this);
                    }
                    return (EmptyBaseNode)EmptyRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<HashNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(HashNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachObjectUndefinedPlaceholderNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class}, 0, 0);

            EachObjectUndefinedPlaceholderNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current) {
                return new EachObjectUndefinedPlaceholderNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHashRubyProc2Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHashRubyProc2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHashRubyProc2Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.eachBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.eachBuckets(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current) {
                return new EachRubyHashRubyProc2Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHashRubyProc1Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHashRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHashRubyProc1Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.eachPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.eachPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current) {
                return new EachRubyHashRubyProc1Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHashRubyProc0Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHashRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHashRubyProc0Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.eachNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyHash(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return super.eachNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current) {
                return new EachRubyHashRubyProc0Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = (EachBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends HashNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachUninitializedNode(this), (Node)new EachPolymorphicNode(this), (DSLNode)((EachBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        if (HashGuards.isNull(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyHashRubyProc0Node.create0(this);
                        }
                        if (!HashGuards.isBuckets(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyHashRubyProc1Node.create0(this);
                        }
                        return (EachBaseNode)EachRubyHashRubyProc2Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (EachBaseNode)EachObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<HashNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(HashNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeletePolymorphicNode
        extends DeleteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            DeletePolymorphicNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyHashObject2Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyHashObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            DeleteRubyHashObject2Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.delete(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.delete(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current) {
                return new DeleteRubyHashObject2Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyHashObject1Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyHashObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            DeleteRubyHashObject1Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!(HashGuards.isNull(arguments0Value) || HashGuards.isBuckets(arguments0Value) || HashGuards.isCompareByIdentity(arguments0Value))) {
                    return super.deletePackedArray(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets, !isCompareByIdentity] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                    return super.deletePackedArray(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current) {
                return new DeleteRubyHashObject1Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyHashObject0Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyHashObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            DeleteRubyHashObject0Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.deleteNull(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.deleteNull(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current) {
                return new DeleteRubyHashObject0Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteUninitializedNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteUninitializedNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBaseNode rootNode = (DeleteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.DeleteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        private static abstract class DeleteBaseNode
        extends HashNodes.DeleteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBaseNode next0;

            DeleteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBaseNode(DeleteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                DeleteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new DeleteUninitializedNode(this);
                    ((DeleteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DeleteBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (DeleteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteUninitializedNode(this), (Node)new DeletePolymorphicNode(this), (DSLNode)((DeleteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyHashObject0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast) && !HashGuards.isCompareByIdentity(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyHashObject1Node.create0(this);
                    }
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyHashObject2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    DeleteBaseNode otherCast = (DeleteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (DeleteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultProcNode.class)
    public static final class DefaultProcNodeFactory
    extends NodeFactoryBase<HashNodes.DefaultProcNode> {
        private static DefaultProcNodeFactory defaultProcNodeFactoryInstance;

        private DefaultProcNodeFactory() {
            super(HashNodes.DefaultProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.DefaultProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefaultProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.DefaultProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefaultProcUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.DefaultProcNode> getInstance() {
            if (defaultProcNodeFactoryInstance == null) {
                defaultProcNodeFactoryInstance = new DefaultProcNodeFactory();
            }
            return defaultProcNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefaultProcPolymorphicNode
        extends DefaultProcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DefaultProcPolymorphicNode(DefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultProcRubyHashNode
        extends DefaultProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultProcRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            DefaultProcRubyHashNode(DefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                return super.defaultProc(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.defaultProc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.DefaultProcNode create0(HashNodes.DefaultProcNode current) {
                return new DefaultProcRubyHashNode((DefaultProcBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefaultProcUninitializedNode
        extends DefaultProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultProcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefaultProcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DefaultProcUninitializedNode(DefaultProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DefaultProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefaultProcBaseNode rootNode = (DefaultProcBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DefaultProcBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.DefaultProcNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefaultProcUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        private static abstract class DefaultProcBaseNode
        extends HashNodes.DefaultProcNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DefaultProcBaseNode next0;

            DefaultProcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DefaultProcBaseNode(DefaultProcBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DefaultProcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefaultProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DefaultProcUninitializedNode(this);
                    ((DefaultProcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DefaultProcBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DefaultProcBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DefaultProcBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DefaultProcUninitializedNode(this), (Node)new DefaultProcPolymorphicNode(this), (DSLNode)((DefaultProcBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefaultProcBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (DefaultProcBaseNode)DefaultProcRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DefaultProcBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DefaultProcBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
    public static final class IsCompareByIdentityNodeFactory
    extends NodeFactoryBase<HashNodes.IsCompareByIdentityNode> {
        private static IsCompareByIdentityNodeFactory isCompareByIdentityNodeFactoryInstance;

        private IsCompareByIdentityNodeFactory() {
            super(HashNodes.IsCompareByIdentityNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.IsCompareByIdentityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsCompareByIdentityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.IsCompareByIdentityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsCompareByIdentityUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.IsCompareByIdentityNode> getInstance() {
            if (isCompareByIdentityNodeFactoryInstance == null) {
                isCompareByIdentityNodeFactoryInstance = new IsCompareByIdentityNodeFactory();
            }
            return isCompareByIdentityNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsCompareByIdentityPolymorphicNode
        extends IsCompareByIdentityBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IsCompareByIdentityPolymorphicNode(IsCompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsCompareByIdentityRubyHashNode
        extends IsCompareByIdentityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsCompareByIdentityRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            IsCompareByIdentityRubyHashNode(IsCompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                return super.compareByIdentity(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.compareByIdentity(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.IsCompareByIdentityNode create0(HashNodes.IsCompareByIdentityNode current) {
                return new IsCompareByIdentityRubyHashNode((IsCompareByIdentityBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsCompareByIdentityUninitializedNode
        extends IsCompareByIdentityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsCompareByIdentityUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsCompareByIdentityUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsCompareByIdentityUninitializedNode(IsCompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IsCompareByIdentityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsCompareByIdentityBaseNode rootNode = (IsCompareByIdentityBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsCompareByIdentityBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.IsCompareByIdentityNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsCompareByIdentityUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        private static abstract class IsCompareByIdentityBaseNode
        extends HashNodes.IsCompareByIdentityNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsCompareByIdentityBaseNode next0;

            IsCompareByIdentityBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsCompareByIdentityBaseNode(IsCompareByIdentityBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IsCompareByIdentityBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsCompareByIdentityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IsCompareByIdentityUninitializedNode(this);
                    ((IsCompareByIdentityUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsCompareByIdentityBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsCompareByIdentityBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IsCompareByIdentityBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsCompareByIdentityUninitializedNode(this), (Node)new IsCompareByIdentityPolymorphicNode(this), (DSLNode)((IsCompareByIdentityBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsCompareByIdentityBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (IsCompareByIdentityBaseNode)IsCompareByIdentityRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IsCompareByIdentityBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IsCompareByIdentityBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
    public static final class CompareByIdentityNodeFactory
    extends NodeFactoryBase<HashNodes.CompareByIdentityNode> {
        private static CompareByIdentityNodeFactory compareByIdentityNodeFactoryInstance;

        private CompareByIdentityNodeFactory() {
            super(HashNodes.CompareByIdentityNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.CompareByIdentityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareByIdentityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.CompareByIdentityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareByIdentityUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.CompareByIdentityNode> getInstance() {
            if (compareByIdentityNodeFactoryInstance == null) {
                compareByIdentityNodeFactoryInstance = new CompareByIdentityNodeFactory();
            }
            return compareByIdentityNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CompareByIdentityPolymorphicNode
        extends CompareByIdentityBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CompareByIdentityPolymorphicNode(CompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareByIdentityRubyHashNode
        extends CompareByIdentityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareByIdentityRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            CompareByIdentityRubyHashNode(CompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                return super.compareByIdentity(arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.compareByIdentity(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.CompareByIdentityNode create0(HashNodes.CompareByIdentityNode current) {
                return new CompareByIdentityRubyHashNode((CompareByIdentityBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareByIdentityUninitializedNode
        extends CompareByIdentityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareByIdentityUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareByIdentityUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareByIdentityUninitializedNode(CompareByIdentityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CompareByIdentityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareByIdentityBaseNode rootNode = (CompareByIdentityBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareByIdentityBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.CompareByIdentityNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareByIdentityUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        private static abstract class CompareByIdentityBaseNode
        extends HashNodes.CompareByIdentityNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareByIdentityBaseNode next0;

            CompareByIdentityBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareByIdentityBaseNode(CompareByIdentityBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CompareByIdentityBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareByIdentityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CompareByIdentityUninitializedNode(this);
                    ((CompareByIdentityUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareByIdentityBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CompareByIdentityBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CompareByIdentityBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareByIdentityUninitializedNode(this), (Node)new CompareByIdentityPolymorphicNode(this), (DSLNode)((CompareByIdentityBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareByIdentityBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (CompareByIdentityBaseNode)CompareByIdentityRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CompareByIdentityBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CompareByIdentityBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<HashNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(HashNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClearUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClearPolymorphicNode
        extends ClearBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClearPolymorphicNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyHash1Node
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ClearRubyHash1Node(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.empty(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.empty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(HashNodes.ClearNode current) {
                return new ClearRubyHash1Node((ClearBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyHash0Node
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ClearRubyHash0Node(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.emptyNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(HashNodes.ClearNode current) {
                return new ClearRubyHash0Node((ClearBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClearUninitializedNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClearUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClearUninitializedNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value;
                try {
                    value = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClearBaseNode rootNode = (ClearBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClearBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClearUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        private static abstract class ClearBaseNode
        extends HashNodes.ClearNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClearBaseNode next0;

            ClearBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClearBaseNode(ClearBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ClearBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClearUninitializedNode(this);
                    ((ClearUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClearBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ClearBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ClearBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClearUninitializedNode(this), (Node)new ClearPolymorphicNode(this), (DSLNode)((ClearBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClearBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (ClearBaseNode)ClearRubyHash0Node.create0(this);
                    }
                    return (ClearBaseNode)ClearRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClearBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClearBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.SetIndexNode> {
        private static SetIndexNodeFactory setIndexNodeFactoryInstance;

        private SetIndexNodeFactory() {
            super(HashNodes.SetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.SetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.SetIndexNode> getInstance() {
            if (setIndexNodeFactoryInstance == null) {
                setIndexNodeFactoryInstance = new SetIndexNodeFactory();
            }
            return setIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetIndexPolymorphicNode
        extends SetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            SetIndexPolymorphicNode(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashRubyString2Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashRubyString2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyString.class, Object.class}, 0, 0);

            SetIndexRubyHashRubyString2Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.setBuckets(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.setBuckets(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashRubyString2Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject2Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject2Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    return super.setBuckets(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isBuckets, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyString(arguments1Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.setBuckets(arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashObject2Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashRubyString1Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyString.class, Object.class}, 0, 0);

            SetIndexRubyHashRubyString1Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.setPackedArray(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.setPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashRubyString1Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject1Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject1Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!(HashGuards.isNull(arguments0Value) || HashGuards.isBuckets(arguments0Value) || super.isRubyString(arguments1Value))) {
                    return super.setPackedArray(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyString(arguments1Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.setPackedArray(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashObject1Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashRubyString0Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyString.class, Object.class}, 0, 0);

            SetIndexRubyHashRubyString0Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.setNull(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return super.setNull(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashRubyString0Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject0Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject0Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isNull(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    return super.setNull(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNull, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyString(arguments1Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.setNull(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current) {
                return new SetIndexRubyHashObject0Node((SetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetIndexUninitializedNode
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetIndexUninitializedNode(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetIndexBaseNode rootNode = (SetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        private static abstract class SetIndexBaseNode
        extends HashNodes.SetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetIndexBaseNode next0;

            SetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetIndexBaseNode(SetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                SetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new SetIndexUninitializedNode(this);
                    ((SetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (SetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetIndexUninitializedNode(this), (Node)new SetIndexPolymorphicNode(this), (DSLNode)((SetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast) && !super.isRubyString(arguments1Value)) {
                        return (SetIndexBaseNode)SetIndexRubyHashObject0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && HashGuards.isNull(arguments0ValueCast)) {
                        return (SetIndexBaseNode)SetIndexRubyHashRubyString0Node.create0(this);
                    }
                    if (!(HashGuards.isNull(arguments0ValueCast) || HashGuards.isBuckets(arguments0ValueCast) || super.isRubyString(arguments1Value))) {
                        return (SetIndexBaseNode)SetIndexRubyHashObject1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && !HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return (SetIndexBaseNode)SetIndexRubyHashRubyString1Node.create0(this);
                    }
                    if (HashGuards.isBuckets(arguments0ValueCast) && !super.isRubyString(arguments1Value)) {
                        return (SetIndexBaseNode)SetIndexRubyHashObject2Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && HashGuards.isBuckets(arguments0ValueCast)) {
                        return (SetIndexBaseNode)SetIndexRubyHashRubyString2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    SetIndexBaseNode otherCast = (SetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (SetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
    public static final class GetOrUndefinedNodeFactory
    extends NodeFactoryBase<HashNodes.GetOrUndefinedNode> {
        private static GetOrUndefinedNodeFactory getOrUndefinedNodeFactoryInstance;

        private GetOrUndefinedNodeFactory() {
            super(HashNodes.GetOrUndefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.GetOrUndefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetOrUndefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.GetOrUndefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetOrUndefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.GetOrUndefinedNode> getInstance() {
            if (getOrUndefinedNodeFactoryInstance == null) {
                getOrUndefinedNodeFactoryInstance = new GetOrUndefinedNodeFactory();
            }
            return getOrUndefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetOrUndefinedPolymorphicNode
        extends GetOrUndefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetOrUndefinedPolymorphicNode(GetOrUndefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetOrUndefinedRubyHashNode
        extends GetOrUndefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetOrUndefinedRubyHashNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetOrUndefinedRubyHashNode(GetOrUndefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.getOrUndefined(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.getOrUndefined(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetOrUndefinedNode create0(HashNodes.GetOrUndefinedNode current) {
                return new GetOrUndefinedRubyHashNode((GetOrUndefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetOrUndefinedUninitializedNode
        extends GetOrUndefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetOrUndefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetOrUndefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetOrUndefinedUninitializedNode(GetOrUndefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetOrUndefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetOrUndefinedBaseNode rootNode = (GetOrUndefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetOrUndefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetOrUndefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetOrUndefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        private static abstract class GetOrUndefinedBaseNode
        extends HashNodes.GetOrUndefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetOrUndefinedBaseNode next0;

            GetOrUndefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetOrUndefinedBaseNode(GetOrUndefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetOrUndefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetOrUndefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetOrUndefinedUninitializedNode(this);
                    ((GetOrUndefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetOrUndefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetOrUndefinedBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetOrUndefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetOrUndefinedUninitializedNode(this), (Node)new GetOrUndefinedPolymorphicNode(this), (DSLNode)((GetOrUndefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetOrUndefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    return (GetOrUndefinedBaseNode)GetOrUndefinedRubyHashNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetOrUndefinedBaseNode otherCast = (GetOrUndefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetOrUndefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(HashNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetIndexPolymorphicNode
        extends GetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetIndexPolymorphicNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyHash arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyHash arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash2Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash2Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.getBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyHash arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyHash arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.getBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.getBuckets(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current) {
                return new GetIndexRubyHash2Node((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash1Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash1Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.getPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyHash arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyHash arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.getPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.getPackedArray(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current) {
                return new GetIndexRubyHash1Node((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash0Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash0Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.getNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyHash arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyHash arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (HashGuards.isNull(arguments0Value)) {
                    return super.getNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.getNull(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current) {
                return new GetIndexRubyHash0Node((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetIndexUninitializedNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetIndexUninitializedNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, RubyHash arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyHash arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetIndexBaseNode rootNode = (GetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        private static abstract class GetIndexBaseNode
        extends HashNodes.GetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetIndexBaseNode next0;

            GetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetIndexBaseNode(GetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetIndexUninitializedNode(this);
                    ((GetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetIndexUninitializedNode(this), (Node)new GetIndexPolymorphicNode(this), (DSLNode)((GetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (GetIndexBaseNode)GetIndexRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (GetIndexBaseNode)GetIndexRubyHash1Node.create0(this);
                    }
                    return (GetIndexBaseNode)GetIndexRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetIndexBaseNode otherCast = (GetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ConstructNode.class)
    public static final class ConstructNodeFactory
    extends NodeFactoryBase<HashNodes.ConstructNode> {
        private static ConstructNodeFactory constructNodeFactoryInstance;

        private ConstructNodeFactory() {
            super(HashNodes.ConstructNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ConstructNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstructNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ConstructNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstructUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ConstructNode> getInstance() {
            if (constructNodeFactoryInstance == null) {
                constructNodeFactoryInstance = new ConstructNodeFactory();
            }
            return constructNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstructPolymorphicNode
        extends ConstructBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConstructPolymorphicNode(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstructRubyClass1Node
        extends ConstructBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstructRubyClass1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, Object[].class}, 0, 0);

            ConstructRubyClass1Node(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.constructFallback(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.constructFallback(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.ConstructNode create0(HashNodes.ConstructNode current) {
                return new ConstructRubyClass1Node((ConstructBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstructRubyClass0Node
        extends ConstructBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstructRubyClass0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, Object[].class}, 0, 0);

            ConstructRubyClass0Node(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ConstructBaseNode.isSmallArrayOfPairs(arguments0Value, arguments1Value)) {
                    return super.construct(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isSmallArrayOfPairs] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyClass arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && ConstructBaseNode.isSmallArrayOfPairs(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    return super.construct(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.ConstructNode create0(HashNodes.ConstructNode current) {
                return new ConstructRubyClass0Node((ConstructBaseNode)current);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstructUninitializedNode
        extends ConstructBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstructUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstructUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstructUninitializedNode(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConstructBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstructBaseNode rootNode = (ConstructBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstructBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.ConstructNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstructUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        private static abstract class ConstructBaseNode
        extends HashNodes.ConstructNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstructBaseNode next0;

            ConstructBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstructBaseNode(ConstructBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ConstructBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstructBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConstructUninitializedNode(this);
                    ((ConstructUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstructBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ConstructBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ConstructBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstructUninitializedNode(this), (Node)new ConstructPolymorphicNode(this), (DSLNode)((ConstructBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstructBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    Object[] arguments1ValueCast;
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    if (HashNodes.ConstructNode.isSmallArrayOfPairs(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                        return (ConstructBaseNode)ConstructRubyClass0Node.create0(this);
                    }
                    return (ConstructBaseNode)ConstructRubyClass1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConstructBaseNode otherCast = (ConstructBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConstructBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

