/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.FixnumLowerNode;
import org.jruby.truffle.nodes.core.RaiseIfFrozenNode;
import org.jruby.truffle.nodes.core.ReturnEnumeratorIfNoBlockNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.nodes.methods.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.util.ArrayUtils;

public abstract class CoreMethodNodeManager {
    public static void addCoreMethodNodes(RubyClass rubyObjectClass, List<? extends NodeFactory<? extends RubyNode>> nodeFactories) {
        for (NodeFactory<? extends RubyNode> nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            CoreClass classAnnotation = nodeClass.getEnclosingClass().getAnnotation(CoreClass.class);
            CoreMethod methodAnnotation = nodeClass.getAnnotation(CoreMethod.class);
            if (methodAnnotation == null) continue;
            MethodDetails details = new MethodDetails(classAnnotation, methodAnnotation, nodeFactory);
            CoreMethodNodeManager.addMethod(rubyObjectClass, details);
        }
    }

    private static void addMethod(RubyClass rubyObjectClass, MethodDetails methodDetails) {
        RubyModule module;
        assert (rubyObjectClass != null);
        assert (methodDetails != null);
        RubyContext context = rubyObjectClass.getContext();
        String fullName = methodDetails.getClassAnnotation().name();
        if (fullName.equals("main")) {
            module = context.getCoreLibrary().getMainObject().getSingletonClass(null);
        } else {
            module = rubyObjectClass;
            for (String moduleName : fullName.split("::")) {
                RubyConstant constant = ModuleOperations.lookupConstant(context, LexicalScope.NONE, module, moduleName);
                if (constant == null) {
                    throw new RuntimeException(String.format("Module %s not found when adding core library", moduleName));
                }
                module = (RubyModule)constant.getValue();
            }
        }
        assert (module != null) : fullName;
        CoreMethod anno = methodDetails.getMethodAnnotation();
        List<String> names = Arrays.asList(anno.names());
        assert (names.size() >= 1);
        Visibility visibility = anno.visibility();
        if (anno.isModuleFunction()) {
            if (visibility != Visibility.PUBLIC) {
                System.err.println("WARNING: visibility ignored when isModuleFunction in " + methodDetails.getIndicativeName());
            }
            if (anno.onSingleton()) {
                System.err.println("WARNING: Either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (!module.isOnlyAModule()) {
                System.err.println("WARNING: Using isModuleFunction on a Class for " + methodDetails.getIndicativeName());
            }
        }
        boolean needsSelf = !anno.isModuleFunction() && !anno.onSingleton() && anno.needsSelf() || anno.reallyDoesNeedSelf();
        RubyRootNode rootNode = CoreMethodNodeManager.makeGenericMethod(context, methodDetails, needsSelf);
        if (anno.isModuleFunction()) {
            CoreMethodNodeManager.addMethod(module, rootNode, names, Visibility.PRIVATE);
            CoreMethodNodeManager.addMethod(module.getSingletonClass(null), rootNode, names, Visibility.PUBLIC);
        } else if (anno.onSingleton()) {
            CoreMethodNodeManager.addMethod(module.getSingletonClass(null), rootNode, names, visibility);
        } else {
            CoreMethodNodeManager.addMethod(module, rootNode, names, visibility);
        }
    }

    private static void addMethod(RubyModule module, RubyRootNode rootNode, List<String> names, Visibility originalVisibility) {
        for (String name : names) {
            RubyRootNode rootNodeCopy = (RubyRootNode)NodeUtil.cloneNode((Node)rootNode);
            Visibility visibility = originalVisibility;
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                visibility = Visibility.PRIVATE;
            }
            InternalMethod method = new InternalMethod(rootNodeCopy.getSharedMethodInfo(), name, module, visibility, false, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNodeCopy), null);
            module.addMethod(null, method.withVisibility(visibility).withName(name));
        }
    }

    private static RubyRootNode makeGenericMethod(RubyContext context, MethodDetails methodDetails, boolean needsSelf) {
        CoreSourceSection sourceSection = new CoreSourceSection(methodDetails.getClassAnnotation().name(), methodDetails.getMethodAnnotation().names()[0]);
        int required = methodDetails.getMethodAnnotation().required();
        int optional = methodDetails.getMethodAnnotation().argumentsAsArray() ? 0 : methodDetails.getMethodAnnotation().optional();
        Arity arity = new Arity(required, optional, methodDetails.getMethodAnnotation().argumentsAsArray(), false, false, 0);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, arity, methodDetails.getIndicativeName(), false, null, true);
        ArrayList<RubyNode> argumentsNodes = new ArrayList<RubyNode>();
        if (needsSelf) {
            RubyNode readSelfNode = new SelfNode(context, (SourceSection)sourceSection);
            if (methodDetails.getMethodAnnotation().lowerFixnumSelf()) {
                readSelfNode = new FixnumLowerNode(readSelfNode);
            }
            if (methodDetails.getMethodAnnotation().raiseIfFrozenSelf()) {
                readSelfNode = new RaiseIfFrozenNode(readSelfNode);
            }
            argumentsNodes.add(readSelfNode);
        }
        if (methodDetails.getMethodAnnotation().argumentsAsArray()) {
            argumentsNodes.add(new ReadAllArgumentsNode(context, (SourceSection)sourceSection));
        } else {
            for (int n = 0; n < arity.getRequired() + arity.getOptional(); ++n) {
                RubyNode readArgumentNode = new ReadPreArgumentNode(context, (SourceSection)sourceSection, n, MissingArgumentBehaviour.UNDEFINED);
                if (ArrayUtils.contains(methodDetails.getMethodAnnotation().lowerFixnumParameters(), n)) {
                    readArgumentNode = new FixnumLowerNode(readArgumentNode);
                }
                if (ArrayUtils.contains(methodDetails.getMethodAnnotation().raiseIfFrozenParameters(), n)) {
                    readArgumentNode = new RaiseIfFrozenNode(readArgumentNode);
                }
                argumentsNodes.add(readArgumentNode);
            }
        }
        if (methodDetails.getMethodAnnotation().needsBlock()) {
            argumentsNodes.add(new ReadBlockNode(context, (SourceSection)sourceSection, UndefinedPlaceholder.INSTANCE));
        }
        RubyNode methodNode = null;
        NodeFactory<? extends RubyNode> nodeFactory = methodDetails.getNodeFactory();
        List signatures = nodeFactory.getNodeSignatures();
        assert (!signatures.isEmpty());
        for (List signature : signatures) {
            if (signature.size() >= 1 && signature.get(0) != RubyContext.class && signature.get(0) != nodeFactory.getNodeClass()) {
                throw new TruffleFatalException("Copy constructor with wrong type for previous in " + nodeFactory.getNodeClass() + " : " + signature.get(0), null);
            }
            if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
                methodNode = (RubyNode)((Object)methodDetails.getNodeFactory().createNode(new Object[]{context, sourceSection, argumentsNodes.toArray(new RubyNode[argumentsNodes.size()])}));
                continue;
            }
            Object[] args = new Object[2 + argumentsNodes.size()];
            args[0] = context;
            args[1] = sourceSection;
            System.arraycopy(argumentsNodes.toArray(new RubyNode[argumentsNodes.size()]), 0, args, 2, argumentsNodes.size());
            methodNode = (RubyNode)((Object)methodDetails.getNodeFactory().createNode(args));
        }
        CoreMethodNodeManager.verifyNoAmbiguousDefaultArguments(methodDetails);
        CheckArityNode checkArity = new CheckArityNode(context, (SourceSection)sourceSection, arity);
        RubyNode sequence = SequenceNode.sequence(context, (SourceSection)sourceSection, checkArity, methodNode);
        if (methodDetails.getMethodAnnotation().returnsEnumeratorIfNoBlock()) {
            sequence = new ReturnEnumeratorIfNoBlockNode(methodDetails.getMethodAnnotation().names()[0], sequence);
        }
        if (methodDetails.getMethodAnnotation().taintFromSelf() || methodDetails.getMethodAnnotation().taintFromParameter() != -1) {
            sequence = new TaintResultNode(methodDetails.getMethodAnnotation().taintFromSelf(), methodDetails.getMethodAnnotation().taintFromParameter(), sequence);
        }
        ExceptionTranslatingNode exceptionTranslatingNode = new ExceptionTranslatingNode(context, (SourceSection)sourceSection, sequence, methodDetails.getMethodAnnotation().unsupportedOperationBehavior());
        return new RubyRootNode(context, (SourceSection)sourceSection, null, sharedMethodInfo, exceptionTranslatingNode);
    }

    private static boolean verifyNoAmbiguousDefaultArguments(MethodDetails methodDetails) {
        boolean success = true;
        if (methodDetails.getMethodAnnotation().optional() > 0) {
            int opt = methodDetails.getMethodAnnotation().optional();
            int argc = methodDetails.getNodeFactory().getExecutionSignature().size();
            Class node = methodDetails.getNodeFactory().getNodeClass();
            boolean undefined = false;
            boolean object = false;
            for (int i = 1; i <= opt; ++i) {
                for (Method method : node.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Specialization.class)) continue;
                    Class<?> c = method.getParameterTypes()[method.getParameterTypes().length - i];
                    if (c == UndefinedPlaceholder.class) {
                        undefined |= true;
                        continue;
                    }
                    if (c != Object.class) continue;
                    String[] guards = method.getAnnotation(Specialization.class).guards();
                    boolean guarded = false;
                    for (String guard : guards) {
                        if (!guard.equals("!isUndefinedPlaceholder(arguments[" + (argc - i) + "])")) continue;
                        guarded = true;
                    }
                    object |= !guarded;
                }
                if (!undefined || !object) continue;
                success = false;
                System.err.println("Ambiguous default argument " + (argc - i) + " in " + node.getCanonicalName());
            }
        }
        if (!success) {
            throw new RuntimeException("Found ambiguous arguments");
        }
        return success;
    }

    public static class MethodDetails {
        private final CoreClass classAnnotation;
        private final CoreMethod methodAnnotation;
        private final NodeFactory<? extends RubyNode> nodeFactory;

        public MethodDetails(CoreClass classAnnotation, CoreMethod methodAnnotation, NodeFactory<? extends RubyNode> nodeFactory) {
            assert (classAnnotation != null);
            assert (methodAnnotation != null);
            assert (nodeFactory != null);
            this.classAnnotation = classAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.nodeFactory = nodeFactory;
        }

        public CoreClass getClassAnnotation() {
            return this.classAnnotation;
        }

        public CoreMethod getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public NodeFactory<? extends RubyNode> getNodeFactory() {
            return this.nodeFactory;
        }

        public String getIndicativeName() {
            return this.classAnnotation.name() + "#" + this.methodAnnotation.names()[0] + "(core)";
        }
    }
}

