/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.globals.GetFromThreadLocalNode;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Binding")
public abstract class BindingNodes {

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariablesNode(LocalVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray localVariables(RubyBinding binding) {
            LocalVariablesNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            MaterializedFrame frame = binding.getFrame();
            while (frame != null) {
                for (Object name : frame.getFrameDescriptor().getIdentifiers()) {
                    if (!(name instanceof String)) continue;
                    array.slowPush(this.getContext().getSymbol((String)name));
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return array;
        }
    }

    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodNode {
        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariableSetNode(LocalVariableSetNode prev) {
            super(prev);
        }

        @Specialization
        public Object localVariableSetNode(RubyBinding binding, RubySymbol symbol, Object value) {
            LocalVariableSetNode.notDesignedForCompilation();
            if (symbol.toString().equals("$_")) {
                value = WrapInThreadLocalNode.wrap(this.getContext(), value);
            }
            MaterializedFrame frame = binding.getFrame();
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString());
                if (frameSlot != null) {
                    frame.setObject(frameSlot, value);
                    return value;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            FrameSlot newFrameSlot = binding.getFrame().getFrameDescriptor().addFrameSlot((Object)symbol.toString());
            binding.getFrame().setObject(newFrameSlot, value);
            return value;
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodNode {
        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariableGetNode(LocalVariableGetNode prev) {
            super(prev);
        }

        @Specialization
        public Object localVariableGet(RubyBinding binding, RubySymbol symbol) {
            LocalVariableGetNode.notDesignedForCompilation();
            MaterializedFrame frame = binding.getFrame();
            Object value = frame.getValue(frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString()));
            if (symbol.toString().equals("$_")) {
                value = GetFromThreadLocalNode.get(this.getContext(), value);
            }
            return value;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(RubyBinding self, RubyBinding from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self == from) {
                return self;
            }
            Object[] arguments = from.getFrame().getArguments();
            InternalMethod method = RubyArguments.getMethod(arguments);
            Object boundSelf = RubyArguments.getSelf(arguments);
            RubyProc boundBlock = RubyArguments.getBlock(arguments);
            Object[] userArguments = RubyArguments.extractUserArguments(arguments);
            Object[] copiedArguments = RubyArguments.pack(method, from.getFrame(), boundSelf, boundBlock, userArguments);
            MaterializedFrame copiedFrame = Truffle.getRuntime().createMaterializedFrame(copiedArguments);
            self.initialize(from.getSelf(), copiedFrame);
            return self;
        }
    }
}

