/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

public final class ArrayConcatNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    @Node.Child
    private ArrayBuilderNode arrayBuilderNode;
    private final BranchProfile appendArrayProfile = BranchProfile.create();
    private final BranchProfile appendObjectProfile = BranchProfile.create();

    public ArrayConcatNode(RubyContext context, SourceSection sourceSection, RubyNode[] children) {
        super(context, sourceSection);
        assert (children.length > 1);
        this.children = children;
        this.arrayBuilderNode = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
    }

    @Override
    public RubyArray execute(VirtualFrame frame) {
        Object store = this.arrayBuilderNode.start();
        int length = 0;
        if (this.children.length == 1) {
            return this.executeSingle(frame, store, length);
        }
        return this.executeArray(frame, store, length);
    }

    @ExplodeLoop
    private RubyArray executeSingle(VirtualFrame frame, Object store, int length) {
        Object childObject = this.children[0].execute(frame);
        if (childObject instanceof RubyArray) {
            this.appendArrayProfile.enter();
            RubyArray childArray = (RubyArray)childObject;
            store = this.arrayBuilderNode.ensure(store, length + childArray.getSize());
            store = this.arrayBuilderNode.append(store, length, childArray);
            length += childArray.getSize();
        } else {
            this.appendObjectProfile.enter();
            store = this.arrayBuilderNode.ensure(store, length + 1);
            store = this.arrayBuilderNode.append(store, length, childObject);
            ++length;
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilderNode.finish(store, length), length);
    }

    @ExplodeLoop
    private RubyArray executeArray(VirtualFrame frame, Object store, int length) {
        for (int n = 0; n < this.children.length; ++n) {
            Object childObject = this.children[n].execute(frame);
            if (childObject instanceof RubyArray) {
                this.appendArrayProfile.enter();
                RubyArray childArray = (RubyArray)childObject;
                store = this.arrayBuilderNode.ensure(store, length + childArray.getSize());
                store = this.arrayBuilderNode.append(store, length, childArray);
                length += childArray.getSize();
                continue;
            }
            this.appendObjectProfile.enter();
            store = this.arrayBuilderNode.ensure(store, length + 1);
            store = this.arrayBuilderNode.append(store, length, childObject);
            ++length;
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilderNode.finish(store, length), length);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (int n = 0; n < this.children.length; ++n) {
            this.children[n].executeVoid(frame);
        }
    }
}

