/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.conversion;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.conversion.ToJavaStringNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=ToJavaStringNode.class)
public final class ToJavaStringNodeFactory
extends NodeFactoryBase<ToJavaStringNode> {
    private static ToJavaStringNodeFactory instance;

    private ToJavaStringNodeFactory() {
        super(ToJavaStringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ToJavaStringNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToJavaStringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToJavaStringNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ToJavaStringUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ToJavaStringNode> getInstance() {
        if (instance == null) {
            instance = new ToJavaStringNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToJavaStringPolymorphicNode
    extends ToJavaStringBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ToJavaStringPolymorphicNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == String.class ? this.child.executeString(frameValue) : (this.childPolymorphicType == RubyString.class ? this.child.executeRubyString(frameValue) : (this.childPolymorphicType == RubySymbol.class ? this.child.executeRubySymbol(frameValue) : this.child.execute(frameValue)));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public String executeJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == String.class ? RubyTypesGen.RUBYTYPES.expectString(childValueEvaluated) : (this.childPolymorphicType == RubyString.class ? RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated) : (this.childPolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated) : childValueEvaluated));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToJavaStringStringNode
    extends ToJavaStringBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToJavaStringStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{String.class}, 0, 0);

        ToJavaStringStringNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            String childValue;
            try {
                childValue = this.child.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof String");
            }
            return super.toJavaString(childValue);
        }

        @Override
        public String executeJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            String childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof String");
            }
            return super.toJavaString(childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isString(childValue)) {
                String childValueCast = RubyTypesGen.RUBYTYPES.asString(childValue);
                return super.toJavaString(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToJavaStringNode create0(ToJavaStringNode current) {
            return new ToJavaStringStringNode((ToJavaStringBaseNode)current);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToJavaStringRubyStringNode
    extends ToJavaStringBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToJavaStringRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        ToJavaStringRubyStringNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyString childValue;
            try {
                childValue = this.child.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.toJavaString(childValue);
        }

        @Override
        public String executeJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyString childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.toJavaString(childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                RubyString childValueCast = RubyTypesGen.RUBYTYPES.asRubyString(childValue);
                return super.toJavaString(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToJavaStringNode create0(ToJavaStringNode current) {
            return new ToJavaStringRubyStringNode((ToJavaStringBaseNode)current);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToJavaStringRubySymbolNode
    extends ToJavaStringBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToJavaStringRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

        ToJavaStringRubySymbolNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            RubySymbol childValue;
            try {
                childValue = this.child.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.toJavaString(childValue);
        }

        @Override
        public String executeJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            RubySymbol childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.toJavaString(childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                RubySymbol childValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(childValue);
                return super.toJavaString(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToJavaStringNode create0(ToJavaStringNode current) {
            return new ToJavaStringRubySymbolNode((ToJavaStringBaseNode)current);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToJavaStringUninitializedNode
    extends ToJavaStringBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToJavaStringUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToJavaStringUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ToJavaStringUninitializedNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public String executeJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected String executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ToJavaStringBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToJavaStringBaseNode rootNode = (ToJavaStringBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ToJavaStringBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static ToJavaStringNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ToJavaStringUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    private static abstract class ToJavaStringBaseNode
    extends ToJavaStringNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ToJavaStringBaseNode next0;

        ToJavaStringBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ToJavaStringBaseNode(ToJavaStringBaseNode copy) {
            super(copy);
        }

        protected abstract String executeChained0(VirtualFrame var1, Object var2);

        protected final String rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            ToJavaStringBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToJavaStringBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ToJavaStringUninitializedNode(this);
                ((ToJavaStringUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ToJavaStringBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToJavaStringBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (ToJavaStringBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToJavaStringUninitializedNode(this), (Node)new ToJavaStringPolymorphicNode(this), (DSLNode)((ToJavaStringBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToJavaStringBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                return (ToJavaStringBaseNode)ToJavaStringRubySymbolNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                return (ToJavaStringBaseNode)ToJavaStringRubyStringNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isString(childValue)) {
                return (ToJavaStringBaseNode)ToJavaStringStringNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ToJavaStringBaseNode)other).child;
            this.next0 = newNext == null ? null : (ToJavaStringBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

