/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RedoException;

public final class WhileNode
extends RubyNode {
    @Node.Child
    private LoopNode loopNode;

    private WhileNode(RubyContext context, SourceSection sourceSection, RepeatingNode repeatingNode) {
        super(context, sourceSection);
        this.loopNode = Truffle.getRuntime().createLoopNode(repeatingNode);
    }

    public static WhileNode createWhile(RubyContext context, SourceSection sourceSection, RubyNode condition, RubyNode body) {
        WhileRepeatingNode repeatingNode = new WhileRepeatingNode(context, condition, body);
        return new WhileNode(context, sourceSection, repeatingNode);
    }

    public static WhileNode createDoWhile(RubyContext context, SourceSection sourceSection, RubyNode condition, RubyNode body) {
        DoWhileRepeatingNode repeatingNode = new DoWhileRepeatingNode(context, condition, body);
        return new WhileNode(context, sourceSection, repeatingNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.loopNode.executeLoop(frame);
        return this.nil();
    }

    private static class DoWhileRepeatingNode
    extends WhileRepeatingBaseNode
    implements RepeatingNode {
        public DoWhileRepeatingNode(RubyContext context, RubyNode condition, RubyNode body) {
            super(context, condition, body);
        }

        public boolean executeRepeating(VirtualFrame frame) {
            this.context.getSafepointManager().poll(this);
            try {
                this.body.execute(frame);
            }
            catch (NextException e) {
                this.nextUsed.enter();
            }
            catch (RedoException e) {
                this.redoUsed.enter();
                return true;
            }
            return this.condition.executeBoolean(frame);
        }
    }

    private static class WhileRepeatingNode
    extends WhileRepeatingBaseNode
    implements RepeatingNode {
        public WhileRepeatingNode(RubyContext context, RubyNode condition, RubyNode body) {
            super(context, condition, body);
        }

        public boolean executeRepeating(VirtualFrame frame) {
            if (!this.condition.executeBoolean(frame)) {
                return false;
            }
            while (true) {
                this.context.getSafepointManager().poll(this);
                try {
                    this.body.execute(frame);
                    return true;
                }
                catch (NextException e) {
                    this.nextUsed.enter();
                    return true;
                }
                catch (RedoException e) {
                    this.redoUsed.enter();
                    continue;
                }
                break;
            }
        }
    }

    private static abstract class WhileRepeatingBaseNode
    extends Node
    implements RepeatingNode {
        protected final RubyContext context;
        @Node.Child
        protected BooleanCastNode condition;
        @Node.Child
        protected RubyNode body;
        protected final BranchProfile redoUsed = BranchProfile.create();
        protected final BranchProfile nextUsed = BranchProfile.create();

        public WhileRepeatingBaseNode(RubyContext context, RubyNode condition, RubyNode body) {
            this.context = context;
            this.condition = BooleanCastNodeFactory.create(context, condition.getSourceSection(), condition);
            this.body = body;
        }
    }
}

