/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

public class OrNode
extends RubyNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private BooleanCastNode leftCast;
    @Node.Child
    private RubyNode right;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public OrNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
        super(context, sourceSection);
        this.left = left;
        this.leftCast = BooleanCastNodeFactory.create(context, sourceSection, null);
        this.right = right;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object leftValue = this.left.execute(frame);
        if (this.conditionProfile.profile(this.leftCast.executeBoolean(frame, leftValue))) {
            return leftValue;
        }
        return this.right.execute(frame);
    }
}

