/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.coerce.SymbolOrToStrNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=SymbolOrToStrNode.class)
public final class SymbolOrToStrNodeFactory
extends NodeFactoryBase<SymbolOrToStrNode> {
    private static SymbolOrToStrNodeFactory instance;

    private SymbolOrToStrNodeFactory() {
        super(SymbolOrToStrNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public SymbolOrToStrNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return SymbolOrToStrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static SymbolOrToStrNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return SymbolOrToStrUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<SymbolOrToStrNode> getInstance() {
        if (instance == null) {
            instance = new SymbolOrToStrNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class SymbolOrToStrPolymorphicNode
    extends SymbolOrToStrBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        SymbolOrToStrPolymorphicNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyString.class ? this.child.executeRubyString(frameValue) : (this.childPolymorphicType == RubySymbol.class ? this.child.executeRubySymbol(frameValue) : this.child.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public String executeToJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyString.class ? RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated) : (this.childPolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated) : childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SymbolOrToStrObjectNode
    extends SymbolOrToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SymbolOrToStrObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        SymbolOrToStrObjectNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue = this.child.execute(frameValue);
            if (!super.isRubySymbol(childValue) && !super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubySymbol, !isRubyString] failed");
        }

        @Override
        public String executeToJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue = childValueEvaluated;
            if (!super.isRubySymbol(childValue) && !super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubySymbol, !isRubyString] failed");
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!super.isRubySymbol(childValue) && !super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SymbolOrToStrNode create0(SymbolOrToStrNode current) {
            return new SymbolOrToStrObjectNode((SymbolOrToStrBaseNode)current);
        }
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SymbolOrToStrRubyStringNode
    extends SymbolOrToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SymbolOrToStrRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        SymbolOrToStrRubyStringNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyString childValue;
            try {
                childValue = this.child.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.coerceRubyString(childValue);
        }

        @Override
        public String executeToJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyString childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.coerceRubyString(childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                RubyString childValueCast = RubyTypesGen.RUBYTYPES.asRubyString(childValue);
                return super.coerceRubyString(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SymbolOrToStrNode create0(SymbolOrToStrNode current) {
            return new SymbolOrToStrRubyStringNode((SymbolOrToStrBaseNode)current);
        }
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SymbolOrToStrRubySymbolNode
    extends SymbolOrToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SymbolOrToStrRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubySymbol.class}, 0, 0);

        SymbolOrToStrRubySymbolNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            RubySymbol childValue;
            try {
                childValue = this.child.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.coerceRubySymbol(childValue);
        }

        @Override
        public String executeToJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            RubySymbol childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubySymbol(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubySymbol");
            }
            return super.coerceRubySymbol(childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                RubySymbol childValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(childValue);
                return super.coerceRubySymbol(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SymbolOrToStrNode create0(SymbolOrToStrNode current) {
            return new SymbolOrToStrRubySymbolNode((SymbolOrToStrBaseNode)current);
        }
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class SymbolOrToStrUninitializedNode
    extends SymbolOrToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SymbolOrToStrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        SymbolOrToStrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        SymbolOrToStrUninitializedNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            String value;
            try {
                value = this.executeString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public String executeToJavaString(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected String executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected String executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            SymbolOrToStrBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                SymbolOrToStrBaseNode rootNode = (SymbolOrToStrBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((SymbolOrToStrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static SymbolOrToStrNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new SymbolOrToStrUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=SymbolOrToStrNode.class)
    private static abstract class SymbolOrToStrBaseNode
    extends SymbolOrToStrNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected SymbolOrToStrBaseNode next0;

        SymbolOrToStrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        SymbolOrToStrBaseNode(SymbolOrToStrBaseNode copy) {
            super(copy);
        }

        protected abstract String executeChained0(VirtualFrame var1, Object var2);

        protected final String rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            SymbolOrToStrBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            SymbolOrToStrBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new SymbolOrToStrUninitializedNode(this);
                ((SymbolOrToStrUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (SymbolOrToStrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SymbolOrToStrBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (SymbolOrToStrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SymbolOrToStrUninitializedNode(this), (Node)new SymbolOrToStrPolymorphicNode(this), (DSLNode)((SymbolOrToStrBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final SymbolOrToStrBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubySymbol(childValue)) {
                return (SymbolOrToStrBaseNode)SymbolOrToStrRubySymbolNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                return (SymbolOrToStrBaseNode)SymbolOrToStrRubyStringNode.create0(this);
            }
            if (!super.isRubySymbol(childValue) && !super.isRubyString(childValue)) {
                return (SymbolOrToStrBaseNode)SymbolOrToStrObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((SymbolOrToStrBaseNode)other).child;
            this.next0 = newNext == null ? null : (SymbolOrToStrBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

