/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.NewFixnumLowerNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=NewFixnumLowerNode.class)
public final class NewFixnumLowerNodeFactory
extends NodeFactoryBase<NewFixnumLowerNode> {
    private static NewFixnumLowerNodeFactory instance;

    private NewFixnumLowerNodeFactory() {
        super(NewFixnumLowerNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public NewFixnumLowerNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return NewFixnumLowerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NewFixnumLowerNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return NewFixnumLowerUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<NewFixnumLowerNode> getInstance() {
        if (instance == null) {
            instance = new NewFixnumLowerNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class NewFixnumLowerPolymorphicNode
    extends NewFixnumLowerBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        NewFixnumLowerPolymorphicNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : this.child.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class NewFixnumLowerLongNode
    extends NewFixnumLowerBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NewFixnumLowerLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        NewFixnumLowerLongNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            if (!NewFixnumLowerBaseNode.canLower(childValue)) {
                return super.lowerFails(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, childValue, "One of guards [!canLower] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            long childValueCast;
            if (RubyTypesGen.RUBYTYPES.isLong(childValue) && !NewFixnumLowerBaseNode.canLower(childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue))) {
                return super.lowerFails(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static NewFixnumLowerNode create0(NewFixnumLowerNode current) {
            return new NewFixnumLowerLongNode((NewFixnumLowerBaseNode)current);
        }
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class NewFixnumLowerIntLongNode
    extends NewFixnumLowerBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NewFixnumLowerIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        NewFixnumLowerIntLongNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            if (NewFixnumLowerBaseNode.canLower(childValue)) {
                return super.lower(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, childValue, "One of guards [canLower] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            long childValueCast;
            if (RubyTypesGen.RUBYTYPES.isLong(childValue) && NewFixnumLowerBaseNode.canLower(childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue))) {
                return super.lower(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static NewFixnumLowerNode create0(NewFixnumLowerNode current) {
            return new NewFixnumLowerIntLongNode((NewFixnumLowerBaseNode)current);
        }
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class NewFixnumLowerIntNode
    extends NewFixnumLowerBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NewFixnumLowerIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        NewFixnumLowerIntNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int"));
            }
            return super.lower(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.lower(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static NewFixnumLowerNode create0(NewFixnumLowerNode current) {
            return new NewFixnumLowerIntNode((NewFixnumLowerBaseNode)current);
        }
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class NewFixnumLowerUninitializedNode
    extends NewFixnumLowerBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NewFixnumLowerUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        NewFixnumLowerUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        NewFixnumLowerUninitializedNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            NewFixnumLowerBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                NewFixnumLowerBaseNode rootNode = (NewFixnumLowerBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((NewFixnumLowerBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static NewFixnumLowerNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new NewFixnumLowerUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=NewFixnumLowerNode.class)
    private static abstract class NewFixnumLowerBaseNode
    extends NewFixnumLowerNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected NewFixnumLowerBaseNode next0;

        NewFixnumLowerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        NewFixnumLowerBaseNode(NewFixnumLowerBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            NewFixnumLowerBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            NewFixnumLowerBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new NewFixnumLowerUninitializedNode(this);
                ((NewFixnumLowerUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (NewFixnumLowerBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NewFixnumLowerBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (NewFixnumLowerBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NewFixnumLowerUninitializedNode(this), (Node)new NewFixnumLowerPolymorphicNode(this), (DSLNode)((NewFixnumLowerBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final NewFixnumLowerBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (NewFixnumLowerBaseNode)NewFixnumLowerIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                if (NewFixnumLowerNode.canLower(childValueCast)) {
                    return (NewFixnumLowerBaseNode)NewFixnumLowerIntLongNode.create0(this);
                }
                return (NewFixnumLowerBaseNode)NewFixnumLowerLongNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((NewFixnumLowerBaseNode)other).child;
            this.next0 = newNext == null ? null : (NewFixnumLowerBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

