/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.EnsureCapacityArrayNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=EnsureCapacityArrayNode.class)
public final class EnsureCapacityArrayNodeFactory
extends NodeFactoryBase<EnsureCapacityArrayNode> {
    private static EnsureCapacityArrayNodeFactory instance;

    private EnsureCapacityArrayNodeFactory() {
        super(EnsureCapacityArrayNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
    }

    public EnsureCapacityArrayNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return EnsureCapacityArrayNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static EnsureCapacityArrayNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return EnsureCapacityArrayUninitializedNode.create0(context, sourceSection, array, requiredCapacity);
    }

    public static NodeFactory<EnsureCapacityArrayNode> getInstance() {
        if (instance == null) {
            instance = new EnsureCapacityArrayNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class EnsureCapacityArrayPolymorphicNode
    extends EnsureCapacityArrayBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> requiredCapacityPolymorphicType;

        EnsureCapacityArrayPolymorphicNode(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            Object requiredCapacityValue = this.requiredCapacity.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer requiredCapacityValue = requiredCapacityValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.requiredCapacityPolymorphicType = types[1];
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class EnsureCapacityArrayRubyArray3Node
    extends EnsureCapacityArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(EnsureCapacityArrayRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        EnsureCapacityArrayRubyArray3Node(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isObjectArray(arrayValue)) {
                return super.ensureCapacityObject(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isObjectArray] failed");
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isObjectArray(arrayValue)) {
                return super.ensureCapacityObject(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isObjectArray] failed");
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isObjectArray(arrayValueCast)) {
                    return super.ensureCapacityObject(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static EnsureCapacityArrayNode create0(EnsureCapacityArrayNode current) {
            return new EnsureCapacityArrayRubyArray3Node((EnsureCapacityArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class EnsureCapacityArrayRubyArray2Node
    extends EnsureCapacityArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(EnsureCapacityArrayRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        EnsureCapacityArrayRubyArray2Node(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return super.ensureCapacityDouble(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isDoubleArray] failed");
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return super.ensureCapacityDouble(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isDoubleArray] failed");
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return super.ensureCapacityDouble(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static EnsureCapacityArrayNode create0(EnsureCapacityArrayNode current) {
            return new EnsureCapacityArrayRubyArray2Node((EnsureCapacityArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class EnsureCapacityArrayRubyArray1Node
    extends EnsureCapacityArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(EnsureCapacityArrayRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        EnsureCapacityArrayRubyArray1Node(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isLongArray(arrayValue)) {
                return super.ensureCapacityLong(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isLongArray] failed");
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isLongArray(arrayValue)) {
                return super.ensureCapacityLong(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isLongArray] failed");
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isLongArray(arrayValueCast)) {
                    return super.ensureCapacityLong(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static EnsureCapacityArrayNode create0(EnsureCapacityArrayNode current) {
            return new EnsureCapacityArrayRubyArray1Node((EnsureCapacityArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class EnsureCapacityArrayRubyArray0Node
    extends EnsureCapacityArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(EnsureCapacityArrayRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        EnsureCapacityArrayRubyArray0Node(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isIntArray(arrayValue)) {
                return super.ensureCapacityInt(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isIntArray] failed");
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isIntArray(arrayValue)) {
                return super.ensureCapacityInt(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isIntArray] failed");
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isIntArray(arrayValueCast)) {
                    return super.ensureCapacityInt(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static EnsureCapacityArrayNode create0(EnsureCapacityArrayNode current) {
            return new EnsureCapacityArrayRubyArray0Node((EnsureCapacityArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class EnsureCapacityArrayUninitializedNode
    extends EnsureCapacityArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(EnsureCapacityArrayUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        EnsureCapacityArrayUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            super(context, sourceSection, array, requiredCapacity);
        }

        EnsureCapacityArrayUninitializedNode(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object requiredCapacityValue = this.requiredCapacity.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public Object executeEnsureCapacity(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer requiredCapacityValue = requiredCapacityValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        protected boolean executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            EnsureCapacityArrayBaseNode newNode = this.specialize0(arrayValue, requiredCapacityValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                EnsureCapacityArrayBaseNode rootNode = (EnsureCapacityArrayBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.requiredCapacity}, new Object[]{arrayValue, requiredCapacityValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((EnsureCapacityArrayBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static EnsureCapacityArrayNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            return new EnsureCapacityArrayUninitializedNode(context, sourceSection, array, requiredCapacity);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    private static abstract class EnsureCapacityArrayBaseNode
    extends EnsureCapacityArrayNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode requiredCapacity;
        @Node.Child
        protected EnsureCapacityArrayBaseNode next0;

        EnsureCapacityArrayBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            super(context, sourceSection);
            this.array = array;
            this.requiredCapacity = requiredCapacity;
        }

        EnsureCapacityArrayBaseNode(EnsureCapacityArrayBaseNode copy) {
            super(copy);
        }

        protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

        protected final boolean rewrite0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue, String reason) {
            String message;
            EnsureCapacityArrayBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            EnsureCapacityArrayBaseNode newNode = this.specialize0(arrayValue, requiredCapacityValue);
            if (newNode == null) {
                newNode = new EnsureCapacityArrayUninitializedNode(this);
                ((EnsureCapacityArrayUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (EnsureCapacityArrayBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EnsureCapacityArrayBaseNode.createInfo0(reason, arrayValue, requiredCapacityValue)))) == null) {
                returnNode = (EnsureCapacityArrayBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EnsureCapacityArrayUninitializedNode(this), (Node)new EnsureCapacityArrayPolymorphicNode(this), (DSLNode)((EnsureCapacityArrayBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final EnsureCapacityArrayBaseNode specialize0(Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isIntArray(arrayValueCast)) {
                    return (EnsureCapacityArrayBaseNode)EnsureCapacityArrayRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isLongArray(arrayValueCast)) {
                    return (EnsureCapacityArrayBaseNode)EnsureCapacityArrayRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return (EnsureCapacityArrayBaseNode)EnsureCapacityArrayRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isObjectArray(arrayValueCast)) {
                    return (EnsureCapacityArrayBaseNode)EnsureCapacityArrayRubyArray3Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.requiredCapacity = null;
            } else {
                EnsureCapacityArrayBaseNode otherCast = (EnsureCapacityArrayBaseNode)other;
                this.array = otherCast.array;
                this.requiredCapacity = otherCast.requiredCapacity;
            }
            this.next0 = newNext == null ? null : (EnsureCapacityArrayBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object requiredCapacityValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("requiredCapacityValue").append(" = ").append(requiredCapacityValue);
                if (requiredCapacityValue != null) {
                    builder.append(" (").append(requiredCapacityValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

