/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayReadDenormalizedNode.class)
public final class ArrayReadDenormalizedNodeFactory
extends NodeFactoryBase<ArrayReadDenormalizedNode> {
    private static ArrayReadDenormalizedNodeFactory instance;

    private ArrayReadDenormalizedNodeFactory() {
        super(ArrayReadDenormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayReadDenormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return ArrayReadDenormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayReadDenormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        return ArrayReadDenormalizedUninitializedNode.create0(context, sourceSection, array, index);
    }

    public static NodeFactory<ArrayReadDenormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayReadDenormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayReadDenormalizedPolymorphicNode
    extends ArrayReadDenormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;

        ArrayReadDenormalizedPolymorphicNode(ArrayReadDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadDenormalizedRubyArrayNode
    extends ArrayReadDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadDenormalizedRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadDenormalizedRubyArrayNode(ArrayReadDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
            }
            return super.read(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            return super.read(frameValue, arrayValue, indexValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                return super.read(frameValue, arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadDenormalizedNode create0(ArrayReadDenormalizedNode current) {
            return new ArrayReadDenormalizedRubyArrayNode((ArrayReadDenormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayReadDenormalizedUninitializedNode
    extends ArrayReadDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadDenormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayReadDenormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            super(context, sourceSection, array, index);
        }

        ArrayReadDenormalizedUninitializedNode(ArrayReadDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            ArrayReadDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayReadDenormalizedBaseNode rootNode = (ArrayReadDenormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index}, new Object[]{arrayValue, indexValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayReadDenormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadDenormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            return new ArrayReadDenormalizedUninitializedNode(context, sourceSection, array, index);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    private static abstract class ArrayReadDenormalizedBaseNode
    extends ArrayReadDenormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected ArrayReadDenormalizedBaseNode next0;

        ArrayReadDenormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
        }

        ArrayReadDenormalizedBaseNode(ArrayReadDenormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, String reason) {
            String message;
            ArrayReadDenormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayReadDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue);
            if (newNode == null) {
                newNode = new ArrayReadDenormalizedUninitializedNode(this);
                ((ArrayReadDenormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayReadDenormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayReadDenormalizedBaseNode.createInfo0(reason, arrayValue, indexValue)))) == null) {
                returnNode = (ArrayReadDenormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayReadDenormalizedUninitializedNode(this), (Node)new ArrayReadDenormalizedPolymorphicNode(this), (DSLNode)((ArrayReadDenormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayReadDenormalizedBaseNode specialize0(Object arrayValue, Object indexValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                return (ArrayReadDenormalizedBaseNode)ArrayReadDenormalizedRubyArrayNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
            } else {
                ArrayReadDenormalizedBaseNode otherCast = (ArrayReadDenormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
            }
            this.next0 = newNext == null ? null : (ArrayReadDenormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

