/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.parser;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.util.ByteList;
import org.prism.Loader;
import org.prism.ParseResult;

public class LoaderPrism
extends Loader {
    private Ruby runtime;
    private Encoding encoding = null;

    LoaderPrism(Ruby runtime, byte[] serialized, byte[] source) {
        super(serialized, source);
        this.runtime = runtime;
    }

    @Override
    public ParseResult load() {
        ParseResult result = super.load();
        this.resolveEncoding();
        return result;
    }

    @Override
    public RubySymbol bytesToName(byte[] bytes) {
        this.resolveEncoding();
        return this.runtime.newSymbol(new ByteList(bytes, this.encoding));
    }

    private void resolveEncoding() {
        if (this.encoding == null) {
            this.encoding = this.runtime.getEncodingService().findEncodingOrAliasEntry(this.encodingName.getBytes()).getEncoding();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }
}

