/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.parser;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import jnr.ffi.Runtime;
import org.jcodings.Encoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyIO;
import org.jruby.RubySymbol;
import org.jruby.lexer.LexingCommon;
import org.jruby.management.ParserStats;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserManager;
import org.jruby.parser.ParserType;
import org.jruby.parser.StaticScope;
import org.jruby.prism.parser.CoverageLineVisitor;
import org.jruby.prism.parser.LoaderPrism;
import org.jruby.prism.parser.ParseResultPrism;
import org.jruby.prism.parser.ParserBindingPrism;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.io.ChannelHelper;
import org.prism.Nodes;
import org.prism.ParseResult;
import org.prism.ParsingOptions;

public class ParserPrism
extends Parser {
    private final ParserBindingPrism prismLibrary;

    public ParserPrism(Ruby runtime, ParserBindingPrism prismLibrary) {
        super(runtime);
        this.prismLibrary = prismLibrary;
    }

    public ParseResult parse(String fileName, int lineNumber, ByteList content, DynamicScope existingScope, ParserType type) {
        int sourceLength = content.realSize();
        byte[] source = content.begin() == 0 ? content.unsafeBytes() : content.bytes();
        byte[] metadata = this.generateMetadata(fileName, lineNumber, content.getEncoding(), existingScope, type);
        byte[] serialized = this.parse(source, sourceLength, metadata);
        return this.parseInternal(fileName, existingScope, source, serialized, type);
    }

    private ParseResult parseInternal(String fileName, DynamicScope blockScope, byte[] source, byte[] serialized, ParserType type) {
        int lineCount;
        RubyArray lines;
        long time = 0L;
        if (ParserManager.PARSER_TIMING) {
            time = System.nanoTime();
        }
        LoaderPrism loader = new LoaderPrism(this.runtime, serialized, source);
        org.prism.ParseResult res = loader.load();
        Encoding encoding = loader.getEncoding();
        if (ParserManager.PARSER_TIMING) {
            ParseResult.Warning[] stats = this.runtime.getParserManager().getParserStats();
            stats.addPrismTimeDeserializing(System.nanoTime() - time);
            stats.addPrismSerializedBytes(serialized.length);
            stats.addParsedBytes(source.length);
        }
        if (res.warnings != null) {
            for (ParseResult.Warning warning : res.warnings) {
                this.runtime.getWarnings().warn(fileName, res.source.line(warning.location.startOffset), warning.message);
            }
        }
        if (res.errors != null && res.errors.length > 0) {
            int line = res.source.line(res.errors[0].location.startOffset);
            throw this.runtime.newSyntaxError(fileName + ":" + line + ": " + res.errors[0].message);
        }
        if (type == ParserType.MAIN && res.dataLocation != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(source, 0, source.length);
            bais.skip(res.dataLocation.startOffset + 8);
            this.runtime.defineDATA((IRubyObject)RubyIO.newIO((Ruby)this.runtime, (Channel)ChannelHelper.readableChannel((InputStream)bais)));
        }
        if ((lines = this.getLines(type == ParserType.EVAL, fileName, lineCount = res.source.getLineCount())) != null) {
            this.populateScriptData(source, encoding, lines);
        }
        int coverageMode = 0;
        if (type != ParserType.EVAL && this.runtime.getCoverageData().isCoverageEnabled()) {
            int[] coverage = new int[lineCount - 1];
            Arrays.fill(coverage, -1);
            CoverageLineVisitor visitor = new CoverageLineVisitor(res.source, coverage);
            visitor.defaultVisit(res.value);
            this.runtime.getCoverageData().prepareCoverage(fileName, coverage);
            coverageMode = this.runtime.getCoverageData().getMode();
        }
        ParseResultPrism result = new ParseResultPrism(fileName, source, (Nodes.ProgramNode)res.value, res.source, encoding, coverageMode);
        if (blockScope != null) {
            if (type == ParserType.MAIN) {
                RubySymbol[] locals = ((Nodes.ProgramNode)result.getAST()).locals;
                for (int i = 0; i < locals.length; ++i) {
                    blockScope.getStaticScope().addVariableThisScope(locals[i].idString());
                }
                blockScope.growIfNeeded();
                result.setDynamicScope(blockScope);
            } else {
                result.getStaticScope().setEnclosingScope(blockScope.getStaticScope());
            }
        }
        return result;
    }

    private void populateScriptData(byte[] source, Encoding encoding, RubyArray lines) {
        int begin = 0;
        int lineNumber = 0;
        for (int i = 0; i < source.length; ++i) {
            if (source[i] != 10) continue;
            ByteList line = new ByteList(source, begin, i - begin + 1);
            line.setEncoding(encoding);
            lines.aset((IRubyObject)this.runtime.newFixnum(lineNumber), (IRubyObject)this.runtime.newString(line));
            begin = i + 1;
            ++lineNumber;
        }
    }

    protected ParseResult parse(String fileName, int lineNumber, InputStream in, Encoding encoding, DynamicScope existingScope, ParserType type) {
        byte[] source = this.getSourceAsBytes(fileName, in);
        byte[] metadata = this.generateMetadata(fileName, lineNumber, encoding, existingScope, type);
        byte[] serialized = this.parse(source, source.length, metadata);
        return this.parseInternal(fileName, existingScope, source, serialized, type);
    }

    private byte[] getSourceAsBytes(String fileName, InputStream in) {
        if (in instanceof LoadServiceResourceInputStream) {
            return ((LoadServiceResourceInputStream)in).getBytes();
        }
        return this.loadFully(fileName, in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadFully(String fileName, InputStream in) {
        try (DataInputStream data = new DataInputStream(in);){
            int length = data.available();
            byte[] source = new byte[length];
            data.readFully(source);
            byte[] byArray = source;
            return byArray;
        }
        catch (IOException e) {
            throw this.runtime.newSyntaxError("Failed to read source file: " + fileName);
        }
    }

    private byte[] parse(byte[] source, int sourceLength, byte[] metadata) {
        long time = 0L;
        if (ParserManager.PARSER_TIMING) {
            time = System.nanoTime();
        }
        ParserBindingPrism.Buffer buffer = new ParserBindingPrism.Buffer(Runtime.getRuntime((Object)this.prismLibrary));
        this.prismLibrary.pm_buffer_init(buffer);
        this.prismLibrary.pm_serialize_parse(buffer, source, sourceLength, metadata);
        if (ParserManager.PARSER_TIMING) {
            ParserStats stats = this.runtime.getParserManager().getParserStats();
            stats.addPrismTimeCParseSerialize(System.nanoTime() - time);
        }
        int length = buffer.length.intValue();
        byte[] src = new byte[length];
        buffer.value.get().get(0L, src, 0, length);
        return src;
    }

    private byte[] generateMetadata(String fileName, int lineNumber, Encoding encoding, DynamicScope scope, ParserType type) {
        ByteList metadata = new ByteList();
        byte[] name = fileName.getBytes();
        this.appendUnsignedInt(metadata, name.length);
        metadata.append(name);
        this.appendUnsignedInt(metadata, lineNumber + 1);
        name = encoding.getName();
        this.appendUnsignedInt(metadata, name.length);
        metadata.append(name);
        metadata.append(this.runtime.getInstanceConfig().isFrozenStringLiteral() ? 1 : 0);
        if ("3.1".equals("3.3")) {
            metadata.append(ParsingOptions.SyntaxVersion.V3_3.getValue());
        } else {
            metadata.append(ParsingOptions.SyntaxVersion.LATEST.getValue());
        }
        if (type == ParserType.EVAL) {
            this.encodeEvalScopes(metadata, scope.getStaticScope());
        } else {
            this.appendUnsignedInt(metadata, 0);
        }
        return metadata.bytes();
    }

    private void writeUnsignedInt(ByteList buf, int index, int value) {
        buf.set(index, value);
        buf.set(index + 1, value >>> 8);
        buf.set(index + 2, value >>> 16);
        buf.set(index + 3, value >>> 24);
    }

    private void appendUnsignedInt(ByteList buf, int value) {
        buf.append(value);
        buf.append(value >>> 8);
        buf.append(value >>> 16);
        buf.append(value >>> 24);
    }

    private byte[] encodeEvalScopes(ByteList buf, StaticScope scope) {
        int startIndex = buf.realSize();
        this.appendUnsignedInt(buf, 0);
        int count = this.encodeEvalScopesInner(buf, scope, 1);
        this.writeUnsignedInt(buf, startIndex, count);
        return buf.bytes();
    }

    private int encodeEvalScopesInner(ByteList buf, StaticScope scope, int count) {
        if (scope.getEnclosingScope() != null && scope.isBlockScope()) {
            count = this.encodeEvalScopesInner(buf, scope.getEnclosingScope(), count + 1);
        }
        String[] names = scope.getVariables();
        this.appendUnsignedInt(buf, names.length);
        for (String name : names) {
            byte[] bytes = name.getBytes(ISO8859_1Encoding.INSTANCE.getCharset());
            this.appendUnsignedInt(buf, bytes.length);
            buf.append(bytes);
        }
        return count;
    }

    public IRubyObject getLineStub(ThreadContext context, ParseResult arg, int lineCount) {
        ParseResultPrism result = (ParseResultPrism)arg;
        int[] lines = new int[lineCount];
        Arrays.fill(lines, -1);
        CoverageLineVisitor lineVisitor = new CoverageLineVisitor(result.nodeSource, lines);
        lineVisitor.defaultVisit(result.root);
        RubyArray lineStubs = context.runtime.newArray(lineCount);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == 0) {
                lineStubs.set(i, (Object)context.runtime.newFixnum(0));
                continue;
            }
            lineStubs.set(i, (Object)context.runtime.getNil());
        }
        return lineStubs;
    }

    public ParseResult addGetsLoop(Ruby runtime, ParseResult result, boolean printing, boolean processLineEndings, boolean split) {
        Nodes.StatementsNode stmts;
        ArrayList<Nodes.Node> newBody = new ArrayList<Nodes.Node>();
        if (processLineEndings) {
            newBody.add(new Nodes.GlobalVariableWriteNode(runtime.newSymbol(CommonByteLists.DOLLAR_BACKSLASH), new Nodes.GlobalVariableReadNode(runtime.newSymbol(CommonByteLists.DOLLAR_SLASH), 0, 0), 0, 0));
        }
        Nodes.GlobalVariableReadNode dollarUnderscore = new Nodes.GlobalVariableReadNode(runtime.newSymbol(LexingCommon.DOLLAR_UNDERSCORE), 0, 0);
        ArrayList<Nodes.Node> whileBody = new ArrayList<Nodes.Node>();
        if (processLineEndings) {
            whileBody.add(new Nodes.CallNode(0, dollarUnderscore, runtime.newSymbol("chomp!"), null, null, 0, 0));
        }
        if (split) {
            whileBody.add(new Nodes.GlobalVariableWriteNode(runtime.newSymbol("$F"), new Nodes.CallNode(0, dollarUnderscore, runtime.newSymbol("split"), null, null, 0, 0), 0, 0));
        }
        if ((stmts = ((Nodes.ProgramNode)result.getAST()).statements) != null && stmts.body != null) {
            whileBody.addAll(Arrays.asList(stmts.body));
        }
        Nodes.ArgumentsNode args = new Nodes.ArgumentsNode(0, new Nodes.Node[]{dollarUnderscore}, 0, 0);
        if (printing) {
            whileBody.add(new Nodes.CallNode(0, null, runtime.newSymbol("print"), args, null, 0, 0));
        }
        Nodes.Node[] nodes = new Nodes.Node[whileBody.size()];
        whileBody.toArray(nodes);
        Nodes.StatementsNode statements = new Nodes.StatementsNode(nodes, 0, 0);
        newBody.add(new Nodes.WhileNode(0, new Nodes.CallNode(2, null, runtime.newSymbol("gets"), null, null, 0, 0), statements, 0, 0));
        nodes = new Nodes.Node[newBody.size()];
        newBody.toArray(nodes);
        Nodes.ProgramNode newRoot = new Nodes.ProgramNode(new RubySymbol[0], new Nodes.StatementsNode(nodes, 0, 0), 0, 0);
        ((ParseResultPrism)result).setRoot(newRoot);
        return result;
    }
}

