/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BlockGivenInstr
extends Instr
implements ResultInstr {
    private Variable result;
    private Operand blockArg;

    public BlockGivenInstr(Variable result2, Operand block) {
        super(Operation.BLOCK_GIVEN);
        assert (result2 != null) : "BlockGivenInstr result is null";
        this.result = result2;
        this.blockArg = block;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.blockArg};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    public Operand getBlockArg() {
        return this.blockArg;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.blockArg = this.blockArg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new BlockGivenInstr(ii.getRenamedVariable(this.result), this.blockArg.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        Object blk = this.blockArg.retrieve(context, self2, currDynScope, temp);
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        Block b2 = (Block)blk;
        return context.runtime.newBoolean(b2.isGiven());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BlockGivenInstr(this);
    }
}

