/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.collections.ClassValue;
import org.jruby.util.collections.ClassValueCalculator;

public class JavaSupport {
    private final Ruby runtime;
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            return Java.allocateProxy(javaObject, clazz);
        }
    };
    private final ClassValue<JavaClass> javaClassCache;
    private final ClassValue<RubyModule> proxyClassCache;
    private final Map<Class, UnfinishedProxy> unfinishedProxies;
    private final ClassValue<Map<String, AssignedName>> staticAssignedNames;
    private final ClassValue<Map<String, AssignedName>> instanceAssignedNames;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    private JavaClass objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass arrayJavaProxyCreatorClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private RubyClass mapJavaProxy;
    private RubyClass javaProxyConstructorClass;
    private final Map<String, JavaClass> nameClassMap = new HashMap<String, JavaClass>(64);
    private Map<Set<?>, JavaProxyClass> javaProxyClassCache = Collections.synchronizedMap(new HashMap());
    @Deprecated
    private volatile Map<Object, Object[]> javaObjectVariables;

    public JavaSupport(final Ruby runtime) {
        this.runtime = runtime;
        this.javaClassCache = ClassValue.newInstance(new ClassValueCalculator<JavaClass>(){

            @Override
            public JavaClass computeValue(Class<?> cls) {
                return new JavaClass(runtime, cls);
            }
        });
        this.proxyClassCache = ClassValue.newInstance(new ClassValueCalculator<RubyModule>(){

            @Override
            public synchronized RubyModule computeValue(Class<?> cls) {
                return Java.createProxyClassForClass(runtime, cls);
            }
        });
        this.staticAssignedNames = ClassValue.newInstance(new ClassValueCalculator<Map<String, AssignedName>>(){

            @Override
            public Map<String, AssignedName> computeValue(Class<?> cls) {
                return new HashMap<String, AssignedName>();
            }
        });
        this.instanceAssignedNames = ClassValue.newInstance(new ClassValueCalculator<Map<String, AssignedName>>(){

            @Override
            public Map<String, AssignedName> computeValue(Class<?> cls) {
                return new HashMap<String, AssignedName>();
            }
        });
        this.unfinishedProxies = new ConcurrentHashMap<Class, UnfinishedProxy>(8, 0.75f, 1);
    }

    public Class loadJavaClass(String className) throws ClassNotFoundException {
        Class primitiveClass = JavaUtil.PRIMITIVE_CLASSES.get(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(className, true, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className);
        }
        return primitiveClass;
    }

    public Class loadJavaClassVerbose(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className + ", probable missing dependency: " + le.getLocalizedMessage(), className, le);
        }
        catch (SecurityException se) {
            if (this.runtime.isVerbose()) {
                se.printStackTrace(this.runtime.getErrorStream());
            }
            throw this.runtime.newSecurityError(se.getLocalizedMessage());
        }
    }

    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn, false);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie, false);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className, className, le, false);
        }
        catch (SecurityException se) {
            throw this.runtime.newSecurityError(se.getLocalizedMessage());
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public RubyModule getProxyClassFromCache(Class clazz) {
        return this.proxyClassCache.get(clazz);
    }

    public void handleNativeException(Throwable exception2, Member target) {
        if (exception2 instanceof RaiseException) {
            throw (RaiseException)exception2;
        }
        if (exception2 instanceof Unrescuable) {
            if (exception2 instanceof Error) {
                throw (Error)exception2;
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
        }
        throw this.createRaiseException(exception2, target);
    }

    private RaiseException createRaiseException(Throwable exception2, Member target) {
        return RaiseException.createNativeRaiseException(this.runtime, exception2, target);
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public Map<String, JavaClass> getNameClassMap() {
        return this.nameClassMap;
    }

    public RubyModule getJavaModule() {
        RubyModule module = this.javaModule;
        if (module != null) {
            return module;
        }
        this.javaModule = this.runtime.getModule("Java");
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        RubyModule module = this.javaUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaUtilitiesModule = this.runtime.getModule("JavaUtilities");
        return this.javaUtilitiesModule;
    }

    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule module = this.javaArrayUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaArrayUtilitiesModule = this.runtime.getModule("JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        RubyClass clazz = this.javaObjectClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaObjectClass = this.getJavaModule().getClass("JavaObject");
        return this.javaObjectClass;
    }

    public RubyClass getJavaProxyConstructorClass() {
        RubyClass clazz = this.javaProxyConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyConstructorClass = this.getJavaModule().getClass("JavaProxyConstructor");
        return this.javaProxyConstructorClass;
    }

    public JavaClass getObjectJavaClass() {
        return this.objectJavaClass;
    }

    public void setObjectJavaClass(JavaClass objectJavaClass) {
        this.objectJavaClass = objectJavaClass;
    }

    public RubyClass getJavaArrayClass() {
        RubyClass clazz = this.javaArrayClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaArrayClass = this.getJavaModule().getClass("JavaArray");
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        RubyClass clazz = this.javaClassClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaClassClass = this.getJavaModule().getClass("JavaClass");
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        RubyModule module = this.javaInterfaceTemplate;
        if (module != null) {
            return module;
        }
        this.javaInterfaceTemplate = this.runtime.getModule("JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        RubyModule module = this.packageModuleTemplate;
        if (module != null) {
            return module;
        }
        this.packageModuleTemplate = this.runtime.getModule("JavaPackageModuleTemplate");
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        RubyClass clazz = this.javaProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyClass = this.runtime.getClass("JavaProxy");
        return this.javaProxyClass;
    }

    public RubyClass getArrayJavaProxyCreatorClass() {
        RubyClass clazz = this.arrayJavaProxyCreatorClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayJavaProxyCreatorClass = this.runtime.getClass("ArrayJavaProxyCreator");
        return this.arrayJavaProxyCreatorClass;
    }

    public RubyClass getConcreteProxyClass() {
        RubyClass clazz = this.concreteProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.concreteProxyClass = this.runtime.getClass("ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    public RubyClass getMapJavaProxyClass() {
        RubyClass clazz = this.mapJavaProxy;
        if (clazz != null) {
            return clazz;
        }
        this.mapJavaProxy = this.runtime.getClass("MapJavaProxy");
        return this.mapJavaProxy;
    }

    public RubyClass getArrayProxyClass() {
        RubyClass clazz = this.arrayProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayProxyClass = this.runtime.getClass("ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    public RubyClass getJavaFieldClass() {
        RubyClass clazz = this.javaFieldClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaFieldClass = this.getJavaModule().getClass("JavaField");
        return this.javaFieldClass;
    }

    public RubyClass getJavaMethodClass() {
        RubyClass clazz = this.javaMethodClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaMethodClass = this.getJavaModule().getClass("JavaMethod");
        return this.javaMethodClass;
    }

    public RubyClass getJavaConstructorClass() {
        RubyClass clazz = this.javaConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaConstructorClass = this.getJavaModule().getClass("JavaConstructor");
        return this.javaConstructorClass;
    }

    public Map<Set<?>, JavaProxyClass> getJavaProxyClassCache() {
        return this.javaProxyClassCache;
    }

    public ClassValue<Map<String, AssignedName>> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    public ClassValue<Map<String, AssignedName>> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    public void beginProxy(Class cls, RubyModule proxy2) {
        UnfinishedProxy up = new UnfinishedProxy(proxy2);
        up.lock();
        this.unfinishedProxies.put(cls, up);
    }

    public void endProxy(Class cls) {
        UnfinishedProxy up = this.unfinishedProxies.remove(cls);
        up.unlock();
    }

    public RubyModule getUnfinishedProxy(Class cls) {
        UnfinishedProxy up = this.unfinishedProxies.get(cls);
        if (up != null && up.isHeldByCurrentThread()) {
            return up.proxy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object getJavaObjectVariable(Object o, int i2) {
        if (i2 == -1) {
            return null;
        }
        Map<Object, Object[]> variables = this.javaObjectVariables;
        if (variables == null) {
            return null;
        }
        JavaSupport javaSupport = this;
        synchronized (javaSupport) {
            Object[] vars = variables.get(o);
            if (vars == null || vars.length <= i2) {
                return null;
            }
            return vars[i2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setJavaObjectVariable(Object o, int i2, Object v) {
        if (i2 == -1) {
            return;
        }
        JavaSupport javaSupport = this;
        synchronized (javaSupport) {
            Object[] vars;
            WeakIdentityHashMap variables = this.javaObjectVariables;
            if (variables == null) {
                variables = this.javaObjectVariables = new WeakIdentityHashMap();
            }
            if ((vars = variables.get(o)) == null) {
                vars = new Object[i2 + 1];
                variables.put(o, vars);
            } else if (vars.length <= i2) {
                Object[] newVars = new Object[i2 + 1];
                System.arraycopy(vars, 0, newVars, 0, vars.length);
                variables.put(o, newVars);
                vars = newVars;
            }
            vars[i2] = v;
        }
    }

    @Deprecated
    public static Class getPrimitiveClass(String primitiveType) {
        return JavaUtil.PRIMITIVE_CLASSES.get(primitiveType);
    }

    private class UnfinishedProxy
    extends ReentrantLock {
        volatile RubyModule proxy;

        UnfinishedProxy(RubyModule proxy2) {
            this.proxy = proxy2;
        }
    }
}

