/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.FiberQueue;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadFiber.class);
    private static final BiConsumer<Ruby, Runnable> FIBER_LAUNCHER;
    private static final MethodHandle VTHREAD_START_METHOD;
    volatile FiberData data;
    volatile RubyThread thread;

    private static void nativeThreadLauncher(Ruby runtime2, Runnable runnable) {
        runtime2.getFiberExecutor().submit(runnable);
    }

    public ThreadFiber(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public static void initRootFiber(ThreadContext context, RubyThread currentThread) {
        Ruby runtime2 = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime2, runtime2.getFiber());
        rootFiber.data = new FiberData(new FiberQueue(runtime2), currentThread, rootFiber);
        rootFiber.thread = currentThread;
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new FiberQueue(runtime2), context.getFiberCurrentThread(), this);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime2, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null || data2.transferred) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime2, values2);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        data2.prev = context.getFiber();
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
            return iRubyObject;
        }
        finally {
            data2.prev = null;
        }
    }

    private static IRubyObject exchangeWithFiber(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, IRubyObject val) {
        targetFiberData.queue.push(context, val);
        try {
            IRubyObject result2 = currentFiberData.queue.pop(context);
            return result2 == NEVER ? context.nil : result2;
        }
        catch (RaiseException re) {
            ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
            IRubyObject result3 = currentFiberData.queue.pop(context);
            return result3 == NEVER ? context.nil : result3;
        }
    }

    private static void handleExceptionDuringExchange(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, RaiseException re) {
        if (context.runtime.getLocalJumpError().isInstance(re.getException())) {
            throw re;
        }
        if (currentFiberData.queue.isShutdown()) {
            throw re;
        }
        if (targetFiberData.queue.isShutdown()) {
            throw re;
        }
        ThreadFiber fiber2 = (ThreadFiber)targetFiberData.fiber.get();
        if (fiber2 == null || !fiber2.alive()) {
            throw re;
        }
        fiber2.thread.raise(re.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject __transfer__(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime2 = context.runtime;
        FiberData data2 = this.data;
        if (data2.prev != null) {
            throw runtime2.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime2.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (data2 == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime2, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime2, values2);
            }
        }
        if (data2.parent != context.getFiberCurrentThread()) {
            throw runtime2.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            data2.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            data2.prev = context.getFiber();
        }
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, data2, val);
            return iRubyObject;
        }
        finally {
            data2.prev = null;
            currentFiberData.transferred = false;
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime2 = context.runtime;
        FiberData currentFiberData = ThreadFiber.verifyCurrentFiber(context, runtime2);
        FiberData prevFiberData = currentFiberData.prev.data;
        return ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, value2);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject[] value2) {
        switch (value2.length) {
            case 0: {
                return ThreadFiber.yield(context, recv2);
            }
            case 1: {
                return ThreadFiber.yield(context, recv2, value2[0]);
            }
        }
        Ruby runtime2 = context.runtime;
        FiberData currentFiberData = ThreadFiber.verifyCurrentFiber(context, runtime2);
        FiberData prevFiberData = currentFiberData.prev.data;
        return ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, RubyArray.newArrayNoCopy(runtime2, value2));
    }

    private static FiberData verifyCurrentFiber(ThreadContext context, Ruby runtime2) {
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime2.newFiberError("can't yield from root fiber");
        }
        if (currentFiberData.prev == null) {
            throw runtime2.newFiberError("BUG: yield occurred with null previous fiber. Report this at http://bugs.jruby.org");
        }
        if (currentFiberData.queue.isShutdown()) {
            throw runtime2.newFiberError("dead fiber yielded");
        }
        return currentFiberData;
    }

    @JRubyMethod
    public IRubyObject __alive__(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.alive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __current__(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    final boolean alive() {
        RubyThread thread2 = this.thread;
        return thread2 != null && thread2.isAlive() && !this.data.queue.isShutdown();
    }

    static RubyThread createThread(Ruby runtime2, FiberData data2, FiberQueue queue, Block block) {
        AtomicReference fiberThread = new AtomicReference();
        boolean retried = false;
        while (!retried) {
            try {
                FIBER_LAUNCHER.accept(runtime2, () -> {
                    ThreadContext context = runtime2.getCurrentContext();
                    context.setFiber((ThreadFiber)data2.fiber.get());
                    context.useRecursionGuardsFrom(data2.parent.getContext());
                    fiberThread.set(context.getThread());
                    context.getThread().setFiberCurrentThread(data2.parent);
                    Thread thread2 = Thread.currentThread();
                    String oldName = thread2.getName();
                    thread2.setName("Fiber thread for block at: " + block.getBody().getFile() + ":" + block.getBody().getLine());
                    try {
                        IRubyObject init = data2.queue.pop(context);
                        try {
                            IRubyObject result2 = init == NEVER ? block.yieldSpecific(context) : block.yieldArray(context, init, null);
                            ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                            if (tf != null) {
                                tf.thread = null;
                            }
                            data2.prev.data.queue.push(context, result2);
                            data2.queue.shutdown();
                            runtime2.getThreadService().unregisterCurrentThread(context);
                        }
                        catch (Throwable throwable) {
                            data2.queue.shutdown();
                            runtime2.getThreadService().unregisterCurrentThread(context);
                            ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                            if (tf != null) {
                                tf.thread = null;
                            }
                            throw throwable;
                        }
                        ThreadFiber tf = (ThreadFiber)data2.fiber.get();
                        if (tf != null) {
                            tf.thread = null;
                        }
                    }
                    catch (JumpException.FlowControlException fce) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(fce.buildException(runtime2).getException());
                        }
                    }
                    catch (IRBreakJump bj) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(((RaiseException)IRException.BREAK_LocalJumpError.getException(runtime2)).getException());
                        }
                    }
                    catch (IRReturnJump rj) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(((RaiseException)IRException.RETURN_LocalJumpError.getException(runtime2)).getException());
                        }
                    }
                    catch (RaiseException re) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(re.getException());
                        }
                    }
                    catch (Throwable t) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(JavaUtil.convertJavaToUsableRubyObject(runtime2, t));
                        }
                    }
                    finally {
                        thread2.setName(oldName);
                    }
                });
                break;
            }
            catch (OutOfMemoryError oome) {
                oome.printStackTrace();
                String oomeMessage = oome.getMessage();
                if (!retried && oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                    System.gc();
                    retried = true;
                    continue;
                }
                throw oome;
            }
        }
        while (fiberThread.get() == null) {
            Thread.yield();
        }
        return (RubyThread)fiberThread.get();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject __finalize__(ThreadContext context) {
        try {
            this.doFinalize();
        }
        catch (Exception ignore) {
            return context.fals;
        }
        return context.nil;
    }

    private void doFinalize() {
        FiberData data2 = this.data;
        this.data = null;
        if (data2 != null) {
            if (data2.parent == null) {
                return;
            }
            data2.queue.shutdown();
        }
        RubyThread thread2 = this.thread;
        this.thread = null;
        if (thread2 != null) {
            thread2.dieFromFinalizer();
            thread2.interrupt();
            data2 = null;
            thread2 = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.doFinalize();
        }
        finally {
            super.finalize();
        }
    }

    public FiberData getData() {
        return this.data;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    static {
        VirtualThreadLauncher fiberLauncher = ThreadFiber::nativeThreadLauncher;
        MethodHandle start2 = null;
        if (Options.FIBER_VTHREADS.load().booleanValue()) {
            try {
                Method ofVirtualMethod = Thread.class.getMethod("ofVirtual", new Class[0]);
                Object builder = ofVirtualMethod.invoke(null, new Object[0]);
                Method startMethod = Class.forName("java.lang.Thread$Builder").getMethod("start", Runnable.class);
                start2 = MethodHandles.publicLookup().unreflect(startMethod).bindTo(builder);
                fiberLauncher = new VirtualThreadLauncher();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        VTHREAD_START_METHOD = start2;
        FIBER_LAUNCHER = fiberLauncher;
    }

    public static class FiberData {
        final FiberQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;

        FiberData(FiberQueue queue, RubyThread parent, ThreadFiber fiber2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
        }

        public ThreadFiber getPrev() {
            return this.prev;
        }
    }

    private static class VirtualThreadLauncher
    implements BiConsumer<Ruby, Runnable> {
        private VirtualThreadLauncher() {
        }

        @Override
        public void accept(Ruby ruby, Runnable runnable) {
            try {
                VTHREAD_START_METHOD.invokeWithArguments(runnable);
            }
            catch (Throwable t) {
                Helpers.throwException(t);
            }
        }
    }
}

