/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class LocalOptimizationPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Local Optimizations";
    }

    @Override
    public String getShortLabel() {
        return "Local Opts";
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        boolean reexamineCFG = false;
        CFG cfg = fic.getCFG();
        for (BasicBlock bb : cfg.getBasicBlocks()) {
            if (!LocalOptimizationPass.runLocalOptsOnBasicBlock(fic, bb)) continue;
            reexamineCFG = true;
            cfg.fixupEdges(bb);
        }
        if (reexamineCFG) {
            fic.getCFG().optimize();
        }
        new LiveVariableAnalysis().invalidate(fic);
        return null;
    }

    private static void recordSimplification(Variable res, Operand val, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        valueMap.put(res, val);
        ArrayList<Variable> valVars = new ArrayList<Variable>();
        val.addUsedVariables(valVars);
        for (Variable v : valVars) {
            List<Variable> x = simplificationMap.get(v);
            if (x == null) {
                x = new ArrayList<Variable>();
                simplificationMap.put(v, x);
            }
            x.add(res);
        }
    }

    public static Instr optInstr(FullInterpreterContext fic, Instr instr, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        List<Variable> simplifiedVars;
        Operand val = instr.simplifyAndGetResult(fic.getScope(), valueMap);
        if (instr instanceof BranchInstr) {
            instr = ((BranchInstr)instr).simplifyBranch(fic);
        }
        if (!(instr instanceof ResultInstr)) {
            return instr;
        }
        Instr newInstr = instr;
        Variable res = ((ResultInstr)((Object)instr)).getResult();
        if (val == null) {
            valueMap.remove(res);
        } else {
            if (!res.equals(val)) {
                LocalOptimizationPass.recordSimplification(res, val, valueMap, simplificationMap);
            }
            if (!instr.hasSideEffects()) {
                if (instr instanceof CopyInstr) {
                    if (res.equals(val) && instr.canBeDeletedFromScope(fic)) {
                        instr.markDead();
                    }
                } else {
                    newInstr = new CopyInstr(res, val);
                }
            }
        }
        if (!res.equals(val) && (simplifiedVars = simplificationMap.get(res)) != null) {
            for (Variable v : simplifiedVars) {
                valueMap.remove(v);
            }
            simplificationMap.remove(res);
        }
        return newInstr;
    }

    public static void runLocalOptsOnInstrArray(FullInterpreterContext fic, Instr[] instrs) {
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        for (int i2 = 0; i2 < instrs.length; ++i2) {
            Operation iop;
            Instr instr = instrs[i2];
            Instr newInstr = LocalOptimizationPass.optInstr(fic, instr, valueMap, simplificationMap);
            if (newInstr != instr) {
                instrs[i2] = newInstr;
            }
            if (!(iop = instr.getOperation()).startsBasicBlock() && !iop.endsBasicBlock() && (!iop.isCall() || instr.isDead())) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
        }
    }

    public static boolean runLocalOptsOnBasicBlock(FullInterpreterContext fic, BasicBlock b2) {
        boolean reexamineCFG = false;
        ListIterator<Instr> instrs = b2.getInstrs().listIterator();
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        while (instrs.hasNext()) {
            Operation iop;
            Instr instr = instrs.next();
            Instr newInstr = LocalOptimizationPass.optInstr(fic, instr, valueMap, simplificationMap);
            if (newInstr.isDead()) {
                if (newInstr != instr && instr.getOperation().endsBasicBlock()) {
                    reexamineCFG = true;
                }
                instrs.remove();
            } else if (newInstr != instr) {
                if (instr.getOperation().endsBasicBlock()) {
                    reexamineCFG = true;
                }
                instrs.set(newInstr);
            }
            if (!(iop = instr.getOperation()).isCall() || instr.isDead()) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
        }
        return reexamineCFG;
    }
}

