/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import jnr.posix.FileStat;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class RubyArgsFile
extends RubyObject {
    private static final ObjectAllocator ARGF_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyArgsFile(runtime2, klass);
        }
    };

    public RubyArgsFile(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public static void initArgsFile(Ruby runtime2) {
        RubyClass argfClass = runtime2.defineClass("ARGFClass", runtime2.getObject(), ARGF_ALLOCATOR);
        argfClass.includeModule(runtime2.getEnumerable());
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        IRubyObject argsFile = argfClass.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{null}, (Block)null);
        runtime2.setArgsFile(argsFile);
        runtime2.getGlobalVariables().defineReadonly("$<", new ArgsFileAccessor(runtime2), GlobalVariable.Scope.GLOBAL);
        runtime2.defineGlobalConstant("ARGF", argsFile);
        runtime2.defineReadonlyVariable("$FILENAME", runtime2.newString("-"), GlobalVariable.Scope.GLOBAL);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        RubyArray argv2 = args2.length == 1 && args2[0] == null ? runtime2.getObject().getConstant("ARGV").convertToArray() : runtime2.newArray(args2);
        if (runtime2.getArgsFile() == null) {
            this.dataWrapStruct(new ArgsFileData(runtime2, argv2));
        } else {
            ArgsFileData data2 = (ArgsFileData)runtime2.getArgsFile().dataGetStruct();
            this.dataWrapStruct(data2);
            data2.setArgs(argv2);
        }
        return this;
    }

    @Deprecated
    public static void setCurrentLineNumber(IRubyObject recv2, int newLineNumber) {
        recv2.getRuntime().setCurrentLine(newLineNumber);
    }

    @JRubyMethod(name={"argv"})
    public static IRubyObject argv(ThreadContext context, IRubyObject recv2) {
        return ArgsFileData.getArgsFileData(context.runtime).argv;
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream").fileno(context);
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream");
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2, internalEncoding);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding, IRubyObject options2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2, internalEncoding, options2);
    }

    @JRubyMethod
    public static IRubyObject internal_encoding(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").internal_encoding(context);
    }

    @JRubyMethod
    public static IRubyObject external_encoding(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").external_encoding(context);
    }

    private static IRubyObject argf_getline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (true) {
            if (!data2.next_argv(context)) {
                return context.nil;
            }
            line = data2.currentFile.callMethod(context, "gets", args2);
            if (!line.isNil() || data2.next_p == -1) break;
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
        }
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.setLastLine(RubyArgsFile.argf_getline(context, recv2, args2));
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        Ruby runtime2 = context.runtime;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(runtime2);
        if (!data2.next_argv(context)) {
            return runtime2.newEmptyArray();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "readlines", args2);
        }
        RubyArray ary = runtime2.newArray();
        while (!(line = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject to_a(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        Ruby runtime2 = context.runtime;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(runtime2);
        if (!data2.next_argv(context)) {
            return runtime2.newEmptyArray();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "to_a", args2);
        }
        RubyArray ary = runtime2.newArray();
        while ((line = RubyArgsFile.argf_getline(context, recv2, args2)) != context.nil) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject bt;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_byte");
        }
        while ((bt = RubyArgsFile.getc(context, recv2)) != context.nil) {
            block.yield(context, bt);
        }
        return recv2;
    }

    @JRubyMethod
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_byte");
    }

    @JRubyMethod(optional=1)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "bytes");
    }

    @JRubyMethod
    public static IRubyObject each_char(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_char");
    }

    @JRubyMethod
    public static IRubyObject chars(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "chars");
    }

    public static IRubyObject each_charCommon(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ch;
        Ruby runtime2 = context.runtime;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(runtime2);
        while ((ch = RubyArgsFile.getc(context, recv2)) != context.nil) {
            boolean cont = true;
            while (cont) {
                cont = false;
                byte c = (byte)RubyNumeric.fix2int(ch);
                int n = runtime2.getKCode().getEncoding().length(c);
                IRubyObject file2 = data2.currentFile;
                RubyString str = runtime2.newString();
                str.setTaint(true);
                str.cat(c);
                while (--n > 0) {
                    ch = RubyArgsFile.getc(context, recv2);
                    if (ch == context.nil) {
                        block.yield(context, str);
                        return recv2;
                    }
                    if (data2.currentFile != file2) {
                        block.yield(context, str);
                        cont = true;
                        continue;
                    }
                    c = (byte)RubyNumeric.fix2int(ch);
                    str.cat(c);
                }
                block.yield(context, str);
            }
        }
        return recv2;
    }

    @JRubyMethod
    public static IRubyObject each_codepoint(ThreadContext context, IRubyObject recv2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        CallSite each_codepoint2 = RubyArgsFile.sites((ThreadContext)context).each_codepoint;
        while (data2.next_argv(context)) {
            each_codepoint2.call(context, recv2, data2.currentFile, block);
        }
        return context.nil;
    }

    @JRubyMethod
    public static IRubyObject codepoints(ThreadContext context, IRubyObject recv2, Block block) {
        context.runtime.getWarnings().warn("ARGF#codepoints is deprecated; use #each_codepoint instead");
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        return RubyArgsFile.each_codepoint(context, recv2, block);
    }

    @JRubyMethod(name={"each_line"}, optional=1)
    public static IRubyObject each_line(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject str;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line", args2);
        }
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            return context.nil;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            if (!data2.next_argv(context)) {
                return recv2;
            }
            data2.currentFile.callMethod(context, "each", NULL_ARRAY, block);
            data2.next_p = 1;
        }
        while ((str = RubyArgsFile.argf_getline(context, recv2, args2)) != context.nil) {
            block.yield(context, str);
        }
        return recv2;
    }

    @Deprecated
    @JRubyMethod(optional=1)
    public static IRubyObject lines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        return RubyArgsFile.each_line(context, recv2, args2, block);
    }

    @Deprecated
    public static IRubyObject each_line19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyArgsFile.each_line(context, recv2, args2, block);
    }

    @JRubyMethod(name={"each"}, optional=1)
    public static IRubyObject each(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each", args2);
    }

    @Deprecated
    public static IRubyObject each19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyArgsFile.each(context, recv2, args2, block);
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        return data2.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        ArgsFileData data2 = ArgsFileData.getArgsFileData(runtime2);
        if (data2.inited && data2.next_p == 0) {
            RubyArgsFile.argf_close(runtime2.getCurrentContext(), data2.currentFile);
            data2.next_p = 1;
        }
        return recv2;
    }

    public static void argf_close(ThreadContext context, IRubyObject file2) {
        if (file2 instanceof RubyIO) {
            ((RubyIO)file2).rbIoClose(context);
        } else {
            file2.callMethod(context, "close");
        }
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        if (data2.currentFile == context.runtime.getGlobalVariables().get("$stdin")) {
            return recv2;
        }
        RubyArgsFile.argf_close(context, data2.currentFile);
        if (data2.next_p != -1) {
            data2.next_p = 1;
        }
        context.runtime.setCurrentLine(0);
        return recv2;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        return RubyBoolean.newBoolean(context.runtime, RubyArgsFile.isClosed(context, data2.currentFile));
    }

    private static boolean isClosed(ThreadContext context, IRubyObject currentFile) {
        if (!(currentFile instanceof RubyIO)) {
            return currentFile.callMethod(context, "closed?").isTrue();
        }
        return ((RubyIO)currentFile).closed_p(context).isTrue();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.binmode = true;
        if (data2.currentFile != context.nil) {
            ((RubyIO)data2.currentFile).binmode();
        }
        return recv2;
    }

    @JRubyMethod(name={"binmode?"})
    public static IRubyObject op_binmode(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream").op_binmode(context);
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newFixnum(context.runtime.getCurrentLine());
    }

    @JRubyMethod(name={"lineno="})
    public static IRubyObject lineno_set(ThreadContext context, IRubyObject recv2, IRubyObject line) {
        context.runtime.setCurrentLine(RubyNumeric.fix2int(line));
        return context.nil;
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to tell").pos(context);
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv2) {
        RubyIO currentFile = RubyArgsFile.getCurrentDataFile(context, "no stream to rewind");
        RubyFixnum retVal = currentFile.rewind(context);
        currentFile.lineno_set(context, context.runtime.newFixnum(0));
        return retVal;
    }

    @JRubyMethod(name={"eof"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.inited) {
            return context.tru;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"eof?"})
    public static IRubyObject eof_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.inited) {
            return context.tru;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof?");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv2, IRubyObject offset2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set position").pos_set(context, offset2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to seek").seek(context, args2);
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getc(context, recv2);
        if (c == context.nil) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public static IRubyObject getbyte(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (data2.next_argv(context)) {
            IRubyObject bt = data2.currentFile instanceof RubyFile ? ((RubyIO)data2.currentFile).getbyte(context) : data2.currentFile.callMethod(context, "getbyte");
            if (bt != context.nil) {
                return bt;
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
        }
        return context.nil;
    }

    @JRubyMethod(required=1, optional=2)
    public static IRubyObject read_nonblock(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.getPartial(context, recv2, args2, true);
    }

    @JRubyMethod(required=1, optional=1)
    public static IRubyObject readpartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.getPartial(context, recv2, args2, false);
    }

    private static IRubyObject getPartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, boolean nonBlocking) {
        ArgsFileData data2;
        Ruby runtime2 = context.runtime;
        boolean noException = false;
        RubyString str = null;
        if (args2.length > 1) {
            IRubyObject opts = TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
            if (opts != context.nil && context.fals == ((RubyHash)opts).op_aref(context, runtime2.newSymbol("exception"))) {
                noException = true;
            }
            if ((args2.length > 2 || opts == context.nil) && args2[1] != context.nil) {
                args2[1] = args2[1].convertToString();
                str = (RubyString)args2[1];
            }
        }
        if (!(data2 = ArgsFileData.getArgsFileData(runtime2)).next_argv(context)) {
            if (str != null) {
                str.clear();
            }
            return RubyIO.nonblockEOF(runtime2, noException);
        }
        IRubyObject res = ((RubyIO)data2.currentFile).getPartial(context, args2, nonBlocking, noException);
        if (res == context.nil) {
            if (data2.next_p == -1) {
                return RubyIO.nonblockEOF(runtime2, noException);
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
            if (data2.argv.isEmpty()) {
                return RubyIO.nonblockEOF(runtime2, noException);
            }
            if (args2.length > 1 && args2[1] instanceof RubyString) {
                return args2[1];
            }
            return RubyString.newEmptyString(runtime2);
        }
        return res;
    }

    @JRubyMethod
    public static IRubyObject readbyte(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getbyte(context, recv2);
        if (c.isNil()) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (data2.next_argv(context)) {
            IRubyObject bt = data2.currentFile instanceof RubyFile ? ((RubyIO)data2.currentFile).getbyte(context) : data2.currentFile.callMethod(context, "getc");
            if (bt != context.nil) {
                return bt;
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
        }
        return context.nil;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject str;
        IRubyObject length2;
        Ruby runtime2 = context.runtime;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        long len = 0L;
        if (args2.length > 0) {
            length2 = args2[0];
            str = args2.length > 1 ? args2[1] : context.nil;
        } else {
            str = length2 = context.nil;
        }
        if (length2 != context.nil) {
            len = RubyNumeric.num2long(length2);
        }
        if (str != context.nil) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args2[1] = context.nil;
        }
        while (true) {
            int strLen;
            if (!data2.next_argv(context)) {
                return str;
            }
            IRubyObject tmp = data2.currentFile instanceof RubyIO ? ((RubyIO)data2.currentFile).read(args2) : data2.currentFile.callMethod(context, "read", args2);
            if (str == context.nil) {
                str = tmp;
            } else if (tmp != context.nil) {
                ((RubyString)str).append(tmp);
            }
            if (tmp == context.nil || length2 == context.nil) {
                if (data2.next_p == -1) break;
                RubyArgsFile.argf_close(context, data2.currentFile);
                data2.next_p = 1;
                continue;
            }
            if (args2.length < 1 || (long)(strLen = ((RubyString)str).getByteList().length()) >= len) break;
            args2[0] = runtime2.newFixnum(len -= (long)strLen);
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static IRubyObject filename(ThreadContext context, IRubyObject recv2) {
        ArgsFileData.getArgsFileData(context.runtime).next_argv(context);
        return context.runtime.getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public static IRubyObject to_s(IRubyObject recv2) {
        return recv2.getRuntime().newString("ARGF");
    }

    private static RubyIO getCurrentDataFile(ThreadContext context, String errorMessage) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            throw context.runtime.newArgumentError(errorMessage);
        }
        return (RubyIO)data2.currentFile;
    }

    private static JavaSites.ArgfSites sites(ThreadContext context) {
        return context.sites.Argf;
    }

    public static final class ArgsFileData {
        private final Ruby runtime;
        private RubyArray argv;
        public IRubyObject currentFile;
        private boolean inited = false;
        public int next_p = 0;
        public boolean binmode = false;

        public ArgsFileData(Ruby runtime2, RubyArray argv2) {
            this.runtime = runtime2;
            this.argv = argv2;
            this.currentFile = runtime2.getNil();
        }

        @Deprecated
        public void setCurrentLineNumber(Ruby runtime2, int linenumber) {
            runtime2.setCurrentLine(linenumber);
        }

        void setArgs(RubyArray argv2) {
            this.inited = false;
            this.argv = argv2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean next_argv(ThreadContext context) {
            if (!this.inited) {
                this.next_p = this.argv.getLength() > 0 ? 1 : -1;
                this.inited = true;
                this.runtime.setCurrentLine(0);
            } else if (this.argv.isNil()) {
                this.next_p = -1;
            } else if (this.next_p == -1 && this.argv.getLength() > 0) {
                this.next_p = 1;
            }
            IRubyObject $FILENAME = this.runtime.getGlobalVariables().get("$FILENAME");
            if (this.next_p != 1) {
                if (this.next_p != -1) return true;
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                if (ArgsFileData.filenameEqlDash((RubyString)$FILENAME)) return true;
                this.runtime.defineReadonlyVariable("$FILENAME", this.runtime.newString("-"), GlobalVariable.Scope.GLOBAL);
                return true;
            }
            if (this.argv.getLength() <= 0) {
                this.next_p = 1;
                return false;
            }
            RubyString filename2 = this.argv.shift(context).convertToString();
            if (!filename2.op_equal(context, $FILENAME).isTrue()) {
                this.runtime.defineReadonlyVariable("$FILENAME", filename2, GlobalVariable.Scope.GLOBAL);
            }
            if (ArgsFileData.filenameEqlDash(filename2)) {
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
            } else {
                this.currentFile = RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                String extension = this.runtime.getInstanceConfig().getInPlaceBackupExtension();
                if (extension != null) {
                    if (Platform.IS_WINDOWS) {
                        this.inplaceEditWindows(context, filename2.asJavaString(), extension);
                    } else {
                        this.inplaceEdit(context, filename2.asJavaString(), extension);
                    }
                }
                if (this.binmode) {
                    ((RubyIO)this.currentFile).binmode();
                }
            }
            this.next_p = 0;
            return true;
        }

        private static boolean filenameEqlDash(RubyString filename2) {
            ByteList filenameBytes = filename2.getByteList();
            return filenameBytes.length() == 1 && filenameBytes.get(0) == 45;
        }

        public static ArgsFileData getArgsFileData(Ruby runtime2) {
            return (ArgsFileData)runtime2.getArgsFile().dataGetStruct();
        }

        @Deprecated
        public static ArgsFileData getDataFrom(IRubyObject recv2) {
            return ArgsFileData.getArgsFileData(recv2.getRuntime());
        }

        private void createNewFile(File file2) {
            try {
                file2.createNewFile();
            }
            catch (IOException ex) {
                throw this.runtime.newIOErrorFromException(ex);
            }
        }

        private void inplaceEditWindows(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            if (extension.length() <= 0) {
                throw this.runtime.newIOError("Windows doesn't support inplace editing without a backup");
            }
            String backup = filename2 + extension;
            File backupFile = new File(backup);
            ((RubyIO)this.currentFile).close();
            backupFile.delete();
            file2.renameTo(backupFile);
            this.currentFile = RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(backup)}, Block.NULL_BLOCK);
            this.createNewFile(file2);
            this.runtime.getGlobalVariables().set("$stdout", RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }

        private void inplaceEdit(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            FileStat stat2 = this.runtime.getPosix().stat(filename2);
            if (extension.length() > 0) {
                file2.renameTo(new File(filename2 + extension));
            } else {
                file2.delete();
            }
            this.createNewFile(file2);
            this.runtime.getPosix().chmod(filename2, stat2.mode());
            this.runtime.getPosix().chown(filename2, stat2.uid(), stat2.gid());
            this.runtime.getGlobalVariables().set("$stdout", (RubyIO)RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }

        public boolean isCurrentFile(RubyIO io2) {
            return this.currentFile == io2;
        }
    }

    private static class ArgsFileAccessor
    implements IAccessor {
        private final Ruby runtime;

        ArgsFileAccessor(Ruby runtime2) {
            this.runtime = runtime2;
        }

        @Override
        public IRubyObject getValue() {
            return this.runtime.getArgsFile();
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

