/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
public class AnnotationBinder
extends AbstractProcessor {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    public static final String SRC_GEN_DIR = "target/generated-sources/org/jruby/gen/";
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private PrintStream out;
    private static final boolean DEBUG = false;

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            FileWriter fw = new FileWriter("target/generated-sources/annotated_classes.txt");
            for (CharSequence name2 : this.classNames) {
                fw.write(name2.toString());
                fw.write(10);
            }
            fw.close();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    public void processType(TypeElement cd) {
        for (TypeElement innerType : ElementFilter.typesIn(cd.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            ExecutableElement decl;
            String qualifiedName = cd.getQualifiedName().toString().replace('.', '$');
            if (!qualifiedName.contains("org$jruby")) {
                return;
            }
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(1024);
            this.out = new PrintStream(bytes2);
            this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
            this.out.println("package org.jruby.gen;");
            this.out.println("import org.jruby.Ruby;");
            this.out.println("import org.jruby.RubyModule;");
            this.out.println("import org.jruby.RubyClass;");
            this.out.println("import org.jruby.anno.TypePopulator;");
            this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
            this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
            this.out.println("import org.jruby.runtime.Arity;");
            this.out.println("import org.jruby.runtime.Visibility;");
            this.out.println("import org.jruby.runtime.MethodIndex;");
            this.out.println("import java.util.Arrays;");
            this.out.println("import java.util.List;");
            this.out.println("import javax.annotation.Generated;");
            this.out.println("@Generated(\"org.jruby.anno.AnnotationBinder\")");
            this.out.println("public class " + qualifiedName + POPULATOR_SUFFIX + " extends TypePopulator {");
            this.out.println("    public void populate(RubyModule cls, Class clazz) {");
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            for (ExecutableElement method : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                hasAnno = true;
                hasMeta |= anno.meta();
                hasModule |= anno.module();
            }
            if (!hasAnno) {
                return;
            }
            this.out.println("        JavaMethod javaMethod;");
            this.out.println("        DynamicMethod moduleMethod;");
            if (hasMeta || hasModule) {
                this.out.println("        RubyClass singletonClass = cls.getSingletonClass();");
            }
            this.out.println("        Ruby runtime = cls.getRuntime();");
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashSet<String> frameAwareMethods = new HashSet<String>(4, 1.0f);
            HashSet<String> scopeAwareMethods = new HashSet<String>(4, 1.0f);
            int methodCount = 0;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                void var17_23;
                JRubyMethod anno = executableElement.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                ++methodCount;
                if (executableElement.getThrownTypes().size() != 0) {
                    System.err.print("Method " + cd.toString() + "." + executableElement.toString() + " should not throw exceptions: ");
                    boolean comma = false;
                    for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                        if (comma) {
                            System.err.print(", ");
                        }
                        System.err.print(typeMirror);
                        comma = true;
                    }
                    System.err.print("\n");
                }
                Name name2 = anno.name().length == 0 ? executableElement.getSimpleName() : anno.name()[0];
                HashMap<CharSequence, List<ExecutableElement>> methodsHash = executableElement.getModifiers().contains((Object)Modifier.STATIC) ? staticAnnotatedMethods : annotatedMethods;
                List list2 = (List)methodsHash.get(name2);
                if (list2 == null) {
                    ArrayList arrayList = new ArrayList(4);
                    methodsHash.put(name2, arrayList);
                }
                var17_23.add(executableElement);
                boolean frame = false;
                boolean scope = false;
                for (FrameField field2 : anno.reads()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                for (FrameField field2 : anno.writes()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                if (frame) {
                    AnnotationHelper.addMethodNamesToSet(frameAwareMethods, anno, executableElement.getSimpleName().toString());
                }
                if (!scope) continue;
                AnnotationHelper.addMethodNamesToSet(scopeAwareMethods, anno, executableElement.getSimpleName().toString());
            }
            if (methodCount == 0) {
                return;
            }
            this.classNames.add(this.getActualQualifiedName(cd));
            this.processMethodDeclarations(staticAnnotatedMethods);
            for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            this.processMethodDeclarations(annotatedMethods);
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            this.out.println("    }");
            this.out.println("    static {");
            if (!frameAwareMethods.isEmpty()) {
                this.out.println("        MethodIndex.addFrameAwareMethods(" + AnnotationBinder.join(frameAwareMethods) + ");");
            }
            if (!scopeAwareMethods.isEmpty()) {
                this.out.println("        MethodIndex.addScopeAwareMethods(" + AnnotationBinder.join(scopeAwareMethods) + ");");
            }
            this.out.println("    }");
            this.out.println("}");
            this.out.close();
            this.out = null;
            new File(SRC_GEN_DIR).mkdirs();
            FileOutputStream fos = new FileOutputStream(SRC_GEN_DIR + qualifiedName + POPULATOR_SUFFIX + ".java");
            fos.write(bytes2.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static StringBuilder join(Iterable<String> names2) {
        StringBuilder str = new StringBuilder();
        boolean first2 = true;
        for (String name2 : names2) {
            if (!first2) {
                str.append(',');
            }
            first2 = false;
            str.append('\"').append(name2).append('\"');
        }
        return str;
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list2 = entry.getValue();
            if (list2.size() == 1) {
                this.processMethodDeclaration(list2.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list2.get(0));
        }
    }

    public void processMethodDeclaration(ExecutableElement method) {
        JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = this.getActualQualifiedName((TypeElement)method.getEnclosingElement());
            boolean hasContext = false;
            boolean hasBlock = false;
            StringBuilder buffer = new StringBuilder();
            boolean first2 = true;
            for (VariableElement variableElement : method.getParameters()) {
                if (!first2) {
                    buffer.append(", ");
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
                buffer.append(".class");
                hasContext |= variableElement.asType().toString().equals("org.jruby.runtime.ThreadContext");
                hasBlock |= variableElement.asType().toString().equals("org.jruby.runtime.Block");
            }
            int actualRequired = this.calculateActualRequired(method, method.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string2 = CodegenUtils.getAnnotatedBindingClassName(method.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            this.out.println("        javaMethod = new " + string2 + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
            this.out.println("        populateMethod(javaMethod, " + AnnotationHelper.getArityValue(anno, actualRequired) + ", \"" + method.getSimpleName() + "\", " + isStatic + ", " + anno.notImplemented() + ", " + ((TypeElement)method.getEnclosingElement()).getQualifiedName() + ".class, " + "\"" + method.getSimpleName() + "\", " + method.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
            this.generateMethodAddCalls(method, anno);
        }
    }

    public void processMethodDeclarationMulti(ExecutableElement method) {
        JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = this.getActualQualifiedName((TypeElement)method.getEnclosingElement());
            boolean hasContext = false;
            boolean hasBlock = false;
            StringBuilder buffer = new StringBuilder();
            boolean first2 = true;
            for (VariableElement variableElement : method.getParameters()) {
                if (!first2) {
                    buffer.append(", ");
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
                buffer.append(".class");
                hasContext |= variableElement.asType().toString().equals("org.jruby.runtime.ThreadContext");
                hasBlock |= variableElement.asType().toString().equals("org.jruby.runtime.Block");
            }
            int actualRequired = this.calculateActualRequired(method, method.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string2 = CodegenUtils.getAnnotatedBindingClassName(method.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            this.out.println("        javaMethod = new " + string2 + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
            this.out.println("        populateMethod(javaMethod, -1, \"" + method.getSimpleName() + "\", " + isStatic + ", " + anno.notImplemented() + ", " + ((TypeElement)method.getEnclosingElement()).getQualifiedName() + ".class, " + "\"" + method.getSimpleName() + "\", " + method.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
            this.generateMethodAddCalls(method, anno);
        }
    }

    private void addCoreMethodMapping(CharSequence rubyName, ExecutableElement decl, PrintStream out) {
        out.println(new StringBuilder(50).append("        runtime.addBoundMethod(").append('\"').append(((TypeElement)decl.getEnclosingElement()).getQualifiedName()).append('\"').append(',').append('\"').append(decl.getSimpleName()).append('\"').append(',').append('\"').append(rubyName).append('\"').append(");").toString());
    }

    private CharSequence getActualQualifiedName(TypeElement td) {
        if (td.getNestingKind() == NestingKind.MEMBER) {
            return this.getActualQualifiedName((TypeElement)td.getEnclosingElement()) + "$" + td.getSimpleName();
        }
        return td.getQualifiedName().toString();
    }

    private int calculateActualRequired(ExecutableElement md, int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int actualRequired;
        if (optional == 0 && !rest2) {
            int args2 = paramsLength;
            if (args2 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args2;
                }
                if (hasContext) {
                    --args2;
                }
                if (hasBlock) {
                    --args2;
                }
                actualRequired = args2;
            }
        } else {
            int args3 = paramsLength;
            if (args3 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args3;
                }
                if (hasContext) {
                    --args3;
                }
                if (hasBlock) {
                    --args3;
                }
                actualRequired = --args3;
            }
            if (actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)md.getEnclosingElement()).getQualifiedName() + "." + md.toString());
            }
        }
        return actualRequired;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod anno) {
        this.generateMethodAddCalls(md, anno.meta(), anno.module(), anno.name(), anno.alias());
    }

    private void generateMethodAddCalls(ExecutableElement md, boolean meta, boolean module, String[] names2, String[] aliases2) {
        if (meta) {
            this.defineMethodOnClass("javaMethod", "singletonClass", names2, aliases2, md);
        } else {
            this.defineMethodOnClass("javaMethod", "cls", names2, aliases2, md);
            if (module) {
                this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                this.defineMethodOnClass("moduleMethod", "singletonClass", names2, aliases2, md);
            }
        }
    }

    private void defineMethodOnClass(String methodVar, String classVar, String[] names2, String[] aliases2, ExecutableElement md) {
        CharSequence baseName;
        if (names2.length == 0) {
            baseName = md.getSimpleName();
            this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + baseName + "\", " + methodVar + ");");
        } else {
            baseName = names2[0];
            for (String name2 : names2) {
                this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + name2 + "\", " + methodVar + ");");
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                this.out.println("        " + classVar + ".defineAlias(\"" + alias + "\", \"" + baseName + "\");");
            }
        }
    }
}

