/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.Regex;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.exception.InternalException;

public final class UnsetAddrList {
    int num;
    Node[] targets;
    int[] offsets;

    public UnsetAddrList(int size2) {
        this.targets = new Node[size2];
        this.offsets = new int[size2];
    }

    public void add(int offset2, Node node) {
        if (this.num >= this.offsets.length) {
            Node[] ttmp = new Node[this.targets.length << 1];
            System.arraycopy(this.targets, 0, ttmp, 0, this.num);
            this.targets = ttmp;
            int[] otmp = new int[this.offsets.length << 1];
            System.arraycopy(this.offsets, 0, otmp, 0, this.num);
            this.offsets = otmp;
        }
        this.targets[this.num] = node;
        this.offsets[this.num] = offset2;
        ++this.num;
    }

    public void fix(Regex regex) {
        for (int i2 = 0; i2 < this.num; ++i2) {
            EncloseNode en = (EncloseNode)this.targets[i2];
            if (!en.isAddrFixed()) {
                new InternalException("internal parser error (bug)");
            }
            regex.code[this.offsets[i2]] = en.callAddr;
        }
    }

    public String toString() {
        StringBuilder value2 = new StringBuilder();
        if (this.num > 0) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                value2.append("offset + " + this.offsets[i2] + " target: " + this.targets[i2].getAddressName());
            }
        }
        return value2.toString();
    }
}

