/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

public enum OperandType {
    ARRAY(65),
    AS_STRING(97),
    BACKREF(92),
    BACKTICK_STRING(96),
    BIGNUM(66),
    BOOLEAN(98),
    LOCAL_VARIABLE(108),
    COMPLEX(67),
    COMPOUND_ARRAY(99),
    COMPOUND_STRING(34),
    CURRENT_SCOPE(115),
    DYNAMIC_SYMBOL(100),
    FIXNUM(102),
    FLOAT(70),
    GLOBAL_VARIABLE(36),
    HASH(123),
    IR_EXCEPTION(33),
    LABEL(76),
    NIL(78),
    NTH_REF(49),
    OBJECT_CLASS(79),
    RANGE(46),
    RATIONAL(114),
    REGEXP(47),
    SCOPE_MODULE(95),
    SELF(83),
    SPLAT(42),
    STANDARD_ERROR(69),
    STRING_LITERAL(39),
    SVALUE(86),
    SYMBOL(58),
    TEMPORARY_VARIABLE(116),
    UNBOXED_BOOLEAN(118),
    UNBOXED_FIXNUM(106),
    UNBOXED_FLOAT(74),
    UNDEFINED_VALUE(117),
    UNEXECUTABLE_NIL(110),
    WRAPPED_IR_CLOSURE(119),
    FROZEN_STRING(122),
    NULL_BLOCK(111);

    private final byte coded;
    private static final OperandType[] byteToOperand;

    private OperandType(byte coded) {
        this.coded = coded;
    }

    public byte getCoded() {
        return this.coded;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static OperandType fromCoded(byte coded) {
        return byteToOperand[coded];
    }

    public static OperandType fromOrdinal(int value2) {
        return value2 < 0 || value2 >= OperandType.values().length ? null : OperandType.values()[value2];
    }

    static {
        byteToOperand = new OperandType[256];
        OperandType[] arr$ = OperandType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            OperandType type2;
            OperandType.byteToOperand[type2.coded] = type2 = arr$[i$];
        }
    }
}

