/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ZSuperInstr
extends UnresolvedSuperInstr {
    public ZSuperInstr(Variable result2, Operand receiver2, Operand[] args2, Operand closure, boolean isPotentiallyRefined) {
        super(Operation.ZSUPER, result2, receiver2, args2, closure, isPotentiallyRefined);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.USES_ZSUPER);
        scope.getFlags().add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ZSuperInstr(ii.getRenamedVariable(this.getResult()), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii), this.isPotentiallyRefined());
    }

    public static ZSuperInstr decode(IRReaderDecoder d) {
        Operand closure;
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call");
        }
        int callTypeOrdinal = d.decodeInt();
        CallType callType = CallType.fromOrdinal(callTypeOrdinal);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, calltype(ord):  " + (Object)((Object)callType));
        }
        String methAddr = d.decodeString();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + methAddr);
        }
        Operand receiver2 = d.decodeOperand();
        int argsCount = d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = d.decodeOperand();
        }
        Operand operand = closure = hasClosureArg ? d.decodeOperand() : null;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("before result");
        }
        Variable result2 = d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, result:  " + result2);
        }
        return new ZSuperInstr(result2, receiver2, args2, closure, d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject[] args2 = this.prepareArguments(context, self2, currScope, currDynScope, temp);
        Block block = this.prepareBlock(context, self2, currScope, currDynScope, temp);
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ZSuperInstr(this);
    }
}

