/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalVariable
extends Variable
implements DepthCloneable {
    protected final String name;
    protected final int scopeDepth;
    protected final int offset;
    protected final int hcode;

    public LocalVariable(String name2, int scopeDepth, int location) {
        this(OperandType.LOCAL_VARIABLE, name2, scopeDepth, location);
    }

    protected LocalVariable(OperandType type2, String name2, int scopeDepth, int location) {
        super(type2);
        this.name = name2;
        this.scopeDepth = scopeDepth;
        this.offset = location;
        this.hcode = (name2 + ":" + this.offset).hashCode();
    }

    public boolean isSameDepth(LocalVariable other) {
        return this.getScopeDepth() == other.getScopeDepth();
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLocation() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.isSelf() ? this.name : this.name + "(" + this.scopeDepth + ":" + this.offset + ")";
    }

    public int hashCode() {
        return this.hcode;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalVariable)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int compareTo(Object arg0) {
        int b2;
        if (!(arg0 instanceof LocalVariable)) {
            return 0;
        }
        int a = this.hashCode();
        return a < (b2 = arg0.hashCode()) ? -1 : (a == b2 ? 0 : 1);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject value2 = currDynScope.getValue(this.offset, this.scopeDepth);
        if (value2 == null) {
            value2 = context.nil;
        }
        return value2;
    }

    @Override
    public Variable clone(SimpleCloneInfo ii) {
        return this;
    }

    @Override
    public LocalVariable cloneForDepth(int n) {
        return new LocalVariable(this.name, n, this.offset);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
        e.encode(this.getScopeDepth());
    }

    public static LocalVariable decode(IRReaderDecoder d) {
        return d.getCurrentScope().getLocalVariable(d.decodeString(), d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LocalVariable(this);
    }
}

