/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyBasicObject;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BacktickInstr
extends ResultBaseInstr {
    public BacktickInstr(Variable result2, Operand[] pieces) {
        super(Operation.BACKTICK_STRING, result2, pieces);
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BacktickInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
    }

    public static BacktickInstr decode(IRReaderDecoder d) {
        return new BacktickInstr(d.decodeVariable(), d.decodeOperandArray());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyString newString = context.runtime.newString();
        for (Operand p2 : this.operands) {
            RubyBasicObject piece = (RubyBasicObject)p2.retrieve(context, self2, currScope, currDynScope, temp);
            newString.append(piece instanceof RubyString ? (RubyString)piece : piece.to_s());
        }
        newString.setFrozen(true);
        return self2.callMethod(context, "`", newString);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BacktickInstr(this);
    }
}

