/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ASTInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(Ruby runtime, ThreadContext context, String file2, int line, RubyModule implClass, Node node, String name2, IRubyObject self2, Block block, boolean isTraceable) {
        try {
            ThreadContext.pushBacktrace(context, name2, file2, line);
            if (isTraceable) {
                ASTInterpreter.methodPreTrace(runtime, context, name2, implClass);
            }
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            if (isTraceable) {
                try {
                    ASTInterpreter.methodPostTrace(runtime, context, name2, implClass);
                }
                finally {
                    ThreadContext.popBacktrace(context);
                }
            } else {
                ThreadContext.popBacktrace(context);
            }
        }
    }

    private static void methodPreTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self2, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return null;
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime, context, self2, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime, ThreadContext context, IRubyObject self2, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc = bodyNode == null ? runtime.getNil() : null;
        return Helpers.getBlockFromBlockPassBody(proc, currentBlock);
    }

    public static RubyModule getClassVariableBase(Ruby runtime, StaticScope scope) {
        RubyModule rubyClass = scope.getModule();
        while (rubyClass.isSingleton() || rubyClass == runtime.getDummy()) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        return rubyClass;
    }
}

