/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.Node;
import org.jruby.truffle.runtime.LexicalScope;

public class SharedMethodInfo {
    private final SourceSection sourceSection;
    private final LexicalScope lexicalScope;
    private final String name;
    private final boolean isBlock;
    private final Node parseTree;
    private final boolean alwaysSplit;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope lexicalScope, String name2, boolean isBlock, Node parseTree, boolean alwaysSplit) {
        assert (sourceSection != null);
        assert (name2 != null);
        this.sourceSection = sourceSection;
        this.lexicalScope = lexicalScope;
        this.name = name2;
        this.isBlock = isBlock;
        this.parseTree = parseTree;
        this.alwaysSplit = alwaysSplit;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public Node getParseTree() {
        return this.parseTree;
    }

    public boolean shouldAlwaysSplit() {
        return this.alwaysSplit;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isBlock) {
            builder.append("block in ");
        }
        builder.append(this.name);
        builder.append(":");
        builder.append(this.sourceSection.getShortDescription());
        return builder.toString();
    }
}

