/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.util.Arrays;
import org.joni.Region;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.util.ArrayUtils;

public class RubyMatchData
extends RubyBasicObject {
    private Region region;
    private final Object[] values;
    private final RubyString pre;
    private final RubyString post;
    private final RubyString global;

    public RubyMatchData(RubyClass rubyClass, Region region, Object[] values2, RubyString pre, RubyString post, RubyString global) {
        super(rubyClass);
        this.region = region;
        this.values = values2;
        this.pre = pre;
        this.post = post;
        this.global = global;
    }

    public Object[] valuesAt(int ... indices) {
        RubyNode.notDesignedForCompilation();
        Object[] result2 = new Object[indices.length];
        for (int n = 0; n < indices.length; ++n) {
            result2[n] = this.values[indices[n]];
        }
        return result2;
    }

    public Object[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public Object[] getCaptures() {
        return ArrayUtils.extractRange(this.values, 1, this.values.length);
    }

    public Object begin(int index2) {
        if (this.region == null) {
            throw new UnsupportedOperationException("begin is not yet working when no grouping data is available");
        }
        int begin2 = this.region.beg[index2];
        if (begin2 < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return begin2;
    }

    public Object end(int index2) {
        if (this.region == null) {
            throw new UnsupportedOperationException("end is not yet working when no grouping data is available");
        }
        int end2 = this.region.end[index2];
        if (end2 < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return end2;
    }

    public int getNumberOfRegions() {
        return this.region.numRegs;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.values) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public RubyString getPre() {
        return this.pre;
    }

    public RubyString getPost() {
        return this.post;
    }

    public RubyString getGlobal() {
        return this.global;
    }
}

